/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDynamicsBase;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParticleI;
import igeo.IPoint;
import igeo.IPointR;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec4;
import igeo.IVecI;

public class IParticleGeo
extends IDynamicsBase
implements IParticleI,
IVecI {
    static double defaultFriction = 0.0;
    public double mass = 1.0;
    public IVec pos;
    public IVec vel;
    public IVec frc;
    public boolean fixed = false;
    public double friction = defaultFriction;
    public boolean skipUpdateOnce;

    public IParticleGeo() {
        this.pos = new IVec();
        this.initParticle();
    }

    public IParticleGeo(IVec iVec) {
        this.pos = iVec;
        this.initParticle();
    }

    public IParticleGeo(IVec iVec, IObject iObject) {
        super(iObject);
        this.pos = iVec;
        this.initParticle();
    }

    public IParticleGeo(IVecI iVecI) {
        this.pos = iVecI.get();
        this.initParticle();
    }

    public IParticleGeo(IVecI iVecI, IObject iObject) {
        super(iObject);
        this.pos = iVecI.get();
        this.initParticle();
    }

    public IParticleGeo(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.initParticle();
    }

    public IParticleGeo(double d, double d2, double d3, IObject iObject) {
        super(iObject);
        this.pos = new IVec(d, d2, d3);
        this.initParticle();
    }

    public IParticleGeo(IPoint iPoint) {
        super(iPoint);
        this.pos = iPoint.pos;
        this.initParticle();
    }

    public IParticleGeo(IPointR iPointR) {
        super(iPointR);
        this.pos = iPointR.pos.get();
        this.initParticle();
    }

    public IParticleGeo(IParticleGeo iParticleGeo) {
        super(iParticleGeo.parent);
        this.pos = iParticleGeo.pos.dup();
        this.initParticle();
    }

    public IParticleGeo(IParticleGeo iParticleGeo, IObject iObject) {
        super(iObject);
        this.pos = iParticleGeo.pos.dup();
        this.initParticle();
    }

    public IParticleGeo(IVec iVec, IVec iVec2) {
        this.pos = iVec;
        this.initParticle(iVec2);
    }

    public IParticleGeo(IVec iVec, IVec iVec2, IObject iObject) {
        super(iObject);
        this.pos = iVec;
        this.initParticle(iVec2);
    }

    public IParticleGeo(IVecI iVecI, IVecI iVecI2) {
        this.pos = iVecI.get();
        this.initParticle(iVecI2);
    }

    public IParticleGeo(IVecI iVecI, IVecI iVecI2, IObject iObject) {
        super(iObject);
        this.pos = iVecI.get();
        this.initParticle(iVecI2);
    }

    public IParticleGeo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos = new IVec(d, d2, d3);
        this.initParticle(new IVec(d4, d5, d6));
    }

    public IParticleGeo(double d, double d2, double d3, double d4, double d5, double d6, IObject iObject) {
        super(iObject);
        this.pos = new IVec(d, d2, d3);
        this.initParticle(new IVec(d4, d5, d6));
    }

    public IParticleGeo(IPoint iPoint, IVecI iVecI) {
        super(iPoint);
        this.pos = iPoint.pos;
        this.initParticle(iVecI);
    }

    public IParticleGeo(IPointR iPointR, IVecI iVecI) {
        super(iPointR);
        this.pos = iPointR.pos.get();
        this.initParticle(iVecI);
    }

    public IParticleGeo(IParticleGeo iParticleGeo, IVecI iVecI) {
        super(iParticleGeo.parent);
        this.pos = iParticleGeo.pos.dup();
        this.initParticle(iVecI);
    }

    public IParticleGeo(IParticleGeo iParticleGeo, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.pos = iParticleGeo.pos.dup();
        this.initParticle(iVecI);
    }

    public synchronized void initParticle() {
        this.vel = new IVec();
        this.frc = new IVec();
    }

    public synchronized void initParticle(IVec iVec) {
        this.vel = iVec;
        this.frc = new IVec();
    }

    public synchronized void initParticle(IVecI iVecI) {
        this.vel = iVecI.get();
        this.frc = new IVec();
    }

    public IParticleGeo dup() {
        return new IParticleGeo(this);
    }

    public synchronized IParticleGeo fix() {
        this.fixed = true;
        this.frc.zero();
        this.vel.zero();
        return this;
    }

    public synchronized IParticleGeo unfix() {
        this.frc.zero();
        this.vel.zero();
        this.fixed = false;
        return this;
    }

    public boolean fixed() {
        return this.fixed;
    }

    public IParticleGeo skipUpdateOnce(boolean bl) {
        this.skipUpdateOnce = bl;
        return this;
    }

    public boolean skipUpdateOnce() {
        return this.skipUpdateOnce;
    }

    public synchronized double mass() {
        return this.mass;
    }

    public synchronized IParticleGeo mass(double d) {
        this.mass = d;
        return this;
    }

    public synchronized IVec position() {
        return this.pos();
    }

    public synchronized IParticleGeo position(IVecI iVecI) {
        return this.pos(iVecI);
    }

    public synchronized IVec pos() {
        return this.pos;
    }

    public synchronized IParticleGeo pos(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public synchronized IVec velocity() {
        return this.vel();
    }

    public synchronized IParticleGeo velocity(IVecI iVecI) {
        return this.vel(iVecI);
    }

    public synchronized IVec vel() {
        return this.vel;
    }

    public synchronized IParticleGeo vel(IVecI iVecI) {
        this.vel.set(iVecI);
        return this;
    }

    public synchronized IVec acceleration() {
        return this.acc();
    }

    public synchronized IVec acc() {
        return this.frc.dup().div(this.mass);
    }

    public synchronized IVec force() {
        return this.frc();
    }

    public synchronized IParticleGeo force(IVecI iVecI) {
        return this.frc(iVecI);
    }

    public synchronized IVec frc() {
        return this.frc;
    }

    public synchronized IParticleGeo frc(IVecI iVecI) {
        this.frc.set(iVecI);
        return this;
    }

    public synchronized double friction() {
        return this.fric();
    }

    public synchronized IParticleGeo friction(double d) {
        return this.fric(d);
    }

    public synchronized double fric() {
        return this.friction;
    }

    public synchronized IParticleGeo fric(double d) {
        this.friction = d;
        return this;
    }

    public double decay() {
        return this.fric();
    }

    public IParticleGeo decay(double d) {
        return this.fric(d);
    }

    public synchronized IParticleGeo push(IVecI iVecI) {
        this.frc.add(iVecI);
        return this;
    }

    public synchronized IParticleGeo push(double d, double d2, double d3) {
        this.frc.add(d, d2, d3);
        return this;
    }

    public synchronized IParticleGeo pull(IVecI iVecI) {
        this.frc.sub(iVecI);
        return this;
    }

    public synchronized IParticleGeo pull(double d, double d2, double d3) {
        this.frc.sub(d, d2, d3);
        return this;
    }

    public synchronized IParticleGeo addForce(IVecI iVecI) {
        return this.push(iVecI);
    }

    public synchronized IParticleGeo addForce(double d, double d2, double d3) {
        return this.push(d, d2, d3);
    }

    public synchronized IParticleGeo reset() {
        this.frc.zero();
        return this;
    }

    public synchronized IParticleGeo resetForce() {
        return this.reset();
    }

    public synchronized void preupdate() {
        if (this.fixed) {
            return;
        }
        this.vel.add(this.frc, IConfig.updateRate / this.mass).mul(1.0 - this.friction);
        this.frc.zero();
    }

    public synchronized void update() {
        if (this.skipUpdateOnce) {
            this.skipUpdateOnce = false;
            return;
        }
        if (this.fixed) {
            return;
        }
        this.pos.add(this.vel, IConfig.updateRate);
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public IParticleGeo x(double d) {
        this.pos.x(d);
        return this;
    }

    public IParticleGeo y(double d) {
        this.pos.y(d);
        return this;
    }

    public IParticleGeo z(double d) {
        this.pos.z(d);
        return this;
    }

    public IParticleGeo x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    public IParticleGeo y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    public IParticleGeo z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    public double x(ISwitchE iSwitchE) {
        return this.pos.x(iSwitchE);
    }

    public double y(ISwitchE iSwitchE) {
        return this.pos.y(iSwitchE);
    }

    public double z(ISwitchE iSwitchE) {
        return this.pos.z(iSwitchE);
    }

    public IDoubleI x(ISwitchR iSwitchR) {
        return this.pos.x(iSwitchR);
    }

    public IDoubleI y(ISwitchR iSwitchR) {
        return this.pos.y(iSwitchR);
    }

    public IDoubleI z(ISwitchR iSwitchR) {
        return this.pos.z(iSwitchR);
    }

    public IVec get() {
        return this.pos.get();
    }

    public IVec2 to2d() {
        return this.pos.to2d();
    }

    public IVec2 to2d(IVecI iVecI) {
        return this.pos.to2d(iVecI);
    }

    public IVec2 to2d(IVecI iVecI, IVecI iVecI2) {
        return this.pos.to2d(iVecI, iVecI2);
    }

    public IVec2 to2d(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.pos.to2d(iVecI, iVecI2, iVecI3);
    }

    public IVec4 to4d() {
        return this.pos.to4d();
    }

    public IVec4 to4d(double d) {
        return this.pos.to4d(d);
    }

    public IVec4 to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    public IDouble getX() {
        return this.pos.getX();
    }

    public IDouble getY() {
        return this.pos.getY();
    }

    public IDouble getZ() {
        return this.pos.getZ();
    }

    public IParticleGeo set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IParticleGeo set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    public IParticleGeo set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IParticleGeo add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    public IParticleGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IParticleGeo add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    public IParticleGeo sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    public IParticleGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IParticleGeo sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    public IParticleGeo mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    public IParticleGeo mul(double d) {
        this.pos.mul(d);
        return this;
    }

    public IParticleGeo div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    public IParticleGeo div(double d) {
        this.pos.div(d);
        return this;
    }

    public IParticleGeo neg() {
        this.pos.neg();
        return this;
    }

    public IParticleGeo rev() {
        return this.neg();
    }

    public IParticleGeo flip() {
        return this.neg();
    }

    public IParticleGeo zero() {
        this.pos.zero();
        return this;
    }

    public IParticleGeo add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    public IParticleGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    public IParticleGeo add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public IParticleGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    public double dot(double d, double d2, double d3) {
        return this.pos.dot(d, d2, d3);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    public IVec cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    public IVec cross(double d, double d2, double d3) {
        return this.pos.cross(d, d2, d3);
    }

    public double len() {
        return this.pos.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    public IDouble len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    public double len2() {
        return this.pos.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    public IParticleGeo len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    public IParticleGeo len(double d) {
        this.pos.len(d);
        return this;
    }

    public IParticleGeo unit() {
        this.pos.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    public double dist(double d, double d2, double d3) {
        return this.pos.dist(d, d2, d3);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    public double dist2(double d, double d2, double d3) {
        return this.pos.dist2(d, d2, d3);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    public boolean eq(double d, double d2, double d3) {
        return this.pos.eq(d, d2, d3);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    public boolean eq(double d, double d2, double d3, double d4) {
        return this.pos.eq(d, d2, d3, d4);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    public boolean eqX(double d) {
        return this.pos.eqX(d);
    }

    public boolean eqY(double d) {
        return this.pos.eqY(d);
    }

    public boolean eqZ(double d) {
        return this.pos.eqZ(d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    public boolean eqX(double d, double d2) {
        return this.pos.eqX(d, d2);
    }

    public boolean eqY(double d, double d2) {
        return this.pos.eqY(d, d2);
    }

    public boolean eqZ(double d, double d2) {
        return this.pos.eqZ(d, d2);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    public double angle(double d, double d2, double d3) {
        return this.pos.angle(d, d2, d3);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.angle(d, d2, d3, d4, d5, d6);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    public IParticleGeo rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    public IParticleGeo rot(double d) {
        this.pos.rot(d);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    public IParticleGeo rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IParticleGeo rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    public IParticleGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IParticleGeo rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    public IParticleGeo rot2(double d) {
        return this.rot(d);
    }

    public IParticleGeo rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    public IParticleGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    public IParticleGeo rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    public IParticleGeo rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    public IParticleGeo rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    public IParticleGeo scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    public IParticleGeo scale(double d) {
        this.pos.scale(d);
        return this;
    }

    public IParticleGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    public IParticleGeo scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    public IParticleGeo scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    public IParticleGeo scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    public IParticleGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    public IParticleGeo scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    public IParticleGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    public IParticleGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IParticleGeo scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public IParticleGeo ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IParticleGeo ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    public IParticleGeo ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IParticleGeo ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d2, d4, d5, d6);
        return this;
    }

    public IParticleGeo mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IParticleGeo mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    public IParticleGeo mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IParticleGeo mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IParticleGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IParticleGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IParticleGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    public IParticleGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IParticleGeo shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    public IParticleGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    public IParticleGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    public IParticleGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    public IParticleGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    public IParticleGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    public IParticleGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IParticleGeo translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    public IParticleGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IParticleGeo translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    public IParticleGeo transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    public IParticleGeo transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    public IParticleGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IParticleGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IParticleGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IParticleGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IParticleGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IParticleGeo cp() {
        return this.dup();
    }

    public IParticleGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IParticleGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IParticleGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec dif(IVecI iVecI) {
        return this.pos.dif(iVecI);
    }

    public IVec dif(double d, double d2, double d3) {
        return this.pos.dif(d, d2, d3);
    }

    public IVec diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    public IVec diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    public IVec mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    public IVec mid(double d, double d2, double d3) {
        return this.pos.mid(d, d2, d3);
    }

    public IVec sum(IVecI iVecI) {
        return this.pos.sum(iVecI);
    }

    public IVec sum(double d, double d2, double d3) {
        return this.pos.sum(d, d2, d3);
    }

    public IVec sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    public IVec bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    public IVec bisect(double d, double d2, double d3) {
        return this.pos.bisect(d, d2, d3);
    }

    public IVec sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    public IVec sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI, iDoubleI, iDoubleI2);
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI, iDoubleI);
    }

    public IVec nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    public IVec nml(double d, double d2, double d3) {
        return this.pos.nml(d, d2, d3);
    }

    public IVec nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    public IVec nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.nml(d, d2, d3, d4, d5, d6);
    }

    public boolean isValid() {
        if (this.pos == null) {
            return false;
        }
        return this.pos.isValid();
    }

    public String toString() {
        if (this.pos == null) {
            return super.toString();
        }
        return this.pos.toString();
    }

    public IParticleGeo target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    public IParticleGeo removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    public IParticleGeo removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }
}

