/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.ISurface;
import igeo.ISurfaceI;
import igeo.ISurfaceR;
import igeo.IVec;
import igeo.IVec2;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;
import igeo.gui.IIsoparmGraphic;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;

public class ISurfaceGraphicWireframeGL
extends IGraphicObject {
    public static float weight = IConfig.strokeWeight;
    public int isoparmNumRatio = IConfig.isoparmResolution;
    public int isoparmNumU;
    public int isoparmNumV;
    public ISurfaceI surface = null;
    public IVec[][] ulinePts;
    public IVec[][] vlinePts;
    public IVec[][] inTrimPts;
    public IVec[][] outTrimPts;
    public IPolyline2D[] uline2;
    public IPolyline2D[] vline2;
    public IPolyline2D[] inTrim2 = null;
    public IPolyline2D[] outTrim2 = null;
    public boolean simpleFlat = false;
    public boolean initialized = false;

    public ISurfaceGraphicWireframeGL(ISurface iSurface) {
        super(iSurface);
        this.surface = iSurface.surface;
    }

    public ISurfaceGraphicWireframeGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
    }

    public ISurfaceGraphicWireframeGL(IObject iObject, ISurfaceI iSurfaceI) {
        super(iObject);
        this.surface = iSurfaceI;
    }

    public ISurfaceGraphicWireframeGL(ISurface iSurface, int n) {
        super(iSurface);
        this.surface = iSurface.surface;
        this.isoparmNumRatio = n;
    }

    public ISurfaceGraphicWireframeGL(ISurfaceR iSurfaceR, int n) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
        this.isoparmNumRatio = n;
    }

    public ISurfaceGraphicWireframeGL(IObject iObject, ISurfaceI iSurfaceI, int n) {
        super(iObject);
        this.surface = iSurfaceI;
        this.isoparmNumRatio = n;
    }

    public void setIsoparmNumberRatio(int n) {
        this.isoparmNumRatio = n;
    }

    public void setWeight(float f) {
        weight = f;
    }

    public float getWeight() {
        return weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSurface() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            int n;
            IIsoparmGraphic iIsoparmGraphic;
            double d;
            int n2;
            int n3;
            ArrayList<IPolyline2D> arrayList;
            int n4;
            int n5 = this.surface.uepNum();
            int n6 = this.surface.vepNum();
            this.isoparmNumU = this.isoparmNumRatio * (n6 - 1) + 1;
            this.isoparmNumV = this.isoparmNumRatio * (n5 - 1) + 1;
            ITrimLoopGraphic[] iTrimLoopGraphicArray = null;
            ITrimLoopGraphic[] iTrimLoopGraphicArray2 = null;
            if (this.surface.hasOuterTrim()) {
                iTrimLoopGraphicArray = new ITrimLoopGraphic[this.surface.outerTrimLoopNum()];
                this.outTrimPts = new IVec[this.surface.outerTrimLoopNum()][];
                this.outTrim2 = new IPolyline2D[this.surface.outerTrimLoopNum()];
                for (n4 = 0; n4 < this.surface.outerTrimLoopNum(); ++n4) {
                    iTrimLoopGraphicArray[n4] = new ITrimLoopGraphic(this.surface.outerTrimLoop(n4), true, IConfig.segmentResolution);
                    this.outTrimPts[n4] = iTrimLoopGraphicArray[n4].getPolyline().get();
                    this.outTrim2[n4] = iTrimLoopGraphicArray[n4].getPolyline2D();
                }
            } else {
                iTrimLoopGraphicArray = new ITrimLoopGraphic[1];
                this.outTrimPts = new IVec[1][];
                this.outTrim2 = new IPolyline2D[1];
                iTrimLoopGraphicArray[0] = new ITrimLoopGraphic(this.surface);
                this.outTrimPts[0] = iTrimLoopGraphicArray[0].getPolyline().get();
                this.outTrim2[0] = iTrimLoopGraphicArray[0].getPolyline2D();
            }
            if (this.surface.hasInnerTrim()) {
                iTrimLoopGraphicArray2 = new ITrimLoopGraphic[this.surface.innerTrimLoopNum()];
                this.inTrimPts = new IVec[this.surface.innerTrimLoopNum()][];
                this.inTrim2 = new IPolyline2D[this.surface.innerTrimLoopNum()];
                for (n4 = 0; n4 < this.surface.innerTrimLoopNum(); ++n4) {
                    iTrimLoopGraphicArray2[n4] = new ITrimLoopGraphic(this.surface.innerTrimLoop(n4), false, IConfig.segmentResolution);
                    this.inTrimPts[n4] = iTrimLoopGraphicArray2[n4].getPolyline().get();
                    this.inTrim2[n4] = iTrimLoopGraphicArray2[n4].getPolyline2D();
                }
            }
            if (this.isoparmNumU > 2) {
                ArrayList<IVec[]> arrayList2 = new ArrayList<IVec[]>();
                arrayList = new ArrayList<IPolyline2D>();
                for (n3 = 0; n3 < n6 - 1; ++n3) {
                    for (n2 = 0; n2 < this.isoparmNumRatio; ++n2) {
                        d = (double)n2 / (double)this.isoparmNumRatio;
                        if (n3 <= 0 && n2 <= 0) continue;
                        iIsoparmGraphic = new IIsoparmGraphic(this.surface, this.surface.v(n3, d), true, iTrimLoopGraphicArray, iTrimLoopGraphicArray2);
                        for (n = 0; n < iIsoparmGraphic.num(); ++n) {
                            arrayList2.add(iIsoparmGraphic.getLine(n).get());
                            arrayList.add(iIsoparmGraphic.getLine2D(n));
                        }
                    }
                }
                this.ulinePts = (IVec[][])arrayList2.toArray((T[])new IVec[arrayList2.size()][]);
                this.uline2 = arrayList.toArray(new IPolyline2D[arrayList.size()]);
            }
            if (this.isoparmNumV > 2) {
                ArrayList<IVec[]> arrayList3 = new ArrayList<IVec[]>();
                arrayList = new ArrayList();
                for (n3 = 0; n3 < n5 - 1; ++n3) {
                    for (n2 = 0; n2 < this.isoparmNumRatio; ++n2) {
                        d = (double)n2 / (double)this.isoparmNumRatio;
                        if (n3 <= 0 && n2 <= 0) continue;
                        iIsoparmGraphic = new IIsoparmGraphic(this.surface, this.surface.u(n3, d), false, iTrimLoopGraphicArray, iTrimLoopGraphicArray2);
                        for (n = 0; n < iIsoparmGraphic.num(); ++n) {
                            arrayList3.add(iIsoparmGraphic.getLine(n).get());
                            arrayList.add(iIsoparmGraphic.getLine2D(n));
                        }
                    }
                }
                this.vlinePts = (IVec[][])arrayList3.toArray((T[])new IVec[arrayList3.size()][]);
                this.vline2 = arrayList.toArray(new IPolyline2D[arrayList.size()]);
            }
            this.initialized = true;
            this.simpleFlat = this.surface != null && this.surface.unum() == 2 && this.surface.vnum() == 2 && Math.abs(this.surface.cp(0, 0).dist(this.surface.cp(1, 0)) - this.surface.cp(0, 1).dist(this.surface.cp(1, 1))) <= IConfig.tolerance && Math.abs(this.surface.cp(0, 0).dist(this.surface.cp(0, 1)) - this.surface.cp(1, 0).dist(this.surface.cp(1, 1))) <= IConfig.tolerance && this.surface.isFlat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSurface() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            IVec2 iVec2;
            int n;
            int n2;
            if (this.simpleFlat && !this.surface.isFlat()) {
                this.simpleFlat = false;
                this.initSurface();
                return;
            }
            if (this.ulinePts != null) {
                if (this.ulinePts.length != this.uline2.length) {
                    this.ulinePts = new IVec[this.uline2.length][];
                }
                for (n2 = 0; n2 < this.uline2.length; ++n2) {
                    if (this.ulinePts[n2] == null || this.ulinePts[n2].length != this.uline2[n2].num()) {
                        this.ulinePts[n2] = new IVec[this.uline2[n2].num()];
                    }
                    for (n = 0; n < this.uline2[n2].num(); ++n) {
                        iVec2 = this.uline2[n2].get(n);
                        this.ulinePts[n2][n] = this.surface.pt(iVec2).get();
                    }
                }
            }
            if (this.vlinePts != null) {
                if (this.vlinePts.length != this.vline2.length) {
                    this.vlinePts = new IVec[this.vline2.length][];
                }
                for (n2 = 0; n2 < this.vline2.length; ++n2) {
                    if (this.vlinePts[n2] == null || this.vlinePts[n2].length != this.vline2[n2].num()) {
                        this.vlinePts[n2] = new IVec[this.vline2[n2].num()];
                    }
                    for (n = 0; n < this.vline2[n2].num(); ++n) {
                        iVec2 = this.vline2[n2].get(n);
                        this.vlinePts[n2][n] = this.surface.pt(iVec2).get();
                    }
                }
            }
            if (this.inTrimPts != null) {
                if (this.inTrimPts.length != this.inTrim2.length) {
                    this.inTrimPts = new IVec[this.inTrim2.length][];
                }
                for (n2 = 0; n2 < this.inTrim2.length; ++n2) {
                    if (this.inTrimPts[n2] == null || this.inTrimPts[n2].length != this.inTrim2[n2].num()) {
                        this.inTrimPts[n2] = new IVec[this.inTrim2[n2].num()];
                    }
                    for (n = 0; n < this.inTrim2[n2].num(); ++n) {
                        iVec2 = this.inTrim2[n2].get(n);
                        this.inTrimPts[n2][n] = this.surface.pt(iVec2).get();
                    }
                }
            }
            if (this.outTrimPts != null) {
                if (this.outTrimPts.length != this.outTrim2.length) {
                    this.outTrimPts = new IVec[this.outTrim2.length][];
                }
                for (n2 = 0; n2 < this.outTrim2.length; ++n2) {
                    if (this.outTrimPts[n2] == null || this.outTrimPts[n2].length != this.outTrim2[n2].num()) {
                        this.outTrimPts[n2] = new IVec[this.outTrim2[n2].num()];
                    }
                    for (n = 0; n < this.outTrim2[n2].num(); ++n) {
                        iVec2 = this.outTrim2[n2].get(n);
                        this.outTrimPts[n2][n] = this.surface.pt(iVec2).get();
                    }
                }
            }
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D() && iGraphicMode.isWireframe();
    }

    public synchronized void draw(IGraphics iGraphics) {
        if (!this.initialized) {
            this.initSurface();
        } else if (this.update) {
            this.updateSurface();
            this.update = false;
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            int n;
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            float[] fArray = null;
            fArray = this.color != null ? this.color.rgba() : IConfig.objectColor.rgba();
            if (!iGraphics3D.view().mode().isTransparentWireframe()) {
                if (fArray[3] != 1.0f) {
                    fArray = new float[]{fArray[0], fArray[1], fArray[2], 1.0f};
                }
            } else if (iGraphics3D.view().mode().isTransparent()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            }
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(fArray[0] * 255.0f, fArray[1] * 255.0f, fArray[2] * 255.0f, 0.0f);
            } else {
                iGraphics3D.stroke(fArray);
            }
            iGraphics3D.weight(weight);
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            if (this.inTrimPts != null) {
                for (n = 0; n < this.inTrimPts.length; ++n) {
                    iGraphics3D.drawLineLoop(this.inTrimPts[n]);
                }
            }
            if (this.outTrimPts != null) {
                for (n = 0; n < this.outTrimPts.length; ++n) {
                    iGraphics3D.drawLineLoop(this.outTrimPts[n]);
                }
            }
            if (this.ulinePts != null) {
                for (n = 0; n < this.ulinePts.length; ++n) {
                    iGraphics3D.drawLineStrip(this.ulinePts[n]);
                }
            }
            if (this.vlinePts != null) {
                for (n = 0; n < this.vlinePts.length; ++n) {
                    iGraphics3D.drawLineStrip(this.vlinePts[n]);
                }
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        }
    }
}

