/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.ICurveR;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class ICurveGraphicGL
extends IGraphicObject {
    public float weight = IConfig.strokeWeight;
    public ICurveI curve;
    public IVec[] pts;

    public ICurveGraphicGL(ICurve iCurve) {
        super(iCurve);
    }

    public ICurveGraphicGL(ICurveR iCurveR) {
        super(iCurveR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initCurve() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            if (this.curve == null) {
                if (this.parent instanceof ICurve) {
                    this.curve = ((ICurve)this.parent).curve;
                } else if (this.parent instanceof ICurveR) {
                    this.curve = ((ICurveR)this.parent).curve;
                }
            }
            if (this.curve.deg() == 1) {
                int n = this.curve.num();
                if (this.pts == null || this.pts.length != n) {
                    this.pts = new IVec[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.pts[i] = this.curve.cp(i).get();
                }
            } else {
                int n = IConfig.segmentResolution;
                int n2 = this.curve.epNum();
                int n3 = (n2 - 1) * n + 1;
                if (this.pts == null || this.pts.length != n3) {
                    this.pts = new IVec[n3];
                }
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (i >= n2 - 1 && j != 0) continue;
                        this.pts[i * n + j] = this.curve.pt(this.curve.u(i, (double)j / (double)n)).get();
                    }
                }
            }
            if (this.update) {
                this.update = false;
            }
        }
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }

    public synchronized void draw(IGraphics iGraphics) {
        if (this.curve == null || this.update) {
            this.initCurve();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            float f;
            float f2;
            float f3;
            float f4;
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            iGraphics3D.weight(this.weight);
            if (this.color != null) {
                f4 = this.color.getRed();
                f3 = this.color.getGreen();
                f2 = this.color.getBlue();
                f = this.color.getAlpha();
            } else {
                f4 = IConfig.objectColor.getRed();
                f3 = IConfig.objectColor.getGreen();
                f2 = IConfig.objectColor.getBlue();
                f = IConfig.objectColor.getAlpha();
            }
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                f = IConfig.transparentModeAlpha;
            }
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(f4, f3, f2, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            iGraphics3D.stroke(f4, f3, f2, f);
            if (this.pts.length == 2) {
                iGraphics3D.drawLineStrip(this.pts);
            } else {
                iGraphics3D.drawLineStrip(this.pts);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        }
    }
}

