/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IFieldGeo;
import igeo.IVec;
import igeo.IVecI;

public class ICurveFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public ICurveI curve;
    public ICurveI fieldCurve;

    public ICurveFieldGeo(ICurveI iCurveI, ICurveI iCurveI2) {
        this.curve = iCurveI;
        this.fieldCurve = iCurveI2;
    }

    public IVecI get(IVecI iVecI, double d) {
        return this.fieldCurve.pt(d);
    }

    public IVecI get(IVecI iVecI) {
        double d;
        double d2 = this.curve.u(iVecI);
        double d3 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            d = this.curve.pt(d2).dist(iVecI);
            if (d >= this.threshold) {
                return new IVec();
            }
            if (this.threshold > 0.0) {
                d3 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian) {
            d = this.curve.pt(d2).dist(iVecI);
            if (this.threshold > 0.0) {
                d3 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
            }
        }
        IVecI iVecI2 = this.get(iVecI, d2);
        if (this.constantIntensity) {
            double d4 = iVecI2.len();
            if (d4 < IConfig.tolerance) {
                return iVecI2.zero();
            }
            return iVecI2.len(d3);
        }
        return iVecI2.mul(d3);
    }

    public ICurveFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    public ICurveFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    public ICurveFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    public ICurveFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    public ICurveFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    public ICurveFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    public ICurveFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    public ICurveFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }
}

