/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IG;
import igeo.IOut;
import igeo.io.I3DXML;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class I3DXMLImporter {
    public static I3DXML read(String string) throws IOException {
        return I3DXMLImporter.read(new File(string));
    }

    public static I3DXML read(File file) throws IOException {
        int n;
        String string = file.getName();
        I3DXML i3DXML = new I3DXML(string);
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            BufferedInputStream bufferedInputStream;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String string2 = zipEntry.getName();
            i3DXML.fileList.add(string2);
            if (string2.toLowerCase().equals(string)) {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                I3DXMLImporter.read3DXML(i3DXML, string2, bufferedInputStream);
                bufferedInputStream.close();
                continue;
            }
            if (string2.toLowerCase().equals("CATMaterialRef.3dxml") || string2.toLowerCase().equals("CATRepImage.3dxml") || string2.toLowerCase().endsWith("3dxml") || !string2.toLowerCase().endsWith("3drep")) continue;
            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            I3DXMLImporter.read3DRep(i3DXML, string2, bufferedInputStream);
        }
        IOut.p("number of files in archive : " + i3DXML.fileList.size());
        IOut.p("number of Reference3D : " + i3DXML.references.size());
        IOut.p("number of Instance3D : " + i3DXML.instances.size());
        IOut.p("number of ReferenceRep : " + i3DXML.referenceReps.size());
        IOut.p("number of InstanceRep : " + i3DXML.instanceReps.size());
        IOut.p("number of RepresentationDocument : " + i3DXML.representationDocuments.size());
        for (n = 0; n < i3DXML.references.size(); ++n) {
            IOut.p("reference " + n + ": " + i3DXML.references.get((int)n).name);
        }
        for (n = 0; n < i3DXML.instances.size(); ++n) {
            IOut.p("instance " + n + ": " + i3DXML.instances.get((int)n).name);
        }
        for (n = 0; n < i3DXML.referenceReps.size(); ++n) {
            IOut.p("referenceRep " + n + ": " + i3DXML.referenceReps.get((int)n).name);
        }
        for (n = 0; n < i3DXML.instanceReps.size(); ++n) {
            IOut.p("instanceRep " + n + ": " + i3DXML.instanceReps.get((int)n).name);
        }
        return i3DXML;
    }

    public static I3DXML read(InputStream inputStream, String string) throws IOException {
        int n;
        int n2;
        ZipEntry zipEntry;
        String string2 = string;
        I3DXML i3DXML = new I3DXML(string);
        ZipInputStreamWrapper zipInputStreamWrapper = new ZipInputStreamWrapper(new BufferedInputStream(inputStream));
        while ((zipEntry = zipInputStreamWrapper.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            String string3 = zipEntry.getName();
            i3DXML.fileList.add(string3);
            if (string3.toLowerCase().equals(string2)) {
                IG.err("reading main 3dxml file");
                I3DXMLImporter.read3DXML(i3DXML, string3, zipInputStreamWrapper);
                IG.err("end reading main 3dxml file");
                continue;
            }
            if (string3.toLowerCase().equals("CATMaterialRef.3dxml") || string3.toLowerCase().equals("CATRepImage.3dxml") || string3.toLowerCase().endsWith("3dxml") || !string3.toLowerCase().endsWith("3drep")) continue;
            IG.err("reading 3drep file");
            I3DXMLImporter.read3DRep(i3DXML, string3, zipInputStreamWrapper);
            IG.err("end reading 3drep file");
        }
        IOut.p("number of files in archive : " + i3DXML.fileList.size());
        IOut.p("number of Reference3D : " + i3DXML.references.size());
        IOut.p("number of Instance3D : " + i3DXML.instances.size());
        IOut.p("number of ReferenceRep : " + i3DXML.referenceReps.size());
        IOut.p("number of InstanceRep : " + i3DXML.instanceReps.size());
        IOut.p("number of RepresentationDocument : " + i3DXML.representationDocuments.size());
        i3DXML.linkNodes();
        i3DXML.instantiate();
        for (n2 = 0; n2 < i3DXML.references.size(); ++n2) {
            IOut.p("reference " + n2 + ": " + i3DXML.references.get((int)n2).name);
            for (n = 0; i3DXML.references.get((int)n2).components != null && n < i3DXML.references.get((int)n2).components.size(); ++n) {
                IOut.p("reference " + n2 + ": component " + n + ": " + i3DXML.references.get((int)n2).components.get((int)n).name + " : (" + i3DXML.references.get((int)n2).components.get(n).getClass().getName() + ")");
            }
            for (n = 0; i3DXML.references.get((int)n2).instances != null && n < i3DXML.references.get((int)n2).instances.size(); ++n) {
                IOut.p("reference " + n2 + ": instance " + n + ": " + i3DXML.references.get((int)n2).instances.get((int)n).name);
            }
        }
        for (n2 = 0; n2 < i3DXML.instances.size(); ++n2) {
            IOut.p("instance " + n2 + ": " + i3DXML.instances.get((int)n2).name);
        }
        for (n2 = 0; n2 < i3DXML.referenceReps.size(); ++n2) {
            IOut.p("referenceRep " + n2 + ": " + i3DXML.referenceReps.get((int)n2).name);
            for (n = 0; i3DXML.referenceReps.get((int)n2).instanceReps != null && n < i3DXML.referenceReps.get((int)n2).instanceReps.size(); ++n) {
                IOut.p("referenceRep " + n2 + ": instanceRep " + n + ": " + i3DXML.referenceReps.get((int)n2).instanceReps.get((int)n).name);
            }
        }
        for (n2 = 0; n2 < i3DXML.instanceReps.size(); ++n2) {
            IOut.p("instanceRep " + n2 + ": " + i3DXML.instanceReps.get((int)n2).name);
        }
        return i3DXML;
    }

    public static Node getXMLNode(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IOut.err("XML document parsing failed");
            return null;
        }
    }

    public static void read3DXML(I3DXML i3DXML, String string, InputStream inputStream) throws IOException {
        IOut.p("reading document: " + string);
        Node node = I3DXMLImporter.getXMLNode(inputStream);
        NodeList nodeList = node.getChildNodes();
        if (node.getNodeType() == 9 && nodeList.getLength() == 1) {
            Node node2 = nodeList.item(0);
            I3DXMLImporter.readModel3DXML(i3DXML, node2);
        } else {
            IOut.err("no document node found");
        }
    }

    public static void readModel3DXML(I3DXML i3DXML, Node node) {
        if (node.getNodeName().equals("Model_3dxml")) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeName().equals("Header")) {
                    I3DXMLImporter.readHeader(i3DXML, node2);
                    continue;
                }
                if (node2.getNodeName().equals("ProductStructure")) {
                    I3DXMLImporter.readProductStructure(i3DXML, node2);
                    continue;
                }
                if (node2.getNodeName().equals("DefaultView")) {
                    I3DXMLImporter.readDefaultView(i3DXML, node2);
                    continue;
                }
                if (node2.getNodeName().equals("CATMaterialRef")) {
                    I3DXMLImporter.readCATMaterialRef(i3DXML, node2);
                    continue;
                }
                if (node2.getNodeName().equals("CATRepImage")) {
                    I3DXMLImporter.readCATRepImage(i3DXML, node2);
                    continue;
                }
                if (!node2.getNodeName().equals("CATMaterial")) continue;
                I3DXMLImporter.readCATMaterial(i3DXML, node2);
            }
        } else {
            IOut.err("invalid node for Model_3dxml: " + node.getNodeName());
        }
    }

    public static void readHeader(I3DXML i3DXML, Node node) {
    }

    public static void readProductStructure(I3DXML i3DXML, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("Reference3D")) {
                I3DXMLImporter.readReference3D(i3DXML, node2);
                continue;
            }
            if (node2.getNodeName().equals("Instance3D")) {
                I3DXMLImporter.readInstance3D(i3DXML, node2);
                continue;
            }
            if (node2.getNodeName().equals("ReferenceRep")) {
                I3DXMLImporter.readReferenceRep(i3DXML, node2);
                continue;
            }
            if (!node2.getNodeName().equals("InstanceRep")) continue;
            I3DXMLImporter.readInstanceRep(i3DXML, node2);
        }
    }

    public static void readReference3D(I3DXML i3DXML, Node node) {
        IOut.p();
        try {
            int n = I3DXMLImporter.getIntegerAttribute(node, "id");
            String string = I3DXMLImporter.getAttribute(node, "name");
            IOut.p("id = " + n);
            IOut.p("name = " + string);
            I3DXML.Reference3D reference3D = new I3DXML.Reference3D(n, string);
            i3DXML.references.add(reference3D);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void readInstance3D(I3DXML i3DXML, Node node) {
        IOut.p();
        try {
            int n = I3DXMLImporter.getIntegerAttribute(node, "id");
            String string = I3DXMLImporter.getAttribute(node, "name");
            IOut.p("id = " + n);
            IOut.p("name = " + string);
            I3DXML.Instance3D instance3D = new I3DXML.Instance3D(n, string);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                try {
                    if (node2.getNodeName().equals("IsAggregatedBy")) {
                        instance3D.aggregatedBy = I3DXMLImporter.getElementIntegerValue(node2);
                        IOut.p("aggregatedBy = " + instance3D.aggregatedBy);
                        continue;
                    }
                    if (node2.getNodeName().equals("IsInstanceOf")) {
                        instance3D.instanceOf = I3DXMLImporter.getElementIntegerValue(node2);
                        IOut.p("instanceOf = " + instance3D.instanceOf);
                        continue;
                    }
                    if (!node2.getNodeName().equals("RelativeMatrix")) continue;
                    instance3D.relativeMatrix = I3DXMLImporter.getMatrix4x3(node2);
                    IOut.p(string + ": relativeMatrix = \n" + instance3D.relativeMatrix);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            i3DXML.instances.add(instance3D);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void readReferenceRep(I3DXML i3DXML, Node node) {
        IOut.p();
        try {
            int n = I3DXMLImporter.getIntegerAttribute(node, "id");
            String string = I3DXMLImporter.getAttribute(node, "name");
            IOut.p("id = " + n);
            IOut.p("name = " + string);
            I3DXML.ReferenceRep referenceRep = new I3DXML.ReferenceRep(n, string);
            String string2 = I3DXMLImporter.getAttribute(node, "format");
            if (string2.equals("UVR")) {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.UVR;
                IOut.p("format = UVR");
            } else if (string2.equals("TECHREP")) {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.TECHREP;
                IOut.p("format = TECHREP");
            } else if (string2.equals("TESSELLATED")) {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.TESSELLATED;
                IOut.p("format = TESSELLATED");
            } else if (string2.equals("BEHAVIORAL")) {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.BEHAVIORAL;
                IOut.p("format = BEHAVIORAL");
            } else if (string2.equals("*")) {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.OTHER;
                IOut.p("format = *");
            } else {
                referenceRep.format = I3DXML.ReferenceRep.FormatType.OTHER;
                IOut.p("format = *");
            }
            referenceRep.associatedURN = I3DXMLImporter.getAttribute(node, "associatedFile");
            String[] stringArray = referenceRep.associatedURN.split(":");
            referenceRep.associatedFile = stringArray[stringArray.length - 1];
            IOut.p("associatedFile = " + referenceRep.associatedFile);
            i3DXML.referenceReps.add(referenceRep);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void readAssociatedFile(I3DXML i3DXML, I3DXML.ReferenceRep referenceRep) {
        String[] stringArray;
        String string;
        if (referenceRep == null || referenceRep.associatedFile == null || (string = (stringArray = referenceRep.associatedFile.split(":"))[stringArray.length - 1]).toLowerCase().endsWith("3drep")) {
            // empty if block
        }
    }

    public static void readInstanceRep(I3DXML i3DXML, Node node) {
        IOut.p();
        try {
            int n = I3DXMLImporter.getIntegerAttribute(node, "id");
            String string = I3DXMLImporter.getAttribute(node, "name");
            IOut.p("id = " + n);
            IOut.p("name = " + string);
            I3DXML.InstanceRep instanceRep = new I3DXML.InstanceRep(n, string);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                try {
                    if (node2.getNodeName().equals("IsAggregatedBy")) {
                        instanceRep.aggregatedBy = I3DXMLImporter.getElementIntegerValue(node2);
                        IOut.p("aggregatedBy = " + instanceRep.aggregatedBy);
                        continue;
                    }
                    if (!node2.getNodeName().equals("IsInstanceOf")) continue;
                    instanceRep.instanceOf = I3DXMLImporter.getElementIntegerValue(node2);
                    IOut.p("instanceOf = " + instanceRep.instanceOf);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            i3DXML.instanceReps.add(instanceRep);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void readDefaultView(I3DXML i3DXML, Node node) {
    }

    public static void readCATMaterialRef(I3DXML i3DXML, Node node) {
    }

    public static void readCATMaterial(I3DXML i3DXML, Node node) {
    }

    public static void readCATRepImage(I3DXML i3DXML, Node node) {
    }

    public static void read3DRep(I3DXML i3DXML, String string, InputStream inputStream) throws IOException {
        IOut.p("reading document: " + string);
        Node node = I3DXMLImporter.getXMLNode(inputStream);
        NodeList nodeList = node.getChildNodes();
        if (node.getNodeType() == 9 && nodeList.getLength() == 1) {
            if (nodeList.item(0).getNodeName().equals("XMLRepresentation")) {
                I3DXML.XMLRepresentationDocument xMLRepresentationDocument = new I3DXML.XMLRepresentationDocument();
                xMLRepresentationDocument.filename = string;
                i3DXML.representationDocuments.add(xMLRepresentationDocument);
                I3DXMLImporter.readXMLRepresentation(xMLRepresentationDocument, nodeList.item(0));
            }
        } else {
            IOut.err("no document node found");
        }
    }

    public static void readXMLRepresentation(I3DXML.XMLRepresentationDocument xMLRepresentationDocument, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Root")) continue;
            xMLRepresentationDocument.root = I3DXMLImporter.readVisualizationRepType(xMLRepresentationDocument, nodeList.item(i));
        }
    }

    public static I3DXML.VisualizationRepType readVisualizationRepType(I3DXML.XMLRepresentationDocument xMLRepresentationDocument, Node node) {
        String string = I3DXMLImporter.getAttribute(node, "xsi:type");
        if (string != null) {
            if (string.equals("VisualizationRepType")) {
                int n = -1;
                try {
                    n = I3DXMLImporter.getIntegerAttribute(node, "id");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                I3DXML.VisualizationRepType visualizationRepType = new I3DXML.VisualizationRepType(n);
                xMLRepresentationDocument.representations.add(visualizationRepType);
                return visualizationRepType;
            }
            if (string.equals("BagRepType")) {
                int n = -1;
                try {
                    n = I3DXMLImporter.getIntegerAttribute(node, "id");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                I3DXML.BagRepType bagRepType = new I3DXML.BagRepType(n);
                xMLRepresentationDocument.representations.add(bagRepType);
                IOut.p("BagType : id : " + bagRepType.id);
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!nodeList.item(i).getNodeName().equals("Rep")) continue;
                    I3DXML.VisualizationRepType visualizationRepType = I3DXMLImporter.readVisualizationRepType(xMLRepresentationDocument, nodeList.item(i));
                    if (visualizationRepType != null) {
                        bagRepType.rep.add(visualizationRepType);
                        continue;
                    }
                    IOut.err("invalid child representation for BagRepType");
                }
                return bagRepType;
            }
            if (string.equals("PolygonalRepType")) {
                return I3DXMLImporter.readPolygonalRepType(xMLRepresentationDocument, node);
            }
            IOut.err("unknown type : " + string);
        } else {
            IOut.err("no type for VisualizationRepType in " + node.getNodeName());
        }
        return null;
    }

    public static I3DXML.PolygonalRepType readPolygonalRepType(I3DXML.XMLRepresentationDocument xMLRepresentationDocument, Node node) {
        int n = -1;
        try {
            n = I3DXMLImporter.getIntegerAttribute(node, "id");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        I3DXML.PolygonalRepType polygonalRepType = new I3DXML.PolygonalRepType(n);
        xMLRepresentationDocument.representations.add(polygonalRepType);
        try {
            polygonalRepType.solid = I3DXMLImporter.getBooleanAttribute(node, "solid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            polygonalRepType.accuracy = I3DXMLImporter.getDoubleAttribute(node, "accuracy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            String string = nodeList.item(i).getNodeName();
            if (string == null || string.equals("SurfaceAttributes") || string.equals("LineAttributes") || string.equals("PolygonalLOD")) continue;
            if (string.equals("Faces")) {
                object = I3DXMLImporter.readFaceSet(nodeList.item(i));
                if (object == null) continue;
                polygonalRepType.faces.add((I3DXML.FaceSetType)object);
                continue;
            }
            if (string.equals("Edges")) {
                object = I3DXMLImporter.readPolylineSet(nodeList.item(i));
                if (object == null) continue;
                polygonalRepType.edges.add((I3DXML.PolylineSetType)object);
                continue;
            }
            if (!string.equals("VertexBuffer") || (object = I3DXMLImporter.readVertexBuffer(nodeList.item(i))) == null) continue;
            polygonalRepType.vertexBuffer = object;
        }
        IOut.p("PolygonalRepType : id : " + polygonalRepType.id);
        return polygonalRepType;
    }

    public static I3DXML.FaceSetType readFaceSet(Node node) {
        I3DXML.FaceSetType faceSetType = new I3DXML.FaceSetType();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            I3DXML.FaceGPType faceGPType;
            String string = nodeList.item(i).getNodeName();
            if (string == null || string.equals("SurfaceAttributes") || !string.equals("Face") || (faceGPType = I3DXMLImporter.readFaceGP(nodeList.item(i))) == null) continue;
            faceSetType.faces.add(faceGPType);
        }
        return faceSetType;
    }

    public static I3DXML.FaceGPType readFaceGP(Node node) {
        I3DXML.FaceGPType faceGPType = new I3DXML.FaceGPType();
        String string = I3DXMLImporter.getAttribute(node, "triangles");
        String string2 = I3DXMLImporter.getAttribute(node, "strips");
        String string3 = I3DXMLImporter.getAttribute(node, "fans");
        if (string != null) {
            faceGPType.setTriangles(string);
        }
        if (string2 != null) {
            faceGPType.setStrips(string2);
        }
        if (string3 != null) {
            faceGPType.setFans(string3);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string4 = nodeList.item(i).getNodeName();
            if (string4 != null && !string4.equals("SurfaceAttributes")) continue;
        }
        return faceGPType;
    }

    public static I3DXML.PolylineSetType readPolylineSet(Node node) {
        I3DXML.PolylineSetType polylineSetType = new I3DXML.PolylineSetType();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            I3DXML.PolylineGPType polylineGPType;
            String string = nodeList.item(i).getNodeName();
            if (string == null || string.equals("LineAttributes") || !string.equals("Polyline") || (polylineGPType = I3DXMLImporter.readPolylineGP(nodeList.item(i))) == null) continue;
            polylineSetType.polyline.add(polylineGPType);
        }
        return polylineSetType;
    }

    public static I3DXML.PolylineGPType readPolylineGP(Node node) {
        String string;
        I3DXML.PolylineGPType polylineGPType = new I3DXML.PolylineGPType();
        polylineGPType.vertices = string = I3DXMLImporter.getAttribute(node, "vertices");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeName();
            if (string2 != null && !string2.equals("LineAttributes")) continue;
        }
        return polylineGPType;
    }

    public static I3DXML.VertexBufferType readVertexBuffer(Node node) {
        I3DXML.VertexBufferType vertexBufferType = new I3DXML.VertexBufferType();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Object object;
            String string2 = nodeList.item(i).getNodeName();
            if (string2 == null) continue;
            if (string2.equals("Positions")) {
                object = nodeList.item(i).getFirstChild();
                if (object == null) continue;
                string = object.getNodeValue();
                vertexBufferType.setPositions(string);
                IOut.p("vertices num = " + vertexBufferType.getVertexNum());
                continue;
            }
            if (string2.equals("Normals")) {
                object = nodeList.item(i).getFirstChild();
                if (object == null) continue;
                string = object.getNodeValue();
                vertexBufferType.setNormals(string);
                continue;
            }
            if (string2.equals("TextureCoordinates")) {
                object = I3DXMLImporter.readTextureCoordinatesBuffer(nodeList.item(i));
                vertexBufferType.textureCoordinates.add((I3DXML.TextureCoordinatesBufferType)object);
                continue;
            }
            if (!string2.equals("DiffuseColors") && !string2.equals("SpecularColors")) continue;
        }
        return vertexBufferType;
    }

    public static I3DXML.TextureCoordinatesBufferType readTextureCoordinatesBuffer(Node node) {
        Node node2;
        I3DXML.TextureCoordinatesBufferType textureCoordinatesBufferType = new I3DXML.TextureCoordinatesBufferType();
        try {
            int n;
            textureCoordinatesBufferType.channel = n = I3DXMLImporter.getIntegerAttribute(node, "channel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = I3DXMLImporter.getAttribute(node, "dimension");
        if (string != null) {
            if (string.equals("1D")) {
                textureCoordinatesBufferType.dimension = I3DXML.TextureCoordinatesBufferType.TextureDimensionType._1D;
            } else if (string.equals("2D")) {
                textureCoordinatesBufferType.dimension = I3DXML.TextureCoordinatesBufferType.TextureDimensionType._2D;
            } else if (string.equals("3D")) {
                textureCoordinatesBufferType.dimension = I3DXML.TextureCoordinatesBufferType.TextureDimensionType._3D;
            }
        }
        if ((node2 = node.getFirstChild()) != null) {
            String string2 = node2.getNodeValue();
            textureCoordinatesBufferType.setTextureCoordinates(string2);
            IOut.p("texture coordinates num = " + textureCoordinatesBufferType.textureXYZ.length);
        }
        return textureCoordinatesBufferType;
    }

    public static String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static int getIntegerAttribute(Node node, String string) throws NumberFormatException {
        String string2 = I3DXMLImporter.getAttribute(node, string);
        if (string2 == null) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(string2);
    }

    public static double getDoubleAttribute(Node node, String string) throws NumberFormatException {
        String string2 = I3DXMLImporter.getAttribute(node, string);
        if (string2 == null) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(string2);
    }

    public static boolean getBooleanAttribute(Node node, String string) throws NumberFormatException {
        String string2 = I3DXMLImporter.getAttribute(node, string);
        if (string2 == null) {
            throw new NumberFormatException();
        }
        if (string2.equals("0") || string2.toLowerCase().equals("false")) {
            return false;
        }
        if (string2.equals("1") || string2.toLowerCase().equals("true")) {
            return true;
        }
        throw new NumberFormatException();
    }

    public static String getElementValue(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static int getElementIntegerValue(Node node) throws NumberFormatException {
        String string = I3DXMLImporter.getElementValue(node);
        if (string == null) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(string);
    }

    public static I3DXML.Matrix4x3 getMatrix4x3(Node node) throws NumberFormatException {
        String string = I3DXMLImporter.getElementValue(node);
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 12) {
            throw new NumberFormatException();
        }
        double[] dArray = new double[12];
        for (int i = 0; i < 12; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return new I3DXML.Matrix4x3(dArray);
    }

    public static void printNode(Node node, int n) {
        String string;
        int n2;
        int n3;
        String string2 = "  ";
        for (int i = 0; i < n; ++i) {
            System.out.print(string2);
        }
        String string3 = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                string3 = "ELEMENT_NODE";
                break;
            }
            case 2: {
                string3 = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                string3 = "TEXT_NODE";
                break;
            }
            case 4: {
                string3 = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                string3 = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 6: {
                string3 = "ENTITY_NODE";
                break;
            }
            case 7: {
                string3 = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 8: {
                string3 = "COMMENT_NODE";
                break;
            }
            case 9: {
                string3 = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                string3 = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                string3 = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 12: {
                string3 = "NOTATION_NODE";
                break;
            }
            default: {
                string3 = "UNKNOWN(" + String.valueOf(s) + ")";
            }
        }
        System.out.println("node type: " + string3);
        if (s != 3 && s != 9) {
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print(string2);
            }
            System.out.println("node name: " + node.getNodeName());
        }
        if (node.hasAttributes()) {
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print(string2);
            }
            System.out.println("node attr:");
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                I3DXMLImporter.printNode(namedNodeMap.item(n2), n + 1);
            }
        }
        if ((string = node.getNodeValue()) != null) {
            if (string.length() > 100) {
                string = string.substring(0, 100);
            }
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print(string2);
            }
            System.out.println("node valu: " + string);
        }
    }

    public static void recursivePrint(Node node, int n) {
        I3DXMLImporter.printNode(node, n);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            I3DXMLImporter.recursivePrint(node2, n + 1);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string == null) {
            return;
        }
        IG.init();
        try {
            I3DXMLImporter.read(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class ZipInputStreamWrapper
    extends ZipInputStream {
        ZipInputStreamWrapper(InputStream inputStream) {
            super(inputStream);
        }

        public void close() {
        }

        public void doClose() throws IOException {
            super.close();
        }
    }
}

