/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IBounds;
import igeo.IGraphicI;
import igeo.IObject;
import igeo.IOut;
import igeo.gui.IComponent;
import igeo.gui.IGraphics;
import igeo.gui.INavigator;
import igeo.gui.IPane;
import igeo.gui.IPanel;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPaneLight
extends IComponent
implements IPane {
    public IPanel parent;
    public IView view;
    public INavigator navigator;
    public float borderWidth = 0.0f;
    public Color borderColor = Color.gray;
    public Stroke borderStroke = new BasicStroke(this.borderWidth);

    public IPaneLight(int n, int n2, int n3, int n4, IView iView, IPanel iPanel) {
        super(n, n2, n3, n4);
        this.view = iView;
        this.parent = iPanel;
        iView.setPane(this);
        this.navigator = new INavigator(iView, this);
    }

    public IPaneLight(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public void setPanel(IPanel iPanel) {
        this.parent = iPanel;
    }

    @Override
    public IPanel getPanel() {
        return this.parent;
    }

    @Override
    public void setBorderWidth(float f) {
        this.borderWidth = f;
        this.borderStroke = new BasicStroke(this.borderWidth);
    }

    @Override
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public INavigator navigator() {
        return this.navigator;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public void setView(IView iView) {
        this.view = iView;
        this.view.setPane(this);
        if (this.navigator == null) {
            this.navigator = new INavigator(this.view, this);
        } else {
            this.navigator.setView(this.view);
        }
    }

    @Override
    public IView getView() {
        return this.view;
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.view != null) {
            ArrayList<IGraphicI> arrayList = this.parent.ig.server().graphicServer().getObjects(this.view);
            iGraphics.draw(arrayList, this.view);
        } else {
            IOut.err("view is null");
        }
    }

    @Override
    public void focus() {
        this.parent.setBounds();
        this.view.focus(this.parent.getBounds());
    }

    @Override
    public void focus(ArrayList<IObject> arrayList) {
        IBounds iBounds = new IBounds();
        iBounds.setObjects(arrayList);
        this.view.focus(iBounds);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.navigator.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.navigator.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.navigator.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.navigator.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.navigator.mouseExited(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.navigator.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.navigator.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.navigator.mouseWheelMoved(mouseWheelEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.navigator.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.navigator.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.navigator.keyTyped(keyEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

