/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IEdge;
import igeo.IFace;
import igeo.IGraphicObject;
import igeo.IMesh;
import igeo.IMeshI;
import igeo.IMeshR;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class IMeshGraphicGL
extends IGraphicObject {
    public static float weight = IConfig.strokeWeight;
    public IMeshI mesh;
    public IVec[][] facePts;
    public IVec[][] faceNormal;
    public IVec[][] edgePts;

    public IMeshGraphicGL(IMesh iMesh) {
        super(iMesh);
    }

    public IMeshGraphicGL(IMeshR iMeshR) {
        super(iMeshR);
    }

    public void initMesh() {
        Object object;
        int n;
        if (this.parent instanceof IMesh) {
            this.mesh = ((IMesh)this.parent).mesh;
        } else if (this.parent instanceof IMeshR) {
            this.mesh = ((IMeshR)this.parent).mesh;
        }
        this.facePts = new IVec[this.mesh.faceNum()][];
        this.faceNormal = new IVec[this.mesh.faceNum()][];
        for (n = 0; n < this.mesh.faceNum(); ++n) {
            object = this.mesh.face(n);
            this.facePts[n] = new IVec[((IFace)object).vertexNum()];
            this.faceNormal[n] = new IVec[((IFace)object).vertexNum()];
            for (int i = 0; i < ((IFace)object).vertexNum(); ++i) {
                this.facePts[n][i] = ((IFace)object).getVertex(i).get();
                this.faceNormal[n][i] = ((IFace)object).getVertex(i).normal().get();
            }
        }
        this.edgePts = new IVec[this.mesh.edgeNum()][];
        for (n = 0; n < this.mesh.edgeNum(); ++n) {
            object = this.mesh.edge(n);
            this.edgePts[n] = new IVec[2];
            this.edgePts[n][0] = ((IEdge)object).getVertex(0).get();
            this.edgePts[n][1] = ((IEdge)object).getVertex(1).get();
        }
    }

    public void setWeight(float f) {
        weight = f;
    }

    public float getWeight() {
        return weight;
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }

    public void draw(IGraphics iGraphics) {
        if (this.mesh == null) {
            this.initMesh();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            int n;
            float f;
            float f2;
            float f3;
            float f4;
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            if (this.color != null) {
                f4 = this.color.getRed();
                f3 = this.color.getGreen();
                f2 = this.color.getBlue();
                f = this.color.getAlpha();
            } else {
                f4 = IConfig.objectColor.getRed();
                f3 = IConfig.objectColor.getGreen();
                f2 = IConfig.objectColor.getBlue();
                f = IConfig.objectColor.getAlpha();
            }
            if (iGraphics3D.view().mode().isTransparent()) {
                f = IConfig.transparentModeAlpha;
            }
            if (iGraphics3D.view().mode().isLight()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(f4, f3, f2, 0.0f);
            }
            iGraphics3D.clr(f4, f3, f2, f);
            if (iGraphics3D.view().mode().isFill()) {
                n = 0;
                for (int i = 0; i < this.facePts.length; ++i) {
                    if (this.facePts[i].length == 3) {
                        iGraphics3D.drawTriangles(this.facePts[i], this.faceNormal[i]);
                        continue;
                    }
                    if (this.facePts[i].length == 4) {
                        iGraphics3D.drawQuads(this.facePts[i], this.faceNormal[i]);
                        continue;
                    }
                    iGraphics3D.drawPolygon(this.facePts[i], this.faceNormal[i]);
                }
            }
            f = iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe() ? (float)IConfig.transparentModeAlpha : (this.color != null ? (float)this.color.getAlpha() : (float)IConfig.objectColor.getAlpha());
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(f4, f3, f2, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            if (iGraphics3D.view().mode().isWireframe()) {
                iGraphics3D.weight(weight);
                iGraphics3D.stroke(f4, f3, f2, f);
                for (n = 0; n < this.edgePts.length; ++n) {
                    iGraphics3D.drawLines(this.edgePts[n]);
                }
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        }
    }
}

