/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IFace;
import igeo.IG;
import igeo.IMesh;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVertex;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class I3DXMLImporter {
    public ArrayList<IVec> positions = new ArrayList();
    public ArrayList<IVec> normals = new ArrayList();
    public ArrayList<IVec2> texture = new ArrayList();
    public ArrayList<IVertex> vertices;
    public ArrayList<Face> faces = new ArrayList();

    public void createMesh() {
        Object object;
        int n;
        this.vertices = new ArrayList();
        for (n = 0; n < this.positions.size(); ++n) {
            object = new IVertex(this.positions.get(n));
            this.vertices.add((IVertex)object);
        }
        if (this.vertices.size() == this.normals.size()) {
            for (n = 0; n < this.vertices.size(); ++n) {
                this.vertices.get(n).nml(this.normals.get(n));
            }
        }
        if (this.vertices.size() == this.texture.size()) {
            for (n = 0; n < this.vertices.size(); ++n) {
                this.vertices.get(n).texture(this.texture.get(n));
            }
        }
        for (n = 0; n < this.faces.size(); ++n) {
            IFace iFace;
            Object object2;
            int n2;
            object = this.faces.get(n);
            ArrayList<IFace> arrayList = new ArrayList<IFace>();
            for (n2 = 0; n2 < ((Face)object).triangles.size(); ++n2) {
                object2 = ((Face)object).triangles.get(n2);
                IFace iFace2 = new IFace(this.vertices.get(((Triangle)object2).i), this.vertices.get(((Triangle)object2).j), this.vertices.get(((Triangle)object2).k));
                arrayList.add(iFace2);
            }
            for (n2 = 0; n2 < ((Face)object).strips.size(); ++n2) {
                object2 = ((Face)object).strips.get(n2);
                for (int i = 0; i < ((Strip)object2).index.size() - 2; ++i) {
                    iFace = null;
                    iFace = i % 2 == 0 ? new IFace(this.vertices.get(((Strip)object2).index.get(i)), this.vertices.get(((Strip)object2).index.get(i + 1)), this.vertices.get(((Strip)object2).index.get(i + 2))) : new IFace(this.vertices.get(((Strip)object2).index.get(i)), this.vertices.get(((Strip)object2).index.get(i + 2)), this.vertices.get(((Strip)object2).index.get(i + 1)));
                    arrayList.add(iFace);
                }
            }
            for (n2 = 0; n2 < ((Face)object).fans.size(); ++n2) {
                object2 = ((Face)object).fans.get(n2);
                for (int i = 1; i < ((Fan)object2).index.size() - 1; ++i) {
                    iFace = new IFace(this.vertices.get(((Fan)object2).index.get(0)), this.vertices.get(((Fan)object2).index.get(i)), this.vertices.get(((Fan)object2).index.get(i + 1)));
                    arrayList.add(iFace);
                }
            }
            IMesh iMesh = new IMesh();
            for (int i = 0; i < arrayList.size(); ++i) {
                iMesh.addFace((IFace)arrayList.get(i));
            }
        }
    }

    public void trace(Node node) {
        this.recurse(node);
    }

    public void recurse(Node node) {
        Object object;
        short s = node.getNodeType();
        String string = node.getNodeName();
        boolean bl = false;
        if (s != 3 && s == 1) {
            if (string.equals("PolygonalLOD")) {
                bl = true;
            } else if (string.equals("Faces")) {
                this.readFaces(node);
                bl = true;
            } else if (string.equals("VertexBuffer")) {
                this.readVertexBuffer(node);
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node2 = object.item(i);
                short s2 = node2.getNodeType();
                String string2 = node2.getNodeName();
            }
        }
        if ((object = node.getNodeValue()) != null) {
            // empty if block
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            this.recurse(node3);
        }
    }

    public void readFaces(Node node) {
        IG.p();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Face")) continue;
            this.readFace(node2);
        }
    }

    public void readFace(Node node) {
        Face face = new Face();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            int n;
            String[] stringArray;
            String string;
            Node node2 = namedNodeMap.item(i);
            short s = node2.getNodeType();
            String string2 = node2.getNodeName();
            if (string2.equals("fans")) {
                string = node2.getNodeValue();
                stringArray = string.split("\\s*,\\s*");
                for (n = 0; n < stringArray.length; ++n) {
                    face.addFan(stringArray[n]);
                }
                continue;
            }
            if (string2.equals("strips")) {
                string = node2.getNodeValue();
                stringArray = string.split("\\s*,\\s*");
                for (n = 0; n < stringArray.length; ++n) {
                    face.addStrip(stringArray[n]);
                }
                continue;
            }
            if (!string2.equals("triangles")) continue;
            string = node2.getNodeValue();
            stringArray = string.split("\\s*,\\s*");
            for (n = 0; n < stringArray.length; ++n) {
                face.addTriangle(stringArray[n]);
            }
        }
        this.faces.add(face);
    }

    public void readVertexBuffer(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("Positions")) {
                this.readPositions(node2);
                continue;
            }
            if (node2.getNodeName().equals("Normals")) {
                this.readNormals(node2);
                continue;
            }
            if (!node2.getNodeName().equals("TextureCoordinates")) continue;
            this.readTextureCoordinates(node2);
        }
    }

    public void readPositions(Node node) {
        IG.p();
        Node node2 = node.getFirstChild();
        if (node2 != null && node2.getNodeType() == 3) {
            String string = node2.getNodeValue();
            String[] stringArray = string.split("\\s*,\\s*");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                if (stringArray2.length < 3) continue;
                double d = Double.parseDouble(stringArray2[0]);
                double d2 = Double.parseDouble(stringArray2[1]);
                double d3 = Double.parseDouble(stringArray2[2]);
                IVec iVec = new IVec(d, d2, d3);
                this.positions.add(iVec);
            }
        }
    }

    public void readNormals(Node node) {
        IG.p();
        Node node2 = node.getFirstChild();
        if (node2 != null && node2.getNodeType() == 3) {
            String string = node2.getNodeValue();
            String[] stringArray = string.split("\\s*,\\s*");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                if (stringArray2.length < 3) continue;
                double d = Double.parseDouble(stringArray2[0]);
                double d2 = Double.parseDouble(stringArray2[1]);
                double d3 = Double.parseDouble(stringArray2[2]);
                IVec iVec = new IVec(d, d2, d3);
                this.normals.add(iVec);
            }
        }
    }

    public void readTextureCoordinates(Node node) {
        IG.p();
        Node node2 = node.getFirstChild();
        if (node2 != null && node2.getNodeType() == 3) {
            String string = node2.getNodeValue();
            String[] stringArray = string.split("\\s*,\\s*");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                double d = 0.0;
                double d2 = 0.0;
                if (stringArray2 == null) continue;
                if (stringArray2.length > 0) {
                    d = Double.parseDouble(stringArray2[0]);
                }
                if (stringArray2.length > 1) {
                    d2 = Double.parseDouble(stringArray2[1]);
                }
                this.texture.add(new IVec2(d, d2));
            }
        }
    }

    public static void recursivePrint(Node node, int n) {
        String string;
        int n2;
        int n3;
        String string2 = "  ";
        for (n3 = 0; n3 < n; ++n3) {
            System.out.print(string2);
        }
        System.out.println("node type: " + node.getNodeType());
        for (n3 = 0; n3 < n; ++n3) {
            System.out.print(string2);
        }
        System.out.println("node name: " + node.getNodeName());
        if (node.hasAttributes()) {
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print(string2);
            }
            System.out.println("node attr:");
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                I3DXMLImporter.recursivePrint(namedNodeMap.item(n2), n + 1);
            }
        }
        if ((string = node.getNodeValue()) != null) {
            if (string.length() > 100) {
                string = string.substring(0, 100);
            }
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print(string2);
            }
            System.out.println("node valu: " + string);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            I3DXMLImporter.recursivePrint(node2, n + 1);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string == null) {
            return;
        }
        IG.debugLevel(100);
        IG.init();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            I3DXMLImporter i3DXMLImporter = new I3DXMLImporter();
            i3DXMLImporter.trace(document);
            IG.p("createMesh");
            i3DXMLImporter.createMesh();
            IG.p("createMesh done");
            IG.save("c:/users/s.sugihara.Morphosis/Documents/java/data/FacadeTest_Surface.obj");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Fan {
        public ArrayList<Integer> index = new ArrayList();

        public void add(int n) {
            this.index.add(n);
        }
    }

    public static class Strip {
        public ArrayList<Integer> index = new ArrayList();

        public void add(int n) {
            this.index.add(n);
        }
    }

    public static class Triangle {
        public int i;
        public int j;
        public int k;

        public Triangle(int n, int n2, int n3) {
            this.i = n;
            this.j = n2;
            this.k = n3;
        }
    }

    public static class Face {
        public ArrayList<Triangle> triangles = new ArrayList();
        public ArrayList<Strip> strips = new ArrayList();
        public ArrayList<Fan> fans = new ArrayList();

        public void addFan(String string) {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null) {
                Fan fan = new Fan();
                for (int i = 0; i < stringArray.length; ++i) {
                    fan.add(Integer.parseInt(stringArray[i]));
                }
                this.fans.add(fan);
            }
            IG.p(this.fans.size() + " fans");
        }

        public void addTriangle(String string) {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; i += 3) {
                    int n = Integer.parseInt(stringArray[i]);
                    int n2 = Integer.parseInt(stringArray[i + 1]);
                    int n3 = Integer.parseInt(stringArray[i + 2]);
                    Triangle triangle = new Triangle(n, n2, n3);
                    this.triangles.add(triangle);
                }
            }
            IG.p(this.triangles.size() + " triangles");
        }

        public void addStrip(String string) {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null) {
                Strip strip = new Strip();
                for (int i = 0; i < stringArray.length; ++i) {
                    strip.add(Integer.parseInt(stringArray[i]));
                }
                this.strips.add(strip);
            }
            IG.p(this.strips.size() + " strips");
        }
    }
}

