/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IG;
import igeo.IOut;
import igeo.IVec;

public class ISun {
    public double latitude = 0.0;
    public double longitude = 0.0;
    public double elevation = 0.0;
    public double timeZone = 0.0;
    public int year = 2000;
    public int month = 1;
    public int day = 1;
    public double hour = 0.0;
    public boolean daylightSaving = false;
    public IVec dir;
    public double azimuth;
    public double altitude;
    public boolean updateAngle = true;
    public IVec northDir;
    public SearchBuffer buffer = null;
    public static boolean precessionCorrection = true;
    public static boolean nutationCorrection = true;
    public static boolean aberrationCorrection = true;
    public static boolean refractionCorrection = false;
    public static boolean measureAzimuthFromSouth = false;

    public ISun() {
    }

    public ISun(double d, double d2, double d3, double d4, IVec iVec, int n, int n2, int n3, double d5, boolean bl) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
        this.northDir = iVec;
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d5;
        this.daylightSaving = bl;
    }

    public ISun(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, boolean bl) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d5;
        this.daylightSaving = bl;
    }

    public ISun(double d, double d2, double d3, double d4, IVec iVec) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
        this.northDir = iVec;
    }

    public ISun(double d, double d2, double d3, double d4) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
    }

    public ISun(double d, double d2, double d3, IVec iVec) {
        this.latitude = d;
        this.longitude = d2;
        this.timeZone = d3;
        this.northDir = iVec;
    }

    public ISun(double d, double d2, double d3) {
        this.latitude = d;
        this.longitude = d2;
        this.timeZone = d3;
    }

    public ISun(City city, IVec iVec) {
        this(Location.cityLocation(city), iVec);
    }

    public ISun(City city) {
        this(Location.cityLocation(city));
    }

    public ISun(Location location, IVec iVec) {
        if (location == null) {
            IOut.err("location is null");
            return;
        }
        this.latitude = location.latitude;
        this.longitude = location.longitude;
        this.elevation = location.elevation;
        this.timeZone = location.timeZone;
        this.northDir = iVec;
    }

    public ISun(Location location) {
        if (location == null) {
            IOut.err("location is null");
            return;
        }
        this.latitude = location.latitude;
        this.longitude = location.longitude;
        this.elevation = location.elevation;
        this.timeZone = location.timeZone;
    }

    public ISun time(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
        this.daylightSaving = bl;
        this.updateAngle = true;
        return this;
    }

    public ISun time(int n, int n2, int n3, int n4, int n5, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
        this.updateAngle = true;
        return this;
    }

    public ISun time(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = (double)n4 + d / 60.0;
        this.daylightSaving = bl;
        this.updateAngle = true;
        return this;
    }

    public ISun time(int n, int n2, int n3, int n4, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = (double)n4 + d / 60.0;
        this.updateAngle = true;
        return this;
    }

    public ISun time(int n, int n2, int n3, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.daylightSaving = bl;
        this.updateAngle = true;
        return this;
    }

    public ISun time(int n, int n2, int n3, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.updateAngle = true;
        return this;
    }

    public ISun location(double d, double d2, double d3, double d4, IVec iVec) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
        this.northDir = iVec;
        this.updateAngle = true;
        return this;
    }

    public ISun location(double d, double d2, double d3, double d4) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.timeZone = d4;
        this.updateAngle = true;
        return this;
    }

    public ISun location(double d, double d2, double d3, IVec iVec) {
        this.latitude = d;
        this.longitude = d2;
        this.timeZone = d3;
        this.northDir = iVec;
        this.updateAngle = true;
        return this;
    }

    public ISun location(double d, double d2, double d3) {
        this.latitude = d;
        this.longitude = d2;
        this.timeZone = d3;
        this.updateAngle = true;
        return this;
    }

    public ISun location(City city, IVec iVec) {
        return this.location(Location.cityLocation(city), iVec);
    }

    public ISun location(City city) {
        return this.location(Location.cityLocation(city));
    }

    public ISun location(Location location, IVec iVec) {
        if (location == null) {
            IOut.err("location is null");
            return this;
        }
        this.latitude = location.latitude;
        this.longitude = location.longitude;
        this.elevation = location.elevation;
        this.timeZone = location.timeZone;
        this.northDir = iVec;
        return this;
    }

    public ISun location(Location location) {
        if (location == null) {
            IOut.err("location is null");
            return this;
        }
        this.latitude = location.latitude;
        this.longitude = location.longitude;
        this.elevation = location.elevation;
        this.timeZone = location.timeZone;
        return this;
    }

    public IVec direction(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        return this.dir(n, n2, n3, n4, n5, d, bl);
    }

    public IVec direction(int n, int n2, int n3, int n4, int n5, double d) {
        return this.dir(n, n2, n3, n4, n5, d);
    }

    public IVec direction(int n, int n2, int n3, int n4, double d, boolean bl) {
        return this.dir(n, n2, n3, n4, d, bl);
    }

    public IVec direction(int n, int n2, int n3, int n4, double d) {
        return this.dir(n, n2, n3, n4, d);
    }

    public IVec direction(int n, int n2, int n3, double d, boolean bl) {
        return this.dir(n, n2, n3, d, bl);
    }

    public IVec direction(int n, int n2, int n3, double d) {
        return this.dir(n, n2, n3, d);
    }

    public IVec direction() {
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        this.time(n, n2, n3, n4, n5, d, bl);
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, int n4, int n5, double d) {
        this.time(n, n2, n3, n4, n5, d);
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.time(n, n2, n3, n4, d, bl);
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, int n4, double d) {
        this.time(n, n2, n3, n4, d);
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, double d, boolean bl) {
        this.time(n, n2, n3, d, bl);
        return this.dir();
    }

    public IVec dir(int n, int n2, int n3, double d) {
        this.time(n, n2, n3, d);
        return this.dir();
    }

    public IVec dir() {
        if (this.updateAngle) {
            this.calc();
        }
        return ISun.direction(this.altitude, this.azimuth, this.northDir);
    }

    public double azimuth(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        this.time(n, n2, n3, n4, n5, d, bl);
        return this.azimuth();
    }

    public double azimuth(int n, int n2, int n3, int n4, int n5, double d) {
        this.time(n, n2, n3, n4, n5, d);
        return this.azimuth();
    }

    public double azimuth(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.time(n, n2, n3, n4, d, bl);
        return this.azimuth();
    }

    public double azimuth(int n, int n2, int n3, int n4, double d) {
        this.time(n, n2, n3, n4, d);
        return this.azimuth();
    }

    public double azimuth(int n, int n2, int n3, double d, boolean bl) {
        this.time(n, n2, n3, d, bl);
        return this.azimuth();
    }

    public double azimuth(int n, int n2, int n3, double d) {
        this.time(n, n2, n3, d);
        return this.azimuth();
    }

    public double azimuth() {
        if (this.updateAngle) {
            this.calc();
        }
        return this.azimuth;
    }

    public double altitude(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        this.time(n, n2, n3, n4, n5, d, bl);
        return this.altitude();
    }

    public double altitude(int n, int n2, int n3, int n4, int n5, double d) {
        this.time(n, n2, n3, n4, n5, d);
        return this.altitude();
    }

    public double altitude(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.time(n, n2, n3, n4, d, bl);
        return this.altitude();
    }

    public double altitude(int n, int n2, int n3, int n4, double d) {
        this.time(n, n2, n3, n4, d);
        return this.altitude();
    }

    public double altitude(int n, int n2, int n3, double d, boolean bl) {
        this.time(n, n2, n3, d, bl);
        return this.altitude();
    }

    public double altitude(int n, int n2, int n3, double d) {
        this.time(n, n2, n3, d);
        return this.altitude();
    }

    public double altitude() {
        if (this.updateAngle) {
            this.calc();
        }
        return this.altitude;
    }

    public double[] angles(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        this.time(n, n2, n3, n4, n5, d, bl);
        return this.angles();
    }

    public double[] angles(int n, int n2, int n3, int n4, int n5, double d) {
        this.time(n, n2, n3, n4, n5, d);
        return this.angles();
    }

    public double[] angles(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.time(n, n2, n3, n4, d, bl);
        return this.angles();
    }

    public double[] angles(int n, int n2, int n3, int n4, double d) {
        this.time(n, n2, n3, n4, d);
        return this.angles();
    }

    public double[] angles(int n, int n2, int n3, double d, boolean bl) {
        this.time(n, n2, n3, d, bl);
        return this.angles();
    }

    public double[] angles(int n, int n2, int n3, double d) {
        this.time(n, n2, n3, d);
        return this.angles();
    }

    public double[] angles() {
        if (this.updateAngle) {
            this.calc();
        }
        return new double[]{this.azimuth, this.altitude};
    }

    public ISun calc() {
        double[] dArray = ISun.calcAngle(this.latitude, this.longitude, this.elevation, this.timeZone, this.year, this.month, this.day, this.hour, this.daylightSaving);
        this.azimuth = dArray[1];
        this.altitude = dArray[0];
        this.updateAngle = false;
        return this;
    }

    public double hourAt(int n, int n2, int n3, boolean bl, IVec iVec, IVec iVec2) {
        double d = -iVec.cp().z(0.0).angle(iVec2.cp().z(0.0), IVec.zaxis);
        if ((d *= 57.29577951308232) < 0.0) {
            d += 360.0;
        }
        return this.hourAt(n, n2, n3, bl, d);
    }

    public double hourAt(int n, int n2, int n3, boolean bl, double d) {
        return this.hourAt(n, n2, n3, bl, d, 1440);
    }

    public double hourAt(int n, int n2, int n3, boolean bl, double d, int n4) {
        if (this.buffer == null || this.buffer.date.year != n || this.buffer.date.month != n2 || this.buffer.date.day != n3 || this.buffer.date.daylightSavingTime != bl || this.buffer.sampleNumber != n4) {
            this.buffer = new SearchBuffer(this, n, n2, n3, bl, n4);
            this.buffer.calc();
        }
        return this.buffer.hourAt(d);
    }

    public static double azimuth(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, boolean bl) {
        double[] dArray = ISun.calcAngle(d, d2, d3, d4, n, n2, n3, d5, bl);
        return dArray[1];
    }

    public static double altitude(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, boolean bl) {
        double[] dArray = ISun.calcAngle(d, d2, d3, d4, n, n2, n3, d5, bl);
        return dArray[0];
    }

    public static IVec dir(double d, double d2, double d3, double d4, IVec iVec, int n, int n2, int n3, double d5, boolean bl) {
        double[] dArray = ISun.calcAngle(d, d2, d3, d4, n, n2, n3, d5, bl);
        return ISun.direction(dArray[0], dArray[1], iVec);
    }

    public static IVec direction(double d, double d2, double d3, double d4, IVec iVec, int n, int n2, int n3, double d5, boolean bl) {
        return ISun.dir(d, d2, d3, d4, iVec, n, n2, n3, d5, bl);
    }

    public static IVec direction(double d, double d2, IVec iVec) {
        IVec iVec2 = null;
        iVec2 = iVec == null ? new IVec(0.0, 1.0, 0.0) : iVec.cp().z(0.0).unit();
        IVec iVec3 = iVec2.cross(IVec.zaxis);
        iVec2.rot(iVec3, Math.toRadians(d));
        if (measureAzimuthFromSouth) {
            iVec2.rot(IVec.zaxis, Math.toRadians(180.0 - d2));
        } else {
            iVec2.rot(IVec.zaxis, Math.toRadians(-d2));
        }
        return iVec2;
    }

    public static double[] angles(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, boolean bl) {
        return ISun.calcAngle(d, d2, d3, d4, n, n2, n3, d5, bl);
    }

    public static double[] calcAngle(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, boolean bl) {
        d5 -= d4;
        if (bl) {
            d5 -= 1.0;
        }
        double d6 = ISun.julianDate(n, n2, n3, d5);
        double[] dArray = ISun.calcEquatorialCoordinates(d6);
        double[] dArray2 = ISun.calcHorizontalCoordinates(dArray[0], dArray[1], d6, d, d2, d3, dArray[2]);
        return dArray2;
    }

    public static double[] calcEquatorialCoordinates(double d) {
        double d2;
        double d3 = (d - 2415020.0) / 36525.0;
        double d4 = (279.696678 + 36000.768925 * d3 % 360.0) * 3600.0;
        double d5 = 358.475844 + 35999.04975 * d3 % 360.0;
        double d6 = (6910.1 - 17.2 * d3) * Math.sin(Math.toRadians(d5)) + 72.3 * Math.sin(Math.toRadians(2.0 * d5));
        d4 += d6;
        double d7 = 212.603219 + 58517.803875 * d3 % 360.0;
        double d8 = 4.8 * Math.cos(Math.toRadians(299.1017 + d7 - d5)) + 5.5 * Math.cos(Math.toRadians(148.3133 + 2.0 * d7 - 2.0 * d5)) + 2.5 * Math.cos(Math.toRadians(315.9433 + 2.0 * d7 - 3.0 * d5)) + 1.6 * Math.cos(Math.toRadians(345.2533 + 3.0 * d7 - 4.0 * d5)) + 1.0 * Math.cos(Math.toRadians(318.15 + 3.0 * d7 - 5.0 * d5));
        d4 += d8;
        double d9 = 319.529425 + 19139.8585 * d3 % 360.0;
        double d10 = 2.0 * Math.cos(Math.toRadians(343.8883 - 2.0 * d9 + 2.0 * d5)) + 1.8 * Math.cos(Math.toRadians(200.4017 - 2.0 * d9 + d5));
        d4 += d10;
        double d11 = 225.328328 + 3034.6920239 * d3 % 360.0;
        double d12 = 7.2 * Math.cos(Math.toRadians(179.5317 - d11 + d5)) + 2.6 * Math.cos(Math.toRadians(263.2167 - d11)) + 2.7 * Math.cos(Math.toRadians(87.145 - 2.0 * d11 + 2.0 * d5)) + 1.6 * Math.cos(Math.toRadians(109.4933 - 2.0 * d11 + d5));
        d4 += d12;
        double d13 = 350.7376814 + 445267.11422 * d3 % 360.0;
        double d14 = 6.5 * Math.sin(Math.toRadians(d13));
        d4 += d14;
        double d15 = 6.4 * Math.sin(Math.toRadians(231.19 + 20.2 * d3));
        d4 += d15;
        d4 = (d4 + 2592000.0) % 1296000.0;
        double d16 = d4 / 3600.0;
        d4 -= 20.5;
        double d17 = 259.183275 - 1934.142008 * d3 % 360.0;
        d4 -= 17.2 * Math.sin(Math.toRadians(d17));
        double d18 = 23.452294 - 0.0130125 * d3 + 9.2 * Math.cos(Math.toRadians(d17)) / 3600.0;
        if ((d2 = Math.atan2(Math.sin(Math.toRadians(d4 /= 3600.0)) * Math.cos(Math.toRadians(d18)), Math.cos(Math.toRadians(d4)))) < 0.0) {
            d2 += Math.PI * 2;
        }
        double d19 = Math.asin(Math.sin(Math.toRadians(d4)) * Math.sin(Math.toRadians(d18)));
        d2 = Math.toDegrees(d2);
        d19 = Math.toDegrees(d19);
        return new double[]{d2, d19, d16, d18};
    }

    public static double[] calcHorizontalCoordinates(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray;
        double d8 = (d3 - 2451545.0) / 365.25 + 2000.0;
        boolean bl = false;
        if (precessionCorrection) {
            if (bl) {
                dArray = ISun.precess(d, d2, 1950.0, d8, true);
                d = dArray[0];
                d2 = dArray[1];
            } else {
                dArray = ISun.precess(d, d2, 2000.0, d8, false);
                d = dArray[0];
                d2 = dArray[1];
            }
        }
        dArray = ISun.conutate(d3, d, d2);
        if (aberrationCorrection) {
            double[] dArray2 = ISun.coaberration(d3, d, d2, dArray[2], d7);
            d += dArray2[0] / 3600.0;
            d2 += dArray2[1] / 3600.0;
        }
        if (nutationCorrection) {
            d += dArray[0] / 3600.0;
            d2 += dArray[1] / 3600.0;
        }
        double d9 = ISun.localSiderealTime(d5, d3) * 15.0;
        double d10 = d9 + dArray[3] * Math.cos(dArray[2]) / 3600.0;
        double d11 = ISun.mod(d10 - d, 360.0);
        double d12 = Math.sin(Math.toRadians(d11));
        double d13 = Math.cos(Math.toRadians(d11));
        double d14 = Math.sin(Math.toRadians(d2));
        double d15 = Math.cos(Math.toRadians(d2));
        double d16 = Math.sin(Math.toRadians(d4));
        double d17 = Math.cos(Math.toRadians(d4));
        double d18 = -d13 * d15 * d16 + d14 * d17;
        double d19 = -d12 * d15;
        double d20 = d13 * d15 * d17 + d14 * d16;
        double d21 = Math.sqrt(d18 * d18 + d19 * d19);
        double d22 = ISun.mod(Math.toDegrees(Math.atan2(d19, d18)), 360.0);
        double d23 = Math.toDegrees(Math.atan2(d20, d21));
        if (measureAzimuthFromSouth) {
            d22 = (d22 + 180.0) % 360.0;
        }
        if (refractionCorrection) {
            d23 = ISun.corefract(d23, d6);
        }
        return new double[]{d23, d22};
    }

    public static double corefract(double d, double d2) {
        double d3 = 0.0065;
        double d4 = 211.5;
        if (d2 <= 11000.0) {
            d4 = 283.0 - d3 * d2;
        }
        double d5 = 1010.0 * Math.pow(1.0 - 2.2569444444444443E-5 * d2, 5.255);
        double d6 = 0.25;
        double d7 = ISun.corefractForward(d, d5, d4);
        double d8 = d + d7;
        double d9 = 0.0;
        for (int i = 0; i < 1000000 && (i == 0 || Math.abs(d9 - d8) * 3600.0 >= d6); ++i) {
            d9 = d8;
            d7 = ISun.corefractForward(d8, d5, d4);
            d8 = d + d7;
        }
        return d8;
    }

    public static double corefractForward(double d, double d2, double d3) {
        double d4 = 1.0 / Math.tan(Math.toRadians(d + 7.31 / (d + 4.4))) / 60.0;
        if (d < 15.0) {
            d4 = 3.569 * (0.1594 + 0.0196 * d + 2.0E-5 * d * d) / (1.0 + 0.505 * d + 0.0845 * d * d);
        }
        return d4 *= d2 / 1010.0 * 283.0 / d3;
    }

    public static double localSiderealTime(double d, double d2) {
        double d3 = d2 - 2451545.0;
        double d4 = d3 / 36525.0;
        double d5 = 280.46061837 + 360.98564736629 * d3 + d4 * d4 * (3.87933E-4 - d4 / 3.871E7);
        double d6 = (d5 + d) / 15.0;
        d6 = ISun.mod(d6, 24.0);
        return d6;
    }

    public static double[] coaberration(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d - 2451545.0) / 36525.0;
        double d7 = 0.016708634 - 4.2037E-5 * d6 - 1.267E-7 * d6 * d6;
        double d8 = 102.93735 + 1.71946 * d6 + 4.6E-4 * d6 * d6;
        double d9 = Math.cos(Math.toRadians(d3));
        double d10 = Math.sin(Math.toRadians(d3));
        double d11 = Math.cos(d4);
        double d12 = Math.tan(d4);
        double d13 = Math.cos(Math.toRadians(d8));
        double d14 = Math.sin(Math.toRadians(d8));
        double d15 = Math.cos(Math.toRadians(d5));
        double d16 = Math.sin(Math.toRadians(d5));
        double d17 = Math.cos(Math.toRadians(d2));
        double d18 = Math.sin(Math.toRadians(d2));
        double d19 = (d17 * d15 * d11 + d18 * d16) / d9;
        double d20 = (d17 * d13 * d11 + d18 * d14) / d9;
        double d21 = d15 * d11 * (d12 * d9 - d18 * d10) + d17 * d10 * d16;
        double d22 = d13 * d11 * (d12 * d9 - d18 * d10) + d17 * d10 * d14;
        double d23 = 20.49552;
        double d24 = -d23 * d19 + d7 * d23 * d20;
        double d25 = -d23 * d21 + d7 * d23 * d22;
        return new double[]{d24, d25};
    }

    public static double[] nutate(double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = 297.85036 + 445267.11148 * d2 - 0.0019142 * d2 * d2 + 5.277768981496142E-6 * d2 * d2 * d2;
        d3 = ISun.mod(Math.toRadians(d3), Math.PI * 2);
        double d4 = 357.52772 + 35999.05034 * d2 - 1.603E-4 * d2 * d2 - 3.3333333333333333E-6 * d2 * d2 * d2;
        d4 = ISun.mod(Math.toRadians(d4), Math.PI * 2);
        double d5 = 134.96298 + 477198.867398 * d2 + 0.0086972 * d2 * d2 + 1.7777777777777777E-5 * d2 * d2 * d2;
        d5 = ISun.mod(Math.toRadians(d5), Math.PI * 2);
        double d6 = 93.27191 + 483202.017538 * d2 - 0.0036825 * d2 * d2 - 3.0555810187307116E-6 * d2 * d2 * d2;
        d6 = ISun.mod(Math.toRadians(d6), Math.PI * 2);
        double d7 = 125.04452 - 1934.136261 * d2 + 0.0020708 * d2 * d2 + 2.222222222222222E-6 * d2 * d2 * d2;
        d7 = ISun.mod(Math.toRadians(d7), Math.PI * 2);
        int[] nArray = new int[]{0, -2, 0, 0, 0, 0, -2, 0, 0, -2, -2, -2, 0, 2, 0, 2, 0, 0, -2, 0, 2, 0, 0, -2, 0, -2, 0, 0, 2, -2, 0, -2, 0, 0, 2, 2, 0, -2, 0, 2, 2, -2, -2, 2, 2, 0, -2, -2, 0, -2, -2, 0, -1, -2, 1, 0, 0, -1, 0, 0, 2, 0, 2};
        int[] nArray2 = new int[]{0, 0, 0, 0, 1, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 1, 0, -1, 0, 0, 0, 1, 1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, -1, 1, -1, -1, 0, -1};
        int[] nArray3 = new int[]{0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, -1, 0, 1, -1, -1, 1, 2, -2, 0, 2, 2, 1, 0, 0, -1, 0, -1, 0, 0, 1, 0, 2, -1, 1, 0, 1, 0, 0, 1, 2, 1, -2, 0, 1, 0, 0, 2, 2, 0, 1, 1, 0, 0, 1, -2, 1, 1, 1, -1, 3, 0};
        int[] nArray4 = new int[]{0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 0, 2, 2, 0, 0, 2, 0, 2, 0, 2, 2, 2, 0, 2, 2, 2, 2, 0, 0, 2, 0, 0, 0, -2, 2, 2, 2, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 0, 2, 0, 2, -2, 0, 0, 0, 2, 2, 0, 0, 2, 2, 2, 2};
        int[] nArray5 = new int[]{1, 2, 2, 2, 0, 0, 2, 1, 2, 2, 0, 1, 2, 0, 1, 2, 1, 1, 0, 1, 2, 2, 0, 2, 0, 0, 1, 0, 1, 2, 1, 1, 1, 0, 1, 2, 2, 0, 2, 1, 0, 2, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 0, 0, 2, 2, 2, 2};
        int[] nArray6 = new int[]{-171996, -13187, -2274, 2062, 1426, 712, -517, -386, -301, 217, -158, 129, 123, 63, 63, -59, -58, -51, 48, 46, -38, -31, 29, 29, 26, -22, 21, 17, 16, -16, -15, -13, -12, 11, -10, -8, 7, -7, -7, -7, 6, 6, 6, -6, -6, 5, -5, -5, -5, 4, 4, 4, -4, -4, -4, 3, -3, -3, -3, -3, -3, -3, -3};
        double[] dArray = new double[]{-174.2, -1.6, -0.2, 0.2, -3.4, 0.1, 1.2, -0.4, 0.0, -0.5, 0.0, 0.1, 0.0, 0.0, 0.1, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int[] nArray7 = new int[]{92025, 5736, 977, -895, 54, -7, 224, 200, 129, -95, 0, -70, -53, 0, -33, 26, 32, 27, 0, -24, 16, 13, 0, -12, 0, 0, -10, 0, -8, 7, 9, 7, 6, 0, 5, 3, -3, 0, 3, 3, 0, -3, -3, 3, 3, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        double[] dArray2 = new double[]{8.9, -3.1, -0.5, 0.5, -0.1, 0.0, -0.6, 0.0, -0.1, 0.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double d8 = 0.0;
        double d9 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d10 = (double)nArray[i] * d3 + (double)nArray2[i] * d4 + (double)nArray3[i] * d5 + (double)nArray4[i] * d6 + (double)nArray5[i] * d7;
            d8 += 1.0E-4 * (dArray[i] * d2 + (double)nArray6[i]) * Math.sin(d10);
            d9 += 1.0E-4 * (dArray2[i] * d2 + (double)nArray7[i]) * Math.cos(d10);
        }
        return new double[]{d8, d9};
    }

    public static double julianDate(int n, int n2, int n3, double d) {
        int n4 = (n2 - 14) / 12;
        double d2 = (long)n3 - 32075L + (long)(1461 * (n + 4800 + n4) / 4) + 367L * (long)(n2 - 2 - n4 * 12) / 12L - (long)(3 * ((n + 4900 + n4) / 100) / 4);
        return d2 += d / 24.0 - 0.5;
    }

    public static double[] conutate(double d, double d2, double d3) {
        double d4 = (d - 2451545.0) / 36525.0;
        double[] dArray = ISun.nutate(d);
        double d5 = Math.toRadians((84381.44795999999 - 46.815 * d4 - 5.9E-4 * d4 * d4 + 0.001813 * d4 * d4 * d4 + dArray[1]) / 3600.0);
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = Math.cos(Math.toRadians(d2)) * Math.cos(Math.toRadians(d3));
        double d9 = Math.sin(Math.toRadians(d2)) * Math.cos(Math.toRadians(d3));
        double d10 = Math.sin(Math.toRadians(d3));
        double d11 = d8 - (d9 * d6 + d10 * d7) * Math.toRadians(dArray[0] / 3600.0);
        double d12 = d9 + (d8 * d6 * Math.toRadians(dArray[0] / 3600.0) - d10 * Math.toRadians(dArray[1] / 3600.0));
        double d13 = d10 + (d8 * d7 * Math.toRadians(dArray[0] / 3600.0) + d9 * Math.toRadians(dArray[1] / 3600.0));
        double d14 = Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = Math.sqrt(d11 * d11 + d12 * d12);
        double d16 = 0.0;
        double d17 = 0.0;
        if (d15 > 0.0) {
            d16 = Math.atan2(d12, d11);
            d17 = Math.asin(d13 / d14);
        } else if (d10 != 0.0) {
            d16 = 0.0;
            d17 = Math.asin(d13 / d14);
        }
        d16 = (ISun.mod(Math.toDegrees(d16), 360.0) - d2) * 3600.0;
        d17 = (Math.toDegrees(d17) - d3) * 3600.0;
        return new double[]{d16, d17, d5, dArray[0], dArray[1]};
    }

    public static double[] precess(double d, double d2, double d3, double d4, boolean bl) {
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        double d5 = Math.cos(d2);
        double[] dArray = new double[]{d5 * Math.cos(d), d5 * Math.sin(d), Math.sin(d2)};
        double[][] dArray2 = ISun.precessMatrix(d3, d4, bl);
        double[] dArray3 = new double[]{dArray2[0][0] * dArray[0] + dArray2[1][0] * dArray[1] + dArray2[2][0] * dArray[2], dArray2[0][1] * dArray[0] + dArray2[1][1] * dArray[1] + dArray2[2][1] * dArray[2], dArray2[0][2] * dArray[0] + dArray2[1][2] * dArray[1] + dArray2[2][2] * dArray[2]};
        d = ISun.mod(Math.toDegrees(Math.atan2(dArray3[1], dArray3[0])), 360.0);
        d2 = ISun.mod(Math.toDegrees(Math.asin(dArray3[2])), 360.0);
        return new double[]{d, d2};
    }

    public static double[][] precessMatrix(double d, double d2, boolean bl) {
        double d3;
        double d4 = 0.001 * (d2 - d);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (!bl) {
            d3 = 0.001 * (d - 2000.0);
            d5 = Math.toRadians(d4 * (23062.181 + d3 * (139.656 + 0.0139 * d3) + d4 * (30.188 - 0.344 * d3 + 17.998 * d4)) / 3600.0);
            d6 = Math.toRadians(d4 * d4 * (79.28 + 0.41 * d3 + 0.205 * d4) / 3600.0) + d5;
            d7 = Math.toRadians(d4 * (20043.109 - d3 * (85.33 + 0.217 * d3) + d4 * (-42.665 - 0.217 * d3 - 41.833 * d4)) / 3600.0);
        } else {
            d3 = 0.001 * (d - 1900.0);
            d5 = Math.toRadians(d4 * (23042.53 + d3 * (139.75 + 0.06 * d3) + d4 * (30.23 - 0.27 * d3 + 18.0 * d4)) / 3600.0);
            d6 = Math.toRadians(d4 * d4 * (79.27 + 0.66 * d3 + 0.32 * d4) / 3600.0) + d5;
            d7 = Math.toRadians(d4 * (20046.85 - d3 * (85.33 + 0.37 * d3) + d4 * (-42.67 - 0.37 * d3 - 41.8 * d4)) / 3600.0);
        }
        d3 = Math.sin(d5);
        double d8 = Math.sin(d6);
        double d9 = Math.sin(d7);
        double d10 = Math.cos(d5);
        double d11 = Math.cos(d6);
        double d12 = Math.cos(d7);
        double[][] dArray = new double[3][3];
        dArray[0][0] = d10 * d11 * d12 - d3 * d8;
        dArray[0][1] = d3 * d11 + d10 * d8 * d12;
        dArray[0][2] = d10 * d9;
        dArray[1][0] = -d10 * d8 - d3 * d11 * d12;
        dArray[1][1] = d10 * d11 - d3 * d8 * d12;
        dArray[1][2] = -d3 * d9;
        dArray[2][0] = -d11 * d9;
        dArray[2][1] = -d8 * d9;
        dArray[2][2] = d12;
        return dArray;
    }

    public static String degStr(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        int n2 = (int)d2;
        double d3 = (d2 - (double)n2) * 60.0;
        return String.valueOf(n) + "d" + String.valueOf(n2) + "'" + String.valueOf(d3) + "\"";
    }

    public static String hourStr(double d) {
        int n = (int)d / 15;
        double d2 = (d / 15.0 - (double)n) * 60.0;
        int n2 = (int)d2;
        double d3 = (d2 - (double)n2) * 60.0;
        return String.valueOf(n) + "h" + String.valueOf(n2) + "'" + String.valueOf(d3) + "\"";
    }

    public static String adstring(double d) {
        IG.p("ra = " + d);
        int n = (int)d;
        IG.p("h = " + n);
        double d2 = d * 60.0 - (double)(n * 60);
        int n2 = (int)d2;
        double d3 = (d2 - (double)n2) * 60.0;
        return String.valueOf(n) + ":" + String.valueOf(n2) + "'" + String.valueOf(d3) + "\"";
    }

    public static double mod(double d, double d2) {
        if ((d %= d2) < 0.0) {
            d += d2;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        refractionCorrection = true;
        double d = 2460107.25;
        double[] dArray = ISun.calcEquatorialCoordinates(d);
        double[] dArray2 = ISun.calcHorizontalCoordinates(100.2425, 9.895555555555555, 2460107.25, 50.526666666666664, 6.8549999999999995, 369.0, dArray[2]);
        IG.p("az = " + ISun.hourStr(dArray2[1]));
        IG.p("alt = " + ISun.degStr(dArray2[0]));
    }

    public static class SearchBuffer {
        public double[] altitudes;
        public double[] azimuths;
        public Date date;
        public int sampleNumber = 1440;
        public ISun sun;

        public SearchBuffer(ISun iSun, Date date, int n) {
            this.sun = iSun;
            this.date = date;
            this.sampleNumber = n;
        }

        public SearchBuffer(ISun iSun, int n, int n2, int n3, boolean bl, int n4) {
            this(iSun, new Date(n, n2, n3, bl), n4);
        }

        public SearchBuffer(ISun iSun, Date date) {
            this.sun = iSun;
            this.date = date;
        }

        public SearchBuffer(ISun iSun, int n, int n2, int n3, boolean bl) {
            this(iSun, new Date(n, n2, n3, bl));
        }

        public double azimuth(int n) {
            return this.azimuths[n];
        }

        public double altitude(int n) {
            return this.altitudes[n];
        }

        public double hourAt(double d) {
            for (int i = 0; i <= this.sampleNumber; ++i) {
                if (this.azimuths[i] == d) {
                    return 24.0 / (double)this.sampleNumber * (double)i;
                }
                if (i >= this.sampleNumber || !(this.azimuths[i] < this.azimuths[i + 1] && d > this.azimuths[i] && d < this.azimuths[i + 1]) && (!(this.azimuths[i] > this.azimuths[i + 1]) || !(d > this.azimuths[i] && d < this.azimuths[i + 1] + 360.0) && (!(d > this.azimuths[i] - 360.0) || !(d < this.azimuths[i + 1])))) continue;
                double d2 = (d - this.azimuths[i]) / (this.azimuths[i + 1] - this.azimuths[i]);
                return 24.0 / (double)this.sampleNumber * ((double)i + d2);
            }
            IOut.err("azimuth (" + d + ") not found");
            return -1.0;
        }

        public double hourAt(IVec iVec, IVec iVec2) {
            double d = -iVec.cp().z(0.0).angle(iVec2.cp().z(0.0), IVec.zaxis);
            if ((d *= 57.29577951308232) < 0.0) {
                d += 360.0;
            }
            return this.hourAt(d);
        }

        public void calc() {
            this.altitudes = new double[this.sampleNumber + 1];
            this.azimuths = new double[this.sampleNumber + 1];
            for (int i = 0; i <= this.sampleNumber; ++i) {
                double d = 24.0 / (double)this.sampleNumber * (double)i;
                double[] dArray = this.sun.angles(this.date.year, this.date.month, this.date.day, d);
                this.azimuths[i] = dArray[0];
                this.altitudes[i] = dArray[1];
            }
        }
    }

    public static class Date {
        public int year = 2000;
        public int month = 1;
        public int day = 1;
        public double hour = 0.0;
        public boolean daylightSavingTime = false;

        public Date() {
        }

        public Date(int n, int n2, int n3, double d, boolean bl) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = d;
            this.daylightSavingTime = bl;
        }

        public Date(int n, int n2, int n3, boolean bl) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.daylightSavingTime = bl;
        }

        public Date(int n, int n2, int n3, int n4, double d, boolean bl) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = (double)n4 + d / 60.0;
            this.daylightSavingTime = bl;
        }

        public Date(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
            this.daylightSavingTime = bl;
        }

        public Date(int n, int n2, int n3, double d) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = d;
        }

        public Date(int n, int n2, int n3) {
            this.year = n;
            this.month = n2;
            this.day = n3;
        }

        public Date(int n, int n2, int n3, int n4, double d) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = (double)n4 + d / 60.0;
        }

        public Date(int n, int n2, int n3, int n4, int n5, double d) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hour = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
        }

        public Date(Date date) {
            this.year = date.year;
            this.month = date.month;
            this.day = date.day;
            this.hour = date.hour;
            this.daylightSavingTime = date.daylightSavingTime;
        }
    }

    public static class Location {
        public double longitude;
        public double latitude;
        public double elevation;
        public double timeZone;

        public Location(double d, double d2, double d3, double d4) {
            this.latitude = d;
            this.longitude = d2;
            this.elevation = d3;
            this.timeZone = d4;
        }

        public static Location cityLocation(City city) {
            switch (city) {
                case AbuDhabi: {
                    return new Location(24.4764, 54.3705, 13.0, 4.0);
                }
                case Abuja: {
                    return new Location(9.058, 7.4891, 777.0, 1.0);
                }
                case Accra: {
                    return new Location(5.5401, -0.2074, 98.0, 0.0);
                }
                case Doha: {
                    return new Location(25.2948, 51.5082, 13.0, 3.0);
                }
                case Adamstown: {
                    return new Location(-25.0662, -130.1027, 0.0, -8.0);
                }
                case AddisAbaba: {
                    return new Location(9.0084, 38.7575, 2362.0, 3.0);
                }
                case Khartoum: {
                    return new Location(15.6331, 32.533, 377.0, 3.0);
                }
                case Kuwait: {
                    return new Location(29.3721, 47.9824, 5.0, 3.0);
                }
                case Manama: {
                    return new Location(26.1921, 50.5354, 6.0, 3.0);
                }
                case Cairo: {
                    return new Location(30.0571, 31.2272, 22.0, 2.0);
                }
                case Algiers: {
                    return new Location(36.7755, 3.0597, 0.0, 1.0);
                }
                case Alofi: {
                    return new Location(-19.0565, -169.9237, 6.0, -11.0);
                }
                case Amman: {
                    return new Location(31.9394, 35.9349, 759.0, 2.0);
                }
                case Amsterdam: {
                    return new Location(52.3738, 4.891, -1.0, 1.0);
                }
                case AndorraLaVella: {
                    return new Location(42.5075, 1.5218, 1409.0, 1.0);
                }
                case Ankara: {
                    return new Location(39.9439, 32.856, 938.0, 2.0);
                }
                case Antananarivo: {
                    return new Location(-18.9201, 47.5237, 1288.0, 3.0);
                }
                case Apia: {
                    return new Location(-13.8314, -171.7518, 0.0, 13.0);
                }
                case Riyadh: {
                    return new Location(24.6748, 46.6977, 624.0, 3.0);
                }
                case Ashgabat: {
                    return new Location(37.9509, 58.3794, 215.0, 5.0);
                }
                case Asmara: {
                    return new Location(15.3315, 38.9183, 2363.0, 3.0);
                }
                case Astana: {
                    return new Location(51.1796, 71.4475, 338.0, 6.0);
                }
                case Asuncion: {
                    return new Location(-25.3005, -57.6362, 54.0, -4.0);
                }
                case Athens: {
                    return new Location(37.9792, 23.7166, 153.0, 2.0);
                }
                case Avarua: {
                    return new Location(-21.2039, -159.7658, 208.0, -10.0);
                }
                case Baghdad: {
                    return new Location(33.3157, 44.3922, 40.0, 3.0);
                }
                case Bairiki: {
                    return new Location(1.3282, 172.9784, 0.0, 12.0);
                }
                case Baku: {
                    return new Location(40.3834, 49.8932, 1.0, 4.0);
                }
                case Bamako: {
                    return new Location(12.653, -7.9864, 349.0, 0.0);
                }
                case BandarSeriBegawan: {
                    return new Location(4.9431, 114.9425, 0.0, 8.0);
                }
                case Bangui: {
                    return new Location(4.3621, 18.5873, 369.0, 1.0);
                }
                case Banjul: {
                    return new Location(13.4399, -16.6775, 0.0, 0.0);
                }
                case BasseTerre: {
                    return new Location(15.9985, -61.722, 0.0, -4.0);
                }
                case Basseterre: {
                    return new Location(17.2968, -62.7138, 0.0, -4.0);
                }
                case Beijing: {
                    return new Location(39.9056, 116.3958, 63.0, 8.0);
                }
                case Belmopan: {
                    return new Location(17.2534, -88.7713, 59.0, -6.0);
                }
                case Belgrade: {
                    return new Location(44.8048, 20.4781, 116.0, 1.0);
                }
                case Berlin: {
                    return new Location(52.5235, 13.4115, 34.0, 1.0);
                }
                case Bern: {
                    return new Location(46.948, 7.4481, 513.0, 1.0);
                }
                case Beirut: {
                    return new Location(33.8872, 35.5134, 55.0, 2.0);
                }
                case Bishkek: {
                    return new Location(42.8679, 74.5984, 771.0, 6.0);
                }
                case Bissau: {
                    return new Location(11.8598, -15.5875, 0.0, 0.0);
                }
                case Bogota: {
                    return new Location(4.6473, -74.0962, 2619.0, -5.0);
                }
                case Brasilia: {
                    return new Location(-15.7801, -47.9292, 1079.0, -3.0);
                }
                case Bratislava: {
                    return new Location(48.2116, 17.1547, 131.0, 1.0);
                }
                case Brazzaville: {
                    return new Location(-4.2767, 15.2662, 155.0, 1.0);
                }
                case Bridgetown: {
                    return new Location(13.0935, -59.6105, 6.0, -4.0);
                }
                case Brussels: {
                    return new Location(50.8371, 4.3676, 76.0, 1.0);
                }
                case Bucharest: {
                    return new Location(44.4479, 26.0979, 70.0, 2.0);
                }
                case Budapest: {
                    return new Location(47.4984, 19.0408, 102.0, 1.0);
                }
                case BuenosAires: {
                    return new Location(-34.6118, -58.4173, 10.0, -3.0);
                }
                case Bujumbura: {
                    return new Location(-3.3818, 29.3622, 794.0, 2.0);
                }
                case Canberra: {
                    return new Location(-35.282, 149.1286, 605.0, 10.0);
                }
                case Caracas: {
                    return new Location(10.4961, -66.8983, 909.0, -4.5);
                }
                case Castries: {
                    return new Location(13.9972, -60.0018, 204.0, -4.0);
                }
                case Cayenne: {
                    return new Location(4.9346, -52.3303, 32.0, -3.0);
                }
                case CharlotteAmalie: {
                    return new Location(18.3405, -64.9326, 0.0, -4.0);
                }
                case Chisinau: {
                    return new Location(47.0167, 28.8497, 80.0, 2.0);
                }
                case MexicoCity: {
                    return new Location(19.4271, -99.1276, 2216.0, -6.0);
                }
                case CockburnTown: {
                    return new Location(21.4608, -71.1363, 0.0, -5.0);
                }
                case Colombo: {
                    return new Location(6.9155, 79.8572, 4.0, 5.5);
                }
                case Conakry: {
                    return new Location(9.537, -13.6785, 0.0, 0.0);
                }
                case Dakar: {
                    return new Location(14.6953, -17.4439, 37.0, 0.0);
                }
                case DalapUligaDarrit: {
                    return new Location(7.1167, 171.3667, 0.0, 12.0);
                }
                case Dhaka: {
                    return new Location(23.7106, 90.3978, 3.0, 6.0);
                }
                case Dili: {
                    return new Location(-8.5662, 125.588, 11.0, 9.0);
                }
                case Damascus: {
                    return new Location(33.5158, 36.2939, 691.0, 2.0);
                }
                case Djibouti: {
                    return new Location(11.5806, 43.1425, 0.0, 3.0);
                }
                case Dodoma: {
                    return new Location(-6.167, 35.7497, 1148.0, 3.0);
                }
                case Douglas: {
                    return new Location(54.167, -4.4821, 34.0, 0.0);
                }
                case Dublin: {
                    return new Location(53.3441, -6.2675, 8.0, 0.0);
                }
                case Dushanbe: {
                    return new Location(38.5737, 68.7738, 789.0, 5.0);
                }
                case FortDeFrance: {
                    return new Location(14.5997, -61.076, 0.0, -4.0);
                }
                case Freetown: {
                    return new Location(8.4697, -13.2659, 76.0, 0.0);
                }
                case Gaborone: {
                    return new Location(-24.657, 25.9089, 1014.0, 2.0);
                }
                case Garapan: {
                    return new Location(15.2069, 145.7197, 132.0, 10.0);
                }
                case GeorgeTown: {
                    return new Location(19.3022, -81.3857, 3.0, -5.0);
                }
                case Georgetown: {
                    return new Location(6.8046, -58.1548, 0.0, -4.0);
                }
                case Gibraltar: {
                    return new Location(36.1377, -5.3453, 447.0, 1.0);
                }
                case Guatemala: {
                    return new Location(14.6248, -90.5328, 1529.0, -6.0);
                }
                case Hanoi: {
                    return new Location(21.0341, 105.8372, 25.0, 7.0);
                }
                case Hagatna: {
                    return new Location(13.4667, 144.747, 9.0, 10.0);
                }
                case Hamilton: {
                    return new Location(32.293, -64.782, 0.0, -4.0);
                }
                case Harare: {
                    return new Location(-17.8227, 31.0496, 1480.0, 2.0);
                }
                case Helsinki: {
                    return new Location(60.1699, 24.9384, 25.0, 2.0);
                }
                case Honiara: {
                    return new Location(-9.4333, 159.95, 29.0, 11.0);
                }
                case Islamabad: {
                    return new Location(33.6751, 73.0946, 507.0, 5.0);
                }
                case Jakarta: {
                    return new Location(-6.1862, 106.8063, 3.0, 7.0);
                }
                case Jamestown: {
                    return new Location(-15.9244, -5.7181, 292.0, 0.0);
                }
                case Kabul: {
                    return new Location(34.5155, 69.1952, 1807.0, 4.5);
                }
                case Kampala: {
                    return new Location(0.3133, 32.5714, 1202.0, 3.0);
                }
                case Kathmandu: {
                    return new Location(27.7058, 85.3157, 1298.0, 5.75);
                }
                case Kigali: {
                    return new Location(-1.9441, 30.0619, 1567.0, 2.0);
                }
                case Kingston: {
                    return new Location(17.9927, -76.792, 53.0, -5.0);
                }
                case KingstonNorfolk: {
                    return new Location(-29.0545, 167.9666, 0.0, 11.5);
                }
                case Kingstown: {
                    return new Location(13.2035, -61.2653, 0.0, -4.0);
                }
                case Kinshasa: {
                    return new Location(-4.3369, 15.3271, 240.0, 1.0);
                }
                case Copenhagen: {
                    return new Location(55.6763, 12.5681, 0.0, 1.0);
                }
                case Bangkok: {
                    return new Location(13.7573, 100.502, 1.0, 7.0);
                }
                case KualaLumpur: {
                    return new Location(3.1502, 101.7077, 60.0, 8.0);
                }
                case Kiev: {
                    return new Location(50.4422, 30.5367, 168.0, 2.0);
                }
                case Havana: {
                    return new Location(23.1333, -82.3667, 4.0, -5.0);
                }
                case LaPaz: {
                    return new Location(-19.0421, -65.2559, 3660.0, -4.0);
                }
                case ElAaiun: {
                    return new Location(27.1536, -13.2033, 72.0, 0.0);
                }
                case Lhasa: {
                    return new Location(29.39, 91.07, 3490.0, 8.0);
                }
                case Libreville: {
                    return new Location(0.3858, 9.4496, 0.0, 1.0);
                }
                case Lilongwe: {
                    return new Location(-13.9899, 33.7703, 1024.0, 2.0);
                }
                case Lima: {
                    return new Location(-12.0931, -77.0465, 107.0, -5.0);
                }
                case Lisbon: {
                    return new Location(38.7072, -9.1355, 15.0, 0.0);
                }
                case Ljubljana: {
                    return new Location(46.0514, 14.506, 281.0, 1.0);
                }
                case Lome: {
                    return new Location(6.1228, 1.2255, 63.0, 0.0);
                }
                case London: {
                    return new Location(51.5002, -0.1262, 14.0, 0.0);
                }
                case Longyearbyen: {
                    return new Location(78.2186, 15.6488, 199.0, 1.0);
                }
                case Luanda: {
                    return new Location(-8.8159, 13.2306, 6.0, 1.0);
                }
                case Lusaka: {
                    return new Location(-15.4145, 28.2809, 1270.0, 2.0);
                }
                case Luxembourg: {
                    return new Location(49.61, 6.1296, 273.0, 1.0);
                }
                case Male: {
                    return new Location(4.1742, 73.5109, 0.0, 5.0);
                }
                case Madrid: {
                    return new Location(40.4167, -3.7033, 588.0, 1.0);
                }
                case Malabo: {
                    return new Location(3.7523, 8.7741, 107.0, 1.0);
                }
                case Mamoudzou: {
                    return new Location(-12.7806, 45.2278, 0.0, 3.0);
                }
                case Managua: {
                    return new Location(12.1475, -86.2734, 75.0, -6.0);
                }
                case Manila: {
                    return new Location(14.579, 120.9726, 7.0, 8.0);
                }
                case Maputo: {
                    return new Location(-25.9686, 32.5804, 63.0, 2.0);
                }
                case Maseru: {
                    return new Location(-29.2976, 27.4854, 1673.0, 2.0);
                }
                case Muscat: {
                    return new Location(23.6086, 58.5922, 68.0, 4.0);
                }
                case MataUtu: {
                    return new Location(-13.2784, -176.143, 0.0, 12.0);
                }
                case Mbabane: {
                    return new Location(-26.3186, 31.141, 1243.0, 2.0);
                }
                case Melekeok: {
                    return new Location(7.5007, 134.6241, 0.0, 9.0);
                }
                case Minsk: {
                    return new Location(53.9678, 27.5766, 198.0, 3.0);
                }
                case Monaco: {
                    return new Location(43.7325, 7.4189, 0.0, 1.0);
                }
                case Monrovia: {
                    return new Location(6.3106, -10.8047, 0.0, 0.0);
                }
                case Montevideo: {
                    return new Location(-34.8941, -56.0675, 43.0, -3.0);
                }
                case Moroni: {
                    return new Location(-11.7004, 43.2412, 110.0, 3.0);
                }
                case Moscow: {
                    return new Location(55.7558, 37.6176, 124.0, 4.0);
                }
                case Mogadishu: {
                    return new Location(2.0411, 45.3426, 28.0, 3.0);
                }
                case Ndjamena: {
                    return new Location(12.1121, 15.0355, 298.0, 1.0);
                }
                case Nairobi: {
                    return new Location(-1.2762, 36.7965, 1728.0, 3.0);
                }
                case Nassau: {
                    return new Location(25.0661, -77.339, 2.0, -5.0);
                }
                case NewDelhi: {
                    return new Location(28.6353, 77.225, 210.0, 5.5);
                }
                case Niamey: {
                    return new Location(13.5164, 2.1157, 207.0, 1.0);
                }
                case Nicosia: {
                    return new Location(35.1676, 33.3736, 134.0, 2.0);
                }
                case Nouakchott: {
                    return new Location(18.0669, -15.99, 6.0, 0.0);
                }
                case Noumea: {
                    return new Location(-22.2758, 166.4581, 0.0, 11.0);
                }
                case Nukualofa: {
                    return new Location(-21.136, -175.2164, 0.0, 13.0);
                }
                case Nuuk: {
                    return new Location(64.1836, -51.7214, 0.0, -3.0);
                }
                case Oranjestad: {
                    return new Location(12.5246, -70.0265, 13.0, -4.0);
                }
                case Oslo: {
                    return new Location(59.9138, 10.7387, 12.0, 1.0);
                }
                case Ottawa: {
                    return new Location(45.4235, -75.6979, 74.0, -5.0);
                }
                case Ouagadougou: {
                    return new Location(12.3569, -1.5352, 305.0, 0.0);
                }
                case Pyongyang: {
                    return new Location(39.0187, 125.7468, 6.0, 9.0);
                }
                case PagoPago: {
                    return new Location(-14.2793, -170.7009, 49.0, -11.0);
                }
                case Palikir: {
                    return new Location(6.9177, 158.1854, 207.0, 11.0);
                }
                case Panama: {
                    return new Location(8.9943, -79.5188, 0.0, -5.0);
                }
                case Papeete: {
                    return new Location(-17.535, -149.5696, 59.0, -10.0);
                }
                case Paramaribo: {
                    return new Location(5.8232, -55.1679, 1.0, -3.0);
                }
                case Paris: {
                    return new Location(48.8567, 2.351, 34.0, 1.0);
                }
                case PhnomPenh: {
                    return new Location(11.5434, 104.8984, 15.0, 7.0);
                }
                case Plymouth: {
                    return new Location(16.6802, -62.2014, 114.0, -4.0);
                }
                case Podgorica: {
                    return new Location(42.4602, 19.2595, 61.0, 1.0);
                }
                case PortLouis: {
                    return new Location(-20.1654, 57.4896, 134.0, 4.0);
                }
                case PortMoresby: {
                    return new Location(-9.4656, 147.1969, 39.0, 10.0);
                }
                case PortOfSpain: {
                    return new Location(10.6596, -61.4789, 0.0, -4.0);
                }
                case PortVila: {
                    return new Location(-17.7404, 168.321, 0.0, 11.0);
                }
                case PortAuPrince: {
                    return new Location(18.5392, -72.3288, 98.0, -5.0);
                }
                case PortoNovo: {
                    return new Location(6.4779, 2.6323, 38.0, 1.0);
                }
                case Prague: {
                    return new Location(50.0878, 14.4205, 244.0, 1.0);
                }
                case Praia: {
                    return new Location(14.9195, -23.5153, 0.0, -1.0);
                }
                case Pretoria: {
                    return new Location(-25.7463, 28.1876, 1271.0, 2.0);
                }
                case Pristina: {
                    return new Location(42.674, 21.1788, 652.0, 1.0);
                }
                case WestIsland: {
                    return new Location(-12.1869, 96.8283, 0.0, 6.5);
                }
                case Pyinmana: {
                    return new Location(19.7378, 96.2083, 77.0, 6.5);
                }
                case Quito: {
                    return new Location(-0.2295, -78.5243, 2763.0, -5.0);
                }
                case Rabat: {
                    return new Location(33.9905, -6.8704, 53.0, 0.0);
                }
                case Reykjavik: {
                    return new Location(64.1353, -21.8952, 15.0, 0.0);
                }
                case Riga: {
                    return new Location(56.9465, 24.1049, 8.0, 2.0);
                }
                case RoadTown: {
                    return new Location(18.4328, -64.6235, 0.0, -4.0);
                }
                case Rome: {
                    return new Location(41.8955, 12.4823, 14.0, 1.0);
                }
                case Roseau: {
                    return new Location(15.2976, -61.39, 0.0, -4.0);
                }
                case SaintDenis: {
                    return new Location(-20.8732, 55.4603, 112.0, 4.0);
                }
                case SaintGeorges: {
                    return new Location(12.054, -61.7486, 25.0, -4.0);
                }
                case SaintHelier: {
                    return new Location(49.1919, -2.1071, 0.0, 0.0);
                }
                case SaintJohns: {
                    return new Location(17.1175, -61.8456, 0.0, -4.0);
                }
                case SaintPeterPort: {
                    return new Location(49.466, -2.5522, 0.0, 0.0);
                }
                case SaintPierre: {
                    return new Location(46.7878, -56.1968, 0.0, -3.0);
                }
                case SanJose: {
                    return new Location(9.9402, -84.1002, 1146.0, -6.0);
                }
                case SanJuan: {
                    return new Location(18.45, -66.0667, 3.0, -4.0);
                }
                case SanMarino: {
                    return new Location(43.9424, 12.4578, 328.0, 1.0);
                }
                case SanSalvador: {
                    return new Location(13.7034, -89.2073, 658.0, -6.0);
                }
                case Sanaa: {
                    return new Location(15.3556, 44.2081, 2253.0, 3.0);
                }
                case Santiago: {
                    return new Location(-33.4691, -70.642, 521.0, -4.0);
                }
                case SantoDomingo: {
                    return new Location(18.479, -69.8908, 0.0, -4.0);
                }
                case SaoTome: {
                    return new Location(0.336, 6.7311, 141.0, 0.0);
                }
                case Sarajevo: {
                    return new Location(43.8608, 18.4214, 577.0, 1.0);
                }
                case Seoul: {
                    return new Location(37.5139, 126.9828, 33.0, 9.0);
                }
                case Singapore: {
                    return new Location(1.2894, 103.85, 0.0, 8.0);
                }
                case Skopje: {
                    return new Location(42.0024, 21.4361, 243.0, 1.0);
                }
                case Sofia: {
                    return new Location(42.7105, 23.3238, 591.0, 2.0);
                }
                case Stanley: {
                    return new Location(-51.701, -57.8492, 0.0, -4.0);
                }
                case Stockholm: {
                    return new Location(59.3328, 18.0645, 15.0, 1.0);
                }
                case Suva: {
                    return new Location(-18.1416, 178.4419, 0.0, 12.0);
                }
                case Taipei: {
                    return new Location(25.0338, 121.5645, 5.0, 8.0);
                }
                case Tbilisi: {
                    return new Location(41.701, 44.793, 451.0, 4.0);
                }
                case Tallinn: {
                    return new Location(59.4389, 24.7545, 37.0, 2.0);
                }
                case Tripoli: {
                    return new Location(32.883, 13.1897, 6.0, 2.0);
                }
                case Tegucigalpa: {
                    return new Location(14.0821, -87.2063, 980.0, -6.0);
                }
                case Tehran: {
                    return new Location(35.7061, 51.4358, 1138.0, 3.5);
                }
                case TheSettlement: {
                    return new Location(-10.4286, 105.6807, 0.0, 7.0);
                }
                case TheValley: {
                    return new Location(18.2249, -63.0669, 0.0, -4.0);
                }
                case Thimphu: {
                    return new Location(27.4405, 89.673, 2736.0, 6.0);
                }
                case Tirana: {
                    return new Location(41.3317, 19.8172, 104.0, 1.0);
                }
                case Tokyo: {
                    return new Location(35.6785, 139.6823, 17.0, 9.0);
                }
                case Torshavn: {
                    return new Location(62.0177, -6.7719, 0.0, 0.0);
                }
                case Tashkent: {
                    return new Location(41.3193, 69.2481, 459.0, 5.0);
                }
                case Tunis: {
                    return new Location(36.8117, 10.1761, 0.0, 1.0);
                }
                case UlanBator: {
                    return new Location(47.9138, 106.922, 1284.0, 8.0);
                }
                case Vaduz: {
                    return new Location(47.1411, 9.5215, 601.0, 1.0);
                }
                case Vaiaku: {
                    return new Location(-8.521, 179.1983, 0.0, 12.0);
                }
                case Valletta: {
                    return new Location(35.9042, 14.5189, 0.0, 1.0);
                }
                case Vientiane: {
                    return new Location(17.9689, 102.6137, 148.0, 7.0);
                }
                case Victoria: {
                    return new Location(-4.6167, 55.45, 0.0, 4.0);
                }
                case Vienna: {
                    return new Location(48.2092, 16.3728, 170.0, 1.0);
                }
                case Vilnius: {
                    return new Location(54.6896, 25.2799, 124.0, 2.0);
                }
                case Warsaw: {
                    return new Location(52.2297, 21.0122, 93.0, 1.0);
                }
                case Washington: {
                    return new Location(38.8921, -77.0241, 2.0, -5.0);
                }
                case Wellington: {
                    return new Location(-41.2865, 174.7762, 20.0, 12.0);
                }
                case Willemstad: {
                    return new Location(12.1034, -68.9335, 0.0, -4.0);
                }
                case Windhoek: {
                    return new Location(-22.5749, 17.0805, 1721.0, 1.0);
                }
                case Yamoussoukro: {
                    return new Location(6.8067, -5.2728, 217.0, 0.0);
                }
                case Yaounde: {
                    return new Location(3.8612, 11.5217, 726.0, 1.0);
                }
                case Yaren: {
                    return new Location(-0.5434, 166.9196, 9.0, 12.0);
                }
                case Yerevan: {
                    return new Location(40.1596, 44.509, 1032.0, 4.0);
                }
                case Jerusalem: {
                    return new Location(31.7857, 35.2007, 580.0, 2.0);
                }
                case Zagreb: {
                    return new Location(45.815, 15.9785, 130.0, 1.0);
                }
                case NewYork: {
                    return new Location(40.77, -73.98, 1.0, -5.0);
                }
                case LosAngeles: {
                    return new Location(34.05, -118.25, 84.0, -8.0);
                }
                case Chicago: {
                    return new Location(41.8833, -87.6333, 181.0, -6.0);
                }
                case Osaka: {
                    return new Location(34.6667, 135.5, 17.0, 9.0);
                }
                case Milan: {
                    return new Location(45.4667, 9.1667, 120.0, 1.0);
                }
            }
            IOut.err("no information for " + (Object)((Object)city) + " found");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum City {
        AbuDhabi,
        Abuja,
        Accra,
        Doha,
        Adamstown,
        AddisAbaba,
        Khartoum,
        Kuwait,
        Manama,
        Cairo,
        Algiers,
        Alofi,
        Amman,
        Amsterdam,
        AndorraLaVella,
        Ankara,
        Antananarivo,
        Apia,
        Riyadh,
        Ashgabat,
        Asmara,
        Astana,
        Asuncion,
        Athens,
        Avarua,
        Baghdad,
        Bairiki,
        Baku,
        Bamako,
        BandarSeriBegawan,
        Bangui,
        Banjul,
        BasseTerre,
        Basseterre,
        Beijing,
        Belmopan,
        Belgrade,
        Berlin,
        Bern,
        Beirut,
        Bishkek,
        Bissau,
        Bogota,
        Brasilia,
        Bratislava,
        Brazzaville,
        Bridgetown,
        Brussels,
        Bucharest,
        Budapest,
        BuenosAires,
        Bujumbura,
        Canberra,
        Caracas,
        Castries,
        Cayenne,
        CharlotteAmalie,
        Chisinau,
        MexicoCity,
        CockburnTown,
        Colombo,
        Conakry,
        Dakar,
        DalapUligaDarrit,
        Dhaka,
        Dili,
        Damascus,
        Djibouti,
        Dodoma,
        Douglas,
        Dublin,
        Dushanbe,
        FortDeFrance,
        Freetown,
        Gaborone,
        Garapan,
        GeorgeTown,
        Georgetown,
        Gibraltar,
        Guatemala,
        Hanoi,
        Hagatna,
        Hamilton,
        Harare,
        Helsinki,
        Honiara,
        Islamabad,
        Jakarta,
        Jamestown,
        Kabul,
        Kampala,
        Kathmandu,
        Kigali,
        Kingston,
        KingstonNorfolk,
        Kingstown,
        Kinshasa,
        Copenhagen,
        Bangkok,
        KualaLumpur,
        Kiev,
        Havana,
        LaPaz,
        ElAaiun,
        Lhasa,
        Libreville,
        Lilongwe,
        Lima,
        Lisbon,
        Ljubljana,
        Lome,
        London,
        Longyearbyen,
        Luanda,
        Lusaka,
        Luxembourg,
        Male,
        Madrid,
        Malabo,
        Mamoudzou,
        Managua,
        Manila,
        Maputo,
        Maseru,
        Muscat,
        MataUtu,
        Mbabane,
        Melekeok,
        Minsk,
        Monaco,
        Monrovia,
        Montevideo,
        Moroni,
        Moscow,
        Mogadishu,
        Ndjamena,
        Nairobi,
        Nassau,
        NewDelhi,
        Niamey,
        Nicosia,
        Nouakchott,
        Noumea,
        Nukualofa,
        Nuuk,
        Oranjestad,
        Oslo,
        Ottawa,
        Ouagadougou,
        Pyongyang,
        PagoPago,
        Palikir,
        Panama,
        Papeete,
        Paramaribo,
        Paris,
        PhnomPenh,
        Plymouth,
        Podgorica,
        PortLouis,
        PortMoresby,
        PortOfSpain,
        PortVila,
        PortAuPrince,
        PortoNovo,
        Prague,
        Praia,
        Pretoria,
        Pristina,
        WestIsland,
        Pyinmana,
        Quito,
        Rabat,
        Reykjavik,
        Riga,
        RoadTown,
        Rome,
        Roseau,
        SaintDenis,
        SaintGeorges,
        SaintHelier,
        SaintJohns,
        SaintPeterPort,
        SaintPierre,
        SanJose,
        SanJuan,
        SanMarino,
        SanSalvador,
        Sanaa,
        Santiago,
        SantoDomingo,
        SaoTome,
        Sarajevo,
        Seoul,
        Singapore,
        Skopje,
        Sofia,
        Stanley,
        Stockholm,
        Suva,
        Taipei,
        Tbilisi,
        Tallinn,
        Tripoli,
        Tegucigalpa,
        Tehran,
        TheSettlement,
        TheValley,
        Thimphu,
        Tirana,
        Tokyo,
        Torshavn,
        Tashkent,
        Tunis,
        UlanBator,
        Vaduz,
        Vaiaku,
        Valletta,
        Vientiane,
        Victoria,
        Vienna,
        Vilnius,
        Warsaw,
        Washington,
        Wellington,
        Willemstad,
        Windhoek,
        Yamoussoukro,
        Yaounde,
        Yaren,
        Yerevan,
        Jerusalem,
        Zagreb,
        NewYork,
        LosAngeles,
        Chicago,
        Osaka,
        Milan;

    }
}

