/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.ICurveI;
import igeo.IMap;
import igeo.ISurfaceI;
import igeo.IVec;

public class ISurfaceDepthMap
extends IMap {
    public ISurfaceI surface;
    public IVec orig;
    public IVec uvec;
    public IVec vvec;
    public IVec minDepthPt = null;
    public IVec depthDir = null;
    public double maxDepth = 0.0;

    public ISurfaceDepthMap(ISurfaceI iSurfaceI) {
        this.surface = iSurfaceI;
        this.initMap();
    }

    public ISurfaceDepthMap(ISurfaceI iSurfaceI, IVec iVec) {
        this.surface = iSurfaceI;
        this.depthDir = iVec;
        this.initMap();
    }

    public ISurfaceDepthMap(ISurfaceI iSurfaceI, IVec iVec, IVec iVec2, IVec iVec3) {
        this.surface = iSurfaceI;
        this.depthDir = iVec.dup().unit();
        this.minDepthPt = iVec2;
        this.maxDepth = iVec3.diff(iVec2).dot(this.depthDir);
    }

    public ISurfaceDepthMap(ISurfaceI iSurfaceI, ICurveI iCurveI) {
        this.surface = iSurfaceI;
        this.minDepthPt = iCurveI.start().get();
        this.depthDir = iCurveI.end().get().diff(this.minDepthPt);
        this.maxDepth = this.depthDir.len();
        this.depthDir.unit();
        this.initMap();
    }

    public void initMap() {
        if (this.minDepthPt == null || this.depthDir == null) {
            this.orig = this.surface.corner(0, 0).get();
            this.uvec = this.surface.corner(1, 0).get().diff(this.orig);
            this.vvec = this.surface.corner(0, 1).get().diff(this.orig);
            this.minDepthPt = this.orig;
            if (this.depthDir == null) {
                this.depthDir = this.uvec.cross(this.vvec).unit();
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.surface.unum(); ++i) {
                for (int j = 0; j < this.surface.vnum(); ++j) {
                    double d3 = this.getDepth(this.surface.cp(i, j).get());
                    if (i == 0 && j == 0) {
                        d = d2 = d3;
                        continue;
                    }
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
            }
            this.maxDepth = d2 - d;
            if (d < 0.0) {
                this.minDepthPt = this.depthDir.dup().len(d).add(this.minDepthPt);
            }
        }
    }

    public double getDepth(double d, double d2) {
        return this.getDepth(this.surface.pt(d, d2).get());
    }

    public double getDepth(IVec iVec) {
        IVec iVec2 = iVec.diff(this.minDepthPt);
        return this.depthDir.dot(iVec2);
    }

    @Override
    public double get(double d, double d2) {
        IVec iVec = this.surface.pt(d, d).get().diff(this.minDepthPt);
        return this.depthDir.dot(iVec) / this.maxDepth;
    }
}

