/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBox;
import igeo.IBrep;
import igeo.ICircleGeo;
import igeo.IComparator;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.ICylinder;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.INurbsGeo;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.ISort;
import igeo.ISphere;
import igeo.ISurface;
import igeo.ISurfaceGeo;
import igeo.ISurfaceI;
import igeo.IVec;
import igeo.IVec4I;
import igeo.IVecI;
import igeo.IVecR;
import java.util.ArrayList;

public class ISurfaceCreator {
    public static IServerI server = null;

    public static void server(IServerI iServerI) {
        server = iServerI;
    }

    public static IServerI server() {
        return server;
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return new ISurface(server, iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return new ISurface(server, iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2) {
        return new ISurface(server, iVecIArray, n, n2);
    }

    public static ISurface surface(IVecI[][] iVecIArray) {
        return new ISurface(server, iVecIArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return new ISurface(server, iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return new ISurface(server, iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return new ISurface(server, iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return new ISurface(server, iVecIArray, bl, bl2);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return new ISurface(server, iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new ISurface(server, iVecI, iVecI2, iVecI3);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return new ISurface(server, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return new ISurface(server, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface surface(double[][][] dArray) {
        return new ISurface(server, dArray);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2) {
        return new ISurface(server, dArray, n, n2);
    }

    public static ISurface surface(double[][][] dArray, boolean bl, boolean bl2) {
        return new ISurface(server, dArray, bl, bl2);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return new ISurface(server, dArray, n, n2, bl, bl2);
    }

    public static ISurface surface(ISurfaceI iSurfaceI) {
        return new ISurface(server, iSurfaceI);
    }

    public static ISurface surface(ICurveI iCurveI) {
        return new ISurface(server, iCurveI);
    }

    public static ISurface surface(ICurveI iCurveI, ICurveI[] iCurveIArray) {
        return new ISurface(server, iCurveI, iCurveIArray);
    }

    public static ISurface surface(ICurveI iCurveI, ICurveI iCurveI2) {
        return new ISurface(server, iCurveI, iCurveI2);
    }

    public static ISurface surface(ICurveI[] iCurveIArray) {
        return new ISurface(server, iCurveIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray) {
        return new ISurface(server, iVecIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n) {
        return new ISurface(server, iVecIArray, n);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n, double[] dArray) {
        return new ISurface(server, iVecIArray, n, dArray);
    }

    public static IBox box(double d, double d2, double d3, double d4) {
        return new IBox(d, d2, d3, d4);
    }

    public static IBox box(double d, double d2, double d3, double d4, double d5, double d6) {
        return new IBox(d, d2, d3, d4, d5, d6);
    }

    public static IBox box(IVecI iVecI, double d) {
        return new IBox(iVecI, d);
    }

    public static IBox box(IVecI iVecI, double d, double d2, double d3) {
        return new IBox(iVecI, d, d2, d3);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return new IBox(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        return new IBox(iVecI, iVecI2, iVecI3, iVecI4, iVecI5, iVecI6, iVecI7, iVecI8);
    }

    public static IBox box(IVecI[][][] iVecIArray) {
        return new IBox(iVecIArray);
    }

    public static ISphere sphere(double d, double d2, double d3, double d4) {
        return new ISphere(server, d, d2, d3, d4);
    }

    public static ISphere sphere(IVecI iVecI, double d) {
        return new ISphere(server, iVecI, d);
    }

    public static ISphere sphere(IVecI iVecI, IDoubleI iDoubleI) {
        return new ISphere(server, iVecI, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d) {
        return new ICylinder(server, iVecI, iVecI2, d);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return new ICylinder(server, iVecI, iVecI2, d, d2);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, double d) {
        return new ICylinder(server, iVecI, iVecI2, d, 0.0);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI, new IDouble(0.0));
    }

    public static ISurface plane(IVecI iVecI, double d, double d2) {
        return ISurfaceCreator.plane(iVecI, new IVec(d, 0.0, 0.0), new IVec(0.0, d2, 0.0));
    }

    public static ISurface plane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new ISurface(server, iVecI, iVecI.dup().add(iVecI2), iVecI.dup().add(iVecI2).add(iVecI3), iVecI.dup().add(iVecI3));
    }

    public static ISurface extrude(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.extrude(iVecIArray2, n, dArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        IVecI[][] iVecIArray2 = new IVecI[2][iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[0][i] = iVecIArray[i];
            iVecIArray2[1][i] = iVecIArray[i].dup().add(iVecI);
        }
        return new ISurface(server, iVecIArray2, 1, n, INurbsGeo.createKnots(1, 2), dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(IVecI[] iVecIArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, ICurve iCurve) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.extrude(iVecIArray2, n, dArray, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iCurve.cps(), iCurve.deg(), iCurve.knots());
    }

    public static ISurface extrude(ICurveI iCurveI, IVecI iVecI) {
        IVecI[][] iVecIArray = new IVecI[2][iCurveI.num()];
        for (int i = 0; i < iCurveI.num(); ++i) {
            iVecIArray[0][i] = iCurveI.cp(i);
            iVecIArray[1][i] = iCurveI.cp(i).dup().add(iVecI);
        }
        return new ISurface(server, iVecIArray, 1, iCurveI.deg(), INurbsGeo.createKnots(1, 2), iCurveI.knots(), 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(ICurveI iCurveI, double d) {
        return ISurfaceCreator.extrude(iCurveI, (IVecI)IVec.averageNormal(iCurveI.cps()).len(d));
    }

    public static ISurface extrude(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iCurveI, (IVecI)IVec.averageNormal(iCurveI.cps()).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iVecIArray2, 1, false);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iVecIArray2, n2, false);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        IVecI[] iVecIArray3 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray3 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray3.length);
        } else {
            iVecIArray3 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray3.length);
        }
        IVecI[] iVecIArray4 = null;
        double[] dArray2 = null;
        if (bl2) {
            iVecIArray4 = INurbsGeo.createClosedCP(iVecIArray2, n2);
            dArray2 = INurbsGeo.createClosedKnots(n2, iVecIArray4.length);
        } else {
            iVecIArray4 = iVecIArray2;
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray4.length);
        }
        return ISurfaceCreator.extrude(iVecIArray3, n, dArray, iVecIArray4, n2, dArray2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        IVecI iVecI = iVecIArray[0];
        IVecI[][] iVecIArray3 = new IVec[iVecIArray2.length][iVecIArray.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < iVecIArray.length; ++j) {
                iVecIArray3[i][j] = iVecIArray2[i].dup().add(iVecIArray[j]).sub(iVecI);
            }
        }
        return new ISurface(server, iVecIArray3, n2, n, dArray2, dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.extrude(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, 1, false, null, null, iVecIArray2, 1, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, 1, false, iVecI, null, iVecIArray2, 1, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, 1, false, iVecI, iVecI2, iVecIArray2, 1, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, false, null, null, iVecIArray2, n2, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, false, iVecI, null, iVecIArray2, n2, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, false, iVecI, iVecI2, iVecIArray2, n2, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, null, null, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, null, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, boolean bl2) {
        IVecI[] iVecIArray3 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray3 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray3.length);
        } else {
            iVecIArray3 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray3.length);
        }
        IVecI[] iVecIArray4 = null;
        double[] dArray2 = null;
        if (bl2) {
            iVecIArray4 = INurbsGeo.createClosedCP(iVecIArray2, n2);
            dArray2 = INurbsGeo.createClosedKnots(n2, iVecIArray4.length);
        } else {
            iVecIArray4 = iVecIArray2;
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray4.length);
        }
        return ISurfaceCreator.sweep(iVecIArray3, n, dArray, iVecI, iVecI2, iVecIArray4, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, 1, null, null, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, 1, null, iVecI, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, 1, null, iVecI, iVecI2, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, null, null, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, null, iVecI, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, null, iVecI, iVecI2, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, null, null, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, null, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.sweep(iVecIArray2, n, dArray, iVecI, iVecI2, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), null, iVecIArray, 1, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecIArray, 1, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecI2, iVecIArray, 1, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), null, iVecIArray, n, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecIArray, n, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecI2, iVecIArray, n, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, null, null, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, null, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n, boolean bl) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecI2, iVecIArray2, n, dArray);
    }

    public static ISurface sweep(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, null, iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecI2, iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, null, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, null, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        IVecI[][] iVecIArray3 = ISurfaceCreator.sweepPoints(iVecIArray, n, iVecI, iVecI2, iVecIArray2, n2);
        if (dArray == null) {
            dArray = INurbsGeo.createKnots(n, iVecIArray.length);
        }
        if (dArray2 == null) {
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray2.length);
        }
        return new ISurface(server, iVecIArray3, n2, n, dArray2, dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static IVecI[][] sweepPoints(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2) {
        if (iVecIArray == null || iVecIArray.length <= 1) {
            IOut.err("profile is null or number of array is too less");
            return null;
        }
        if (iVecIArray2 == null || iVecIArray2.length <= 1) {
            IOut.err("rail is null or number of array is too less");
            return null;
        }
        IVec iVec = IVec.averageNormal(iVecIArray);
        iVecI = iVecI == null ? ISurfaceCreator.getCenter(iVecIArray, n) : iVecI.dup();
        boolean bl = ISurfaceCreator.isClosed(iVecIArray2, n2);
        IVec iVec2 = null;
        if (iVecI2 != null) {
            iVec2 = IVec.averageNormal(iVecIArray2);
        }
        IVecI[] iVecIArray3 = ISurfaceCreator.duplicatePoints(iVecIArray);
        IVecI[][] iVecIArray4 = new IVecI[iVecIArray2.length][];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            IVecI[] iVecIArray5;
            IVecI iVecI3 = null;
            if (i == 0) {
                if (!bl && i < iVecIArray2.length - 1) {
                    iVecI3 = iVecIArray2[i + 1].diff(iVecIArray2[i]);
                } else if (bl && iVecIArray2.length - n2 > 0) {
                    iVecI3 = iVecIArray2[iVecIArray2.length - n2].diff(iVecIArray2[iVecIArray2.length - n2 - 1]);
                }
                iVecIArray5 = ISurfaceCreator.orient(iVecIArray3, iVecI, iVec, iVecI2, iVecIArray2[i], iVecI3, iVec2);
                if (bl) {
                    if (i < iVecIArray2.length - 1) {
                        iVecI3 = iVecIArray2[i + 1].diff(iVecIArray2[i]);
                    }
                    iVecIArray5 = ISurfaceCreator.orientAndBisect(iVecIArray3, iVecI, iVec, iVecI2, iVecIArray2[i], iVecI3, iVec2);
                }
                iVecIArray4[i] = iVecIArray5;
                continue;
            }
            if (bl && i >= iVecIArray2.length - n2) {
                iVecIArray4[i] = ISurfaceCreator.duplicatePoints(iVecIArray4[i - (iVecIArray2.length - n2)]);
                continue;
            }
            if (i == iVecIArray2.length - 1) {
                ISurfaceCreator.orient(iVecIArray3, iVecI, iVecIArray2[i]);
                iVecIArray4[i] = iVecIArray3;
                continue;
            }
            iVecI3 = i < iVecIArray2.length - 1 ? iVecIArray2[i + 1].diff(iVecIArray2[i]) : iVecIArray2[i].diff(iVecIArray2[i - 1]);
            iVecIArray5 = ISurfaceCreator.orientAndBisect(iVecIArray3, iVecI, iVec, iVecI2, iVecIArray2[i], iVecI3, iVec2);
            iVecIArray4[i] = iVecIArray5;
        }
        return iVecIArray4;
    }

    public static IVecI[] duplicatePoints(IVecI[] iVecIArray) {
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i].dup();
        }
        return iVecIArray2;
    }

    public static IVecI[] duplicatePoints(IVecI[] iVecIArray, double d) {
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            double d2 = 1.0;
            if (iVecIArray[i] instanceof IVec4I) {
                d2 = ((IVec4I)iVecIArray[i]).w();
            }
            iVecIArray2[i] = iVecIArray[i].to4d(d2 * d);
        }
        return iVecIArray2;
    }

    public static IVecI[] orient(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2) {
        IVec iVec = iVecI2.get().diff(iVecI);
        for (IVecI iVecI3 : iVecIArray) {
            iVecI3.add(iVec);
        }
        iVecI.set(iVecI2);
        return iVecIArray;
    }

    public static IVecI[] orient(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.orient(iVecIArray, iVecI, iVecI2, null, iVecI3, iVecI4, null);
    }

    public static IVecI[] orient(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6) {
        IVec iVec = null;
        double d = 0.0;
        if (iVecI5 != null && !iVecI2.get().isParallel(iVecI5)) {
            iVec = iVecI2.get().cross(iVecI5);
            d = iVecI2.angle(iVecI5, (IVecI)iVec);
        }
        for (IVecI iVecI7 : iVecIArray) {
            iVecI7.sub(iVecI);
            if (iVec == null) continue;
            iVecI7.rot((IVecI)iVec, d);
        }
        if (iVec != null) {
            iVecI2.rot((IVecI)iVec, d);
        }
        if (iVecI3 != null) {
            if (iVec != null) {
                iVecI3.rot((IVecI)iVec, d);
            }
            if (iVecI6 != null && !iVecI3.get().isParallel(iVecI6)) {
                d = iVecI3.angle(iVecI6, iVecI5);
                for (IVecI iVecI7 : iVecIArray) {
                    iVecI7.rot(iVecI5, d);
                }
                iVecI3.rot(iVecI5, d);
            }
        }
        for (IVecI iVecI7 : iVecIArray) {
            iVecI7.add(iVecI4);
        }
        iVecI.set(iVecI4);
        if (iVecI4 instanceof IVec4I) {
            return ISurfaceCreator.duplicatePoints(iVecIArray, ((IVec4I)iVecI4).w());
        }
        return ISurfaceCreator.duplicatePoints(iVecIArray);
    }

    public static IVecI[] orientAndBisect(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.orientAndBisect(iVecIArray, iVecI, iVecI2, null, iVecI3, iVecI4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static IVecI[] orientAndBisect(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6) {
        void var13_22;
        IVec iVec = null;
        double d = 0.0;
        if (iVecI5 != null && !iVecI2.get().isParallel(iVecI5)) {
            iVec = iVecI2.get().cross(iVecI5);
            d = iVecI2.angle(iVecI5, (IVecI)iVec);
        }
        for (IVecI iVecIArray22 : iVecIArray) {
            iVecIArray22.sub(iVecI);
        }
        double d2 = d / 2.0;
        IVec iVec2 = null;
        if (iVec != null) {
            for (IVecI iVecI7 : iVecIArray) {
                iVecI7.rot((IVecI)iVec, d);
            }
            iVec2 = iVecI2.get().cross(iVec);
            iVec2.rot(iVec, d2);
            iVecI2.rot((IVecI)iVec, d);
            if (iVecI3 != null) {
                iVecI3.rot((IVecI)iVec, d);
            }
        }
        if (iVecI3 != null && iVecI6 != null && !iVecI3.get().isParallel(iVecI6)) {
            d = iVecI3.angle(iVecI6, iVecI5);
            for (IVecI iVecI7 : iVecIArray) {
                iVecI7.rot(iVecI5, d);
            }
            iVecI3.rot(iVecI5, d);
        }
        Object var13_19 = null;
        if (iVecI4 instanceof IVec4I) {
            IVecI[] iVecIArray2 = ISurfaceCreator.duplicatePoints(iVecIArray, ((IVec4I)iVecI4).w());
        } else {
            IVecI[] iVecIArray3 = ISurfaceCreator.duplicatePoints(iVecIArray);
        }
        if (iVec != null) {
            for (IVecI iVecI8 : var13_22) {
                iVecI8.rot((IVecI)iVec, -d2);
                if (!(Math.abs(d2 - 1.5707963267948966) >= IConfig.angleTolerance)) continue;
                double d3 = 1.0 / Math.abs(Math.cos(d2));
                iVecI8.scale1d((IVecI)iVec2, d3);
            }
        }
        for (IVecI iVecI8 : iVecIArray) {
            iVecI8.add(iVecI4);
        }
        for (IVecI iVecI8 : var13_22) {
            iVecI8.add(iVecI4);
        }
        iVecI.set(iVecI4);
        return var13_22;
    }

    public static boolean isClosed(IVecI[] iVecIArray, int n) {
        boolean bl = true;
        for (int i = 0; i < n && bl; ++i) {
            if (iVecIArray[i].eq(iVecIArray[iVecIArray.length - n + i])) continue;
            bl = false;
        }
        return bl;
    }

    public static IVec getCenter(IVecI[] iVecIArray, int n) {
        boolean bl = ISurfaceCreator.isClosed(iVecIArray, n);
        IVec iVec = new IVec();
        int n2 = 0;
        for (int i = 0; i < iVecIArray.length && !bl || i < iVecIArray.length - n && bl; ++i) {
            iVec.add(iVecIArray[i]);
            ++n2;
        }
        iVec.div(n2);
        return iVec;
    }

    public static ISurface pipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.pipe(new IVecI[]{iVecI, iVecI2}, 1, false, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, 1, false, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, false, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.pipe(iVecIArray2, n, dArray, d);
    }

    public static ISurface pipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.pipe(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec iVec2 = iVecIArray[1].get().diff(iVecIArray[0]);
        IVec iVec3 = iVecIArray[0].get();
        IVec iVec4 = iVec2.cross(iVec);
        IVecI[] iVecIArray2 = ICircleGeo.circleCP(iVec3, iVec2, iVec4, d);
        int n2 = ICircleGeo.circleDeg();
        double[] dArray2 = ICircleGeo.circleKnots();
        return ISurfaceCreator.sweep(iVecIArray2, n2, dArray2, (IVecI)iVec3, (IVecI)iVec4, iVecIArray, n, dArray);
    }

    public static ISurface squarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.rectPipe(new IVecI[]{iVecI, iVecI2}, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d);
    }

    public static ISurface squarePipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.rectPipe(new IVecI[]{iVecI, iVecI2}, 1, false, d, d2);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(new IVecI[]{iVecI, iVecI2}, 1, false, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, 1, false, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, 1, false, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, false, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, false, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, -d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2, double d3, double d4) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.rectPipe(iVecIArray2, n, dArray, d, d2, d3, d4);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2) {
        return ISurfaceCreator.rectPipe(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), d, d2);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, -d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2, double d3, double d4) {
        IVecI[] iVecIArray2;
        IVec iVec;
        IVec iVec2 = IVec.averageNormal(iVecIArray);
        IVec iVec3 = iVecIArray[1].get().diff(iVecIArray[0]);
        IVec iVec4 = iVecIArray[0].get();
        IVec iVec5 = iVec3.cross(iVec2);
        if (iVec5.eq(new IVec(0.0, 0.0, 0.0))) {
            iVec5 = new IVec(1.0, 0.0, 0.0);
        }
        if ((iVec = iVec3.cross(iVec5)).eq(new IVec(0.0, 0.0, 0.0))) {
            iVec5 = new IVec(0.0, 1.0, 0.0);
        }
        iVecIArray2 = new IVec[]{iVec4.cp().add(iVec5.cp().len(d)).add(iVec.cp().len(d3)), iVec4.cp().add(iVec5.cp().len(d)).add(iVec.cp().len(d4)), iVec4.cp().add(iVec5.cp().len(d2)).add(iVec.cp().len(d4)), iVec4.cp().add(iVec5.cp().len(d2)).add(iVec.cp().len(d3)), iVecIArray2[0].cp()};
        double[] dArray2 = INurbsGeo.createClosedKnots(1, iVecIArray2.length);
        return ISurfaceCreator.sweep(iVecIArray2, 1, dArray2, (IVecI)iVec4, (IVecI)iVec, iVecIArray, n, dArray);
    }

    public static ISurface loft(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loft(iCurveIArray, 1, false);
    }

    public static ISurface loft(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.loft(new ICurveI[]{iCurveI, iCurveI2}, 1, false);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loft(iCurveIArray, n, false);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n, boolean bl) {
        int n2 = ISurfaceCreator.checkCPNumForLoft(iCurveIArray);
        if (n2 < 2) {
            return null;
        }
        IVecI[][] iVecIArray = new IVec[iCurveIArray.length][n2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                iVecIArray[i][j] = iCurveIArray[i].cp(j);
            }
        }
        double[] dArray = null;
        if (bl) {
            iVecIArray = INurbsGeo.createClosedCPInU(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray.length);
        } else {
            dArray = INurbsGeo.createKnots(n, iVecIArray.length);
        }
        double[] dArray2 = null;
        int n3 = iCurveIArray[0].deg();
        if (iCurveIArray[0].num() == n2) {
            dArray2 = iCurveIArray[0].knots();
        } else {
            if (n3 > n2 - 1) {
                n3 = n2 - 1;
            }
            dArray2 = INurbsGeo.createKnots(n3, n2);
        }
        return new ISurface(server, iVecIArray, n, n3, dArray, dArray2, 0.0, 1.0, 0.0, 1.0);
    }

    public static int checkCPNumForLoft(ICurveI[] iCurveIArray) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no curve is provided");
            return 0;
        }
        int n = iCurveIArray[0].num();
        boolean bl = true;
        for (int i = 1; i < iCurveIArray.length; ++i) {
            if (iCurveIArray[i].num() == n) continue;
            bl = false;
            if (iCurveIArray[i].num() >= n) continue;
            n = iCurveIArray[i].num();
        }
        if (!bl) {
            IOut.err("num of control points needs to be same for lofting");
        }
        return n;
    }

    public static IVecI[][] checkCPNumForLoft(IVecI[][] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length == 0) {
            IOut.err("no pts is provided");
            return null;
        }
        int n = iVecIArray[0].length;
        boolean bl = true;
        for (int i = 1; i < iVecIArray.length; ++i) {
            if (iVecIArray[i].length == n) continue;
            bl = false;
            if (iVecIArray[i].length >= n) continue;
            n = iVecIArray[i].length;
        }
        if (!bl) {
            IOut.err("num of control points needs to be same for lofting");
        }
        if (bl) {
            return iVecIArray;
        }
        IVecI[][] iVecIArray2 = new IVecI[iVecIArray.length][n];
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                iVecIArray2[i][j] = iVecIArray[i][j];
            }
        }
        return iVecIArray2;
    }

    public static ISurface loft(IVecI[][] iVecIArray) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray));
    }

    public static ISurface loft(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), bl, bl2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), n, n2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), n, n2, bl, bl2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3));
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, boolean bl) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), 1, n);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n, boolean bl) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), 1, n, false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4));
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, boolean bl) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), n, n2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2, boolean bl) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), n, n2, false, bl);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftX(iCurveIArray, 1, false);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftX(iCurveIArray, n, false);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new XCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftY(iCurveIArray, 1, false);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftY(iCurveIArray, n, false);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new YCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftZ(iCurveIArray, 1, false);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftZ(iCurveIArray, n, false);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new ZCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static IVec getCenter(ICurveI iCurveI) {
        return ISurfaceCreator.getCenter(iCurveI.cps(), iCurveI.deg());
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI, IVecI iVecI2) {
        int n;
        IVecI[][] iVecIArray = new IVecI[iSurfaceI.unum()][iSurfaceI.vnum()];
        for (int i = 0; i < iSurfaceI.unum(); ++i) {
            for (n = 0; n < iSurfaceI.vnum(); ++n) {
                iVecIArray[i][n] = iSurfaceI.cp(i, n);
            }
        }
        IVec.projectToPlane(iVecIArray, iVecI, iVecI2);
        double[] dArray = new double[iSurfaceI.uknotNum()];
        for (n = 0; n < iSurfaceI.uknotNum(); ++n) {
            dArray[n] = iSurfaceI.uknot(n);
        }
        double[] dArray2 = new double[iSurfaceI.vknotNum()];
        for (int i = 0; i < iSurfaceI.vknotNum(); ++i) {
            dArray2[i] = iSurfaceI.vknot(i);
        }
        return ISurfaceCreator.surface(iVecIArray, iSurfaceI.udeg(), iSurfaceI.vdeg(), dArray, dArray2, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI) {
        int n;
        IVecI[][] iVecIArray = new IVecI[iSurfaceI.unum()][iSurfaceI.vnum()];
        for (int i = 0; i < iSurfaceI.unum(); ++i) {
            for (n = 0; n < iSurfaceI.vnum(); ++n) {
                iVecIArray[i][n] = iSurfaceI.cp(i, n);
            }
        }
        IVec.projectToPlane(iVecIArray, iVecI);
        double[] dArray = new double[iSurfaceI.uknotNum()];
        for (n = 0; n < iSurfaceI.uknotNum(); ++n) {
            dArray[n] = iSurfaceI.uknot(n);
        }
        double[] dArray2 = new double[iSurfaceI.vknotNum()];
        for (int i = 0; i < iSurfaceI.vknotNum(); ++i) {
            dArray2[i] = iSurfaceI.vknot(i);
        }
        return ISurfaceCreator.surface(iVecIArray, iSurfaceI.udeg(), iSurfaceI.vdeg(), dArray, dArray2, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI) {
        int n;
        IVecI[][] iVecIArray = new IVecI[iSurfaceI.unum()][iSurfaceI.vnum()];
        for (int i = 0; i < iSurfaceI.unum(); ++i) {
            for (n = 0; n < iSurfaceI.vnum(); ++n) {
                iVecIArray[i][n] = iSurfaceI.cp(i, n);
            }
        }
        IVec.projectToPlane(iVecIArray);
        double[] dArray = new double[iSurfaceI.uknotNum()];
        for (n = 0; n < iSurfaceI.uknotNum(); ++n) {
            dArray[n] = iSurfaceI.uknot(n);
        }
        double[] dArray2 = new double[iSurfaceI.vknotNum()];
        for (int i = 0; i < iSurfaceI.vknotNum(); ++i) {
            dArray2[i] = iSurfaceI.vknot(i);
        }
        return ISurfaceCreator.surface(iVecIArray, iSurfaceI.udeg(), iSurfaceI.vdeg(), dArray, dArray2, 0.0, 1.0, 0.0, 1.0);
    }

    public static IBrep cap(ISurfaceI iSurfaceI) {
        Object object;
        boolean bl = iSurfaceI.isUClosed();
        boolean bl2 = iSurfaceI.isVClosed();
        if (bl && bl2) {
            IOut.debug(20, "both u and v are closed. no need to cap. returning null.");
            return null;
        }
        if (!bl && !bl2) {
            IOut.err("both u and v are open. one of them needs to be closed to be capped. returning null.");
            return null;
        }
        if (bl) {
            Object object2;
            int n = iSurfaceI.unum();
            if (n < 4) {
                return null;
            }
            ISurfaceGeo iSurfaceGeo = null;
            ISurfaceGeo iSurfaceGeo2 = null;
            int n2 = iSurfaceI.udeg();
            if (n2 == 1 && n <= 5) {
                if (n == 4) {
                    iSurfaceGeo = new ISurfaceGeo(new IVecI[]{iSurfaceI.cp(0, 0), iSurfaceI.cp(2, 0), iSurfaceI.cp(1, 0)});
                    iSurfaceGeo2 = new ISurfaceGeo(new IVecI[]{iSurfaceI.cp(0, iSurfaceI.vnum() - 1), iSurfaceI.cp(1, iSurfaceI.vnum() - 1), iSurfaceI.cp(2, iSurfaceI.vnum() - 1)});
                } else {
                    iSurfaceGeo = new ISurfaceGeo(iSurfaceI.cp(0, 0), iSurfaceI.cp(3, 0), iSurfaceI.cp(2, 0), iSurfaceI.cp(1, 0));
                    iSurfaceGeo2 = new ISurfaceGeo(iSurfaceI.cp(0, iSurfaceI.vnum() - 1), iSurfaceI.cp(1, iSurfaceI.vnum() - 1), iSurfaceI.cp(2, iSurfaceI.vnum() - 1), iSurfaceI.cp(3, iSurfaceI.vnum() - 1));
                }
            } else {
                object2 = new IVecI[n];
                for (int i = 0; i < n; ++i) {
                    object2[i] = iSurfaceI.cp(n - 1 - i, 0);
                }
                iSurfaceGeo = ISurfaceCreator.profileSurfaceGeo((IVecI[])object2, n2, iSurfaceI.uknots());
                IVecI[] iVecIArray = new IVecI[n];
                for (int i = 0; i < n; ++i) {
                    iVecIArray[i] = iSurfaceI.cp(i, iSurfaceI.vnum() - 1);
                }
                iSurfaceGeo2 = ISurfaceCreator.profileSurfaceGeo(iVecIArray, n2, INurbsGeo.invertKnots(iSurfaceI.uknots()));
            }
            if (iSurfaceGeo == null || iSurfaceGeo2 == null) {
                return null;
            }
            object2 = new IBrep(server, new ISurfaceGeo[]{iSurfaceI.get(), iSurfaceGeo, iSurfaceGeo2});
            ((IBrep)object2).solid = true;
            if (iSurfaceI instanceof IObject) {
                ((IBrep)object2).clr(((IObject)((Object)iSurfaceI)).clr());
            }
            return object2;
        }
        int n = iSurfaceI.vnum();
        if (n < 4) {
            return null;
        }
        ISurfaceGeo iSurfaceGeo = null;
        ISurfaceGeo iSurfaceGeo3 = null;
        int n3 = iSurfaceI.vdeg();
        if (n3 == 1 && n <= 5) {
            if (n == 4) {
                iSurfaceGeo = new ISurfaceGeo(new IVecI[]{iSurfaceI.cp(0, 0), iSurfaceI.cp(0, 2), iSurfaceI.cp(0, 1)});
                iSurfaceGeo3 = new ISurfaceGeo(new IVecI[]{iSurfaceI.cp(iSurfaceI.unum() - 1, 0), iSurfaceI.cp(iSurfaceI.unum() - 1, 1), iSurfaceI.cp(iSurfaceI.unum() - 1, 2)});
            } else {
                iSurfaceGeo = new ISurfaceGeo(iSurfaceI.cp(0, 0), iSurfaceI.cp(0, 3), iSurfaceI.cp(0, 2), iSurfaceI.cp(0, 1));
                iSurfaceGeo3 = new ISurfaceGeo(iSurfaceI.cp(iSurfaceI.unum() - 1, 0), iSurfaceI.cp(iSurfaceI.unum() - 1, 1), iSurfaceI.cp(iSurfaceI.unum() - 1, 2), iSurfaceI.cp(iSurfaceI.unum() - 1, 3));
            }
        } else {
            object = new IVecI[n];
            for (int i = 0; i < n; ++i) {
                object[i] = iSurfaceI.cp(0, n - 1 - i);
            }
            iSurfaceGeo = ISurfaceCreator.profileSurfaceGeo((IVecI[])object, n3, iSurfaceI.vknots());
            IVecI[] iVecIArray = new IVecI[n];
            for (int i = 0; i < n; ++i) {
                iVecIArray[i] = iSurfaceI.cp(iSurfaceI.unum() - 1, i);
            }
            iSurfaceGeo3 = ISurfaceCreator.profileSurfaceGeo(iVecIArray, n3, INurbsGeo.invertKnots(iSurfaceI.vknots()));
        }
        if (iSurfaceGeo == null || iSurfaceGeo3 == null) {
            return null;
        }
        object = new IBrep(server, new ISurfaceGeo[]{iSurfaceI.get(), iSurfaceGeo, iSurfaceGeo3});
        ((IBrep)object).solid = true;
        if (iSurfaceI instanceof IObject) {
            ((IBrep)object).clr(((IObject)((Object)iSurfaceI)).clr());
        }
        return object;
    }

    public static ISurfaceGeo profileSurfaceGeo(IVecI[] iVecIArray, int n, double[] dArray) {
        if (IVec.isFlat(iVecIArray)) {
            return new ISurfaceGeo(iVecIArray, n, dArray);
        }
        return ISurfaceCreator.radialSurfaceGeo(iVecIArray, n, dArray);
    }

    public static ISurface profileSurface(IVecI[] iVecIArray, int n, double[] dArray) {
        if (IVec.isFlat(iVecIArray)) {
            return ISurfaceCreator.surface(iVecIArray, n, dArray);
        }
        return ISurfaceCreator.radialSurface(iVecIArray, n, dArray);
    }

    public static ISurface profileSurface(ICurveI iCurveI) {
        return ISurfaceCreator.profileSurface(iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurfaceGeo radialSurfaceGeo(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.pointLoftGeo(iVecIArray, n, dArray, IVec.center(iVecIArray));
    }

    public static ISurface radialSurface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.pointLoft(iVecIArray, n, dArray, IVec.center(iVecIArray));
    }

    public static ISurface radialSurface(ICurveI iCurveI) {
        return ISurfaceCreator.radialSurface(iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurfaceGeo pointLoftGeo(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        int n2 = iVecIArray.length;
        IVecI[][] iVecIArray2 = new IVecI[n2][2];
        IVec iVec = iVecI.get();
        for (int i = 0; i < n2; ++i) {
            iVecIArray2[i][0] = iVecIArray[i];
            iVecIArray2[i][1] = iVec.dup();
        }
        return new ISurfaceGeo(iVecIArray2, n, 1, dArray, INurbsGeo.createKnots(1, 2));
    }

    public static ISurface pointLoft(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        int n2 = iVecIArray.length;
        IVecI[][] iVecIArray2 = new IVecI[n2][2];
        IVec iVec = iVecI.get();
        for (int i = 0; i < n2; ++i) {
            iVecIArray2[i][0] = iVecIArray[i];
            iVecIArray2[i][1] = iVec.dup();
        }
        return new ISurface(iVecIArray2, n, 1, dArray, INurbsGeo.createKnots(1, 2));
    }

    public static ISurface pointLoft(ICurveI iCurveI, IVecI iVecI) {
        return ISurfaceCreator.pointLoft(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI);
    }

    public static class ZCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).z;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).z;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class YCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).y;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).y;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class XCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).x;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).x;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }
}

