/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticle;
import igeo.IParticleI;
import igeo.ITensionI;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

public class ISpacingEqualizer
extends IDynamicsBase
implements ITensionI {
    public IParticleI pt1;
    public IParticleI pt2;
    public IParticleI pt3;
    public double tension = 1.0;
    public boolean constantTension = false;

    public ISpacingEqualizer(IParticleI iParticleI, IParticleI iParticleI2, IParticleI iParticleI3, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.pt3 = iParticleI3;
    }

    public ISpacingEqualizer(IParticle iParticle, IParticle iParticle2, IParticle iParticle3, IObject iObject) {
        super(iObject);
        this.pt1 = iParticle;
        this.pt2 = iParticle2;
        this.pt3 = iParticle3;
    }

    public ISpacingEqualizer(IVec iVec, IVec iVec2, IVec iVec3, IObject iObject) {
        super(iObject);
        this.pt1 = new IParticle(iVec);
        this.pt2 = new IParticle(iVec2);
        this.pt3 = new IParticle(iVec3);
    }

    public ISpacingEqualizer(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IObject iObject) {
        super(iObject);
        this.pt1 = new IParticle(iVecI.get());
        this.pt2 = new IParticle(iVecI2.get());
        this.pt3 = new IParticle(iVecI3.get());
    }

    public ISpacingEqualizer(IParticleI iParticleI, IParticleI iParticleI2, IParticleI iParticleI3) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.pt3 = iParticleI3;
    }

    public ISpacingEqualizer(IParticle iParticle, IParticle iParticle2, IParticle iParticle3) {
        this.pt1 = iParticle;
        this.pt2 = iParticle2;
        this.pt3 = iParticle3;
    }

    public ISpacingEqualizer(IVec iVec, IVec iVec2, IVec iVec3) {
        this.pt1 = new IParticle(iVec);
        this.pt2 = new IParticle(iVec2);
        this.pt3 = new IParticle(iVec3);
    }

    public ISpacingEqualizer(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pt1 = new IParticle(iVecI.get());
        this.pt2 = new IParticle(iVecI2.get());
        this.pt3 = new IParticle(iVecI3.get());
    }

    @Override
    public double tension() {
        return this.tension;
    }

    @Override
    public ISpacingEqualizer tension(double d) {
        this.tension = d;
        return this;
    }

    @Override
    public boolean constant() {
        return this.constantTension;
    }

    @Override
    public ISpacingEqualizer constant(boolean bl) {
        this.constantTension = bl;
        return this;
    }

    @Override
    public IParticleI pt(int n) {
        if (n == 2) {
            return this.pt3;
        }
        if (n == 1) {
            return this.pt2;
        }
        return this.pt1;
    }

    @Override
    public IParticleI particle(int n) {
        return this.pt(n);
    }

    @Override
    public IVec pos(int n) {
        return this.pt(n).pos();
    }

    @Override
    public IParticleI pt1() {
        return this.pt1;
    }

    @Override
    public IParticleI particle1() {
        return this.pt1();
    }

    @Override
    public IVec pos1() {
        return this.pt1().pos();
    }

    @Override
    public IParticleI pt2() {
        return this.pt2;
    }

    @Override
    public IParticleI particle2() {
        return this.pt2();
    }

    @Override
    public IVec pos2() {
        return this.pt2().pos();
    }

    public IParticleI pt3() {
        return this.pt3;
    }

    public IParticleI particle3() {
        return this.pt3();
    }

    public IVec pos3() {
        return this.pt3().pos();
    }

    @Override
    public ISpacingEqualizer parent(IObject iObject) {
        super.parent(iObject);
        return this;
    }

    @Override
    public ISpacingEqualizer target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public ISpacingEqualizer removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public ISpacingEqualizer removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        IVec iVec = this.pt1.pos();
        IVec iVec2 = this.pt2.pos();
        IVec iVec3 = this.pt3.pos();
        IVec iVec4 = iVec3.diff(iVec);
        iVec4.div(2.0).add(iVec).sub(iVec2);
        if (!this.constantTension) {
            iVec4.mul(this.tension);
        } else if (iVec4.len2() > 0.0) {
            iVec4.len(this.tension);
        }
        this.pt2.addForce(iVec4);
        iVec4.mul(-0.5);
        this.pt1.addForce(iVec4);
        this.pt3.addForce(iVec4);
    }
}

