/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

public class IGraphicMode {
    public GraphicType graphicType;
    public boolean wireframe = true;
    public boolean fill = true;
    public boolean transparent = true;
    public boolean transparentWireframe = false;
    public boolean lightWireframe = false;
    public boolean light = true;

    public IGraphicMode() {
    }

    public IGraphicMode(GraphicType graphicType) {
        this.graphicType = graphicType;
    }

    public IGraphicMode(GraphicType graphicType, boolean bl, boolean bl2, boolean bl3) {
        this.graphicType = graphicType;
        this.fill = bl;
        this.wireframe = bl2;
        this.transparent = bl3;
    }

    public IGraphicMode(IGraphicMode iGraphicMode) {
        this.graphicType = iGraphicMode.graphicType;
        this.fill = iGraphicMode.fill;
        this.wireframe = iGraphicMode.wireframe;
        this.transparent = iGraphicMode.transparent;
        this.transparentWireframe = iGraphicMode.transparentWireframe;
        this.lightWireframe = iGraphicMode.lightWireframe;
        this.light = iGraphicMode.light;
    }

    public void setGraphicType(GraphicType graphicType) {
        this.graphicType = graphicType;
    }

    public GraphicType getGraphicType() {
        return this.graphicType;
    }

    public boolean isGL() {
        return this.graphicType == GraphicType.GL;
    }

    public boolean isJava() {
        return this.graphicType == GraphicType.JAVA;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean isFill() {
        return this.fill;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isNone() {
        return !this.wireframe && !this.fill && !this.transparent;
    }

    public boolean isLight() {
        return this.light;
    }

    public boolean isTransparentWireframe() {
        return this.transparentWireframe;
    }

    public boolean isLightWireframe() {
        return this.lightWireframe;
    }

    public void setDrawMode(boolean bl, boolean bl2, boolean bl3) {
        this.wireframe = bl;
        this.fill = bl2;
        this.transparent = bl3;
    }

    public void toggleWireframe() {
        if (!this.wireframe || this.fill) {
            this.wireframe = !this.wireframe;
        }
    }

    public void toggleFill() {
        if (!this.fill || this.wireframe) {
            this.fill = !this.fill;
        }
    }

    public void toggleTransparent() {
        this.transparent = !this.transparent;
    }

    public void enableLight() {
        this.light = true;
    }

    public void disableLight() {
        this.light = false;
    }

    public static IGraphicMode[] getAllModes() {
        GraphicType[] graphicTypeArray = GraphicType.values();
        IGraphicMode[] iGraphicModeArray = new IGraphicMode[graphicTypeArray.length];
        for (int i = 0; i < graphicTypeArray.length; ++i) {
            iGraphicModeArray[i] = new IGraphicMode(graphicTypeArray[i]);
        }
        return iGraphicModeArray;
    }

    public static enum GraphicType {
        GL,
        JAVA;

    }
}

