/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurveI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IG;
import igeo.IMesh;
import igeo.IMeshGeo;
import igeo.IMeshType;
import igeo.IOut;
import igeo.IServerI;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.util.ArrayList;

public class IMeshCreator {
    public static IServerI server = null;
    public static IMeshType type = new IMeshType();

    public static void server(IServerI iServerI) {
        server = iServerI;
    }

    public static IServerI server() {
        return server;
    }

    public static void meshType(IMeshType iMeshType) {
        type = iMeshType;
    }

    public static IMeshType meshType() {
        return type;
    }

    public static IMesh mesh() {
        return new IMesh(server);
    }

    public static IMesh mesh(IMeshGeo iMeshGeo) {
        return new IMesh(server, iMeshGeo);
    }

    public static IMesh mesh(IMesh iMesh) {
        return new IMesh(server, iMesh);
    }

    public static IMesh mesh(ArrayList<ICurveI> arrayList) {
        return new IMesh(server, arrayList, type);
    }

    public static IMesh mesh(IVec[][] iVecArray) {
        return new IMesh(server, iVecArray);
    }

    public static IMesh mesh(IVec[][] iVecArray, boolean bl) {
        return new IMesh(server, iVecArray, bl, type);
    }

    public static IMesh mesh(IVec[][] iVecArray, int n, int n2, boolean bl) {
        return new IMesh(server, iVecArray, n, n2, bl, type);
    }

    public static IMesh mesh(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        return new IMesh(server, arrayList, arrayList2, arrayList3);
    }

    public static IMesh mesh(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        return new IMesh(server, iVertexArray, iEdgeArray, iFaceArray);
    }

    public static IMesh mesh(IVec[] iVecArray) {
        return new IMesh(server, iVecArray);
    }

    public static IMesh mesh(IVertex[] iVertexArray) {
        return new IMesh(server, iVertexArray);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        return new IMesh(server, iVertex, iVertex2, iVertex3);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        return new IMesh(server, iVertex, iVertex2, iVertex3, iVertex4);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new IMesh(server, iVecI, iVecI2, iVecI3);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return new IMesh(server, iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return new IMesh(server, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return new IMesh(server, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static IMesh mesh(IFace[] iFaceArray) {
        return new IMesh(server, iFaceArray);
    }

    public static IMesh box(double d, double d2, double d3, double d4) {
        return IMeshCreator.box((IVecI)new IVec(d, d2, d3), d4, d4, d4);
    }

    public static IMesh box(double d, double d2, double d3, double d4, double d5, double d6) {
        return IMeshCreator.box((IVecI)new IVec(d, d2, d3), d4, d5, d6);
    }

    public static IMesh box(IVecI iVecI, double d) {
        return IMeshCreator.box(iVecI, d, d, d);
    }

    public static IMesh box(IVecI iVecI, double d, double d2, double d3) {
        return IMeshCreator.box(iVecI, new IVec(d, 0.0, 0.0), new IVec(0.0, d2, 0.0), new IVec(0.0, 0.0, d3));
    }

    public static IMesh box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][][] iVecIArray = new IVecI[2][2][2];
        IVec iVec = iVecI.get();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    iVecIArray[i][j][k] = iVec.dup();
                    if (i > 0) {
                        iVecIArray[i][j][k].add(iVecI2);
                    }
                    if (j > 0) {
                        iVecIArray[i][j][k].add(iVecI3);
                    }
                    if (k <= 0) continue;
                    iVecIArray[i][j][k].add(iVecI4);
                }
            }
        }
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        IVecI[][][] iVecIArray = new IVecI[2][2][2];
        iVecIArray[0][0][0] = iVecI;
        iVecIArray[1][0][0] = iVecI2;
        iVecIArray[1][1][0] = iVecI3;
        iVecIArray[0][1][0] = iVecI4;
        iVecIArray[0][0][1] = iVecI5;
        iVecIArray[1][0][1] = iVecI6;
        iVecIArray[1][1][1] = iVecI7;
        iVecIArray[0][1][1] = iVecI8;
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh box(IVecI[][][] iVecIArray) {
        if (iVecIArray.length < 2 || iVecIArray[0].length < 2 || iVecIArray[1].length < 2 || iVecIArray[0][0].length < 2 || iVecIArray[0][1].length < 2 || iVecIArray[1][0].length < 2 || iVecIArray[1][1].length < 2) {
            return null;
        }
        IVertex[][][] iVertexArray = new IVertex[2][2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    iVertexArray[i][j][k] = type.createVertex(iVecIArray[i][j][k]);
                }
            }
        }
        return IMeshCreator.box(iVertexArray);
    }

    public static IMesh box(IVertex[][][] iVertexArray) {
        int n;
        if (iVertexArray.length < 2 || iVertexArray[0].length < 2 || iVertexArray[1].length < 2 || iVertexArray[0][0].length < 2 || iVertexArray[0][1].length < 2 || iVertexArray[1][0].length < 2 || iVertexArray[1][1].length < 2) {
            return null;
        }
        IEdge[] iEdgeArray = new IEdge[12];
        IFace[] iFaceArray = new IFace[6];
        IVec iVec = iVertexArray[1][0][0].get().dif(iVertexArray[0][0][0]);
        IVec iVec2 = iVertexArray[0][1][0].get().dif(iVertexArray[0][0][0]);
        IVec iVec3 = iVertexArray[0][0][1].get().dif(iVertexArray[0][0][0]);
        if (iVec.cross(iVec2).dot(iVec3) >= 0.0) {
            iEdgeArray[0] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][1][0]);
            iEdgeArray[1] = type.createEdge(iVertexArray[0][1][0], iVertexArray[1][1][0]);
            iEdgeArray[2] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][0][0]);
            iEdgeArray[3] = type.createEdge(iVertexArray[1][0][0], iVertexArray[0][0][0]);
            iEdgeArray[4] = type.createEdge(iVertexArray[0][0][1], iVertexArray[0][1][1]);
            iEdgeArray[5] = type.createEdge(iVertexArray[0][1][1], iVertexArray[1][1][1]);
            iEdgeArray[6] = type.createEdge(iVertexArray[1][1][1], iVertexArray[1][0][1]);
            iEdgeArray[7] = type.createEdge(iVertexArray[1][0][1], iVertexArray[0][0][1]);
        } else {
            iEdgeArray[0] = type.createEdge(iVertexArray[0][0][1], iVertexArray[0][1][1]);
            iEdgeArray[1] = type.createEdge(iVertexArray[0][1][1], iVertexArray[1][1][1]);
            iEdgeArray[2] = type.createEdge(iVertexArray[1][1][1], iVertexArray[1][0][1]);
            iEdgeArray[3] = type.createEdge(iVertexArray[1][0][1], iVertexArray[0][0][1]);
            iEdgeArray[4] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][1][0]);
            iEdgeArray[5] = type.createEdge(iVertexArray[0][1][0], iVertexArray[1][1][0]);
            iEdgeArray[6] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][0][0]);
            iEdgeArray[7] = type.createEdge(iVertexArray[1][0][0], iVertexArray[0][0][0]);
        }
        iEdgeArray[8] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][0][1]);
        iEdgeArray[9] = type.createEdge(iVertexArray[0][1][0], iVertexArray[0][1][1]);
        iEdgeArray[10] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][1][1]);
        iEdgeArray[11] = type.createEdge(iVertexArray[1][0][0], iVertexArray[1][0][1]);
        iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[1], iEdgeArray[2], iEdgeArray[3]);
        iFaceArray[1] = type.createFace(iEdgeArray[4], iEdgeArray[7], iEdgeArray[6], iEdgeArray[5]);
        iFaceArray[2] = type.createFace(iEdgeArray[8], iEdgeArray[4], iEdgeArray[9], iEdgeArray[0]);
        iFaceArray[3] = type.createFace(iEdgeArray[11], iEdgeArray[2], iEdgeArray[10], iEdgeArray[6]);
        iFaceArray[4] = type.createFace(iEdgeArray[11], iEdgeArray[7], iEdgeArray[8], iEdgeArray[3]);
        iFaceArray[5] = type.createFace(iEdgeArray[9], iEdgeArray[5], iEdgeArray[10], iEdgeArray[1]);
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    arrayList.add(iVertexArray[n][i][j]);
                }
            }
        }
        for (n = 0; n < 12; ++n) {
            arrayList2.add(iEdgeArray[n]);
        }
        for (n = 0; n < 6; ++n) {
            arrayList3.add(iFaceArray[n]);
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][][] iVecIArray = new IVec[2][2][2];
        IVec iVec = iVecI.get();
        IVec iVec2 = iVecI2.get();
        iVecIArray[0][0][0] = iVec.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[0][0][1] = iVec.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[0][1][0] = iVec.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[0][1][1] = iVec.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[1][0][0] = iVec2.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][0][1] = iVec2.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][1][0] = iVec2.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[1][1][1] = iVec2.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, double d, double d2, IVecI iVecI3) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(iVecI3);
        if (iVec2.len2() < IConfig.tolerance && (iVec2 = iVec.cross(IVec.zaxis)).len2() < IConfig.tolerance) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectStick(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(IVec.zaxis);
        if (iVec2.len2() > 0.0) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectStick(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh squareStick(IVecI iVecI, IVecI iVecI2, double d, IVecI iVecI3) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d, iVecI3);
    }

    public static IMesh squareStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d, n, IG.zaxis);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, int n, IVecI iVecI3) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d, n, iVecI3);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, n, IG.zaxis);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n, IVecI iVecI3) {
        int n2;
        IEdge[] iEdgeArray;
        if (n <= 2) {
            IOut.err("too less vertex number of a polygon. needs to be >= 3");
            return null;
        }
        int n3 = n;
        IVertex[] iVertexArray = new IVertex[n3];
        IVertex[] iVertexArray2 = new IVertex[n3];
        IVec iVec = iVecI.get();
        IVec iVec2 = iVecI2.get();
        IVertex iVertex = type.createVertex(iVec);
        IVertex iVertex2 = type.createVertex(iVec2);
        IVec iVec3 = iVec2.dif(iVec);
        IVec iVec4 = iVecI3.get().cross(iVec3);
        if (iVec4.len2() < IConfig.tolerance && (iVec4 = IVec.zaxis.cross(iVec3)).len2() < IConfig.tolerance) {
            iVec4 = IVec.xaxis.cross(iVec3);
        }
        IVec iVec5 = iVec3.cross(iVec4).len(d);
        double d3 = Math.PI * 2 / (double)n3;
        if (d != d2) {
            iEdgeArray = iVec5.dup().len(d2);
            for (int i = 0; i < n3; ++i) {
                iVertexArray[i] = type.createVertex(iVec.cp(iVec5));
                iVertexArray2[i] = type.createVertex(iVec2.cp((IVec)iEdgeArray));
                iVec5.rot(iVec3, d3);
                iEdgeArray.rot(iVec3, d3);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                iVertexArray[i] = type.createVertex(iVec.cp(iVec5));
                iVertexArray2[i] = type.createVertex(iVec2.cp(iVec5));
                iVec5.rot(iVec3, d3);
            }
        }
        iEdgeArray = new IEdge[n3];
        IEdge[] iEdgeArray2 = new IEdge[n3];
        IEdge[] iEdgeArray3 = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            iEdgeArray[i] = type.createEdge(iVertexArray[i], iVertexArray[(i + 1) % n3]);
            iEdgeArray2[i] = type.createEdge(iVertexArray2[i], iVertexArray2[(i + 1) % n3]);
            iEdgeArray3[i] = type.createEdge(iVertexArray[i], iVertexArray2[i]);
        }
        IEdge[] iEdgeArray4 = null;
        IEdge[] iEdgeArray5 = null;
        if (n3 > 4) {
            iEdgeArray4 = new IEdge[n3];
            iEdgeArray5 = new IEdge[n3];
            for (int i = 0; i < n3; ++i) {
                iEdgeArray4[i] = type.createEdge(iVertex, iVertexArray[i]);
                iEdgeArray5[i] = type.createEdge(iVertex2, iVertexArray2[i]);
            }
        }
        IFace[] iFaceArray = null;
        IFace[] iFaceArray2 = null;
        if (n3 == 3) {
            iFaceArray = new IFace[1];
            iFaceArray2 = new IFace[1];
            iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[2], iEdgeArray[1]);
            iFaceArray2[0] = type.createFace(iEdgeArray2[0], iEdgeArray2[1], iEdgeArray2[2]);
        } else if (n3 == 4) {
            iFaceArray = new IFace[1];
            iFaceArray2 = new IFace[1];
            iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[3], iEdgeArray[2], iEdgeArray[1]);
            iFaceArray2[0] = type.createFace(iEdgeArray2[0], iEdgeArray2[1], iEdgeArray2[2], iEdgeArray2[3]);
        } else {
            iFaceArray = new IFace[n3];
            iFaceArray2 = new IFace[n3];
            for (int i = 0; i < n3; ++i) {
                iFaceArray[i] = type.createFace(iEdgeArray4[(i + 1) % n3], iEdgeArray[i], iEdgeArray4[i]);
                iFaceArray2[i] = type.createFace(iEdgeArray5[i], iEdgeArray2[i], iEdgeArray5[(i + 1) % n3]);
            }
        }
        IFace[] iFaceArray3 = new IFace[n3];
        for (int i = 0; i < n3; ++i) {
            iFaceArray3[i] = type.createFace(iEdgeArray[i], iEdgeArray3[(i + 1) % n3], iEdgeArray2[i], iEdgeArray3[i]);
        }
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        if (n3 > 4) {
            arrayList.add(iVertex);
        }
        if (n3 > 4) {
            arrayList.add(iVertex2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(iVertexArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(iVertexArray2[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray2[n2]);
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(iEdgeArray4[n2]);
            }
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(iEdgeArray5[n2]);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray3[n2]);
        }
        for (n2 = 0; n2 < iFaceArray.length; ++n2) {
            arrayList3.add(iFaceArray[n2]);
        }
        for (n2 = 0; n2 < iFaceArray2.length; ++n2) {
            arrayList3.add(iFaceArray2[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList3.add(iFaceArray3[n2]);
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh stick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, IConfig.meshCircleResolution);
    }

    public static IMesh stick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, IConfig.meshCircleResolution);
    }

    public static IMesh roundStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.stick(iVecI, iVecI2, d);
    }

    public static IMesh roundStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.stick(iVecI, iVecI2, d, d2);
    }
}

