/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IBounds;
import igeo.IGraphicI;
import igeo.IObject;
import igeo.IOut;
import igeo.gui.IComponent;
import igeo.gui.IGraphics;
import igeo.gui.INavigator;
import igeo.gui.IPanel;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPane
extends IComponent {
    public IPanel parent;
    public IView view;
    public INavigator navigator;
    public float borderWidth = 0.0f;
    public Color borderColor = Color.gray;
    public BasicStroke borderStroke = new BasicStroke(this.borderWidth);

    public IPane(int n, int n2, int n3, int n4, IView iView, IPanel iPanel) {
        super(n, n2, n3, n4);
        this.view = iView;
        this.parent = iPanel;
        iView.setPane(this);
        this.navigator = new INavigator(iView, this);
    }

    public void setParent(IPanel iPanel) {
        this.parent = iPanel;
    }

    public IPanel getPanel() {
        return this.parent;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
        this.borderStroke = new BasicStroke(this.borderWidth);
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public INavigator navigator() {
        return this.navigator;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.view.setPane(this);
    }

    public void setView(IView iView) {
        this.view = iView;
    }

    public IView getView() {
        return this.view;
    }

    public void draw(IGraphics iGraphics) {
        if (this.view != null) {
            iGraphics.setView(this.view);
            ArrayList<IGraphicI> arrayList = this.parent.ig.server().graphicServer().getObjects(this.view);
            if (this.view.mode().isGL()) {
                this.view.draw(iGraphics.getGL());
                if (arrayList != null) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        if (!arrayList.get(i).isVisible()) continue;
                        arrayList.get(i).draw(iGraphics);
                    }
                }
                if (this.view.mode().isLight()) {
                    iGraphics.getGL().glDisable(2896);
                    iGraphics.getGL().glDisable(16385);
                }
                if (iGraphics.getGraphics() != null) {
                    Graphics2D graphics2D = iGraphics.getGraphics();
                    if (this.borderWidth > 0.0f && (this.parent.width != this.width || this.parent.height != this.height)) {
                        graphics2D.setColor(this.borderColor);
                        graphics2D.setStroke(this.borderStroke);
                        graphics2D.drawRect(this.x, this.y, this.width, this.height);
                    }
                }
            } else if (this.view.mode().isJava() && arrayList != null) {
                for (IGraphicI iGraphicI : arrayList) {
                    iGraphicI.draw(iGraphics);
                }
            }
        } else {
            IOut.err("view is null");
        }
    }

    public void focus() {
        this.parent.setBounds();
        this.view.focus(this.parent.getBounds());
    }

    public void focus(ArrayList<IObject> arrayList) {
        IBounds iBounds = new IBounds();
        iBounds.setObjects(arrayList);
        this.view.focus(iBounds);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.navigator.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.navigator.mouseReleased(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.navigator.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.navigator.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.navigator.mouseExited(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.navigator.mouseMoved(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.navigator.mouseDragged(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.navigator.mouseWheelMoved(mouseWheelEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.navigator.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.navigator.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.navigator.keyTyped(keyEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }
}

