/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;

public class IVec2f
extends IParameterObject
implements IVec2I {
    public float x;
    public float y;

    public IVec2f() {
    }

    public IVec2f(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public IVec2f(double d, double d2) {
        this.x = (float)d;
        this.y = (float)d2;
    }

    public IVec2f(IVec2f iVec2f) {
        this.x = iVec2f.x;
        this.y = iVec2f.y;
    }

    public IVec2f(IVec2 iVec2) {
        this.x = (float)iVec2.x;
        this.y = (float)iVec2.y;
    }

    public IVec2f(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        this.x = (float)iVec2.x;
        this.y = (float)iVec2.y;
    }

    public IVec2f(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = (float)iDoubleI.x();
        this.y = (float)iDoubleI2.x();
    }

    public IVec2f(IServerI iServerI) {
        super(iServerI);
    }

    public IVec2f(IServerI iServerI, float f, float f2) {
        super(iServerI);
        this.x = f;
        this.y = f2;
    }

    public IVec2f(IServerI iServerI, double d, double d2) {
        super(iServerI);
        this.x = (float)d;
        this.y = (float)d2;
    }

    public IVec2f(IServerI iServerI, IVec2f iVec2f) {
        super(iServerI);
        this.x = iVec2f.x;
        this.y = iVec2f.y;
    }

    public IVec2f(IServerI iServerI, IVec2 iVec2) {
        super(iServerI);
        this.x = (float)iVec2.x;
        this.y = (float)iVec2.y;
    }

    public IVec2f(IServerI iServerI, IVec2I iVec2I) {
        super(iServerI);
        IVec2 iVec2 = iVec2I.get();
        this.x = (float)iVec2.x;
        this.y = (float)iVec2.y;
    }

    public IVec2f(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super(iServerI);
        this.x = (float)iDoubleI.x();
        this.y = (float)iDoubleI2.x();
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public IVec2f x(double d) {
        this.x = (float)d;
        return this;
    }

    public IVec2f y(double d) {
        this.y = (float)d;
        return this;
    }

    public IVec2f x(float f) {
        this.x = f;
        return this;
    }

    public IVec2f y(float f) {
        this.y = f;
        return this;
    }

    public IVec2f x(IDoubleI iDoubleI) {
        this.x = (float)iDoubleI.x();
        return this;
    }

    public IVec2f y(IDoubleI iDoubleI) {
        this.y = (float)iDoubleI.x();
        return this;
    }

    public double x(ISwitchE iSwitchE) {
        return this.x();
    }

    public double y(ISwitchE iSwitchE) {
        return this.y();
    }

    public IDouble x(ISwitchR iSwitchR) {
        return new IDouble(this.x);
    }

    public IDouble y(ISwitchR iSwitchR) {
        return new IDouble(this.y);
    }

    public IVec2 get() {
        return new IVec2(this.x, this.y);
    }

    public IVec2f dup() {
        return new IVec2f(this);
    }

    public IVec to3d() {
        return new IVec(this);
    }

    public IVec to3d(double d) {
        return new IVec(this.x, (double)this.y, d);
    }

    public IVec to3d(IDoubleI iDoubleI) {
        return new IVec(this.x, (double)this.y, iDoubleI.x());
    }

    public IVec4 to4d() {
        return new IVec4(this.x, (double)this.y, 0.0);
    }

    public IVec4 to4d(double d, double d2) {
        return new IVec4(this.x, (double)this.y, d, d2);
    }

    public IVec4 to4d(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec4(this.x, (double)this.y, iDoubleI.x(), iDoubleI2.x());
    }

    public IDouble getX() {
        return new IDouble(this.x);
    }

    public IDouble getY() {
        return new IDouble(this.y);
    }

    public IVec2f set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public IVec2f set(double d, double d2) {
        this.x = (float)d;
        this.y = (float)d2;
        return this;
    }

    public IVec2f set(IVec2f iVec2f) {
        this.x = iVec2f.x;
        this.y = iVec2f.y;
        return this;
    }

    public IVec2f set(IVec2 iVec2) {
        this.x = (float)iVec2.x;
        this.y = (float)iVec2.y;
        return this;
    }

    public IVec2f set(IVec2I iVec2I) {
        return this.set(iVec2I.get());
    }

    public IVec2f set(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = (float)iDoubleI.x();
        this.y = (float)iDoubleI2.x();
        return this;
    }

    public IVec2f add(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public IVec2f add(double d, double d2) {
        this.x = (float)((double)this.x + d);
        this.y = (float)((double)this.y + d2);
        return this;
    }

    public IVec2f add(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = (float)((double)this.x + iDoubleI.x());
        this.y = (float)((double)this.y + iDoubleI2.x());
        return this;
    }

    public IVec2f add(IVec2f iVec2f) {
        this.x += iVec2f.x;
        this.y += iVec2f.y;
        return this;
    }

    public IVec2f add(IVec2 iVec2) {
        this.x = (float)((double)this.x + iVec2.x);
        this.y = (float)((double)this.y + iVec2.y);
        return this;
    }

    public IVec2f add(IVec2I iVec2I) {
        return this.add(iVec2I.get());
    }

    public IVec2f sub(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        return this;
    }

    public IVec2f sub(double d, double d2) {
        this.x = (float)((double)this.x - d);
        this.y = (float)((double)this.y - d2);
        return this;
    }

    public IVec2f sub(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = (float)((double)this.x - iDoubleI.x());
        this.y = (float)((double)this.y - iDoubleI2.x());
        return this;
    }

    public IVec2f sub(IVec2f iVec2f) {
        this.x -= iVec2f.x;
        this.y -= iVec2f.y;
        return this;
    }

    public IVec2f sub(IVec2 iVec2) {
        this.x = (float)((double)this.x - iVec2.x);
        this.y = (float)((double)this.y - iVec2.y);
        return this;
    }

    public IVec2f sub(IVec2I iVec2I) {
        return this.sub(iVec2I.get());
    }

    public IVec2f mul(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public IVec2f mul(double d) {
        this.x = (float)((double)this.x * d);
        this.y = (float)((double)this.y * d);
        return this;
    }

    public IVec2f mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    public IVec2f div(float f) {
        this.x /= f;
        this.y /= f;
        return this;
    }

    public IVec2f div(double d) {
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
        return this;
    }

    public IVec2f div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    public IVec2f neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public IVec2f rev() {
        return this.neg();
    }

    public IVec2f flip() {
        return this.neg();
    }

    public IVec2f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    public IVec2f add(IVec2f iVec2f, float f) {
        this.x += iVec2f.x * f;
        this.y += iVec2f.y * f;
        return this;
    }

    public IVec2f add(IVec2I iVec2I, double d) {
        return this.add((IVec2I)iVec2I.get(), d);
    }

    public IVec2f add(IVec2I iVec2I, IDoubleI iDoubleI) {
        this.add((IVec2I)iVec2I.get(), iDoubleI.x());
        return this;
    }

    public IVec2f add(float f, IVec2f iVec2f) {
        return this.add(iVec2f, f);
    }

    public IVec2f add(double d, IVec2I iVec2I) {
        return this.add(iVec2I, d);
    }

    public IVec2f add(IDoubleI iDoubleI, IVec2I iVec2I) {
        return this.add(iVec2I, iDoubleI);
    }

    public float dot(IVec2f iVec2f) {
        return this.x * iVec2f.x + this.y * iVec2f.y;
    }

    public double dot(IVec2 iVec2) {
        return (double)this.x * iVec2.x + (double)this.y * iVec2.y;
    }

    public double dot(double d, double d2) {
        return (double)this.x * d + (double)this.y * d2;
    }

    public float dot(float f, float f2) {
        return this.x * f + this.y * f2;
    }

    public double dot(IVec2I iVec2I) {
        return this.dot(iVec2I.get());
    }

    public double dot(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dot(iVec2I);
    }

    public IDouble dot(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dot(iVec2I));
    }

    public IVec cross(IVec2f iVec2f) {
        return new IVec(0.0, 0.0, (double)(this.x * iVec2f.y - this.y * iVec2f.x));
    }

    public IVec cross(IVec2 iVec2) {
        return new IVec(0.0, 0.0, (double)this.x * iVec2.y - (double)this.y * iVec2.x);
    }

    public IVec cross(IVec2I iVec2I) {
        return this.cross(iVec2I.get());
    }

    public IVec cross(double d, double d2) {
        return new IVec(0.0, 0.0, (double)this.x * d2 - (double)this.y * d);
    }

    public IVec cross(float f, float f2) {
        return new IVec(0.0, 0.0, (double)(this.x * f2 - this.y * f));
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    public double len2() {
        return this.x * this.x + this.y * this.y;
    }

    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return new IDouble(this.len2());
    }

    public IVec2f len(IDoubleI iDoubleI) {
        return this.len(iDoubleI.x());
    }

    public IVec2f len(double d) {
        this.x = (float)((double)this.x * (d /= this.len()));
        this.y = (float)((double)this.y * d);
        return this;
    }

    public IVec2f len(float f) {
        f = (float)((double)f / this.len());
        this.x *= f;
        this.y *= f;
        return this;
    }

    public IVec2f unit() {
        double d = this.len();
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
        return this;
    }

    public IVec2f ortho() {
        float f = this.x;
        this.x = -this.y;
        this.y = f;
        return this;
    }

    public double dist(IVec2I iVec2I) {
        return this.dist(iVec2I.get());
    }

    public double dist(IVec2 iVec2) {
        return Math.sqrt(((double)this.x - iVec2.x) * ((double)this.x - iVec2.x) + ((double)this.y - iVec2.y) * ((double)this.y - iVec2.y));
    }

    public double dist(IVec2f iVec2f) {
        return Math.sqrt((this.x - iVec2f.x) * (this.x - iVec2f.x) + (this.y - iVec2f.y) * (this.y - iVec2f.y));
    }

    public double dist(double d, double d2) {
        return Math.sqrt(((double)this.x - d) * ((double)this.x - d) + ((double)this.y - d2) * ((double)this.y - d2));
    }

    public double dist(float f, float f2) {
        return Math.sqrt((this.x - f) * (this.x - f) + (this.y - f2) * (this.y - f2));
    }

    public double dist(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist(iVec2I);
    }

    public IDouble dist(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist(iVec2I));
    }

    public double dist2(IVec2I iVec2I) {
        return this.dist2(iVec2I.get());
    }

    public double dist2(IVec2 iVec2) {
        return ((double)this.x - iVec2.x) * ((double)this.x - iVec2.x) + ((double)this.y - iVec2.y) * ((double)this.y - iVec2.y);
    }

    public float dist2(IVec2f iVec2f) {
        return (this.x - iVec2f.x) * (this.x - iVec2f.x) + (this.y - iVec2f.y) * (this.y - iVec2f.y);
    }

    public double dist2(double d, double d2) {
        return ((double)this.x - d) * ((double)this.x - d) + ((double)this.y - d2) * ((double)this.y - d2);
    }

    public float dist2(float f, float f2) {
        return (this.x - f) * (this.x - f) + (this.y - f2) * (this.y - f2);
    }

    public double dist2(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist2(iVec2I);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist2(iVec2I));
    }

    public boolean eq(IVec2I iVec2I) {
        return this.eq(iVec2I.get(), IConfig.tolerance);
    }

    public boolean eq(IVec2 iVec2) {
        return this.eq(iVec2, IConfig.tolerance);
    }

    public boolean eq(IVec2f iVec2f) {
        return this.eq(iVec2f, IConfig.tolerance);
    }

    public boolean eq(double d, double d2) {
        return this.eq(d, d2, IConfig.tolerance);
    }

    public boolean eq(float f, float f2) {
        return this.eq(f, f2, IConfig.tolerance);
    }

    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eq(iVec2I);
    }

    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eq(iVec2I));
    }

    public boolean eq(IVec2I iVec2I, double d) {
        return this.eq(iVec2I.get(), d);
    }

    public boolean eq(IVec2 iVec2, double d) {
        return this.dist2(iVec2) <= d * d;
    }

    public boolean eq(IVec2f iVec2f, double d) {
        return (double)this.dist2(iVec2f) <= d * d;
    }

    public boolean eq(double d, double d2, double d3) {
        return this.dist2(d, d2) <= d3 * d3;
    }

    public boolean eq(float f, float f2, double d) {
        return (double)this.dist2(f, f2) <= d * d;
    }

    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eq(iVec2I, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eq(iVec2I, iDoubleI.x()));
    }

    public boolean eqX(IVec2f iVec2f) {
        return this.eqX(iVec2f, IConfig.tolerance);
    }

    public boolean eqY(IVec2f iVec2f) {
        return this.eqY(iVec2f, IConfig.tolerance);
    }

    public boolean eqX(IVec2 iVec2) {
        return this.eqX(iVec2, IConfig.tolerance);
    }

    public boolean eqY(IVec2 iVec2) {
        return this.eqY(iVec2, IConfig.tolerance);
    }

    public boolean eqX(double d) {
        return this.eqX(d, IConfig.tolerance);
    }

    public boolean eqY(double d) {
        return this.eqY(d, IConfig.tolerance);
    }

    public boolean eqX(float f) {
        return this.eqX(f, IConfig.tolerance);
    }

    public boolean eqY(float f) {
        return this.eqY(f, IConfig.tolerance);
    }

    public boolean eqX(IVec2I iVec2I) {
        return this.eqX(iVec2I.get(), IConfig.tolerance);
    }

    public boolean eqY(IVec2I iVec2I) {
        return this.eqY(iVec2I.get(), IConfig.tolerance);
    }

    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqX(iVec2I);
    }

    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqY(iVec2I);
    }

    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqX(iVec2I));
    }

    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqY(iVec2I));
    }

    public boolean eqX(IVec2f iVec2f, double d) {
        return (double)Math.abs(this.x - iVec2f.x) <= d;
    }

    public boolean eqY(IVec2f iVec2f, double d) {
        return (double)Math.abs(this.y - iVec2f.y) <= d;
    }

    public boolean eqX(IVec2 iVec2, double d) {
        return Math.abs((double)this.x - iVec2.x) <= d;
    }

    public boolean eqY(IVec2 iVec2, double d) {
        return Math.abs((double)this.y - iVec2.y) <= d;
    }

    public boolean eqX(double d, double d2) {
        return Math.abs((double)this.x - d) <= d2;
    }

    public boolean eqY(double d, double d2) {
        return Math.abs((double)this.y - d) <= d2;
    }

    public boolean eqX(float f, double d) {
        return (double)Math.abs(this.x - f) <= d;
    }

    public boolean eqY(float f, double d) {
        return (double)Math.abs(this.y - f) <= d;
    }

    public boolean eqX(IVec2I iVec2I, double d) {
        return Math.abs((double)this.x - iVec2I.x()) <= d;
    }

    public boolean eqY(IVec2I iVec2I, double d) {
        return Math.abs((double)this.y - iVec2I.y()) <= d;
    }

    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqX(iVec2I, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqY(iVec2I, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqX(iVec2I, iDoubleI.x()));
    }

    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqY(iVec2I, iDoubleI.x()));
    }

    public double angle(IVec2 iVec2) {
        double d = (double)this.x * iVec2.x + (double)this.y * iVec2.y;
        double d2 = this.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = iVec2.len();
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = (double)this.x * iVec2.y - (double)this.y * iVec2.x;
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = d / (d2 * d3);
        if (d5 > 1.0) {
            d5 = 1.0;
        } else if (d5 < -1.0) {
            d5 = -1.0;
        }
        double d6 = Math.acos(d5);
        if (d4 < 0.0) {
            return -d6;
        }
        return d6;
    }

    public float angle(IVec2f iVec2f) {
        float f = this.x * iVec2f.x + this.y * iVec2f.y;
        float f2 = (float)this.len();
        if (f2 == 0.0f) {
            return 0.0f;
        }
        float f3 = (float)iVec2f.len();
        if (f3 == 0.0f) {
            return 0.0f;
        }
        float f4 = this.x * iVec2f.y - this.y * iVec2f.x;
        if (f4 == 0.0f) {
            return 0.0f;
        }
        float f5 = f / (f2 * f3);
        if ((double)f5 > 1.0) {
            f5 = 1.0f;
        } else if ((double)f5 < -1.0) {
            f5 = -1.0f;
        }
        float f6 = (float)Math.acos(f5);
        if (f4 < 0.0f) {
            return -f6;
        }
        return f6;
    }

    public double angle(double d, double d2) {
        double d3 = (double)this.x * d + (double)this.y * d2;
        double d4 = this.len();
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = Math.sqrt(d * d + d2 * d2);
        if (d5 == 0.0) {
            return 0.0;
        }
        double d6 = (double)this.x * d2 - (double)this.y * d;
        if (d6 == 0.0) {
            return 0.0;
        }
        double d7 = d3 / (d4 * d5);
        if (d7 > 1.0) {
            d7 = 1.0;
        } else if (d7 < -1.0) {
            d7 = -1.0;
        }
        double d8 = Math.acos(d7);
        if (d6 < 0.0) {
            return -d8;
        }
        return d8;
    }

    public float angle(float f, float f2) {
        float f3 = this.x * f + this.y * f2;
        float f4 = (float)this.len();
        if (f4 == 0.0f) {
            return 0.0f;
        }
        float f5 = (float)Math.sqrt(f * f + f2 * f2);
        if (f5 == 0.0f) {
            return 0.0f;
        }
        float f6 = this.x * f2 - this.y * f;
        if (f6 == 0.0f) {
            return 0.0f;
        }
        float f7 = f3 / (f4 * f5);
        if ((double)f7 > 1.0) {
            f7 = 1.0f;
        } else if ((double)f7 < -1.0) {
            f7 = -1.0f;
        }
        float f8 = (float)Math.acos(f7);
        if (f6 < 0.0f) {
            return -f8;
        }
        return f8;
    }

    public double angle(IVec2I iVec2I) {
        return this.angle(iVec2I.get());
    }

    public double angle(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.angle(iVec2I);
    }

    public IDouble angle(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.angle(iVec2I));
    }

    public IVec2f rot(double d) {
        float f = this.x;
        this.x = (float)((double)this.x * Math.cos(d) - (double)this.y * Math.sin(d));
        this.y = (float)((double)f * Math.sin(d) + (double)this.y * Math.cos(d));
        return this;
    }

    public IVec2f rot(float f) {
        float f2 = this.x;
        this.x = this.x * (float)Math.cos(f) - this.y * (float)Math.sin(f);
        this.y = f2 * (float)Math.sin(f) + this.y * (float)Math.cos(f);
        return this;
    }

    public IVec2f rot(IDoubleI iDoubleI) {
        return this.rot(iDoubleI.x());
    }

    public IVec2f rot(IVec2f iVec2f, double d) {
        if (iVec2f == this) {
            return this;
        }
        return this.sub(iVec2f).rot(d).add(iVec2f);
    }

    public IVec2f rot(IVec2 iVec2, double d) {
        return this.sub(iVec2).rot(d).add(iVec2);
    }

    public IVec2f rot(double d, double d2, double d3) {
        return this.sub(d, d2).rot(d3).add(d, d2);
    }

    public IVec2f rot(float f, float f2, float f3) {
        return this.sub(f, f2).rot(f3).add(f, f2);
    }

    public IVec2f rot(IVec2I iVec2I, double d) {
        return this.rot(iVec2I.get(), d);
    }

    public IVec2f rot(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.rot(iVec2I.get(), iDoubleI.x());
    }

    public IVec2f rot(IVec2f iVec2f) {
        return this.rot(this.angle(iVec2f));
    }

    public IVec2f rot(IVec2 iVec2) {
        return this.rot(this.angle(iVec2));
    }

    public IVec2f rot(IVec2I iVec2I) {
        return this.rot(iVec2I.get());
    }

    public IVec2f rot(IVec2f iVec2f, IVec2f iVec2f2) {
        if (iVec2f == this) {
            return this;
        }
        return this.sub(iVec2f).rot(iVec2f2.diff(iVec2f)).add(iVec2f);
    }

    public IVec2f rot(IVec2 iVec2, IVec2 iVec22) {
        return this.sub(iVec2).rot(iVec22.diff(iVec2)).add(iVec2);
    }

    public IVec2f rot(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.rot(iVec2I.get(), iVec2I2.get());
    }

    public IVec2f scale(double d) {
        return this.mul(d);
    }

    public IVec2f scale(float f) {
        return this.mul(f);
    }

    public IVec2f scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVec2f scale(IVec2f iVec2f, double d) {
        if (iVec2f == this) {
            return this;
        }
        return this.sub(iVec2f).mul(d).add(iVec2f);
    }

    public IVec2f scale(IVec2 iVec2, double d) {
        return this.sub(iVec2).mul(d).add(iVec2);
    }

    public IVec2f scale(IVec2I iVec2I, double d) {
        return this.scale(iVec2I.get(), d);
    }

    public IVec2f scale(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.scale(iVec2I.get(), iDoubleI.x());
    }

    public IVec2f scale(double d, double d2, double d3) {
        return this.sub(d, d2).mul(d3).add(d, d2);
    }

    public IVec2f scale(float f, float f2, float f3) {
        return this.sub(f, f2).mul(f3).add(f, f2);
    }

    public IVec2f ref(IVec2f iVec2f) {
        return this.rev().add(iVec2f.dup().mul((double)this.dot(iVec2f) / iVec2f.len2() * -2.0));
    }

    public IVec2f ref(IVec2 iVec2) {
        return this.rev().add(iVec2.dup().mul(this.dot(iVec2) / iVec2.len2() * -2.0));
    }

    public IVec2f ref(double d, double d2) {
        double d3 = this.dot(d, d2) / (d * d + d2 * d2) * -2.0;
        this.x = -this.x + (float)(d * d3);
        this.y = -this.y + (float)(d2 * d3);
        return this;
    }

    public IVec2f ref(float f, float f2) {
        float f3 = this.dot(f, f2) / (f * f + f2 * f2) * -2.0f;
        this.x = -this.x + f * f3;
        this.y = -this.y + f2 * f3;
        return this;
    }

    public IVec2f ref(IVec2I iVec2I) {
        return this.ref(iVec2I.get());
    }

    public IVec2f ref(IVec2f iVec2f, IVec2 iVec2) {
        if (iVec2f == this) {
            return this;
        }
        return this.sub(iVec2f).ref(iVec2).add(iVec2f);
    }

    public IVec2f ref(IVec2 iVec2, IVec2 iVec22) {
        return this.sub(iVec2).ref(iVec22).add(iVec2);
    }

    public IVec2f ref(double d, double d2, double d3, double d4) {
        return this.sub(d, d2).ref(d3, d4).add(d, d2);
    }

    public IVec2f ref(float f, float f2, float f3, float f4) {
        return this.sub(f, f2).ref(f3, f4).add(f, f2);
    }

    public IVec2f ref(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.ref(iVec2I.get(), iVec2I2.get());
    }

    public IVec2f mirror(IVec2f iVec2f) {
        return this.ref(iVec2f);
    }

    public IVec2f mirror(IVec2 iVec2) {
        return this.ref(iVec2);
    }

    public IVec2f mirror(IVec2I iVec2I) {
        return this.ref(iVec2I.get());
    }

    public IVec2f mirror(double d, double d2) {
        return this.ref(d, d2);
    }

    public IVec2f mirror(float f, float f2) {
        return this.ref(f, f2);
    }

    public IVec2f mirror(IVec2f iVec2f, IVec2 iVec2) {
        return this.ref(iVec2f, iVec2);
    }

    public IVec2f mirror(IVec2 iVec2, IVec2 iVec22) {
        return this.ref(iVec2, iVec22);
    }

    public IVec2f mirror(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.ref(iVec2I.get(), iVec2I2.get());
    }

    public IVec2f mirror(double d, double d2, double d3, double d4) {
        return this.ref(d, d2, d3, d4);
    }

    public IVec2f mirror(float f, float f2, float f3, float f4) {
        return this.ref(f, f2, f3, f4);
    }

    public IVec2f transform(IVec2f iVec2f, IVec2f iVec2f2) {
        float f = iVec2f.x * this.x + iVec2f2.x * this.y;
        float f2 = iVec2f.y * this.x + iVec2f2.y * this.y;
        this.x = f;
        this.y = f2;
        return this;
    }

    public IVec2f transform(IVec2 iVec2, IVec2 iVec22) {
        double d = iVec2.x * (double)this.x + iVec22.x * (double)this.y;
        double d2 = iVec2.y * (double)this.x + iVec22.y * (double)this.y;
        this.x = (float)d;
        this.y = (float)d2;
        return this;
    }

    public IVec2f transform(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.transform(iVec2I.get(), iVec2I2.get());
    }

    public IVec2f transform(IVec2f iVec2f, IVec2f iVec2f2, IVec2f iVec2f3) {
        return this.transform(iVec2f, iVec2f2).add(iVec2f3);
    }

    public IVec2f transform(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return this.transform(iVec2, iVec22).add(iVec23);
    }

    public IVec2f transform(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3) {
        return this.transform(iVec2I.get(), iVec2I2.get(), iVec2I3.get());
    }

    public IVec2f dif(IVec2I iVec2I) {
        return this.dup().sub(iVec2I);
    }

    public IVec2f dif(IVec2f iVec2f) {
        return new IVec2f(this.x - iVec2f.x, this.y - iVec2f.y);
    }

    public IVec2f dif(double d, double d2) {
        return new IVec2f((double)this.x - d, (double)this.y - d2);
    }

    public IVec2f dif(float f, float f2) {
        return new IVec2f(this.x - f, this.y - f2);
    }

    public IVec2f diff(IVec2I iVec2I) {
        return this.dif(iVec2I);
    }

    public IVec2f diff(IVec2f iVec2f) {
        return this.dif(iVec2f);
    }

    public IVec2f diff(double d, double d2) {
        return this.dif(d, d2);
    }

    public IVec2f diff(float f, float f2) {
        return this.dif(f, f2);
    }

    public IVec2f mid(IVec2I iVec2I) {
        return this.dup().add(iVec2I).div(2.0f);
    }

    public IVec2f mid(IVec2f iVec2f) {
        return new IVec2f((this.x + iVec2f.x) / 2.0f, (this.y + iVec2f.y) / 2.0f);
    }

    public IVec2f mid(double d, double d2) {
        return new IVec2f(((double)this.x + d) / 2.0, ((double)this.y + d2) / 2.0);
    }

    public IVec2f mid(float f, float f2) {
        return new IVec2f((this.x + f) / 2.0f, (this.y + f2) / 2.0f);
    }

    public IVec2f sum(IVec2I iVec2I) {
        return this.dup().add(iVec2I);
    }

    public IVec2f sum(IVec2f iVec2f) {
        return new IVec2f(this.x + iVec2f.x, this.y + iVec2f.y);
    }

    public IVec2f sum(double d, double d2) {
        return new IVec2f((double)this.x + d, (double)this.y + d2);
    }

    public IVec2f sum(float f, float f2) {
        return new IVec2f(this.x + f, this.y + f2);
    }

    public IVec2f sum(IVec2I ... iVec2IArray) {
        IVec2f iVec2f = this.dup();
        for (IVec2I iVec2I : iVec2IArray) {
            iVec2f.add(iVec2I);
        }
        return iVec2f;
    }

    public IVec2f bisect(IVec2f iVec2f) {
        return this.dup().unit().add(iVec2f.dup().unit());
    }

    public IVec2f bisect(IVec2 iVec2) {
        return this.dup().unit().add(iVec2.dup().unit());
    }

    public IVec2f bisect(IVec2I iVec2I) {
        return this.bisect(iVec2I.get());
    }

    public IVec2f bisect(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2);
        return this.dup().unit().add(d / d3, d2 / d3);
    }

    public IVec2f sum(IVec2f iVec2f, double d, double d2) {
        return this.dup().mul(d).add((IVec2I)iVec2f, d2);
    }

    public IVec2f sum(IVec2 iVec2, double d, double d2) {
        return this.dup().mul(d).add((IVec2I)iVec2, d2);
    }

    public IVec2f sum(IVec2I iVec2I, double d, double d2) {
        return this.sum(iVec2I.get(), d, d2);
    }

    public IVec2f sum(IVec2I iVec2I, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVec2I.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec2f sum(IVec2f iVec2f, double d) {
        return this.dup().mul(1.0 - d).add((IVec2I)iVec2f, d);
    }

    public IVec2f sum(IVec2 iVec2, double d) {
        return this.dup().mul(1.0 - d).add((IVec2I)iVec2, d);
    }

    public IVec2f sum(IVec2I iVec2I, double d) {
        return this.sum(iVec2I.get(), d);
    }

    public IVec2f sum(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.sum((IVec2I)iVec2I.get(), iDoubleI.get());
    }

    public IVec nml(IVec2I iVec2I) {
        return this.cross(iVec2I);
    }

    public IVec nml(double d, double d2) {
        return this.cross(d, d2);
    }

    public IVec nml(float f, float f2) {
        return this.cross(f, f2);
    }

    public IVec nml(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.dif(iVec2I).cross(this.dif(iVec2I2));
    }

    public IVec nml(double d, double d2, double d3, double d4) {
        return this.dif(d, d2).cross(this.dif(d3, d4));
    }

    public IVec nml(float f, float f2, float f3, float f4) {
        return this.dif(f, f2).cross(this.dif(f3, f4));
    }

    public boolean isValid() {
        if (!IDouble.isValid(this.x)) {
            IOut.err("invalid x (" + this.x + ")");
            return false;
        }
        if (!IDouble.isValid(this.y)) {
            IOut.err("invalid y (" + this.y + ")");
            return false;
        }
        return true;
    }
}

