/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBrep;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveR;
import igeo.IMesh;
import igeo.IMeshR;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IServer;
import igeo.ISurface;
import igeo.ISurfaceR;
import igeo.IVec;
import igeo.IVectorObject;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBoundingBox {
    public IVec min = null;
    public IVec max = null;

    public void setObjects(IServer iServer) {
        this.setObjects(iServer.getAllObjects());
    }

    public void compare(IVec iVec) {
        if (iVec == null || !iVec.isValid()) {
            return;
        }
        if (this.min == null || this.max == null) {
            this.init(iVec);
            return;
        }
        if (iVec.x < this.min.x) {
            this.min.x = iVec.x;
        } else if (iVec.x > this.max.x) {
            this.max.x = iVec.x;
        }
        if (iVec.y < this.min.y) {
            this.min.y = iVec.y;
        } else if (iVec.y > this.max.y) {
            this.max.y = iVec.y;
        }
        if (iVec.z < this.min.z) {
            this.min.z = iVec.z;
        } else if (iVec.z > this.max.z) {
            this.max.z = iVec.z;
        }
    }

    public void init(IVec iVec) {
        this.min = new IVec(iVec);
        this.max = new IVec(iVec);
    }

    public void initBox() {
        this.max = null;
        this.min = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setObjects(ArrayList<IObject> arrayList) {
        if (arrayList.size() > 1000) {
            IOut.debug(10, "calculating bounding box of " + arrayList.size() + " objects");
        }
        this.initBox();
        Object object = arrayList;
        synchronized (object) {
            int n = 0;
            while (true) {
                block19: {
                    int n2;
                    int n3;
                    IObject iObject;
                    block31: {
                        block27: {
                            block25: {
                                block18: {
                                    IObject iObject2;
                                    block30: {
                                        block29: {
                                            block28: {
                                                block26: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                block21: {
                                                                    block20: {
                                                                        if (n >= arrayList.size()) break block18;
                                                                        iObject2 = arrayList.get(n);
                                                                        if (!iObject2.visible()) break block19;
                                                                        if (!(iObject2 instanceof IPoint)) break block20;
                                                                        iObject = (IPoint)iObject2;
                                                                        this.compare(((IPoint)iObject).get());
                                                                        break block19;
                                                                    }
                                                                    if (!(iObject2 instanceof IPointR)) break block21;
                                                                    iObject = (IPointR)iObject2;
                                                                    this.compare(((IPointR)iObject).get());
                                                                    break block19;
                                                                }
                                                                if (!(iObject2 instanceof ICurve)) break block22;
                                                                iObject = (ICurve)iObject2;
                                                                for (n3 = 0; n3 < ((ICurve)iObject).num(); ++n3) {
                                                                    this.compare(((ICurve)iObject).cp(n3).get());
                                                                }
                                                                break block19;
                                                            }
                                                            if (!(iObject2 instanceof ICurveR)) break block23;
                                                            iObject = (ICurveR)iObject2;
                                                            for (n3 = 0; n3 < ((ICurveR)iObject).num(); ++n3) {
                                                                this.compare(((ICurveR)iObject).cp(n3).get());
                                                            }
                                                            break block19;
                                                        }
                                                        if (!(iObject2 instanceof ISurface)) break block24;
                                                        iObject = (ISurface)iObject2;
                                                        break block25;
                                                    }
                                                    if (!(iObject2 instanceof ISurfaceR)) break block26;
                                                    iObject = (ISurfaceR)iObject2;
                                                    break block27;
                                                }
                                                if (!(iObject2 instanceof IMesh)) break block28;
                                                iObject = (IMesh)iObject2;
                                                for (n3 = 0; n3 < ((IMesh)iObject).vertexNum(); ++n3) {
                                                    this.compare(((IMesh)iObject).vertex(n3).get());
                                                }
                                                break block19;
                                            }
                                            if (!(iObject2 instanceof IMeshR)) break block29;
                                            iObject = (IMeshR)iObject2;
                                            for (n3 = 0; n3 < ((IMeshR)iObject).vertexNum(); ++n3) {
                                                this.compare(((IMeshR)iObject).vertex(n3).get());
                                            }
                                            break block19;
                                        }
                                        if (!(iObject2 instanceof IBrep)) break block30;
                                        iObject = (IBrep)iObject2;
                                        break block31;
                                    }
                                    if (iObject2 instanceof IVectorObject) {
                                        iObject = (IVectorObject)iObject2;
                                        this.compare(((IVectorObject)iObject).vec.get());
                                        this.compare(((IVectorObject)iObject).root.get());
                                    }
                                    break block19;
                                }
                                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl58 : MonitorExitStatement: MONITOREXIT : var2_2
                                if (this.min != null && this.max != null && this.min.eq(this.max, IConfig.minimumBoundingBox)) {
                                    IOut.err("bounding box is too small. minimum size is set");
                                    object = new IVec(IConfig.minimumBoundingBox, IConfig.minimumBoundingBox, IConfig.minimumBoundingBox);
                                    ((IVec)object).div(2.0);
                                    this.max.set(this.min).add((IVec)object);
                                    this.min.sub((IVec)object);
                                }
                                if (arrayList.size() > 1000) {
                                    IOut.debug(10, "calculation of bounding box completed");
                                }
                                IOut.debug(100, this);
                                return;
                            }
                            for (n3 = 0; n3 < ((ISurface)iObject).unum(); ++n3) {
                                for (n2 = 0; n2 < ((ISurface)iObject).vnum(); ++n2) {
                                    this.compare(((ISurface)iObject).cp(n3, n2).get());
                                }
                            }
                            break block19;
                        }
                        for (n3 = 0; n3 < ((ISurfaceR)iObject).unum(); ++n3) {
                            for (n2 = 0; n2 < ((ISurfaceR)iObject).vnum(); ++n2) {
                                this.compare(((ISurfaceR)iObject).cp(n3, n2).get());
                            }
                        }
                        break block19;
                    }
                    for (n3 = 0; n3 < ((IBrep)iObject).surfaces.length; ++n3) {
                        for (n2 = 0; n2 < ((IBrep)iObject).surfaces[n3].unum(); ++n2) {
                            for (int i = 0; i < ((IBrep)iObject).surfaces[n3].vnum(); ++i) {
                                this.compare(((IBrep)iObject).surfaces[n3].cp(n2, i).get());
                            }
                        }
                    }
                }
                ++n;
            }
        }
    }

    public String toString() {
        String string = "null";
        if (this.min != null) {
            string = this.min.toString();
        }
        String string2 = "null";
        if (this.max != null) {
            string2 = this.max.toString();
        }
        return string + "-" + string2;
    }
}

