/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAgent;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IParticleAgent;
import igeo.IVec;
import igeo.IVecI;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBoid
extends IParticleAgent {
    public double cohesionDist = 100.0;
    public double cohesionRatio = 5.0;
    public double cohesionLimit = -1.0;
    public double separationDist = 50.0;
    public double separationRatio = 5.0;
    public double separationLimit = -1.0;
    public double alignmentDist = 20.0;
    public double alignmentRatio = 5.0;
    public double alignmentLimit = -1.0;
    IVec cohesionForce = new IVec();
    IVec separationForce = new IVec();
    IVec alignmentForce = new IVec();

    public IBoid() {
        this.initBoid();
    }

    public IBoid(IVecI iVecI) {
        super(iVecI);
        this.initBoid();
    }

    public IBoid(IVec iVec) {
        super(iVec);
        this.initBoid();
    }

    public IBoid(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
        this.initBoid();
    }

    public IBoid(IVec iVec, IVec iVec2) {
        super(iVec, iVec2);
        this.initBoid();
    }

    public IBoid(double d, double d2, double d3) {
        super(d, d2, d3);
        this.initBoid();
    }

    public IBoid(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
        this.initBoid();
    }

    public IBoid(IBoid iBoid) {
        super(iBoid);
        this.cohesionDist = iBoid.cohesionDist;
        this.cohesionRatio = iBoid.cohesionRatio;
        this.cohesionLimit = iBoid.cohesionLimit;
        this.separationDist = iBoid.separationDist;
        this.separationRatio = iBoid.separationRatio;
        this.separationLimit = iBoid.separationLimit;
        this.alignmentDist = iBoid.alignmentDist;
        this.alignmentRatio = iBoid.alignmentRatio;
        this.alignmentLimit = iBoid.alignmentLimit;
        this.initBoid();
    }

    public void initBoid() {
        this.cohesionForce = new IVec();
        this.separationForce = new IVec();
        this.alignmentForce = new IVec();
    }

    public double cohDist() {
        return this.cohesionDist;
    }

    public double cohesionDist() {
        return this.cohDist();
    }

    public IBoid cohDist(double d) {
        this.cohesionDist = d;
        return this;
    }

    public IBoid cohesionDist(double d) {
        return this.cohDist(d);
    }

    public double cohRatio() {
        return this.cohesionRatio;
    }

    public double cohesionRatio() {
        return this.cohRatio();
    }

    public IBoid cohRatio(double d) {
        this.cohesionRatio = d;
        return this;
    }

    public IBoid cohesionRatio(double d) {
        return this.cohRatio(d);
    }

    public double cohLimit() {
        return this.cohesionLimit;
    }

    public double cohesionLimit() {
        return this.cohLimit();
    }

    public IBoid cohLimit(double d) {
        this.cohesionLimit = d;
        return this;
    }

    public IBoid cohesionLimit(double d) {
        return this.cohLimit(d);
    }

    public double sepDist() {
        return this.separationDist;
    }

    public double separationDist() {
        return this.sepDist();
    }

    public IBoid sepDist(double d) {
        this.separationDist = d;
        return this;
    }

    public IBoid separationDist(double d) {
        return this.sepDist(d);
    }

    public double sepRatio() {
        return this.separationRatio;
    }

    public double separationRatio() {
        return this.sepRatio();
    }

    public IBoid sepRatio(double d) {
        this.separationRatio = d;
        return this;
    }

    public IBoid separationRatio(double d) {
        return this.sepRatio(d);
    }

    public double sepLimit() {
        return this.separationLimit;
    }

    public double separationLimit() {
        return this.sepLimit();
    }

    public IBoid sepLimit(double d) {
        this.separationLimit = d;
        return this;
    }

    public IBoid separationLimit(double d) {
        return this.sepLimit(d);
    }

    public double aliDist() {
        return this.alignmentDist;
    }

    public double alignmentDist() {
        return this.aliDist();
    }

    public IBoid aliDist(double d) {
        this.alignmentDist = d;
        return this;
    }

    public IBoid alignmentDist(double d) {
        return this.aliDist(d);
    }

    public double aliRatio() {
        return this.alignmentRatio;
    }

    public double alignmentRatio() {
        return this.aliRatio();
    }

    public IBoid aliRatio(double d) {
        this.alignmentRatio = d;
        return this;
    }

    public IBoid alignmentRatio(double d) {
        return this.aliRatio(d);
    }

    public double aliLimit() {
        return this.alignmentLimit;
    }

    public double alignmentLimit() {
        return this.aliLimit();
    }

    public IBoid aliLimit(double d) {
        this.alignmentLimit = d;
        return this;
    }

    public IBoid alignmentLimit(double d) {
        return this.aliLimit(d);
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.cohesionForce.zero();
        this.separationForce.zero();
        this.alignmentForce.zero();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof IBoid) || arrayList.get(n) == this) continue;
            IBoid iBoid = (IBoid)arrayList.get(n);
            IVec iVec = iBoid.pos().dif(this.pos());
            double d = iVec.len();
            if (d < this.cohesionDist) {
                this.cohesionForce.add(iVec);
                ++n2;
            }
            if (d < this.separationDist) {
                if (d == 0.0) {
                    if (this.vel().len() > 0.0) {
                        this.separationForce.add(this.vel().dup().len(this.separationDist));
                    } else {
                        this.separationForce.add(new IVec(this.separationDist, 0.0, 0.0));
                    }
                } else {
                    this.separationForce.add(iVec.len(d - this.separationDist));
                }
                ++n3;
            }
            if (!(d < this.alignmentDist)) continue;
            this.alignmentForce.add(iBoid.vel());
            ++n4;
        }
        if (n2 > 0) {
            this.cohesionForce.mul(this.cohesionRatio / (double)n2);
            if (this.cohesionLimit >= 0.0 && this.cohesionForce.len() > this.cohesionLimit) {
                this.cohesionForce.len(this.cohesionLimit);
            }
            this.push(this.cohesionForce);
        }
        if (n3 > 0) {
            this.separationForce.mul(this.separationRatio / (double)n3);
            if (this.separationLimit >= 0.0 && this.separationForce.len() > this.separationLimit) {
                this.separationForce.len(this.separationLimit);
            }
            this.push(this.separationForce);
        }
        if (n4 > 0) {
            this.alignmentForce.div(n4).sub(this.vel()).mul(this.alignmentRatio);
            if (this.alignmentLimit >= 0.0 && this.alignmentForce.len() > this.alignmentLimit) {
                this.alignmentForce.len(this.alignmentLimit);
            }
            this.push(this.alignmentForce);
        }
        n = 0;
        try {
            n = this.getClass().getMethod("interact", IDynamics.class).getDeclaringClass() != IAgent.class ? 1 : 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (n != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) == this) continue;
                this.interact(arrayList.get(i));
            }
        }
    }

    @Override
    public IBoid fix() {
        super.fix();
        return this;
    }

    @Override
    public IBoid unfix() {
        super.unfix();
        return this;
    }

    @Override
    public IBoid mass(double d) {
        super.mass(d);
        return this;
    }

    @Override
    public IBoid position(IVecI iVecI) {
        super.position(iVecI);
        return this;
    }

    @Override
    public IBoid pos(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public IBoid velocity(IVecI iVecI) {
        super.velocity(iVecI);
        return this;
    }

    @Override
    public IBoid vel(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public IBoid force(IVecI iVecI) {
        super.force(iVecI);
        return this;
    }

    @Override
    public IBoid frc(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public IBoid friction(double d) {
        super.friction(d);
        return this;
    }

    @Override
    public IBoid fric(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public IBoid decay(double d) {
        return this.fric(d);
    }

    @Override
    public IBoid push(IVecI iVecI) {
        super.push(iVecI);
        return this;
    }

    @Override
    public IBoid push(double d, double d2, double d3) {
        super.push(d, d2, d3);
        return this;
    }

    @Override
    public IBoid pull(IVecI iVecI) {
        super.pull(iVecI);
        return this;
    }

    @Override
    public IBoid pull(double d, double d2, double d3) {
        super.pull(d, d2, d3);
        return this;
    }

    @Override
    public IBoid addForce(IVecI iVecI) {
        super.addForce(iVecI);
        return this;
    }

    @Override
    public IBoid addForce(double d, double d2, double d3) {
        super.addForce(d, d2, d3);
        return this;
    }

    @Override
    public IBoid reset() {
        super.reset();
        return this;
    }

    @Override
    public IBoid resetForce() {
        super.resetForce();
        return this;
    }

    @Override
    public IBoid x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IBoid y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IBoid z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IBoid x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IBoid y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IBoid z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IBoid dup() {
        return new IBoid(this);
    }

    @Override
    public IBoid set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IBoid set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IBoid set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IBoid add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IBoid sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IBoid sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IBoid mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IBoid mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IBoid div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IBoid div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IBoid neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IBoid rev() {
        return this.neg();
    }

    @Override
    public IBoid flip() {
        return this.neg();
    }

    @Override
    public IBoid zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IBoid add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IBoid add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid add(double d, IVecI iVecI) {
        this.pos.add(d, iVecI);
        return this;
    }

    @Override
    public IBoid add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iDoubleI, iVecI);
        return this;
    }

    @Override
    public IBoid len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IBoid len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IBoid unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IBoid rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IBoid rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IBoid rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoid rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoid rot2(double d) {
        this.pos.rot2(d);
        return this;
    }

    @Override
    public IBoid rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        return this;
    }

    @Override
    public IBoid rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IBoid rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IBoid rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IBoid rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IBoid scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IBoid scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IBoid scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoid scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IBoid ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoid ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IBoid ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d5, d6, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoid mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IBoid mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoid shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoid shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IBoid shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IBoid shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IBoid shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IBoid translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IBoid transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IBoid transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IBoid transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoid transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IBoid mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IBoid mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoid mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IBoid cp() {
        return this.dup();
    }

    @Override
    public IBoid cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IBoid cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoid cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IBoid setSize(double d) {
        return this.size(d);
    }

    @Override
    public IBoid size(double d) {
        this.point.size(d);
        return this;
    }

    @Override
    public IBoid name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IBoid layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IBoid show() {
        super.show();
        return this;
    }

    @Override
    public IBoid hide() {
        super.hide();
        return this;
    }

    @Override
    public IBoid clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public IBoid clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public IBoid clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IBoid clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IBoid clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IBoid hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IBoid setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public IBoid setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public IBoid setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IBoid setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IBoid setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IBoid setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

