/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IMatrixI;
import igeo.ISwitchE;
import igeo.ISwitchR;

public class IMatrix
implements IMatrixI {
    public double[][] val;
    public int rowNum;
    public int columnNum;

    public IMatrix(int n, int n2) {
        this.rowNum = n;
        this.columnNum = n2;
        this.val = new double[this.rowNum][this.columnNum];
    }

    public IMatrix(IMatrix iMatrix) {
        this.rowNum = iMatrix.rowNum;
        this.columnNum = iMatrix.columnNum;
        this.val = new double[this.rowNum][this.columnNum];
        this.set(iMatrix);
    }

    public IMatrix get() {
        return this;
    }

    public IMatrix dup() {
        return new IMatrix(this);
    }

    public int rowNum() {
        return this.rowNum;
    }

    public int columnNum() {
        return this.columnNum;
    }

    public int rowNum(ISwitchE iSwitchE) {
        return this.rowNum();
    }

    public int columnNum(ISwitchE iSwitchE) {
        return this.columnNum();
    }

    public IInteger rowNum(ISwitchR iSwitchR) {
        return new IInteger(this.rowNum());
    }

    public IInteger columnNum(ISwitchR iSwitchR) {
        return new IInteger(this.columnNum());
    }

    public IMatrix setZero() {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                this.val[i][j] = 0.0;
            }
        }
        return this;
    }

    public IMatrix setId() {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                this.val[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return this;
    }

    public double get(int n, int n2) {
        return this.val[n][n2];
    }

    public double get(ISwitchE iSwitchE, int n, int n2) {
        return this.get(n, n2);
    }

    public IDouble get(ISwitchR iSwitchR, IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return new IDouble(this.get(iIntegerI.x(), iIntegerI2.x()));
    }

    public IMatrix set(double[][] dArray) {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                this.val[i][j] = dArray[i][j];
            }
        }
        return this;
    }

    public IMatrix set(int n, int n2, double d) {
        this.val[n][n2] = d;
        return this;
    }

    public IMatrix set(IIntegerI iIntegerI, IIntegerI iIntegerI2, IDoubleI iDoubleI) {
        return this.set(iIntegerI.x(), iIntegerI2.x(), iDoubleI.x());
    }

    public IMatrix set(IDoubleI[][] iDoubleIArray) {
        double[][] dArray = new double[iDoubleIArray.length][iDoubleIArray[0].length];
        return this.set(dArray);
    }

    public IMatrix set(IMatrix iMatrix) {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                this.val[i][j] = iMatrix.val[i][j];
            }
        }
        return this;
    }

    public IMatrix set(IMatrixI iMatrixI) {
        return this.set(iMatrixI.get());
    }

    public IMatrix setRange(IMatrix iMatrix, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.val[i + n][j + n3] = iMatrix.val[i + n][j + n3];
            }
        }
        return this;
    }

    public IMatrix add(IMatrix iMatrix) {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                double[] dArray = this.val[i];
                int n = j;
                dArray[n] = dArray[n] + iMatrix.val[i][j];
            }
        }
        return this;
    }

    public IMatrix add(IMatrixI iMatrixI) {
        return this.add(iMatrixI.get());
    }

    public IMatrix sub(IMatrix iMatrix) {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                double[] dArray = this.val[i];
                int n = j;
                dArray[n] = dArray[n] - iMatrix.val[i][j];
            }
        }
        return this;
    }

    public IMatrix sub(IMatrixI iMatrixI) {
        return this.sub(iMatrixI.get());
    }

    public IMatrix div(double d) {
        for (int i = 0; i < this.rowNum; ++i) {
            int n = 0;
            while (n < this.columnNum) {
                double[] dArray = this.val[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
        return this;
    }

    public IMatrix div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    public IMatrix mul(double d) {
        for (int i = 0; i < this.rowNum; ++i) {
            int n = 0;
            while (n < this.columnNum) {
                double[] dArray = this.val[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
        return this;
    }

    public IMatrix mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    public IMatrix mul(IMatrix iMatrix) {
        if (this.columnNum != iMatrix.rowNum) {
            return null;
        }
        IMatrix iMatrix2 = new IMatrix(this.rowNum, iMatrix.columnNum);
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < iMatrix.columnNum; ++j) {
                iMatrix2.val[i][j] = 0.0;
                for (int k = 0; k < this.columnNum; ++k) {
                    double[] dArray = iMatrix2.val[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.val[i][k] * iMatrix.val[k][j];
                }
            }
        }
        return iMatrix2;
    }

    public IMatrix mul(IMatrixI iMatrixI) {
        return this.mul(iMatrixI.get());
    }

    public static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public double determinant() {
        return 0.0;
    }

    public double determinant(ISwitchE iSwitchE) {
        return this.determinant();
    }

    public IDouble determinant(ISwitchR iSwitchR) {
        return new IDouble(this.determinant());
    }

    public IMatrix invert() {
        return null;
    }

    public String toString() {
        if (this.val == null) {
            return super.toString();
        }
        String string = new String();
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.columnNum; ++j) {
                string = string + String.valueOf(this.val[i][j]);
                string = j == this.columnNum - 1 ? string + "\n" : string + " ";
            }
        }
        return string;
    }
}

