/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IGraphicObject;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicGL;
import javax.media.opengl.GL;

public class IPointGraphic
extends IGraphicObject {
    public static double defaultSize = 5.0;
    public IVecI pt = null;
    public double size = defaultSize;

    public IPointGraphic(IPoint iPoint) {
        super(iPoint);
        this.initPoint(iPoint.pos);
    }

    public IPointGraphic(IPointR iPointR) {
        super(iPointR);
        this.initPoint(iPointR.pos);
    }

    public void initPoint(IVecI iVecI) {
        this.pt = iVecI;
    }

    public void initPoint() {
        if (this.parent instanceof IPoint) {
            this.pt = ((IPoint)this.parent).pos;
        } else if (this.parent instanceof IPointR) {
            this.pt = ((IPointR)this.parent).pos;
        }
    }

    public void size(double d) {
        this.size = d;
    }

    public double size() {
        return this.size;
    }

    public void draw(IGraphics iGraphics) {
        if (this.pt == null) {
            this.initPoint();
        }
        if (iGraphics.view().mode().isGL()) {
            GL gL = iGraphics.getGL();
            gL.glPointSize((float)this.size);
            float f = defaultRed;
            float f2 = defaultGreen;
            float f3 = defaultBlue;
            float f4 = defaultAlpha;
            if (this.color != null) {
                f = (float)this.color.getRed() / 255.0f;
                f2 = (float)this.color.getGreen() / 255.0f;
                f3 = (float)this.color.getBlue() / 255.0f;
                f4 = (float)this.color.getAlpha() / 255.0f;
            }
            if (iGraphics.view().mode().isTransparent() && iGraphics.view().mode().isTransparentWireframe()) {
                f4 = (float)transparentModeAlpha;
            }
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                float[] fArray = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, fArray, 0);
                gL.glMaterialfv(1032, 4609, fArray, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glDisable(2896);
            }
            gL.glBegin(0);
            gL.glColor4f(f, f2, f3, f4);
            gL.glVertex3d(this.pt.x(), this.pt.y(), this.pt.z());
            gL.glEnd();
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glEnable(2896);
            }
        } else if (iGraphics.view().mode().isJava()) {
            // empty if block
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }
}

