/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IOut;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec4I;
import igeo.IVecI;

public class IVec4
extends IVec
implements IVec4I,
IEntityParameter {
    public double w;

    public IVec4() {
    }

    public IVec4(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public IVec4(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = 1.0;
    }

    public IVec4(IVec4 iVec4) {
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IVec4I iVec4I) {
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IVec iVec, double d) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IVecI iVecI, double d) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IVecI iVecI, IDoubleI iDoubleI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
    }

    public IVec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
    }

    public IVec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI) {
        super(iServerI);
    }

    public IVec4(IServerI iServerI, double d, double d2, double d3, double d4) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public IVec4(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVec4 iVec4) {
        super(iServerI);
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IServerI iServerI, IVec4I iVec4I) {
        super(iServerI);
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
    }

    public IVec4(IServerI iServerI, IVec iVec) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = 1.0;
    }

    public IVec4(IServerI iServerI, IVec iVec, double d) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IServerI iServerI, IVecI iVecI, double d) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
    }

    public IVec4(IServerI iServerI, IVecI iVecI, IDoubleI iDoubleI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
    }

    public IVec4(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
    }

    public IVec4(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = 1.0;
    }

    @Override
    public double w() {
        return this.w;
    }

    @Override
    public IVec4 get() {
        return new IVec4(this.x, this.y, this.z, this.w);
    }

    @Override
    public IVec4 dup() {
        return new IVec4(this.x, this.y, this.z, this.w);
    }

    @Override
    public IVec to3d() {
        return new IVec(this);
    }

    @Override
    public IVec2 to2d() {
        return new IVec2(this);
    }

    @Override
    public IVec4 to4d() {
        return new IVec4(this);
    }

    @Override
    public IVec4 to4d(double d) {
        return new IVec4(this, d);
    }

    @Override
    public IVec4 to4d(IDoubleI iDoubleI) {
        return new IVec4((IVecI)this, iDoubleI);
    }

    @Override
    public IDouble getW() {
        return new IDouble(this.w);
    }

    @Override
    public IVec4 set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
        return this;
    }

    @Override
    public IVec4 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        this.w = iDoubleI4.x();
        return this;
    }

    public IVec4 set(IVec4 iVec4) {
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
        return this;
    }

    public IVec4 set(IVec iVec, double d) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
        return this;
    }

    @Override
    public IVec4 set(IVec4I iVec4I) {
        IVec4 iVec4 = iVec4I.get();
        this.x = iVec4.x;
        this.y = iVec4.y;
        this.z = iVec4.z;
        this.w = iVec4.w;
        return this;
    }

    @Override
    public IVec4 set(IVecI iVecI, double d) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = d;
        return this;
    }

    @Override
    public IVec4 set(IVecI iVecI, IDoubleI iDoubleI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        this.w = iDoubleI.x();
        return this;
    }

    @Override
    public IVec4 set(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    @Override
    public IVec4 set(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    @Override
    public IVec4 set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public IVec4 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        return this;
    }

    @Override
    public IVec4 add(double d, double d2, double d3) {
        super.add(d, d2, d3);
        return this;
    }

    @Override
    public IVec4 add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVec4 add(IVec iVec) {
        super.add(iVec);
        return this;
    }

    @Override
    public IVec4 add(IVecI iVecI) {
        super.add(iVecI);
        return this;
    }

    @Override
    public IVec4 sub(double d, double d2, double d3) {
        super.sub(d, d2, d3);
        return this;
    }

    @Override
    public IVec4 sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVec4 sub(IVec iVec) {
        super.sub(iVec);
        return this;
    }

    @Override
    public IVec4 sub(IVecI iVecI) {
        super.sub(iVecI);
        return this;
    }

    @Override
    public IVec4 mul(IDoubleI iDoubleI) {
        super.mul(iDoubleI);
        return this;
    }

    @Override
    public IVec4 mul(double d) {
        super.mul(d);
        return this;
    }

    @Override
    public IVec4 div(IDoubleI iDoubleI) {
        super.div(iDoubleI);
        return this;
    }

    @Override
    public IVec4 div(double d) {
        super.div(d);
        return this;
    }

    @Override
    public IVec4 neg() {
        super.neg();
        return this;
    }

    @Override
    public IVec4 rev() {
        this.neg();
        return this;
    }

    @Override
    public IVec4 flip() {
        this.neg();
        return this;
    }

    @Override
    public IVec4 zero() {
        super.zero();
        return this;
    }

    @Override
    public IVec4 add(IVec iVec, double d) {
        super.add(iVec, d);
        return this;
    }

    @Override
    public IVec4 add(IVecI iVecI, double d) {
        super.add(iVecI, d);
        return this;
    }

    @Override
    public IVec4 add(IVecI iVecI, IDoubleI iDoubleI) {
        super.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4 add(double d, IVec iVec) {
        return this.add(iVec, d);
    }

    @Override
    public IVec4 add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IVec4 add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public IVec4 len(IDoubleI iDoubleI) {
        super.len(iDoubleI);
        return this;
    }

    @Override
    public IVec4 len(double d) {
        super.len(d);
        return this;
    }

    @Override
    public IVec4 unit() {
        super.unit();
        return this;
    }

    @Override
    public IVec4 cross(IVec iVec) {
        return new IVec4(this.y * iVec.z - this.z * iVec.y, this.z * iVec.x - this.x * iVec.z, this.x * iVec.y - this.y * iVec.x, this.w);
    }

    @Override
    public IVec4 cross(double d, double d2, double d3) {
        return new IVec4(this.y * d3 - this.z * d2, this.z * d - this.x * d3, this.x * d2 - this.y * d, this.w);
    }

    @Override
    public IVec4 cross(IVecI iVecI) {
        return this.cross(iVecI.get());
    }

    @Override
    public IVec4 icross(IVec iVec) {
        double d = this.y * iVec.z - this.z * iVec.y;
        double d2 = this.z * iVec.x - this.x * iVec.z;
        double d3 = this.x * iVec.y - this.y * iVec.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    @Override
    public IVec4 icross(double d, double d2, double d3) {
        double d4 = this.y * d3 - this.z * d2;
        double d5 = this.z * d - this.x * d3;
        double d6 = this.x * d2 - this.y * d;
        this.x = d4;
        this.y = d5;
        this.z = d6;
        return this;
    }

    @Override
    public IVec4 icross(IVecI iVecI) {
        return this.icross(iVecI.get());
    }

    public boolean eqW(IVec4 iVec4) {
        return this.eqW(iVec4, IConfig.tolerance);
    }

    @Override
    public boolean eqW(double d) {
        return this.eqW(d, IConfig.tolerance);
    }

    @Override
    public boolean eqW(IVec4I iVec4I) {
        return this.eqW(iVec4I, IConfig.tolerance);
    }

    @Override
    public boolean eqW(IVec4I iVec4I, double d) {
        return Math.abs(this.w - iVec4I.w()) <= d;
    }

    public boolean eqW(IVec4 iVec4, double d) {
        return Math.abs(this.w - iVec4.w) <= d;
    }

    @Override
    public boolean eqW(double d, double d2) {
        return Math.abs(this.w - d) <= d2;
    }

    @Override
    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I) {
        return this.eqW(iVec4I);
    }

    @Override
    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I, double d) {
        return this.eqW(iVec4I, d);
    }

    @Override
    public IBool eqW(ISwitchR iSwitchR, IVec4I iVec4I) {
        return new IBool(this.eqW(iVec4I));
    }

    @Override
    public IBool eqW(ISwitchR iSwitchR, IVec4I iVec4I, IDoubleI iDoubleI) {
        return new IBool(this.eqW(iVec4I, iDoubleI.x()));
    }

    @Override
    public IVec4 rot(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    @Override
    public IVec4 rot(double d) {
        super.rot(d);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, double d) {
        super.rot(iVecI, d);
        return this;
    }

    @Override
    public IVec4 rot(IVec iVec, double d) {
        super.rot(iVec, d);
        return this;
    }

    @Override
    public IVec4 rot(double d, double d2, double d3, double d4) {
        super.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, IVecI iVecI2, double d) {
        super.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVec4 rot(IVec iVec, IVec iVec2, double d) {
        super.rot(iVec, iVec2, d);
        return this;
    }

    @Override
    public IVec4 rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        super.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVec4 rot(IVec iVec, IVec iVec2) {
        super.rot(iVec, iVec2);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, IVecI iVecI2) {
        super.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVec4 rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVec4 rot(IVec iVec, IVec iVec2, IVec iVec3) {
        super.rot(iVec, iVec2, iVec3);
        return this;
    }

    @Override
    public IVec4 rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IVec4 rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IVec4 rot2(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4 rot2(IVecI iVecI, double d) {
        super.rot2(iVecI, d);
        return this;
    }

    @Override
    public IVec4 rot2(IVec iVec, double d) {
        super.rot2(iVec, d);
        return this;
    }

    @Override
    public IVec4 rot2(double d, double d2, double d3) {
        super.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IVec4 rot2(IVec iVec) {
        super.rot2(iVec);
        return this;
    }

    @Override
    public IVec4 rot2(IVecI iVecI) {
        super.rot2(iVecI);
        return this;
    }

    @Override
    public IVec4 rot2(IVecI iVecI, IVecI iVecI2) {
        super.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVec4 rot2(IVec iVec, IVec iVec2) {
        super.rot2(iVec, iVec2);
        return this;
    }

    @Override
    public IVec4 scale(IDoubleI iDoubleI) {
        super.scale(iDoubleI);
        return this;
    }

    @Override
    public IVec4 scale(double d) {
        super.scale(d);
        return this;
    }

    @Override
    public IVec4 scale(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4 scale(IVecI iVecI, double d) {
        super.scale(iVecI, d);
        return this;
    }

    @Override
    public IVec4 scale(IVec iVec, double d) {
        super.scale(iVec, d);
        return this;
    }

    @Override
    public IVec4 scale(double d, double d2, double d3, double d4) {
        super.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVec4 scale1d(IVec iVec, double d) {
        super.scale1d(iVec, d);
        return this;
    }

    @Override
    public IVec4 scale1d(double d, double d2, double d3, double d4) {
        super.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVec4 scale1d(IVecI iVecI, double d) {
        super.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IVec4 scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4 scale1d(IVec iVec, IVec iVec2, double d) {
        super.scale1d(iVec, iVec2, d);
        return this;
    }

    @Override
    public IVec4 scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        super.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IVec4 scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        super.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IVec4 scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IVec4 ref(IVec iVec) {
        super.ref(iVec);
        return this;
    }

    @Override
    public IVec4 ref(double d, double d2, double d3) {
        super.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVec4 ref(IVecI iVecI) {
        super.ref(iVecI);
        return this;
    }

    @Override
    public IVec4 ref(IVec iVec, IVec iVec2) {
        super.ref(iVec, iVec2);
        return this;
    }

    @Override
    public IVec4 ref(double d, double d2, double d3, double d4, double d5, double d6) {
        super.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVec4 ref(IVecI iVecI, IVecI iVecI2) {
        super.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVec4 mirror(IVec iVec) {
        super.ref(iVec);
        return this;
    }

    @Override
    public IVec4 mirror(double d, double d2, double d3) {
        super.ref(d, d2, d3);
        return this;
    }

    @Override
    public IVec4 mirror(IVecI iVecI) {
        super.ref(iVecI);
        return this;
    }

    @Override
    public IVec4 mirror(IVec iVec, IVec iVec2) {
        super.ref(iVec, iVec2);
        return this;
    }

    @Override
    public IVec4 mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        super.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVec4 mirror(IVecI iVecI, IVecI iVecI2) {
        super.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IVec4 shear(double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVec4 shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVec4 shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IVec4 shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVec4 shearXY(double d, double d2) {
        super.shearXY(d, d2);
        return this;
    }

    @Override
    public IVec4 shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 shearXY(IVecI iVecI, double d, double d2) {
        super.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IVec4 shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 shearYZ(double d, double d2) {
        super.shearYZ(d, d2);
        return this;
    }

    @Override
    public IVec4 shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 shearYZ(IVecI iVecI, double d, double d2) {
        super.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IVec4 shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 shearZX(double d, double d2) {
        super.shearZX(d, d2);
        return this;
    }

    @Override
    public IVec4 shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 shearZX(IVecI iVecI, double d, double d2) {
        super.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IVec4 shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec4 translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVec4 translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4 translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVec4 transform(IMatrix3I iMatrix3I) {
        super.transform(iMatrix3I);
        return this;
    }

    @Override
    public IVec4 transform(IMatrix4I iMatrix4I) {
        super.transform(iMatrix4I);
        return this;
    }

    @Override
    public IVec4 transform(IVec iVec, IVec iVec2, IVec iVec3) {
        super.transform(iVec, iVec2, iVec3);
        return this;
    }

    @Override
    public IVec4 transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVec4 transform(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        super.transform(iVec, iVec2, iVec3, iVec4);
        return this;
    }

    @Override
    public IVec4 transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IVec4 mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVec4 mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4 mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVec4 cp() {
        return this.dup();
    }

    @Override
    public IVec4 cp(IVec iVec) {
        return new IVec4(this.x + iVec.x, this.y + iVec.y, this.z + iVec.z, this.w);
    }

    @Override
    public IVec4 cp(double d, double d2, double d3) {
        return new IVec4(this.x + d, this.y + d2, this.z + d3, this.w);
    }

    @Override
    public IVec4 cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4 cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec4 dif(IVec iVec) {
        return new IVec4(this.x - iVec.x, this.y - iVec.y, this.z - iVec.z, this.w);
    }

    @Override
    public IVec4 dif(double d, double d2, double d3) {
        return new IVec4(this.x - d, this.y - d2, this.z - d3, this.w);
    }

    @Override
    public IVec4 dif(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    @Override
    public IVec4 diff(IVec iVec) {
        return this.dif(iVec);
    }

    @Override
    public IVec4 diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    @Override
    public IVec4 diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    @Override
    public IVec4 mid(IVec iVec) {
        return new IVec4((this.x + iVec.x) / 2.0, (this.y + iVec.y) / 2.0, (this.z + iVec.z) / 2.0, this.w);
    }

    @Override
    public IVec4 mid(double d, double d2, double d3) {
        return new IVec4((this.x + d) / 2.0, (this.y + d2) / 2.0, (this.z + d3) / 2.0, this.w);
    }

    @Override
    public IVec4 mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    @Override
    public IVec4 sum(IVec iVec) {
        return new IVec4(this.x + iVec.x, this.y + iVec.y, this.z + iVec.y, this.w);
    }

    @Override
    public IVec4 sum(double d, double d2, double d3) {
        return new IVec4(this.x + d, this.y + d2, this.z + d2, this.w);
    }

    @Override
    public IVec4 sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec4 sum(IVec ... iVecArray) {
        IVec4 iVec4 = this.dup();
        for (IVec iVec : iVecArray) {
            iVec4.add(iVec);
        }
        return iVec4;
    }

    @Override
    public IVec4 sum(IVecI ... iVecIArray) {
        IVec4 iVec4 = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVec4.add(iVecI);
        }
        return iVec4;
    }

    @Override
    public IVec4 bisect(IVec iVec) {
        return this.dup().unit().add(iVec.dup().unit());
    }

    @Override
    public IVec4 bisect(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return this.dup().unit().add(d / d4, d2 / d4, d3 / d4);
    }

    @Override
    public IVec4 bisect(IVecI iVecI) {
        return this.bisect(iVecI.get());
    }

    @Override
    public IVec4 sum(IVec iVec, double d, double d2) {
        return this.dup().mul(d).add(iVec, d2);
    }

    @Override
    public IVec4 sum(IVec iVec, double d) {
        return this.dup().mul(1.0 - d).add(iVec, d);
    }

    @Override
    public IVec4 sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI.get(), d, d2);
    }

    @Override
    public IVec4 sum(IVecI iVecI, double d) {
        return this.sum(iVecI, d);
    }

    @Override
    public IVec4 sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI.get(), iDoubleI.x(), iDoubleI2.x());
    }

    @Override
    public IVec4 sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI.get(), iDoubleI.x());
    }

    @Override
    public IVec4 nml(IVec iVec) {
        return this.cross(iVec);
    }

    @Override
    public IVec4 nml(IVecI iVecI) {
        return this.cross(iVecI);
    }

    @Override
    public IVec4 nml(double d, double d2, double d3) {
        return this.cross(d, d2, d3);
    }

    @Override
    public IVec4 nml(IVec iVec, IVec iVec2) {
        return this.diff(iVec).icross(this.diff(iVec2));
    }

    @Override
    public IVec4 nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.diff(d, d2, d3).cross(this.diff(d4, d5, d6));
    }

    @Override
    public IVec4 nml(IVecI iVecI, IVecI iVecI2) {
        return this.diff(iVecI).icross(this.diff(iVecI2));
    }

    @Override
    public boolean isValid() {
        if (!IDouble.isValid(this.x)) {
            IOut.err("invalid x (" + this.x + ")");
            return false;
        }
        if (!IDouble.isValid(this.y)) {
            IOut.err("invalid y (" + this.y + ")");
            return false;
        }
        if (!IDouble.isValid(this.z)) {
            IOut.err("invalid z (" + this.z + ")");
            return false;
        }
        if (!IDouble.isValid(this.w)) {
            IOut.err("invalid w (" + this.w + ")");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z) + "," + String.valueOf(this.w) + ")";
    }
}

