/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVecI;
import java.util.ArrayList;

public class IVec2
extends IParameterObject
implements IVec2I,
IEntityParameter {
    public double x;
    public double y;

    public IVec2() {
    }

    public IVec2(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public IVec2(IVec2 iVec2) {
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
    }

    public IVec2(IVecI iVecI) {
        this.x = iVecI.x();
        this.y = iVecI.y();
    }

    public IVec2(IServerI iServerI) {
        super(iServerI);
    }

    public IVec2(IServerI iServerI, double d, double d2) {
        super(iServerI);
        this.x = d;
        this.y = d2;
    }

    public IVec2(IServerI iServerI, IVec2 iVec2) {
        super(iServerI);
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IServerI iServerI, IVec2I iVec2I) {
        super(iServerI);
        IVec2 iVec2 = iVec2I.get();
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
    }

    public IVec2(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.x = iVecI.x();
        this.y = iVecI.y();
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public IVec2 get() {
        return new IVec2(this);
    }

    @Override
    public IVec2 dup() {
        return new IVec2(this);
    }

    @Override
    public IVec to3d() {
        return new IVec(this);
    }

    @Override
    public IVec to3d(double d) {
        return new IVec(this.x, this.y, d);
    }

    @Override
    public IVec to3d(IDoubleI iDoubleI) {
        return new IVec(this.x, this.y, iDoubleI.x());
    }

    @Override
    public IVec4 to4d() {
        return new IVec4(this.x, this.y, 0.0);
    }

    @Override
    public IVec4 to4d(double d, double d2) {
        return new IVec4(this.x, this.y, d, d2);
    }

    @Override
    public IVec4 to4d(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec4(this.x, this.y, iDoubleI.x(), iDoubleI2.x());
    }

    @Override
    public IDouble getX() {
        return new IDouble(this.x);
    }

    @Override
    public IDouble getY() {
        return new IDouble(this.y);
    }

    @Override
    public IVec2 set(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public IVec2 set(IVec2 iVec2) {
        this.x = iVec2.x;
        this.y = iVec2.y;
        return this;
    }

    @Override
    public IVec2 set(IVec2I iVec2I) {
        return this.set(iVec2I.get());
    }

    @Override
    public IVec2 set(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        return this;
    }

    @Override
    public IVec2 add(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    @Override
    public IVec2 add(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x += iDoubleI.x();
        this.y += iDoubleI2.x();
        return this;
    }

    public IVec2 add(IVec2 iVec2) {
        this.x += iVec2.x;
        this.y += iVec2.y;
        return this;
    }

    @Override
    public IVec2 add(IVec2I iVec2I) {
        return this.add(iVec2I.get());
    }

    @Override
    public IVec2 sub(double d, double d2) {
        this.x -= d;
        this.y -= d2;
        return this;
    }

    @Override
    public IVec2 sub(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x -= iDoubleI.x();
        this.y -= iDoubleI2.x();
        return this;
    }

    public IVec2 sub(IVec2 iVec2) {
        this.x -= iVec2.x;
        this.y -= iVec2.y;
        return this;
    }

    @Override
    public IVec2 sub(IVec2I iVec2I) {
        return this.sub(iVec2I.get());
    }

    @Override
    public IVec2 mul(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public IVec2 mul(IDouble iDouble) {
        return this.mul(iDouble.x);
    }

    @Override
    public IVec2 mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    @Override
    public IVec2 div(double d) {
        this.x /= d;
        this.y /= d;
        return this;
    }

    public IVec2 div(IDouble iDouble) {
        return this.div(iDouble.x);
    }

    @Override
    public IVec2 div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    @Override
    public IVec2 neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    public IVec2 rev() {
        return this.neg();
    }

    @Override
    public IVec2 flip() {
        return this.neg();
    }

    @Override
    public IVec2 zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public IVec2 add(IVec2 iVec2, double d) {
        this.x += iVec2.x * d;
        this.y += iVec2.y * d;
        return this;
    }

    @Override
    public IVec2 add(IVec2I iVec2I, double d) {
        return this.add(iVec2I.get(), d);
    }

    @Override
    public IVec2 add(IVec2I iVec2I, IDoubleI iDoubleI) {
        this.add(iVec2I.get(), iDoubleI.x());
        return this;
    }

    public IVec2 add(double d, IVec2 iVec2) {
        return this.add(iVec2, d);
    }

    @Override
    public IVec2 add(double d, IVec2I iVec2I) {
        return this.add(iVec2I, d);
    }

    @Override
    public IVec2 add(IDoubleI iDoubleI, IVec2I iVec2I) {
        return this.add(iVec2I, iDoubleI);
    }

    public double dot(IVec2 iVec2) {
        return this.x * iVec2.x + this.y * iVec2.y;
    }

    @Override
    public double dot(double d, double d2) {
        return this.x * d + this.y * d2;
    }

    @Override
    public double dot(IVec2I iVec2I) {
        return this.dot(iVec2I.get());
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dot(iVec2I);
    }

    @Override
    public IDouble dot(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dot(iVec2I));
    }

    public IVec cross(IVec2 iVec2) {
        return new IVec(0.0, 0.0, this.x * iVec2.y - this.y * iVec2.x);
    }

    @Override
    public IVec cross(double d, double d2) {
        return new IVec(0.0, 0.0, this.x * d2 - this.y * d);
    }

    @Override
    public IVec cross(IVec2I iVec2I) {
        return this.cross(iVec2I.get());
    }

    @Override
    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    @Override
    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    @Override
    public double len2() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    @Override
    public IDouble len2(ISwitchR iSwitchR) {
        return new IDouble(this.len2());
    }

    @Override
    public IVec2 len(IDoubleI iDoubleI) {
        return this.len(iDoubleI.x());
    }

    @Override
    public IVec2 len(double d) {
        this.x *= (d /= this.len());
        this.y *= d;
        return this;
    }

    @Override
    public IVec2 unit() {
        double d = this.len();
        this.x /= d;
        this.y /= d;
        return this;
    }

    @Override
    public IVec2 ortho() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
        return this;
    }

    public double dist(IVec2 iVec2) {
        return Math.sqrt((this.x - iVec2.x) * (this.x - iVec2.x) + (this.y - iVec2.y) * (this.y - iVec2.y));
    }

    @Override
    public double dist(double d, double d2) {
        return Math.sqrt((this.x - d) * (this.x - d) + (this.y - d2) * (this.y - d2));
    }

    @Override
    public double dist(IVec2I iVec2I) {
        return this.dist(iVec2I.get());
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist(iVec2I);
    }

    @Override
    public IDouble dist(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist(iVec2I));
    }

    public double dist2(IVec2 iVec2) {
        return (this.x - iVec2.x) * (this.x - iVec2.x) + (this.y - iVec2.y) * (this.y - iVec2.y);
    }

    @Override
    public double dist2(double d, double d2) {
        return (this.x - d) * (this.x - d) + (this.y - d2) * (this.y - d2);
    }

    @Override
    public double dist2(IVec2I iVec2I) {
        return this.dist2(iVec2I.get());
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist2(iVec2I);
    }

    @Override
    public IDouble dist2(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist2(iVec2I));
    }

    public boolean eq(IVec2 iVec2) {
        return this.eq(iVec2, IConfig.tolerance);
    }

    @Override
    public boolean eq(double d, double d2) {
        return this.eq(d, d2, IConfig.tolerance);
    }

    @Override
    public boolean eq(IVec2I iVec2I) {
        return this.eq(iVec2I.get(), IConfig.tolerance);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eq(iVec2I);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eq(iVec2I));
    }

    public boolean eq(IVec2 iVec2, double d) {
        return this.dist2(iVec2) <= d * d;
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.dist2(d, d2) <= d3 * d3;
    }

    @Override
    public boolean eq(IVec2I iVec2I, double d) {
        return this.eq(iVec2I.get(), d);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eq(iVec2I, d);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eq(iVec2I, iDoubleI.x()));
    }

    public boolean eqX(IVec2 iVec2) {
        return this.eqX(iVec2, IConfig.tolerance);
    }

    public boolean eqY(IVec2 iVec2) {
        return this.eqY(iVec2, IConfig.tolerance);
    }

    @Override
    public boolean eqX(double d) {
        return this.eqX(d, IConfig.tolerance);
    }

    @Override
    public boolean eqY(double d) {
        return this.eqY(d, IConfig.tolerance);
    }

    @Override
    public boolean eqX(IVec2I iVec2I) {
        return this.eqX(iVec2I.get(), IConfig.tolerance);
    }

    @Override
    public boolean eqY(IVec2I iVec2I) {
        return this.eqY(iVec2I.get(), IConfig.tolerance);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqX(iVec2I);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqY(iVec2I);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqX(iVec2I));
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqY(iVec2I));
    }

    public boolean eqX(IVec2 iVec2, double d) {
        return Math.abs(iVec2.x - this.x) <= d;
    }

    public boolean eqY(IVec2 iVec2, double d) {
        return Math.abs(iVec2.y - this.y) <= d;
    }

    @Override
    public boolean eqX(double d, double d2) {
        return Math.abs(d - this.x) <= d2;
    }

    @Override
    public boolean eqY(double d, double d2) {
        return Math.abs(d - this.y) <= d2;
    }

    @Override
    public boolean eqX(IVec2I iVec2I, double d) {
        return Math.abs(iVec2I.x() - this.x) <= d;
    }

    @Override
    public boolean eqY(IVec2I iVec2I, double d) {
        return Math.abs(iVec2I.y() - this.y) <= d;
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqX(iVec2I, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqY(iVec2I, d);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqX(iVec2I, iDoubleI.x()));
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqY(iVec2I, iDoubleI.x()));
    }

    public double angle(IVec2 iVec2) {
        double d = this.x * iVec2.x + this.y * iVec2.y;
        double d2 = this.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = iVec2.len();
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = this.x * iVec2.y - this.y * iVec2.x;
        double d5 = d / (d2 * d3);
        if (d5 > 1.0) {
            d5 = 1.0;
        } else if (d5 < -1.0) {
            d5 = -1.0;
        }
        double d6 = Math.acos(d5);
        if (d4 < 0.0) {
            return -d6;
        }
        return d6;
    }

    @Override
    public double angle(double d, double d2) {
        double d3 = this.x * d + this.y * d2;
        double d4 = this.len();
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = Math.sqrt(d * d + d2 * d2);
        if (d5 == 0.0) {
            return 0.0;
        }
        double d6 = this.x * d2 - this.y * d;
        double d7 = d3 / (d4 * d5);
        if (d7 > 1.0) {
            d7 = 1.0;
        } else if (d7 < -1.0) {
            d7 = -1.0;
        }
        double d8 = Math.acos(d7);
        if (d6 < 0.0) {
            return -d8;
        }
        return d8;
    }

    @Override
    public double angle(IVec2I iVec2I) {
        return this.angle(iVec2I.get());
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.angle(iVec2I);
    }

    @Override
    public IDouble angle(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.angle(iVec2I));
    }

    @Override
    public IVec2 rot(double d) {
        double d2 = this.x;
        this.x = this.x * Math.cos(d) - this.y * Math.sin(d);
        this.y = d2 * Math.sin(d) + this.y * Math.cos(d);
        return this;
    }

    @Override
    public IVec2 rot(IDoubleI iDoubleI) {
        return this.rot(iDoubleI.x());
    }

    public IVec2 rot(IVec2 iVec2, double d) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).rot(d).add(iVec2);
    }

    @Override
    public IVec2 rot(double d, double d2, double d3) {
        return this.sub(d, d2).rot(d3).add(d, d2);
    }

    @Override
    public IVec2 rot(IVec2I iVec2I, double d) {
        return this.rot(iVec2I.get(), d);
    }

    @Override
    public IVec2 rot(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.rot(iVec2I.get(), iDoubleI.x());
    }

    public IVec2 rot(IVec2 iVec2) {
        return this.rot(this.angle(iVec2));
    }

    @Override
    public IVec2 rot(IVec2I iVec2I) {
        return this.rot(iVec2I.get());
    }

    public IVec2 rot(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).rot(iVec22.diff(iVec2)).add(iVec2);
    }

    @Override
    public IVec2 rot(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.rot(iVec2I.get(), iVec2I2.get());
    }

    @Override
    public IVec2 scale(double d) {
        return this.mul(d);
    }

    @Override
    public IVec2 scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVec2 scale(IVec2 iVec2, double d) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).mul(d).add(iVec2);
    }

    @Override
    public IVec2 scale(double d, double d2, double d3) {
        return this.sub(d, d2).mul(d3).add(d, d2);
    }

    @Override
    public IVec2 scale(IVec2I iVec2I, double d) {
        return this.scale(iVec2I.get(), d);
    }

    @Override
    public IVec2 scale(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.scale(iVec2I.get(), iDoubleI.x());
    }

    public IVec2 ref(IVec2 iVec2) {
        return this.rev().add(iVec2.dup().mul(this.dot(iVec2) / iVec2.len2() * -2.0));
    }

    @Override
    public IVec2 ref(double d, double d2) {
        double d3 = this.dot(d, d2) / (d * d + d2 * d2) * -2.0;
        this.x = -this.x + d * d3;
        this.y = -this.y + d2 * d3;
        return this;
    }

    @Override
    public IVec2 ref(IVec2I iVec2I) {
        return this.ref(iVec2I.get());
    }

    public IVec2 ref(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).ref(iVec22).add(iVec2);
    }

    @Override
    public IVec2 ref(double d, double d2, double d3, double d4) {
        return this.sub(d, d2).ref(d3, d4).add(d, d2);
    }

    @Override
    public IVec2 ref(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.ref(iVec2I.get(), iVec2I2.get());
    }

    public IVec2 mirror(IVec2 iVec2) {
        return this.ref(iVec2);
    }

    @Override
    public IVec2 mirror(double d, double d2) {
        return this.ref(d, d2);
    }

    @Override
    public IVec2 mirror(IVec2I iVec2I) {
        return this.ref(iVec2I.get());
    }

    public IVec2 mirror(IVec2 iVec2, IVec2 iVec22) {
        return this.ref(iVec2, iVec22);
    }

    @Override
    public IVec2 mirror(double d, double d2, double d3, double d4) {
        return this.ref(d, d2, d3, d4);
    }

    @Override
    public IVec2 mirror(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.ref(iVec2I, iVec2I2);
    }

    public IVec2 transform(IVec2 iVec2, IVec2 iVec22) {
        double d = iVec2.x * this.x + iVec22.x * this.y;
        double d2 = iVec2.y * this.x + iVec22.y * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    @Override
    public IVec2 transform(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.transform(iVec2I.get(), iVec2I2.get());
    }

    public IVec2 transform(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return this.transform(iVec2, iVec22).add(iVec23);
    }

    @Override
    public IVec2 transform(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3) {
        return this.transform(iVec2I.get(), iVec2I2.get(), iVec2I3.get());
    }

    public IVec2 dif(IVec2 iVec2) {
        return new IVec2(this.x - iVec2.x, this.y - iVec2.y);
    }

    @Override
    public IVec2 dif(double d, double d2) {
        return new IVec2(this.x - d, this.y - d2);
    }

    @Override
    public IVec2 dif(IVec2I iVec2I) {
        return this.dup().sub(iVec2I);
    }

    public IVec2 diff(IVec2 iVec2) {
        return this.dif(iVec2);
    }

    @Override
    public IVec2 diff(double d, double d2) {
        return this.dif(d, d2);
    }

    @Override
    public IVec2 diff(IVec2I iVec2I) {
        return this.dif(iVec2I);
    }

    public IVec2 mid(IVec2 iVec2) {
        return new IVec2((this.x + iVec2.x) / 2.0, (this.y + iVec2.y) / 2.0);
    }

    @Override
    public IVec2 mid(double d, double d2) {
        return new IVec2((this.x + d) / 2.0, (this.y + d2) / 2.0);
    }

    @Override
    public IVec2 mid(IVec2I iVec2I) {
        return this.dup().add(iVec2I).div(2.0);
    }

    public IVec2 sum(IVec2 iVec2) {
        return this.dup().add(iVec2);
    }

    @Override
    public IVec2 sum(double d, double d2) {
        return this.dup().add(d, d2);
    }

    @Override
    public IVec2 sum(IVec2I iVec2I) {
        return this.dup().add(iVec2I);
    }

    @Override
    public IVec2 sum(IVec2I ... iVec2IArray) {
        IVec2 iVec2 = this.dup();
        for (IVec2I iVec2I : iVec2IArray) {
            iVec2.add(iVec2I);
        }
        return iVec2;
    }

    public IVec2 bisect(IVec2 iVec2) {
        return this.dup().unit().add(iVec2.dup().unit());
    }

    @Override
    public IVec2 bisect(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2);
        return this.dup().unit().add(d / d3, d2 / d3);
    }

    @Override
    public IVec2 bisect(IVec2I iVec2I) {
        return this.bisect(iVec2I.get());
    }

    public IVec2 sum(IVec2 iVec2, double d, double d2) {
        return this.dup().mul(d).add(iVec2, d2);
    }

    @Override
    public IVec2 sum(IVec2I iVec2I, double d, double d2) {
        return this.sum(iVec2I.get(), d, d2);
    }

    @Override
    public IVec2 sum(IVec2I iVec2I, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVec2I.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec2 sum(IVec2 iVec2, double d) {
        return this.dup().mul(1.0 - d).add(iVec2, d);
    }

    @Override
    public IVec2 sum(IVec2I iVec2I, double d) {
        return this.sum(iVec2I.get(), d);
    }

    @Override
    public IVec2 sum(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.sum((IVec2I)iVec2I.get(), iDoubleI.get());
    }

    public IVec nml(IVec2 iVec2) {
        return this.cross(iVec2);
    }

    @Override
    public IVec nml(IVec2I iVec2I) {
        return this.cross(iVec2I);
    }

    @Override
    public IVecI nml(double d, double d2) {
        return this.cross(d, d2);
    }

    public IVecI nml(IVec2 iVec2, IVec2 iVec22) {
        return this.dif(iVec2).cross(this.dif(iVec22));
    }

    @Override
    public IVecI nml(double d, double d2, double d3, double d4) {
        return this.dif(d, d2).cross(this.dif(d3, d4));
    }

    @Override
    public IVecI nml(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.dif(iVec2I).cross(this.dif(iVec2I2));
    }

    public boolean isParallel(IVec2I iVec2I) {
        return this.isParallel(iVec2I, IConfig.angleTolerance);
    }

    public boolean isParallel(IVec2I iVec2I, double d) {
        return Math.abs(this.dot(iVec2I.get()) / (this.len() * iVec2I.get().len())) > Math.cos(d);
    }

    public boolean isStraight(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.isStraight(iVec2I, iVec2I2, IConfig.angleTolerance);
    }

    public boolean isStraight(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        return iVec2I.get().diff(this).isParallel(iVec2I2.get().diff(iVec2I), d);
    }

    public static IVec2 intersect(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4) {
        double d = iVec2I4.x() * iVec2I2.y() - iVec2I2.x() * iVec2I4.y();
        if (d == 0.0) {
            return null;
        }
        IVec2 iVec2 = new IVec2(iVec2I.x() * iVec2I2.y() * iVec2I4.x() - iVec2I3.x() * iVec2I2.x() * iVec2I4.y() - (iVec2I.y() - iVec2I3.y()) * iVec2I2.x() * iVec2I4.x(), iVec2I3.y() * iVec2I2.y() * iVec2I4.x() - iVec2I.y() * iVec2I2.x() * iVec2I4.y() + (iVec2I.x() - iVec2I3.x()) * iVec2I2.y() * iVec2I4.y());
        iVec2.div(d);
        return iVec2;
    }

    public static IVec2 intersectYLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec22.x == 0.0) {
            return null;
        }
        return new IVec2(d, iVec2.y - (iVec2.x - d) * iVec22.y / iVec22.x);
    }

    public static IVec2 intersectXLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec22.y == 0.0) {
            return null;
        }
        return new IVec2(iVec2.x - (iVec2.y - d) * iVec22.x / iVec22.y, d);
    }

    public static IVec2 intersectSegment(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4) {
        if (Math.max(iVec2I.x(), iVec2I2.x()) < Math.min(iVec2I3.x(), iVec2I4.x()) || Math.max(iVec2I3.x(), iVec2I4.x()) < Math.min(iVec2I.x(), iVec2I2.x()) || Math.max(iVec2I.y(), iVec2I2.y()) < Math.min(iVec2I3.y(), iVec2I4.y()) || Math.max(iVec2I3.y(), iVec2I4.y()) < Math.min(iVec2I.y(), iVec2I2.y())) {
            return null;
        }
        IVec2 iVec2 = IVec2.intersect(iVec2I, iVec2I2.get().diff(iVec2I), iVec2I3, iVec2I4.get().diff(iVec2I3));
        if (iVec2 == null) {
            return null;
        }
        if (!iVec2.isBetween(iVec2I, iVec2I2) || !iVec2.isBetween(iVec2I3, iVec2I4)) {
            return null;
        }
        return iVec2;
    }

    public static IVec2 intersectPolyline(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray, boolean bl) {
        for (int i = 0; i < iVec2IArray.length - 1 || bl && i < iVec2IArray.length; ++i) {
            IVec2 iVec2 = IVec2.intersectSegment(iVec2I, iVec2I2, iVec2IArray[i], iVec2IArray[(i + 1) % iVec2IArray.length]);
            if (iVec2 == null) continue;
            return iVec2;
        }
        return null;
    }

    public static IVec2 intersectPolyline(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray) {
        return IVec2.intersectPolyline(iVec2I, iVec2I2, iVec2IArray, false);
    }

    public static IVec2 intersectPolygon(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray) {
        return IVec2.intersectPolyline(iVec2I, iVec2I2, iVec2IArray, true);
    }

    public static IVec2 intersectSegmentAndXLine(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        if (Math.max(iVec2I.y(), iVec2I2.y()) < d || Math.min(iVec2I.y(), iVec2I2.y()) > d) {
            return null;
        }
        IVec2 iVec2 = iVec2I2.get().diff(iVec2I);
        if (iVec2.y == 0.0) {
            return iVec2I.get().dup();
        }
        iVec2.mul((d - iVec2I.y()) / iVec2.y);
        iVec2.add(iVec2I);
        return iVec2;
    }

    public static IVec2 intersectSegmentAndYLine(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        if (Math.max(iVec2I.x(), iVec2I2.x()) < d || Math.min(iVec2I.x(), iVec2I2.x()) > d) {
            return null;
        }
        IVec2 iVec2 = iVec2I2.get().diff(iVec2I);
        if (iVec2.x == 0.0) {
            return iVec2I.get().dup();
        }
        iVec2.mul((d - iVec2I.x()) / iVec2.x);
        iVec2.add(iVec2I);
        return iVec2;
    }

    public static IVec2I[] removeStraightPoints(IVec2I[] iVec2IArray, boolean bl) {
        int n = iVec2IArray.length;
        if (n <= 2) {
            return iVec2IArray;
        }
        ArrayList<IVec2I> arrayList = new ArrayList<IVec2I>();
        arrayList.add(iVec2IArray[0]);
        for (int i = 1; !bl && i < n - 1 || bl && i < n; ++i) {
            if (((IVec2I)arrayList.get(arrayList.size() - 1)).get().isStraight(iVec2IArray[i], iVec2IArray[(i + 1) % n])) continue;
            arrayList.add(iVec2IArray[i]);
        }
        if (bl && ((IVec2I)arrayList.get(arrayList.size() - 1)).get().isStraight((IVec2I)arrayList.get(0), (IVec2I)arrayList.get(1))) {
            arrayList.remove(0);
        }
        if (arrayList.size() == n) {
            return iVec2IArray;
        }
        IVec2I[] iVec2IArray2 = new IVec2I[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            iVec2IArray2[i] = (IVec2I)arrayList.get(i);
        }
        return iVec2IArray2;
    }

    public static IVec2I[] removeDuplicatedPoints(IVec2I[] iVec2IArray, boolean bl) {
        int n = iVec2IArray.length;
        ArrayList<IVec2I> arrayList = new ArrayList<IVec2I>();
        arrayList.add(iVec2IArray[0]);
        for (int i = 1; i < n; ++i) {
            if (((IVec2I)arrayList.get(arrayList.size() - 1)).get().eq(iVec2IArray[i])) continue;
            if (bl && i == n - 1) {
                if (((IVec2I)arrayList.get(0)).get().eq(iVec2IArray[i])) continue;
                arrayList.add(iVec2IArray[i]);
                continue;
            }
            arrayList.add(iVec2IArray[i]);
        }
        return arrayList.toArray(new IVec2I[arrayList.size()]);
    }

    public boolean isInside(IVec2I[] iVec2IArray) {
        double d = 0.0;
        int n = iVec2IArray.length;
        for (int i = 0; i < n; ++i) {
            IVec2 iVec2 = iVec2IArray[i].get().diff(this);
            IVec2 iVec22 = iVec2IArray[(i + 1) % n].get().diff(this);
            d += iVec2.angle(iVec22);
        }
        return Math.abs(d) < 0.1;
    }

    public boolean isInside(IVec2[] iVec2Array) {
        int n;
        double d = 0.0;
        int n2 = iVec2Array.length;
        for (n = 0; n < n2; ++n) {
            IVec2 iVec2;
            IVec2 iVec22 = iVec2Array[n].diff(this);
            double d2 = iVec22.angle(iVec2 = iVec2Array[(n + 1) % n2].diff(this));
            if (Math.abs(d2 - Math.PI) < IConfig.angleTolerance || Math.abs(d2 + Math.PI) < IConfig.angleTolerance || iVec22.len() < IConfig.tolerance || iVec2.len() < IConfig.tolerance) {
                return true;
            }
            d += d2;
        }
        n = (int)(Math.abs(d / (Math.PI * 2)) + 0.5);
        return n % 2 != 0;
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
    }

    public double distToLine(IVec2 iVec2, IVec2 iVec22) {
        double d = iVec22.x - iVec2.x;
        double d2 = iVec22.y - iVec2.y;
        return Math.abs(d2 * this.x + -d * this.y - iVec2.x * iVec22.y + iVec22.x * iVec2.y) / Math.sqrt(d2 * d2 + d * d);
    }

    public boolean isOnLine(IVec2 iVec2, IVec2 iVec22) {
        return this.distToLine(iVec2, iVec22) < IConfig.tolerance;
    }

    public boolean isBetween(IVec2I iVec2I, IVec2I iVec2I2) {
        IVec2 iVec2;
        IVec2 iVec22 = this.diff(iVec2I);
        double d = iVec22.dot(iVec2 = iVec2I2.get().diff(iVec2I));
        if (d < 0.0) {
            return false;
        }
        return !(d > iVec2.len2());
    }
}

