/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.ICurve;
import igeo.ICurveGeo;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IOut;
import igeo.ISurfaceI;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;

public class ITrimCurve
extends ICurveGeo
implements ITrimCurveI {
    public ISurfaceI surface = null;

    public ITrimCurve() {
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        super(iVecIArray, n, dArray, d, d2);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, double[] dArray) {
        super(iVecIArray, n, dArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n) {
        super(iVecIArray, n);
    }

    public ITrimCurve(IVecI[] iVecIArray) {
        super(iVecIArray);
    }

    public ITrimCurve(IVecI[] iVecIArray, int n, boolean bl) {
        super(iVecIArray, n, bl);
    }

    public ITrimCurve(IVecI[] iVecIArray, boolean bl) {
        super(iVecIArray, bl);
    }

    public ITrimCurve(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
    }

    public ITrimCurve(double d, double d2, double d3, double d4) {
        super(d, d2, 0.0, d3, d4, 0.0);
    }

    public ITrimCurve(double[][] dArray) {
        super(dArray);
    }

    public ITrimCurve(double[][] dArray, int n) {
        super(dArray, n);
    }

    public ITrimCurve(double[][] dArray, boolean bl) {
        super(dArray, bl);
    }

    public ITrimCurve(double[][] dArray, int n, boolean bl) {
        super(dArray, n, bl);
    }

    public ITrimCurve(ICurveGeo iCurveGeo) {
        super(iCurveGeo);
    }

    public ITrimCurve(ICurve iCurve) {
        this(iCurve.curve);
    }

    public ITrimCurve(ICurveI iCurveI) {
        this(iCurveI.get());
    }

    public ITrimCurve(ITrimCurve iTrimCurve) {
        super(iTrimCurve);
        this.surface = iTrimCurve.surface;
    }

    @Override
    public ITrimCurve surface(ISurfaceI iSurfaceI) {
        if (this.surface != null && this.surface != iSurfaceI) {
            IOut.err("surface is already set. overwritten.");
        }
        this.surface = iSurfaceI;
        return this;
    }

    @Override
    public ISurfaceI surface() {
        return this.surface;
    }

    @Override
    public ITrimCurve dup() {
        ITrimCurve iTrimCurve = new ITrimCurve(this);
        iTrimCurve.surface = null;
        return iTrimCurve;
    }

    @Override
    public ITrimCurve get() {
        return this;
    }

    @Override
    public ICurveGeo get3d() {
        Object object;
        int n;
        if (this.surface == null) {
            IOut.err("surface is not set");
            return null;
        }
        IVecI[] iVecIArray = new IVec[this.num()];
        for (n = 0; n < iVecIArray.length; ++n) {
            IVec iVec;
            object = this.cp(n);
            if (this.defaultWeights[n]) {
                iVec = object.get();
                iVecIArray[n] = this.surface.pt(iVec.x, iVec.y).get();
                continue;
            }
            iVec = object.get();
            IVec4 iVec4 = this.surface.pt(iVec.x, iVec.y).to4d().get();
            iVec4.w = object instanceof IVec4I ? ((IVec4I)object).w() : 1.0;
            iVecIArray[n] = iVec4;
        }
        n = this.deg();
        object = new double[this.knotNum()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = this.knot(i);
        }
        double d = this.ustart();
        double d2 = this.uend();
        return new ICurveGeo(iVecIArray, n, (double[])object, d, d2);
    }

    public void normalizeControlPoints() {
        this.normalizeControlPoints(this.surface);
    }

    public void normalizeControlPoints(ISurfaceI iSurfaceI) {
        double d = iSurfaceI.ustart();
        double d2 = iSurfaceI.uend();
        double d3 = iSurfaceI.vstart();
        double d4 = iSurfaceI.vend();
        if (d != 0.0 || d2 != 1.0 || d3 != 0.0 || d4 != 1.0) {
            for (IVecI iVecI : this.controlPoints) {
                iVecI.set((iVecI.x() - d) / (d2 - d), (iVecI.y() - d3) / (d4 - d3), iVecI.z());
            }
        }
    }

    @Override
    public void pt(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        iVec.set(this.surface.pt(iVec2.x, iVec2.y));
    }

    public void pt2d(double d, IVec2 iVec2) {
        IVec iVec = new IVec();
        super.pt(d, iVec);
        iVec2.set(iVec.x, iVec.y);
    }

    @Override
    public IVec2I pt2d(double d) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(d, iVec2);
        return iVec2;
    }

    @Override
    public IVec2I pt2d(IDoubleI iDoubleI) {
        IVec2 iVec2 = new IVec2();
        this.pt2d(iDoubleI.x(), iVec2);
        return iVec2;
    }

    @Override
    public IVec2 start2d() {
        IVec iVec = new IVec();
        super.pt(0.0, iVec);
        return new IVec2(iVec);
    }

    @Override
    public IVec2 end2d() {
        IVec iVec = new IVec();
        super.pt(1.0, iVec);
        return new IVec2(iVec);
    }

    @Override
    public IVec2 startCP2d() {
        return new IVec2(this.cp(0));
    }

    @Override
    public IVec2 endCP2d() {
        return new IVec2(this.cp(this.num() - 1));
    }

    @Override
    public void tan(double d, IVec iVec) {
        IVec iVec2 = new IVec();
        super.pt(d, iVec2);
        IVec iVec3 = new IVec();
        super.tan(d, iVec3);
        IVec iVec4 = this.surface.utan(iVec2.x, iVec2.y).get();
        IVec iVec5 = this.surface.vtan(iVec2.x, iVec2.y).get();
        iVec4.mul(iVec3.x).add(iVec5.mul(iVec3.y));
        iVec.set(iVec4);
    }

    @Override
    public boolean isClosed() {
        boolean bl = true;
        if (this.knots[0] != 0.0 || this.knots[this.knots.length - 1] != 1.0) {
            bl = false;
        }
        if (bl) {
            return this.cp(0).eq(this.cp(this.cpNum() - 1));
        }
        return this.pt2d(0.0).eq(this.pt2d(1.0));
    }

    @Override
    public ITrimCurve rev() {
        super.rev();
        return this;
    }

    @Override
    public ITrimCurve add(double d, double d2, double d3) {
        super.add(d, d2, d3);
        return this;
    }

    @Override
    public ITrimCurve add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ITrimCurve add(IVecI iVecI) {
        super.add(iVecI);
        return this;
    }

    @Override
    public ITrimCurve sub(double d, double d2, double d3) {
        super.sub(d, d2, d3);
        return this;
    }

    @Override
    public ITrimCurve sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ITrimCurve sub(IVecI iVecI) {
        super.sub(iVecI);
        return this;
    }

    @Override
    public ITrimCurve mul(IDoubleI iDoubleI) {
        super.mul(iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve mul(double d) {
        super.mul(d);
        return this;
    }

    @Override
    public ITrimCurve div(IDoubleI iDoubleI) {
        super.div(iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve div(double d) {
        super.div(d);
        return this;
    }

    @Override
    public ITrimCurve neg() {
        super.neg();
        return this;
    }

    @Override
    public ITrimCurve flip() {
        return this.neg();
    }

    @Override
    public ITrimCurve add(IVecI iVecI, double d) {
        super.add(iVecI, d);
        return this;
    }

    @Override
    public ITrimCurve add(IVecI iVecI, IDoubleI iDoubleI) {
        super.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public ITrimCurve add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public ITrimCurve rot(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve rot(double d) {
        super.rot(d);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, double d) {
        super.rot(iVecI, d);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, double d) {
        super.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2) {
        super.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public ITrimCurve rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public ITrimCurve rot2(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve rot2(double d) {
        super.rot(d);
        return this;
    }

    @Override
    public ITrimCurve rot2(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve rot2(IVecI iVecI, double d) {
        super.rot2(iVecI, d);
        return this;
    }

    @Override
    public ITrimCurve rot2(IVecI iVecI) {
        super.rot2(iVecI);
        return this;
    }

    @Override
    public ITrimCurve rot2(IVecI iVecI, IVecI iVecI2) {
        super.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public ITrimCurve scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public ITrimCurve scale(double d) {
        return this.mul(d);
    }

    @Override
    public ITrimCurve scale(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ITrimCurve scale(IVecI iVecI, double d) {
        super.scale(iVecI, d);
        return this;
    }

    @Override
    public ITrimCurve ref(IVecI iVecI) {
        super.ref(iVecI);
        return this;
    }

    @Override
    public ITrimCurve ref(IVecI iVecI, IVecI iVecI2) {
        super.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public ITrimCurve mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public ITrimCurve mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public ITrimCurve shear(double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ITrimCurve shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ITrimCurve shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ITrimCurve shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ITrimCurve shearXY(double d, double d2) {
        super.shearXY(d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve shearXY(IVecI iVecI, double d, double d2) {
        super.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve shearYZ(double d, double d2) {
        super.shearYZ(d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve shearYZ(IVecI iVecI, double d, double d2) {
        super.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve shearZX(double d, double d2) {
        super.shearZX(d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve shearZX(IVecI iVecI, double d, double d2) {
        super.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public ITrimCurve shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ITrimCurve translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ITrimCurve translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITrimCurve translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ITrimCurve transform(IMatrix3I iMatrix3I) {
        super.transform(iMatrix3I);
        return this;
    }

    @Override
    public ITrimCurve transform(IMatrix4I iMatrix4I) {
        super.transform(iMatrix4I);
        return this;
    }

    @Override
    public ITrimCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public ITrimCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public ITrimCurve mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ITrimCurve mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITrimCurve mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ITrimCurve cp() {
        return this.dup();
    }

    @Override
    public ITrimCurve cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public ITrimCurve cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ITrimCurve cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

