/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IComparator;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.IDynamicServer;
import igeo.IDynamicsBase;
import igeo.IG;
import igeo.ILayer;
import igeo.IObject;
import igeo.IOut;
import igeo.IParticle;
import igeo.IParticleAgent;
import igeo.IParticleI;
import igeo.IParticleOnCurve;
import igeo.IServer;
import igeo.ISort;
import igeo.ISpacingEqualizer;
import igeo.IStraightenerCurve;
import igeo.ITensionLine;
import igeo.ITensionOnCurve;
import igeo.IVec;
import igeo.IVecI;
import java.awt.Color;
import java.util.ArrayList;

public class ITensileNet {
    public static double friction = 0.005;
    public static double tension = 1.0;
    public static double onRailTension = 1.0;
    public static double straightenerTension = 1.0;
    public static double equalizerTension = 1.0;
    public static boolean constantTension = false;
    public static double tolerance = IConfig.tolerance;
    public static double railTolerance = IConfig.tolerance;
    public static Color pointColor = new Color(255, 255, 255);
    public static Color railPointColor = new Color(192, 192, 192);
    public static Color fixedPointColor = new Color(255, 255, 0);
    public static Color straightenerColor = new Color(255, 128, 0);
    public static String pointLayer = "nodes";
    public static String fixedPointLayer = "fixedNodes";
    public static String straightenerLayer = "straightener";
    public static String equalizerLayer = "equalizer";
    public static boolean fixOpenLinePoint = true;
    public static boolean deleteInputLine = true;
    public static boolean tensionOnSameRail = true;
    public static boolean fixPointOnRailEnd = true;
    public static boolean fixPointNotOnRail = true;
    public static boolean enableStraightener = false;
    public static double straightenerThresholdAngle = 1.0471975511965976;
    public static boolean noBranchingStraightener = true;
    public static boolean enableSpacingEqualizer = false;
    public ArrayList<ITensionLine> links;
    public ArrayList<IParticleAgent> nodes;

    ITensileNet() {
    }

    ITensileNet(ArrayList<ITensionLine> arrayList, ArrayList<IParticleAgent> arrayList2) {
        this.links = arrayList;
        this.nodes = arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray) {
        int n;
        IVec[] iVecArray;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray2 = new IVec[iCurveIArray.length][2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iVecArray2[i][0] = iCurveIArray[i].start().get();
            iVecArray2[i][1] = iCurveIArray[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray.length];
        IServer iServer = null;
        if (deleteInputLine) {
            for (n3 = 0; n3 < iCurveIArray.length; ++n3) {
                if (!(iCurveIArray[n3] instanceof IObject)) continue;
                colorArray[n3] = ((IObject)((Object)iCurveIArray[n3])).clr();
                iLayerArray[n3] = ((IObject)((Object)iCurveIArray[n3])).layer();
                ((IObject)((Object)iCurveIArray[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray[n3])).server();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray2.length; ++n3) {
            IVec[] iVecArray3 = iVecArray2[n3];
            if (iVecArray3[1].eq(iVecArray3[0], tolerance)) {
                iVecArray3[1] = iVecArray3[0];
            }
            for (n2 = n3 + 1; n2 < iVecArray2.length; ++n2) {
                iVecArray = iVecArray2[n2];
                for (n = 0; n < 2; ++n) {
                    if (iVecArray[n].eq(iVecArray3[0], tolerance)) {
                        iVecArray[n] = iVecArray3[0];
                        continue;
                    }
                    if (!iVecArray[n].eq(iVecArray3[1], tolerance)) continue;
                    iVecArray[n] = iVecArray3[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (n2 = 0; n2 < 2; ++n2) {
                iVecArray = iVecArray2[i][n2];
                if (arrayList.contains(iVecArray)) continue;
                arrayList.add(iVecArray);
            }
        }
        if (fixOpenLinePoint) {
            ArrayList arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray2.length; ++n) {
                    if (iVecArray2[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray2[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
            if (iVecIArray != null) {
                for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                    arrayList2.add(iVecIArray[n2]);
                }
            }
            iVecIArray = arrayList2.toArray(new IVecI[arrayList2.size()]);
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            Object object;
            IParticleI iParticleI;
            ArrayList<IParticleAgent> arrayList3 = new ArrayList<IParticleAgent>();
            for (n = 0; n < arrayList.size(); ++n) {
                IParticleAgent iParticleAgent = new IParticleAgent((IVec)arrayList.get(n));
                iParticleAgent.fric(friction);
                iParticleAgent.clr(pointColor);
                arrayList3.add(iParticleAgent);
                if (pointLayer == null) continue;
                iParticleAgent.layer(IG.layer(pointLayer).clr(pointColor));
            }
            if (iVecIArray != null) {
                for (n = 0; n < iVecIArray.length; ++n) {
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        if (!iVecIArray[n].eq(arrayList3.get(i), tolerance)) continue;
                        arrayList3.get(i).fix();
                        arrayList3.get(i).clr(fixedPointColor);
                        if (fixedPointLayer == null) continue;
                        arrayList3.get(i).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                    }
                }
            }
            ArrayList<ITensionLine> arrayList4 = new ArrayList<ITensionLine>();
            for (int i = 0; i < iVecArray2.length; ++i) {
                IVec[] iVecArray4 = iVecArray2[i];
                int n5 = arrayList.indexOf(iVecArray4[0]);
                int n6 = arrayList.indexOf(iVecArray4[1]);
                if (n5 >= 0 && n6 >= 0) {
                    IParticleI iParticleI2 = arrayList3.get(n5);
                    iParticleI = arrayList3.get(n6);
                    object = new ITensionLine(iParticleI2, iParticleI, tension);
                    if (colorArray[i] != null) {
                        ((ICurve)object).clr(colorArray[i]);
                    }
                    if (iLayerArray[i] != null) {
                        ((ICurve)object).layer(iLayerArray[i]);
                    }
                    ((ITensionLine)object).tension(tension);
                    ((ITensionLine)object).constant(constantTension);
                    arrayList4.add((ITensionLine)object);
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (enableStraightener) {
                Object object2;
                IParticleI iParticleI3;
                IParticleI iParticleI4;
                int n7;
                ArrayList<IStraightenerCurve> arrayList5 = new ArrayList<IStraightenerCurve>();
                for (n7 = 0; n7 < arrayList4.size(); ++n7) {
                    IParticleI iParticleI5 = arrayList4.get(n7).pt(0);
                    IParticleI iParticleI6 = arrayList4.get(n7).pt(1);
                    for (int i = n7 + 1; i < arrayList4.size(); ++i) {
                        iParticleI = arrayList4.get(i).pt(0);
                        object = arrayList4.get(i).pt(1);
                        iParticleI4 = null;
                        iParticleI3 = null;
                        object2 = null;
                        if (iParticleI5 == iParticleI) {
                            iParticleI4 = iParticleI6;
                            iParticleI3 = iParticleI5;
                            object2 = object;
                        } else if (iParticleI5 == object) {
                            iParticleI4 = iParticleI6;
                            iParticleI3 = iParticleI5;
                            object2 = iParticleI;
                        } else if (iParticleI6 == iParticleI) {
                            iParticleI4 = iParticleI5;
                            iParticleI3 = iParticleI6;
                            object2 = object;
                        } else if (iParticleI6 == object) {
                            iParticleI4 = iParticleI5;
                            iParticleI3 = iParticleI6;
                            object2 = iParticleI;
                        }
                        if (iParticleI4 == null || iParticleI3 == null || object2 == null || !(Math.abs(iParticleI3.pos().diff(iParticleI4.pos()).angle(object2.pos().diff(iParticleI3.pos()))) < straightenerThresholdAngle)) continue;
                        IStraightenerCurve iStraightenerCurve = new IStraightenerCurve(iParticleI4, iParticleI3, (IParticleI)object2);
                        iStraightenerCurve.tension(straightenerTension);
                        iStraightenerCurve.clr(straightenerColor);
                        iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                        arrayList5.add(iStraightenerCurve);
                    }
                }
                if (noBranchingStraightener) {
                    for (n7 = 0; n7 < arrayList5.size(); ++n7) {
                        IParticleI iParticleI7 = ((IStraightenerCurve)arrayList5.get(n7)).pt(0);
                        IParticleI iParticleI8 = ((IStraightenerCurve)arrayList5.get(n7)).pt(1);
                        IParticleI iParticleI9 = ((IStraightenerCurve)arrayList5.get(n7)).pt(2);
                        boolean bl = false;
                        for (int i = n7 + 1; i < arrayList5.size() && !bl; ++i) {
                            iParticleI4 = ((IStraightenerCurve)arrayList5.get(i)).pt(0);
                            iParticleI3 = ((IStraightenerCurve)arrayList5.get(i)).pt(1);
                            object2 = ((IStraightenerCurve)arrayList5.get(i)).pt(2);
                            if (iParticleI8 != iParticleI3 || iParticleI7 != iParticleI4 && iParticleI7 != object2 && iParticleI9 != iParticleI4 && iParticleI9 != object2) continue;
                            double d = iParticleI8.pos().diff(iParticleI7.pos()).angle(iParticleI9.pos().diff(iParticleI8.pos()));
                            double d2 = iParticleI3.pos().diff(iParticleI4.pos()).angle(object2.pos().diff(iParticleI3.pos()));
                            if (Math.abs(d) < Math.abs(d2)) {
                                ((IStraightenerCurve)arrayList5.get(i)).del();
                                arrayList5.remove(i);
                                --i;
                                continue;
                            }
                            ((IStraightenerCurve)arrayList5.get(n7)).del();
                            arrayList5.remove(n7);
                            --n7;
                            --i;
                            bl = true;
                        }
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray) {
        int n;
        IVec[] iVecArray;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            return ITensileNet.create(iCurveIArray2, iVecIArray);
        }
        if (iCurveIArray2 == null || iCurveIArray2.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray2 = new IVec[iCurveIArray2.length][2];
        for (int i = 0; i < iCurveIArray2.length; ++i) {
            iVecArray2[i][0] = iCurveIArray2[i].start().get();
            iVecArray2[i][1] = iCurveIArray2[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray2.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray2.length];
        IServer iServer = null;
        if (deleteInputLine) {
            for (n3 = 0; n3 < iCurveIArray2.length; ++n3) {
                if (!(iCurveIArray2[n3] instanceof IObject)) continue;
                colorArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).clr();
                iLayerArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).layer();
                ((IObject)((Object)iCurveIArray2[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray2[n3])).server();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray2.length; ++n3) {
            IVec[] iVecArray3 = iVecArray2[n3];
            if (iVecArray3[1].eq(iVecArray3[0], tolerance)) {
                iVecArray3[1] = iVecArray3[0];
            }
            for (n2 = n3 + 1; n2 < iVecArray2.length; ++n2) {
                iVecArray = iVecArray2[n2];
                for (n = 0; n < 2; ++n) {
                    if (iVecArray[n].eq(iVecArray3[0], tolerance)) {
                        iVecArray[n] = iVecArray3[0];
                        continue;
                    }
                    if (!iVecArray[n].eq(iVecArray3[1], tolerance)) continue;
                    iVecArray[n] = iVecArray3[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (n2 = 0; n2 < 2; ++n2) {
                iVecArray = iVecArray2[i][n2];
                if (arrayList.contains(iVecArray)) continue;
                arrayList.add(iVecArray);
            }
        }
        ArrayList arrayList2 = null;
        if (fixOpenLinePoint) {
            arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray2.length; ++n) {
                    if (iVecArray2[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray2[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            blArray[i] = false;
            if (iVecIArray == null) continue;
            for (n = 0; n < iVecIArray.length && !blArray[i]; ++n) {
                if (!iVecIArray[n].eq((IVecI)arrayList.get(i), tolerance)) continue;
                blArray[i] = true;
            }
        }
        ArrayList[] arrayListArray = null;
        if (tensionOnSameRail || enableSpacingEqualizer) {
            ArrayList[] arrayListArray2;
            arrayListArray = arrayListArray2 = new ArrayList[iCurveIArray.length];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            Object object;
            IParticleI iParticleI;
            int n5;
            int n6;
            int n7;
            Object object2;
            ArrayList<IParticleAgent> arrayList3 = new ArrayList<IParticleAgent>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.size() > 100 && i % 100 == 0) {
                    IOut.debug(0, "finding curve for point to be on (" + i + "/" + arrayList.size() + ")");
                }
                IParticleOnCurve iParticleOnCurve = ITensileNet.createParticleOnClosestCurve(iCurveIArray, (IVec)arrayList.get(i), railTolerance, 0.001);
                object2 = null;
                if (iParticleOnCurve != null) {
                    object2 = new IParticleAgent(iParticleOnCurve);
                    ((IParticleAgent)object2).clr(railPointColor);
                    if (pointLayer != null) {
                        ((IParticleAgent)object2).layer(IG.layer(pointLayer).clr(pointColor));
                    }
                } else {
                    object2 = new IParticleAgent((IVec)arrayList.get(i));
                    if (fixPointNotOnRail || fixOpenLinePoint && arrayList2 != null && arrayList2.contains(arrayList.get(i))) {
                        ((IParticleAgent)object2).fix();
                        ((IParticleAgent)object2).clr(fixedPointColor);
                        if (fixedPointLayer != null) {
                            ((IParticleAgent)object2).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                        }
                    } else {
                        ((IParticleAgent)object2).clr(pointColor);
                        if (pointLayer != null) {
                            ((IParticleAgent)object2).layer(IG.layer(pointLayer).clr(pointColor));
                        }
                    }
                }
                ((IParticleAgent)object2).fric(friction);
                arrayList3.add((IParticleAgent)object2);
                if (blArray[i]) {
                    ((IParticleAgent)object2).fix();
                    ((IParticleAgent)object2).clr(fixedPointColor);
                    if (fixedPointLayer != null) {
                        ((IParticleAgent)object2).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                    }
                }
                if (iParticleOnCurve == null) continue;
                if (tensionOnSameRail || enableSpacingEqualizer) {
                    n7 = -1;
                    for (n6 = 0; n6 < iCurveIArray.length && n7 < 0; ++n6) {
                        if (iCurveIArray[n6] != iParticleOnCurve.curve()) continue;
                        n7 = n6;
                    }
                    if (n7 >= 0) {
                        arrayListArray[n7].add(iParticleOnCurve);
                    }
                }
                if (!fixPointOnRailEnd || !(iParticleOnCurve.upos() < IConfig.parameterTolerance) && !(iParticleOnCurve.upos() > 1.0 - IConfig.parameterTolerance)) continue;
                iParticleOnCurve.fix();
                if (object2 == null) continue;
                ((IParticleAgent)object2).clr(fixedPointColor);
                if (fixedPointLayer == null) continue;
                ((IParticleAgent)object2).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
            }
            ArrayList<ITensionLine> arrayList4 = new ArrayList<ITensionLine>();
            for (n5 = 0; n5 < iVecArray2.length; ++n5) {
                object2 = iVecArray2[n5];
                n7 = arrayList.indexOf(object2[0]);
                n6 = arrayList.indexOf(object2[1]);
                if (n7 >= 0 && n6 >= 0) {
                    IParticleI iParticleI2 = arrayList3.get(n7);
                    iParticleI = arrayList3.get(n6);
                    object = new ITensionLine(iParticleI2, iParticleI, tension);
                    if (colorArray[n5] != null) {
                        ((ICurve)object).clr(colorArray[n5]);
                    }
                    if (iLayerArray[n5] != null) {
                        ((ICurve)object).layer(iLayerArray[n5]);
                    }
                    ((ITensionLine)object).tension(tension);
                    ((ITensionLine)object).constant(constantTension);
                    arrayList4.add((ITensionLine)object);
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (tensionOnSameRail || enableSpacingEqualizer) {
                for (n5 = 0; n5 < iCurveIArray.length; ++n5) {
                    IDynamicsBase iDynamicsBase;
                    if (arrayListArray[n5].size() <= 1) continue;
                    ISort.sort(arrayListArray[n5], new IParticleOnCurveComparator());
                    boolean bl = iCurveIArray[n5].isClosed();
                    if (tensionOnSameRail) {
                        for (n7 = 0; !bl && n7 < arrayListArray[n5].size() - 1 || bl && n7 < arrayListArray[n5].size(); ++n7) {
                            iDynamicsBase = new ITensionOnCurve((IParticleOnCurve)arrayListArray[n5].get(n7), (IParticleOnCurve)arrayListArray[n5].get((n7 + 1) % arrayListArray[n5].size()), onRailTension);
                        }
                    }
                    if (!enableSpacingEqualizer) continue;
                    for (n7 = 0; !bl && n7 < arrayListArray[n5].size() - 2 || bl && n7 < arrayListArray[n5].size(); ++n7) {
                        iDynamicsBase = new ISpacingEqualizer((IParticle)arrayListArray[n5].get(n7), (IParticle)arrayListArray[n5].get((n7 + 1) % arrayListArray[n5].size()), (IParticle)arrayListArray[n5].get((n7 + 2) % arrayListArray[n5].size())).tension(equalizerTension);
                    }
                }
            }
            if (enableStraightener) {
                Object object3;
                IParticleI iParticleI3;
                IParticleI iParticleI4;
                int n8;
                ArrayList<IStraightenerCurve> arrayList5 = new ArrayList<IStraightenerCurve>();
                for (n8 = 0; n8 < arrayList4.size(); ++n8) {
                    IParticleI iParticleI5 = arrayList4.get(n8).pt(0);
                    IParticleI iParticleI6 = arrayList4.get(n8).pt(1);
                    for (int i = n8 + 1; i < arrayList4.size(); ++i) {
                        iParticleI = arrayList4.get(i).pt(0);
                        object = arrayList4.get(i).pt(1);
                        iParticleI4 = null;
                        iParticleI3 = null;
                        object3 = null;
                        if (iParticleI5 == iParticleI) {
                            iParticleI4 = iParticleI6;
                            iParticleI3 = iParticleI5;
                            object3 = object;
                        } else if (iParticleI5 == object) {
                            iParticleI4 = iParticleI6;
                            iParticleI3 = iParticleI5;
                            object3 = iParticleI;
                        } else if (iParticleI6 == iParticleI) {
                            iParticleI4 = iParticleI5;
                            iParticleI3 = iParticleI6;
                            object3 = object;
                        } else if (iParticleI6 == object) {
                            iParticleI4 = iParticleI5;
                            iParticleI3 = iParticleI6;
                            object3 = iParticleI;
                        }
                        if (iParticleI4 == null || iParticleI3 == null || object3 == null || !(Math.abs(iParticleI3.pos().diff(iParticleI4.pos()).angle(object3.pos().diff(iParticleI3.pos()))) < straightenerThresholdAngle)) continue;
                        IStraightenerCurve iStraightenerCurve = new IStraightenerCurve(iParticleI4, iParticleI3, (IParticleI)object3);
                        iStraightenerCurve.tension(straightenerTension);
                        iStraightenerCurve.clr(straightenerColor);
                        iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                        arrayList5.add(iStraightenerCurve);
                    }
                }
                if (noBranchingStraightener) {
                    for (n8 = 0; n8 < arrayList5.size(); ++n8) {
                        IParticleI iParticleI7 = ((IStraightenerCurve)arrayList5.get(n8)).pt(0);
                        IParticleI iParticleI8 = ((IStraightenerCurve)arrayList5.get(n8)).pt(1);
                        IParticleI iParticleI9 = ((IStraightenerCurve)arrayList5.get(n8)).pt(2);
                        boolean bl = false;
                        for (int i = n8 + 1; i < arrayList5.size() && !bl; ++i) {
                            iParticleI4 = ((IStraightenerCurve)arrayList5.get(i)).pt(0);
                            iParticleI3 = ((IStraightenerCurve)arrayList5.get(i)).pt(1);
                            object3 = ((IStraightenerCurve)arrayList5.get(i)).pt(2);
                            if (iParticleI8 != iParticleI3 || iParticleI7 != iParticleI4 && iParticleI7 != object3 && iParticleI9 != iParticleI4 && iParticleI9 != object3) continue;
                            double d = iParticleI8.pos().diff(iParticleI7.pos()).angle(iParticleI9.pos().diff(iParticleI8.pos()));
                            double d2 = iParticleI3.pos().diff(iParticleI4.pos()).angle(object3.pos().diff(iParticleI3.pos()));
                            if (Math.abs(d) < Math.abs(d2)) {
                                ((IStraightenerCurve)arrayList5.get(i)).del();
                                arrayList5.remove(i);
                                --i;
                                continue;
                            }
                            ((IStraightenerCurve)arrayList5.get(n8)).del();
                            arrayList5.remove(n8);
                            --n8;
                            --i;
                            bl = true;
                        }
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray) {
        int n;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (n = 0; n < iCurveIArray3.length; ++n) {
            int n2;
            IVec iVec;
            IVec iVec2 = iCurveIArray3[n].start().get();
            if (iVec2.eq(iVec = iCurveIArray3[n].end().get(), tolerance)) {
                iVec = null;
            }
            for (n2 = 0; n2 < arrayList.size() && iVec2 != null; ++n2) {
                if (!iVec2.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec2 = null;
            }
            if (iVec2 != null) {
                arrayList.add(iVec2);
            }
            for (n2 = 0; n2 < arrayList.size() && iVec != null; ++n2) {
                if (!iVec.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec = null;
            }
            if (iVec == null) continue;
            arrayList.add(iVec);
        }
        for (n = 0; iVecIArray != null && n < iVecIArray.length; ++n) {
            arrayList.add(iVecIArray[n]);
        }
        return ITensileNet.create(iCurveIArray, iCurveIArray2, arrayList.toArray(new IVecI[arrayList.size()]));
    }

    public static ICurveI findClosestCurve(ICurveI[] iCurveIArray, IVec iVec, int n) {
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j <= n; ++j) {
                double d2 = iCurveIArray[i].pt((double)j / (double)n).dist(iVec);
                if (n2 >= 0 && !(d2 < d)) continue;
                n2 = i;
                d = d2;
            }
        }
        if (n2 < 0) {
            return null;
        }
        return iCurveIArray[n2];
    }

    public static IParticleOnCurve createParticleOnClosestCurve(ICurveI[] iCurveIArray, IVec iVec, double d, double d2) {
        IParticleOnCurve iParticleOnCurve = null;
        do {
            ICurveI iCurveI = null;
            iCurveI = iCurveIArray.length == 1 ? iCurveIArray[0] : ITensileNet.findClosestCurve(iCurveIArray, iVec, 20);
            iParticleOnCurve = ITensileNet.createParticleOnCurve(iCurveI, iVec, d, d2);
            if (iParticleOnCurve != null) continue;
            if (iCurveIArray.length > 1) {
                ICurveI[] iCurveIArray2 = new ICurveI[iCurveIArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n < iCurveIArray.length) {
                    if (iCurveIArray[n] != iCurveI) {
                        iCurveIArray2[n2] = iCurveIArray[n];
                    } else {
                        --n2;
                    }
                    ++n;
                    ++n2;
                }
                iCurveIArray = iCurveIArray2;
                continue;
            }
            return null;
        } while (iParticleOnCurve == null && iCurveIArray.length > 1);
        return iParticleOnCurve;
    }

    public static IParticleOnCurve createParticleOnCurve(ICurveI iCurveI, IVec iVec, double d, double d2) {
        int n = 0;
        if (iCurveI == null) {
            return null;
        }
        n = d2 == 0.0 ? 10000 : (int)(1.0 / d2 + 0.5);
        double d3 = -1.0;
        double d4 = -1.0;
        for (int i = 0; i <= n; ++i) {
            double d5 = (double)i / (double)n;
            double d6 = iCurveI.pt(d5).dist(iVec);
            if (!(d4 < 0.0) && !(d6 < d3)) continue;
            d3 = d6;
            d4 = d5;
        }
        if (d4 >= 0.0) {
            IVec iVec2 = iCurveI.pt(d4).get();
            IVec iVec3 = iCurveI.tan(d4).get();
            double d7 = iVec3.len2();
            double d8 = iVec.diff(iVec2).dot(iVec3) / d7;
            if ((d4 += d8) < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d3 = iCurveI.pt(d4).dist(iVec);
        }
        if (d >= 0.0 && d3 > d) {
            return null;
        }
        return new IParticleOnCurve(iCurveI, d4, iVec);
    }

    public static class IParticleOnCurveComparator
    implements IComparator<IParticleOnCurve> {
        @Override
        public int compare(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2) {
            if (iParticleOnCurve.upos() < iParticleOnCurve2.upos()) {
                return -1;
            }
            if (iParticleOnCurve.upos() > iParticleOnCurve2.upos()) {
                return 1;
            }
            return 0;
        }
    }
}

