/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDoubleI;
import igeo.IMatrix;
import igeo.IMatrix4I;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;

public class IMatrix4
extends IMatrix
implements IMatrix4I {
    public IMatrix4() {
        super(4, 4);
        this.setZero();
    }

    public IMatrix4(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        super(4, 4);
        this.set(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public IMatrix4(IMatrix4 iMatrix4) {
        super(4, 4);
        this.set(iMatrix4.val);
    }

    public IMatrix4 get() {
        return this;
    }

    public IMatrix4 set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.val[0][0] = d;
        this.val[0][1] = d2;
        this.val[0][2] = d3;
        this.val[0][3] = d4;
        this.val[1][0] = d5;
        this.val[1][1] = d6;
        this.val[1][2] = d7;
        this.val[1][3] = d8;
        this.val[2][0] = d9;
        this.val[2][1] = d10;
        this.val[2][2] = d11;
        this.val[2][3] = d12;
        this.val[3][0] = d13;
        this.val[3][1] = d14;
        this.val[3][2] = d15;
        this.val[3][3] = d16;
        return this;
    }

    public IMatrix4 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6, IDoubleI iDoubleI7, IDoubleI iDoubleI8, IDoubleI iDoubleI9, IDoubleI iDoubleI10, IDoubleI iDoubleI11, IDoubleI iDoubleI12, IDoubleI iDoubleI13, IDoubleI iDoubleI14, IDoubleI iDoubleI15, IDoubleI iDoubleI16) {
        return this.set(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x(), iDoubleI4.x(), iDoubleI5.x(), iDoubleI6.x(), iDoubleI7.x(), iDoubleI8.x(), iDoubleI9.x(), iDoubleI10.x(), iDoubleI11.x(), iDoubleI12.x(), iDoubleI13.x(), iDoubleI14.x(), iDoubleI15.x(), iDoubleI16.x());
    }

    public IMatrix4 dup() {
        return new IMatrix4(this);
    }

    public double determinant() {
        return IMatrix4.det(this.val[0][0], this.val[0][1], this.val[1][0], this.val[1][1]) * IMatrix4.det(this.val[2][2], this.val[2][3], this.val[3][2], this.val[3][3]) + IMatrix4.det(this.val[0][0], this.val[0][2], this.val[1][0], this.val[1][2]) * IMatrix4.det(this.val[2][3], this.val[2][1], this.val[3][3], this.val[3][1]) + IMatrix4.det(this.val[0][0], this.val[0][3], this.val[1][0], this.val[1][3]) * IMatrix4.det(this.val[2][1], this.val[2][2], this.val[3][1], this.val[3][2]) + IMatrix4.det(this.val[0][1], this.val[0][2], this.val[1][1], this.val[1][2]) * IMatrix4.det(this.val[2][0], this.val[2][3], this.val[3][0], this.val[3][3]) + IMatrix4.det(this.val[0][3], this.val[0][1], this.val[1][3], this.val[1][1]) * IMatrix4.det(this.val[2][0], this.val[2][2], this.val[3][0], this.val[3][2]) + IMatrix4.det(this.val[0][2], this.val[0][3], this.val[1][2], this.val[1][3]) * IMatrix4.det(this.val[2][0], this.val[2][1], this.val[3][0], this.val[3][1]);
    }

    public IMatrix4 invert() {
        double d = this.determinant();
        this.set(this.val[1][1] * IMatrix4.det(this.val[2][2], this.val[2][3], this.val[3][2], this.val[3][3]) + this.val[1][2] * IMatrix4.det(this.val[2][3], this.val[2][1], this.val[3][3], this.val[3][1]) + this.val[1][3] * IMatrix4.det(this.val[2][1], this.val[2][2], this.val[3][1], this.val[3][2]), this.val[2][1] * IMatrix4.det(this.val[0][2], this.val[0][3], this.val[3][2], this.val[3][3]) + this.val[2][2] * IMatrix4.det(this.val[0][3], this.val[0][1], this.val[3][3], this.val[3][1]) + this.val[2][3] * IMatrix4.det(this.val[0][1], this.val[0][2], this.val[3][1], this.val[3][2]), this.val[3][1] * IMatrix4.det(this.val[0][2], this.val[0][3], this.val[1][2], this.val[1][3]) + this.val[3][2] * IMatrix4.det(this.val[0][3], this.val[0][1], this.val[1][3], this.val[1][1]) + this.val[3][3] * IMatrix4.det(this.val[0][1], this.val[0][2], this.val[1][1], this.val[1][2]), this.val[0][1] * IMatrix4.det(this.val[1][3], this.val[1][2], this.val[2][3], this.val[2][2]) + this.val[0][2] * IMatrix4.det(this.val[1][1], this.val[1][3], this.val[2][1], this.val[2][3]) + this.val[0][3] * IMatrix4.det(this.val[1][2], this.val[1][1], this.val[2][2], this.val[2][1]), this.val[1][2] * IMatrix4.det(this.val[2][0], this.val[2][3], this.val[3][0], this.val[3][3]) + this.val[1][3] * IMatrix4.det(this.val[2][2], this.val[2][0], this.val[3][2], this.val[3][0]) + this.val[1][0] * IMatrix4.det(this.val[2][3], this.val[2][2], this.val[3][3], this.val[3][2]), this.val[2][2] * IMatrix4.det(this.val[0][0], this.val[0][3], this.val[3][0], this.val[3][3]) + this.val[2][3] * IMatrix4.det(this.val[0][2], this.val[0][0], this.val[3][2], this.val[3][0]) + this.val[2][0] * IMatrix4.det(this.val[0][3], this.val[0][2], this.val[3][3], this.val[3][2]), this.val[3][2] * IMatrix4.det(this.val[0][0], this.val[0][3], this.val[1][0], this.val[1][3]) + this.val[3][3] * IMatrix4.det(this.val[0][2], this.val[0][0], this.val[1][2], this.val[1][0]) + this.val[3][0] * IMatrix4.det(this.val[0][3], this.val[0][2], this.val[1][3], this.val[1][2]), this.val[0][2] * IMatrix4.det(this.val[1][3], this.val[1][0], this.val[2][3], this.val[2][0]) + this.val[0][3] * IMatrix4.det(this.val[1][0], this.val[1][2], this.val[2][0], this.val[2][2]) + this.val[0][0] * IMatrix4.det(this.val[1][2], this.val[1][3], this.val[2][2], this.val[2][3]), this.val[1][3] * IMatrix4.det(this.val[2][0], this.val[2][1], this.val[3][0], this.val[3][1]) + this.val[1][0] * IMatrix4.det(this.val[2][1], this.val[2][3], this.val[3][1], this.val[3][3]) + this.val[1][1] * IMatrix4.det(this.val[2][3], this.val[2][0], this.val[3][3], this.val[3][0]), this.val[2][3] * IMatrix4.det(this.val[0][0], this.val[0][1], this.val[3][0], this.val[3][1]) + this.val[2][0] * IMatrix4.det(this.val[0][1], this.val[0][3], this.val[3][1], this.val[3][3]) + this.val[2][1] * IMatrix4.det(this.val[0][3], this.val[0][0], this.val[3][3], this.val[3][0]), this.val[3][3] * IMatrix4.det(this.val[0][0], this.val[0][1], this.val[1][0], this.val[1][1]) + this.val[3][0] * IMatrix4.det(this.val[0][1], this.val[0][3], this.val[1][1], this.val[1][3]) + this.val[3][1] * IMatrix4.det(this.val[0][3], this.val[0][0], this.val[1][3], this.val[1][0]), this.val[0][3] * IMatrix4.det(this.val[1][1], this.val[1][0], this.val[2][1], this.val[2][0]) + this.val[0][0] * IMatrix4.det(this.val[1][3], this.val[1][1], this.val[2][3], this.val[2][1]) + this.val[0][1] * IMatrix4.det(this.val[1][0], this.val[1][3], this.val[2][0], this.val[2][3]), this.val[1][0] * IMatrix4.det(this.val[2][2], this.val[2][1], this.val[3][2], this.val[3][1]) + this.val[1][1] * IMatrix4.det(this.val[2][0], this.val[2][2], this.val[3][0], this.val[3][2]) + this.val[1][2] * IMatrix4.det(this.val[2][1], this.val[2][0], this.val[3][1], this.val[3][0]), this.val[2][0] * IMatrix4.det(this.val[0][2], this.val[0][1], this.val[3][2], this.val[3][1]) + this.val[2][1] * IMatrix4.det(this.val[0][0], this.val[0][2], this.val[3][0], this.val[3][2]) + this.val[2][2] * IMatrix4.det(this.val[0][1], this.val[0][0], this.val[3][1], this.val[3][0]), this.val[3][0] * IMatrix4.det(this.val[0][2], this.val[0][1], this.val[1][2], this.val[1][1]) + this.val[3][1] * IMatrix4.det(this.val[0][0], this.val[0][2], this.val[1][0], this.val[1][2]) + this.val[3][2] * IMatrix4.det(this.val[0][1], this.val[0][0], this.val[1][1], this.val[1][0]), this.val[0][0] * IMatrix4.det(this.val[1][1], this.val[1][2], this.val[2][1], this.val[2][2]) + this.val[0][1] * IMatrix4.det(this.val[1][2], this.val[1][0], this.val[2][2], this.val[2][0]) + this.val[0][2] * IMatrix4.det(this.val[1][0], this.val[1][1], this.val[2][0], this.val[2][1]));
        this.div(d);
        return this;
    }

    public IMatrix4 mul(IMatrix4 iMatrix4) {
        for (int i = 0; i < 4; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int j = 0; j < 4; ++j) {
                d += this.val[i][j] * iMatrix4.val[j][0];
                d2 += this.val[i][j] * iMatrix4.val[j][1];
                d3 += this.val[i][j] * iMatrix4.val[j][2];
                d4 += this.val[i][j] * iMatrix4.val[j][3];
            }
            this.val[i][0] = d;
            this.val[i][1] = d2;
            this.val[i][2] = d3;
            this.val[i][3] = d4;
        }
        return this;
    }

    public IMatrix4 mul(IMatrix4I iMatrix4I) {
        return this.mul(iMatrix4I.get());
    }

    public IVec4 mul(IVec4I iVec4I) {
        IVec4 iVec4 = new IVec4();
        iVec4.x = this.val[0][0] * iVec4I.x() + this.val[0][1] * iVec4I.y() + this.val[0][2] * iVec4I.z() + this.val[0][3] * iVec4I.w();
        iVec4.y = this.val[1][0] * iVec4I.x() + this.val[1][1] * iVec4I.y() + this.val[1][2] * iVec4I.z() + this.val[1][3] * iVec4I.w();
        iVec4.z = this.val[2][0] * iVec4I.x() + this.val[2][1] * iVec4I.y() + this.val[2][2] * iVec4I.z() + this.val[2][3] * iVec4I.w();
        iVec4.w = this.val[3][0] * iVec4I.x() + this.val[3][1] * iVec4I.y() + this.val[3][2] * iVec4I.z() + this.val[3][3] * iVec4I.w();
        return iVec4;
    }

    public IVec mul(IVecI iVecI) {
        IVec iVec = new IVec();
        iVec.x = this.val[0][0] * iVecI.x() + this.val[0][1] * iVecI.y() + this.val[0][2] * iVecI.z() + this.val[0][3];
        iVec.y = this.val[1][0] * iVecI.x() + this.val[1][1] * iVecI.y() + this.val[1][2] * iVecI.z() + this.val[1][3];
        iVec.z = this.val[2][0] * iVecI.x() + this.val[2][1] * iVecI.y() + this.val[2][2] * iVecI.z() + this.val[2][3];
        return iVec;
    }

    public IVec transform(IVecI iVecI) {
        return this.mul(iVecI);
    }

    public static IMatrix4 getXRotation(double d) {
        return new IMatrix4(1.0, 0.0, 0.0, 0.0, 0.0, Math.cos(d), -Math.sin(d), 0.0, 0.0, Math.sin(d), Math.cos(d), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getYRotation(double d) {
        return new IMatrix4(Math.cos(d), 0.0, Math.sin(d), 0.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(d), 0.0, Math.cos(d), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getZRotation(double d) {
        return new IMatrix4(Math.cos(d), -Math.sin(d), 0.0, 0.0, Math.sin(d), Math.cos(d), 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getRotation(IVec iVec, double d) {
        IVec iVec2 = iVec.dup().unit();
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        return new IMatrix4(d4 * iVec2.x * iVec2.x + d3, iVec2.x * iVec2.y * d4 - iVec2.z * d2, iVec2.x * iVec2.z * d4 + iVec2.y * d2, 0.0, iVec2.x * iVec2.y * d4 + iVec2.z * d2, iVec2.y * iVec2.y * d4 + d3, iVec2.y * iVec2.z * d4 - iVec2.x * d2, 0.0, iVec2.x * iVec2.z * d4 - iVec2.y * d2, iVec2.y * iVec2.z * d4 + iVec2.x * d2, iVec2.z * iVec2.z * d4 + d3, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static IMatrix4 getScale(double d) {
        return new IMatrix4(d, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getTranslate(double d, double d2, double d3) {
        return new IMatrix4(1.0, 0.0, 0.0, d, 0.0, 1.0, 0.0, d2, 0.0, 0.0, 1.0, d3, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getTranslate(IVec iVec) {
        return new IMatrix4(1.0, 0.0, 0.0, iVec.x, 0.0, 1.0, 0.0, iVec.y, 0.0, 0.0, 1.0, iVec.z, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 getTransform(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        return new IMatrix4(iVec.x, iVec2.x, iVec3.x, iVec4.x, iVec.y, iVec2.y, iVec3.y, iVec4.y, iVec.z, iVec2.z, iVec3.z, iVec4.z, 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix4 convertCoordinates(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5, IVec iVec6, IVec iVec7, IVec iVec8) {
        IMatrix4 iMatrix4 = IMatrix4.getTransform(iVec, iVec2, iVec3, iVec4);
        IMatrix4 iMatrix42 = IMatrix4.getTransform(iVec5, iVec6, iVec7, iVec8);
        iMatrix4.invert();
        return iMatrix42.mul(iMatrix4);
    }

    public static IMatrix4 getAlignmentOnPlane(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5, IVec iVec6) {
        IVec iVec7;
        IVec iVec8 = iVec2.diff(iVec);
        IVec iVec9 = iVec8.cross(iVec7 = iVec3.diff(iVec));
        if (iVec9.len() == 0.0 && (iVec9 = iVec8.cross(IVec.zaxis)).len() == 0.0) {
            iVec9 = iVec8.cross(IVec.xaxis);
        }
        iVec9.unit();
        IVec iVec10 = iVec8;
        iVec10.unit();
        IVec iVec11 = iVec9.cross(iVec10);
        iVec11.unit();
        IVec iVec12 = iVec5.diff(iVec4);
        IVec iVec13 = iVec6.diff(iVec4);
        IVec iVec14 = iVec12.cross(iVec13);
        if (iVec14.len() == 0.0 && (iVec14 = iVec12.cross(IVec.zaxis)).len() == 0.0) {
            iVec14 = iVec12.cross(IVec.xaxis);
        }
        iVec14.unit();
        IVec iVec15 = iVec12;
        iVec15.unit();
        IVec iVec16 = iVec14.cross(iVec15);
        iVec16.unit();
        return IMatrix4.convertCoordinates(iVec10, iVec11, iVec9, iVec, iVec15, iVec16, iVec14, iVec4);
    }
}

