/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IBoundingBox;
import igeo.IConfig;
import igeo.IMatrix3;
import igeo.IMatrix4;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IPane;
import java.awt.Color;
import javax.media.opengl.GL;

public class IView {
    public static double defaultNear = IConfig.nearView;
    public static double defaultFar = IConfig.farView;
    public static double defaultAxonRatio = IConfig.axonometricRatio;
    public static double defaultPersRatio = IConfig.perspectiveRatio;
    public static double defaultViewDistance = IConfig.viewDistance;
    public static IGraphicMode defaultMode = new IGraphicMode(IGraphicMode.GraphicType.GL, true, true, true);
    public static float[] defaultGLLightPosition = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static float[] defaultGLAmbientLight = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    public static float[] defaultGLDiffuseLight = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static float[] defaultGLSpecularLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static boolean defaultGLTwoSidedLighting = false;
    public static double[][][] defaultGLBGColor = new double[][][]{new double[][]{{1.0, 1.0, 1.0}, {0.3, 0.5, 0.7}}, new double[][]{{0.9, 0.9, 0.9}, {0.3, 0.5, 0.7}}};
    public IVec pos;
    public double yaw;
    public double pitch;
    public double roll;
    public boolean axonometric = true;
    public int screenX;
    public int screenY;
    public int screenWidth;
    public int screenHeight;
    public double persRatio = defaultPersRatio;
    public double axonRatio = defaultAxonRatio;
    public double near = defaultNear;
    public double far = defaultFar;
    public IVec target;
    public boolean rotateAroundTarget = false;
    public double distToTarget;
    public double glWidth;
    public double glHeight;
    public IMatrix4 glTransformMatrix;
    public double[] glTransformArray;
    public boolean useGL = false;
    public boolean hide = false;
    public IPane pane;
    public IGraphicMode mode = new IGraphicMode(defaultMode);
    public double[][][] glBGColor = defaultGLBGColor;
    public Color javaBGColor1;
    public Color javaBGColor2;

    public IView(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3, int n4, boolean bl) {
        this.pos = new IVec(d, d2, d3);
        this.yaw = d4;
        this.pitch = d5;
        this.roll = d6;
        this.screenX = n;
        this.screenY = n2;
        this.screenWidth = n3;
        this.screenHeight = n4;
        this.axonometric = bl;
        this.target = new IVec();
    }

    public IView(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3, int n4) {
        this(d, d2, d3, d4, d5, d6, n, n2, n3, n4, true);
    }

    public IView(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos = new IVec(d, d2, d3);
        this.yaw = d4;
        this.pitch = d5;
        this.roll = d6;
        this.target = new IVec();
    }

    public IView(double d, double d2, double d3, double d4, double d5) {
        this.pos = new IVec(d, d2, d3);
        this.yaw = d4;
        this.pitch = d5;
        this.roll = 0.0;
        this.target = new IVec();
    }

    public void enableGL() {
        this.useGL = true;
        this.glTransformMatrix = new IMatrix4();
        this.glTransformArray = new double[16];
        this.update();
    }

    public void disableGL() {
        this.useGL = false;
    }

    public void setMode(IGraphicMode iGraphicMode) {
        this.mode = iGraphicMode;
    }

    public IGraphicMode mode() {
        return this.mode;
    }

    public boolean isHidden() {
        return this.hide;
    }

    public void hide() {
        this.hide = true;
    }

    public void show() {
        this.hide = false;
    }

    public void setBGColor(Color color) {
        if (this.useGL) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.glBGColor[i][j][0] = (double)color.getRed() / 255.0;
                    this.glBGColor[i][j][1] = (double)color.getGreen() / 255.0;
                    this.glBGColor[i][j][2] = (double)color.getBlue() / 255.0;
                }
            }
        } else {
            this.javaBGColor1 = color;
            this.javaBGColor2 = color;
        }
    }

    public void setBGColor(Color color, Color color2) {
        if (this.useGL) {
            for (int i = 0; i < 2; ++i) {
                this.glBGColor[i][0][0] = (double)color.getRed() / 255.0;
                this.glBGColor[i][0][1] = (double)color.getGreen() / 255.0;
                this.glBGColor[i][0][2] = (double)color.getBlue() / 255.0;
                this.glBGColor[i][1][0] = (double)color2.getRed() / 255.0;
                this.glBGColor[i][1][1] = (double)color2.getGreen() / 255.0;
                this.glBGColor[i][1][2] = (double)color2.getBlue() / 255.0;
            }
        } else {
            this.javaBGColor1 = color;
            this.javaBGColor2 = color2;
        }
    }

    public void setBGColor(Color color, Color color2, Color color3, Color color4) {
        this.setBGColor(new Color[][]{{color, color4}, {color2, color3}});
    }

    public void setBGColor(Color[][] colorArray) {
        if (this.useGL) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.glBGColor[i][j][0] = (double)colorArray[i][j].getRed() / 255.0;
                    this.glBGColor[i][j][1] = (double)colorArray[i][j].getGreen() / 255.0;
                    this.glBGColor[i][j][2] = (double)colorArray[i][j].getBlue() / 255.0;
                }
            }
        } else {
            this.javaBGColor1 = colorArray[0][0];
            this.javaBGColor2 = colorArray[0][1];
        }
    }

    public void setPane(IPane iPane) {
        this.pane = iPane;
        int n = this.screenHeight;
        this.screenX = this.pane.x;
        this.screenWidth = this.pane.width;
        this.screenHeight = this.pane.height;
        this.screenY = this.mode.isGL() ? this.pane.getPanel().height - (this.pane.y + this.pane.height) : this.pane.y;
        if (this.axonometric && this.screenHeight > 0 && n > 0) {
            this.axonRatio /= (double)this.screenHeight / (double)n;
        }
        this.update();
    }

    public void setScreen(int n, int n2, int n3, int n4) {
        this.screenX = n;
        this.screenY = n2;
        this.screenWidth = n3;
        this.screenHeight = n4;
        this.update();
    }

    public void setScreenSize(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.update();
    }

    public void setScreenPosition(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
    }

    public double getAxonometricRatio() {
        return this.axonRatio;
    }

    public double getPerspectiveRatio() {
        return this.persRatio;
    }

    public void setAxonometricRatio(double d) {
        this.axonRatio = d;
        this.axonometric = true;
        this.glWidth = (double)this.screenWidth * this.axonRatio;
        this.glHeight = (double)this.screenHeight * this.axonRatio;
        this.update();
    }

    public void setPerspectiveRatio(double d) {
        this.persRatio = d;
        this.axonometric = false;
        this.glWidth = this.near * this.persRatio * 2.0;
        this.glHeight = this.glWidth * (double)this.screenHeight / (double)this.screenWidth;
        this.update();
    }

    public void setPerspectiveAngle(double d) {
        this.setPerspectiveRatio(Math.tan(d / 2.0));
    }

    public void perspective() {
        this.axonometric = false;
    }

    public void axonometric() {
        this.axonometric = true;
    }

    public boolean isAxonometric() {
        return this.axonometric;
    }

    public void setTarget(double d, double d2, double d3) {
        this.target.set(d, d2, d3);
    }

    public void setTarget(IVecI iVecI) {
        this.target.set(iVecI);
    }

    public void enableRotationAroundTarget() {
        this.rotateAroundTarget = true;
    }

    public void disableRotationAroundTarget() {
        this.rotateAroundTarget = true;
    }

    public double distanceToTarget() {
        return this.target.diff(this.pos).len();
    }

    public void set(double d, double d2, double d3) {
        this.setLocation(d, d2, d3);
    }

    public void set(IVec iVec) {
        this.setLocation(iVec);
    }

    public void set(double d, double d2, double d3, double d4, double d5) {
        this.set(d, d2, d3, d4, d5, 0.0);
    }

    public void set(IVec iVec, double d, double d2) {
        this.set(iVec, d, d2, 0.0);
    }

    public void set(double d, double d2, double d3, double d4, double d5, double d6) {
        this.disableRotationAroundTarget();
        this.setLocation(d, d2, d3);
        this.setAngle(d4, d5, d6);
        this.update();
    }

    public void set(IVec iVec, double d, double d2, double d3) {
        this.disableRotationAroundTarget();
        this.setLocation(iVec);
        this.setAngle(d, d2, d3);
        this.update();
    }

    public IVec getLocation() {
        return this.pos;
    }

    public void setLocation(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
    }

    public void setLocation(IVecI iVecI) {
        this.pos.set(iVecI);
    }

    public void setAngle(double d, double d2, double d3) {
        this.roll = d3;
        this.setAngle(d, d2);
    }

    public void setAngle(double d, double d2, double d3, boolean bl) {
        this.roll = d3;
        this.setAngle(d, d2, bl);
    }

    public void setAngle(double d, double d2) {
        this.setAngle(d, d2, false);
    }

    public void setAngle(double d, double d2, boolean bl) {
        this.yaw = d;
        this.pitch = d2;
        if (bl) {
            IVec iVec = this.frontDirection();
            iVec.len(defaultViewDistance);
            this.target.set(iVec.add(this.pos));
        } else if (this.rotateAroundTarget) {
            IVec iVec = this.frontDirection();
            IVec iVec2 = this.target.diff(this.pos);
            double d3 = -iVec2.len();
            if (iVec2.dot(iVec) < 0.0) {
                d3 = -d3;
            }
            iVec.len(d3);
            iVec.add(this.target);
            this.pos.set(iVec);
        }
    }

    public void moveForward(double d) {
        IVec iVec = this.frontDirection();
        iVec.len(d);
        this.pos.add(iVec);
        this.target.add(iVec);
        this.update();
    }

    public IVec location() {
        return this.pos.dup();
    }

    public IVec target() {
        return this.target.dup();
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getRoll() {
        return this.roll;
    }

    public IVec getAngles() {
        return new IVec(this.yaw, this.pitch, this.roll);
    }

    public IVec frontDirection() {
        IVec iVec = IVec.xaxis.dup();
        iVec.rot(IVec.yaxis, this.pitch);
        iVec.rot(IVec.zaxis, this.yaw);
        return iVec;
    }

    public IVec rightDirection() {
        IVec iVec = new IVec(0.0, -1.0, 0.0);
        iVec.rot(IVec.xaxis, this.roll);
        iVec.rot(IVec.yaxis, this.pitch);
        iVec.rot(IVec.zaxis, this.yaw);
        return iVec;
    }

    public IVec upDirection() {
        IVec iVec = IVec.zaxis.dup();
        iVec.rot(IVec.xaxis, this.roll);
        iVec.rot(IVec.yaxis, this.pitch);
        iVec.rot(IVec.zaxis, this.yaw);
        return iVec;
    }

    public void focus(IBoundingBox iBoundingBox) {
        if (iBoundingBox == null || iBoundingBox.min == null || iBoundingBox.max == null) {
            return;
        }
        IVec iVec = iBoundingBox.min.mid(iBoundingBox.max);
        IVec iVec2 = this.frontDirection();
        IVec[] iVecArray = new IVec[]{new IVec(iBoundingBox.min.x, iBoundingBox.min.y, iBoundingBox.min.z), new IVec(iBoundingBox.max.x, iBoundingBox.min.y, iBoundingBox.min.z), new IVec(iBoundingBox.min.x, iBoundingBox.max.y, iBoundingBox.min.z), new IVec(iBoundingBox.max.x, iBoundingBox.max.y, iBoundingBox.min.z), new IVec(iBoundingBox.min.x, iBoundingBox.min.y, iBoundingBox.max.z), new IVec(iBoundingBox.max.x, iBoundingBox.min.y, iBoundingBox.max.z), new IVec(iBoundingBox.min.x, iBoundingBox.max.y, iBoundingBox.max.z), new IVec(iBoundingBox.max.x, iBoundingBox.max.y, iBoundingBox.max.z)};
        IVec iVec3 = this.glTransformMatrix.transform(iVec);
        for (int i = 0; i < iVecArray.length; ++i) {
            iVecArray[i] = this.glTransformMatrix.transform(iVecArray[i]);
        }
        if (this.axonometric) {
            double d;
            double d2;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < iVecArray.length; ++i) {
                if (i == 0) {
                    d3 = d5 = iVecArray[i].x;
                    d4 = d6 = iVecArray[i].y;
                    continue;
                }
                if (iVecArray[i].x < d3) {
                    d3 = iVecArray[i].x;
                } else if (iVecArray[i].x > d5) {
                    d5 = iVecArray[i].x;
                }
                if (iVecArray[i].y < d4) {
                    d4 = iVecArray[i].y;
                    continue;
                }
                if (!(iVecArray[i].y > d6)) continue;
                d6 = iVecArray[i].y;
            }
            double d7 = iVec3.x - d3;
            if (d5 - iVec3.x > d7) {
                d7 = d5 - iVec3.x;
            }
            if (d6 - iVec3.y > (d2 = iVec3.y - d4)) {
                d2 = d6 - iVec3.y;
            }
            if (d2 / (double)(this.screenHeight / 2) > (d = d7 / (double)(this.screenWidth / 2))) {
                d = d2 / (double)(this.screenHeight / 2);
            }
            iVec2.len(-defaultViewDistance);
            this.axonRatio = d;
        } else {
            double d = 0.0;
            for (int i = 0; i < iVecArray.length; ++i) {
                double d8 = 0.0;
                d8 = iVecArray[i].x < iVec3.x ? iVecArray[i].z + (iVec3.x - iVecArray[i].x) / this.persRatio : iVecArray[i].z + (iVecArray[i].x - iVec3.x) / this.persRatio;
                if (i == 0) {
                    d = d8;
                } else if (d8 > d) {
                    d = d8;
                }
                d8 = iVecArray[i].y < iVec3.y ? iVecArray[i].z + (iVec3.y - iVecArray[i].y) / this.persRatio : iVecArray[i].z + (iVecArray[i].y - iVec3.y) / this.persRatio;
                if (!(d8 > d)) continue;
                d = d8;
            }
            iVec2.len(-(d -= iVec3.z));
        }
        this.setLocation(iVec2.add(iVec));
        this.setTarget(iVec);
        this.enableRotationAroundTarget();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convert(IVecI iVecI, IVec2 iVec2) {
        IView iView = this;
        synchronized (iView) {
            IVec iVec = this.glTransformMatrix.transform(iVecI);
            if (this.axonometric) {
                iVec.div(this.axonRatio);
                iVec2.x = (double)(this.screenWidth / 2) + iVec.x;
                iVec2.y = (double)(this.screenHeight / 2) - iVec.y;
            } else {
                iVec.z = -iVec.z;
                if (iVec.z < this.near) {
                    return false;
                }
                double d = (double)this.screenHeight * this.near / iVec.z / this.glHeight;
                iVec2.x = (double)(this.screenWidth / 2) + iVec.x * d;
                iVec2.y = (double)(this.screenHeight / 2) - iVec.y * d;
            }
            return !(iVec2.x < 0.0 || iVec2.x > (double)this.screenWidth || iVec2.y < 0.0) && !(iVec2.y > (double)this.screenHeight);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convert(IVecI iVecI, IVec iVec) {
        IView iView = this;
        synchronized (iView) {
            IVec iVec2 = this.glTransformMatrix.transform(iVecI);
            iVec2.z = -iVec2.z;
            if (this.axonometric) {
                iVec2.div(this.axonRatio);
                iVec.x = (double)(this.screenWidth / 2) + iVec2.x;
                iVec.y = (double)(this.screenHeight / 2) - iVec2.y;
                iVec.z = iVec2.z;
            } else {
                double d = (double)this.screenHeight * this.near / iVec2.z / this.glHeight;
                iVec.x = (double)(this.screenWidth / 2) + iVec2.x * d;
                iVec.y = (double)(this.screenHeight / 2) - iVec2.y * d;
                iVec.z = iVec2.z;
                if (iVec2.z < this.near) {
                    return false;
                }
            }
            return !(iVec.x < 0.0 || iVec.x > (double)this.screenWidth || iVec.y < 0.0) && !(iVec.y > (double)this.screenHeight);
            {
            }
        }
    }

    public void drawBG(GL gL) {
        if (this.glBGColor != null) {
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glDisable(2929);
            gL.glBegin(7);
            gL.glColor3dv(this.glBGColor[0][1], 0);
            gL.glVertex3d(-1.0, -1.0, 0.0);
            gL.glColor3dv(this.glBGColor[1][1], 0);
            gL.glVertex3d(1.0, -1.0, 0.0);
            gL.glColor3dv(this.glBGColor[1][0], 0);
            gL.glVertex3d(1.0, 1.0, 0.0);
            gL.glColor3dv(this.glBGColor[0][0], 0);
            gL.glVertex3d(-1.0, 1.0, 0.0);
            gL.glEnd();
            gL.glEnable(2929);
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
        }
    }

    public void draw(GL gL) {
        if (this.hide) {
            return;
        }
        gL.glViewport(this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        this.drawBG(gL);
        if (this.mode.isLight()) {
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glLightfv(16385, 4611, defaultGLLightPosition, 0);
            gL.glLightfv(16385, 4608, defaultGLAmbientLight, 0);
            gL.glLightfv(16385, 4609, defaultGLDiffuseLight, 0);
            gL.glLightfv(16385, 4610, defaultGLSpecularLight, 0);
            if (defaultGLTwoSidedLighting) {
                gL.glLightModeli(2898, 1);
            }
            gL.glEnable(16385);
            gL.glEnable(2896);
            gL.glPopMatrix();
        }
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        if (this.axonometric) {
            gL.glOrtho(-this.glWidth / 2.0, this.glWidth / 2.0, -this.glHeight / 2.0, this.glHeight / 2.0, this.near, this.far);
        } else {
            gL.glFrustum(-this.glWidth / 2.0, this.glWidth / 2.0, -this.glHeight / 2.0, this.glHeight / 2.0, this.near, this.far);
        }
        gL.glMatrixMode(5888);
        gL.glLoadMatrixd(this.glTransformArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        IView iView = this;
        synchronized (iView) {
            if (this.useGL) {
                IMatrix3 iMatrix3 = IMatrix3.getZRotation(this.yaw);
                iMatrix3.mul(IMatrix3.getYRotation(this.pitch));
                if (this.roll != 0.0) {
                    iMatrix3.mul(IMatrix3.getXRotation(this.roll));
                }
                iMatrix3.invert();
                IMatrix3 iMatrix32 = new IMatrix3(0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0);
                iMatrix32 = iMatrix32.mul(iMatrix3);
                this.glTransformMatrix.setId();
                this.glTransformMatrix.setRange(iMatrix32, 0, 3, 0, 3);
                this.glTransformMatrix.mul(IMatrix4.getTranslate(-this.pos.x, -this.pos.y, -this.pos.z));
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        this.glTransformArray[j * 4 + i] = this.glTransformMatrix.get(i, j);
                    }
                }
                if (this.axonometric) {
                    this.glWidth = (double)this.screenWidth * this.axonRatio;
                    this.glHeight = (double)this.screenHeight * this.axonRatio;
                } else {
                    this.glWidth = this.glHeight * (double)this.screenWidth / (double)this.screenHeight;
                    this.glHeight = this.near * this.persRatio * 2.0;
                }
            }
        }
    }

    public void setTop() {
        this.setTop(0.0, 0.0);
    }

    public void setTop(double d, double d2) {
        this.setTop(d, d2, defaultViewDistance);
    }

    public void setTop(double d, double d2, double d3) {
        this.setTop(d, d2, d3, this.axonRatio);
    }

    public void setTop(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(1.5707963267948966, 1.5707963267948966, true);
        this.setAxonometricRatio(d4);
    }

    public void setBottom() {
        this.setBottom(0.0, 0.0);
    }

    public void setBottom(double d, double d2) {
        this.setBottom(d, d2, -defaultViewDistance);
    }

    public void setBottom(double d, double d2, double d3) {
        this.setBottom(d, d2, d3, this.axonRatio);
    }

    public void setBottom(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(1.5707963267948966, -1.5707963267948966, true);
        this.setAxonometricRatio(d4);
    }

    public void setLeft() {
        this.setLeft(0.0, 0.0);
    }

    public void setLeft(double d, double d2) {
        this.setLeft(-defaultViewDistance, d, d2);
    }

    public void setLeft(double d, double d2, double d3) {
        this.setLeft(d, d2, d3, this.axonRatio);
    }

    public void setLeft(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(0.0, 0.0, true);
        this.setAxonometricRatio(d4);
    }

    public void setRight() {
        this.setRight(0.0, 0.0);
    }

    public void setRight(double d, double d2) {
        this.setRight(defaultViewDistance, d, d2);
    }

    public void setRight(double d, double d2, double d3) {
        this.setRight(d, d2, d3, this.axonRatio);
    }

    public void setRight(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(Math.PI, 0.0, true);
        this.setAxonometricRatio(d4);
    }

    public void setFront() {
        this.setFront(0.0, 0.0);
    }

    public void setFront(double d, double d2) {
        this.setFront(d, -defaultViewDistance, d2);
    }

    public void setFront(double d, double d2, double d3) {
        this.setFront(d, d2, d3, this.axonRatio);
    }

    public void setFront(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(1.5707963267948966, 0.0, true);
        this.setAxonometricRatio(d4);
    }

    public void setBack() {
        this.setBack(0.0, 0.0);
    }

    public void setBack(double d, double d2) {
        this.setBack(d, defaultViewDistance, d2);
    }

    public void setBack(double d, double d2, double d3) {
        this.setBack(d, d2, d3, this.axonRatio);
    }

    public void setBack(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2, d3);
        this.setAngle(-1.5707963267948966, 0.0, true);
        this.setAxonometricRatio(d4);
    }

    public void setPerspective() {
        this.setPerspective(-defaultViewDistance / Math.sqrt(3.0), -defaultViewDistance / Math.sqrt(3.0), defaultViewDistance / Math.sqrt(3.0));
    }

    public void setPerspective(double d, double d2, double d3) {
        this.setPerspective(d, d2, d3, 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0));
    }

    public void setPerspective(double d, double d2, double d3, double d4, double d5) {
        this.setLocation(d, d2, d3);
        this.setAngle(d4, d5, true);
        this.perspective();
        this.setPerspectiveRatio(defaultPersRatio);
    }

    public void setPerspective(double d) {
        this.setPerspective(-defaultViewDistance / Math.sqrt(3.0), -defaultViewDistance / Math.sqrt(3.0), defaultViewDistance / Math.sqrt(3.0), d);
        this.setAngle(0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0), true);
        this.perspective();
        this.setPerspectiveAngle(d);
    }

    public void setPerspective(double d, double d2, double d3, double d4) {
        this.setPerspective(d, d2, d3, 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0));
    }

    public void setPerspective(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setLocation(d, d2, d3);
        this.setAngle(d4, d5, true);
        this.perspective();
        this.setPerspectiveAngle(d6);
    }

    public void setAxonometric() {
        this.setAxonometric(-defaultViewDistance / Math.sqrt(3.0), -defaultViewDistance / Math.sqrt(3.0), defaultViewDistance / Math.sqrt(3.0));
    }

    public void setAxonometric(double d, double d2, double d3) {
        this.setAxonometric(d, d2, d3, 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0));
    }

    public void setAxonometric(double d, double d2, double d3, double d4) {
        this.setAxonometric(d, d2, d3, 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0), d4);
    }

    public void setAxonometric(double d, double d2, double d3, double d4, double d5) {
        this.setAxonometric(d, d2, d3, d4, d5, this.axonRatio);
    }

    public void setAxonometric(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setLocation(d, d2, d3);
        this.setAngle(d4, d5, true);
        this.setAxonometricRatio(d6);
    }

    public static IView getTopView(int n, int n2, int n3, int n4) {
        return new IView(0.0, 0.0, defaultViewDistance, 1.5707963267948966, 1.5707963267948966, 0.0, n, n2, n3, n4, true);
    }

    public static IView getBottomView(int n, int n2, int n3, int n4) {
        return new IView(0.0, 0.0, -defaultViewDistance, 1.5707963267948966, -1.5707963267948966, 0.0, n, n2, n3, n4, true);
    }

    public static IView getLeftView(int n, int n2, int n3, int n4) {
        return new IView(-defaultViewDistance, 0.0, 0.0, 0.0, 0.0, 0.0, n, n2, n3, n4, true);
    }

    public static IView getRightView(int n, int n2, int n3, int n4) {
        return new IView(defaultViewDistance, 0.0, 0.0, Math.PI, 0.0, 0.0, n, n2, n3, n4, true);
    }

    public static IView getFrontView(int n, int n2, int n3, int n4) {
        return new IView(0.0, -defaultViewDistance, 0.0, 1.5707963267948966, 0.0, 0.0, n, n2, n3, n4, true);
    }

    public static IView getBackView(int n, int n2, int n3, int n4) {
        return new IView(0.0, defaultViewDistance, 0.0, -1.5707963267948966, 0.0, 0.0, n, n2, n3, n4, true);
    }

    public static IView getDefaultAxonometricView(int n, int n2, int n3, int n4) {
        return new IView(-defaultViewDistance / Math.sqrt(3.0), -defaultViewDistance / Math.sqrt(3.0), defaultViewDistance / Math.sqrt(3.0), 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0), 0.0, n, n2, n3, n4, true);
    }

    public static IView getDefaultPerspectiveView(int n, int n2, int n3, int n4) {
        return new IView(-defaultViewDistance / Math.sqrt(3.0), -defaultViewDistance / Math.sqrt(3.0), defaultViewDistance / Math.sqrt(3.0), 0.7853981633974483, Math.atan(Math.sqrt(2.0) / 2.0), 0.0, n, n2, n3, n4, false);
    }
}

