/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IMap;

public class IDoubleMap
extends IMap {
    public boolean interpolation = true;
    public int width;
    public int height;
    public double[][] map;

    public IDoubleMap() {
    }

    public IDoubleMap(int n, int n2) {
        this.initMap(n, n2);
    }

    public void initMap(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.map = new double[n][n2];
    }

    public int width() {
        return this.width;
    }

    public int getWidth() {
        return this.width();
    }

    public int height() {
        return this.height;
    }

    public int getHeight() {
        return this.height();
    }

    public void set(int n, int n2, double d) {
        this.map[n][n2] = d;
    }

    public void setInterpolation(boolean bl) {
        this.interpolation = bl;
    }

    public void enableInterpolation() {
        this.interpolation = true;
    }

    public void disableInterpolation() {
        this.interpolation = false;
    }

    public double get(double d, double d2) {
        if (this.interpolation) {
            int n = (int)((double)(this.width - 1) * d);
            int n2 = (int)((double)(this.height - 1) * d2);
            if (n < 0) {
                n = 0;
            } else if (n >= this.width) {
                n = this.width - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.height) {
                n2 = this.height - 1;
            }
            double d3 = (double)n / (double)(this.width - 1) - d;
            double d4 = (double)n2 / (double)(this.height - 1) - d2;
            if (d3 == 0.0 || n == this.width - 1) {
                if (d4 == 0.0 || n2 == this.height - 1) {
                    return this.map[n][n2];
                }
                return this.map[n][n2] * (1.0 - d4) + this.map[n][n2 + 1] * d4;
            }
            if (d4 == 0.0 || n2 == this.height - 1) {
                return this.map[n][n2] * (1.0 - d3) + this.map[n + 1][n2] * d3;
            }
            return (this.map[n][n2] * (1.0 - d3) + this.map[n + 1][n2] * d3) * (1.0 - d4) + (this.map[n][n2 + 1] * (1.0 - d3) + this.map[n + 1][n2 + 1] * d3) * d4;
        }
        int n = (int)((double)(this.width - 1) * d + 0.5);
        int n3 = (int)((double)(this.height - 1) * d2 + 0.5);
        if (n < 0) {
            n = 0;
        } else if (n >= this.width) {
            n = this.width - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.height) {
            n3 = this.height - 1;
        }
        return this.map[n][n3];
    }

    public void flipU() {
        double[][] dArray = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                dArray[i][j] = this.map[this.width - i - 1][j];
            }
        }
        this.map = dArray;
    }

    public void flipV() {
        double[][] dArray = new double[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                dArray[i][j] = this.map[i][this.height - j - 1];
            }
        }
        this.map = dArray;
    }

    public void scale(double d) {
        for (int i = 0; i < this.width; ++i) {
            int n = 0;
            while (n < this.height) {
                double[] dArray = this.map[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public void add(double d) {
        for (int i = 0; i < this.width; ++i) {
            int n = 0;
            while (n < this.height) {
                double[] dArray = this.map[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] + d;
            }
        }
    }
}

