/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IEdge;
import igeo.IFace;
import igeo.IGraphicObject;
import igeo.IMesh;
import igeo.IMeshI;
import igeo.IMeshR;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicGL;
import javax.media.opengl.GL;

public class IMeshGraphicGL
extends IGraphicObject {
    public static float weight = 1.0f;
    public IMeshI mesh;
    public IVec[][] facePts;
    public IVec[][] faceNormal;
    public IVec[][] edgePts;

    public IMeshGraphicGL(IMesh iMesh) {
        super(iMesh);
    }

    public IMeshGraphicGL(IMeshR iMeshR) {
        super(iMeshR);
    }

    public void initMesh() {
        Object object;
        int n;
        if (this.parent instanceof IMesh) {
            this.mesh = ((IMesh)this.parent).mesh;
        } else if (this.parent instanceof IMeshR) {
            this.mesh = ((IMeshR)this.parent).mesh;
        }
        this.facePts = new IVec[this.mesh.faceNum()][];
        this.faceNormal = new IVec[this.mesh.faceNum()][];
        for (n = 0; n < this.mesh.faceNum(); ++n) {
            object = this.mesh.face(n);
            this.facePts[n] = new IVec[((IFace)object).vertexNum()];
            this.faceNormal[n] = new IVec[((IFace)object).vertexNum()];
            for (int i = 0; i < ((IFace)object).vertexNum(); ++i) {
                this.facePts[n][i] = ((IFace)object).getVertex(i).get();
                this.faceNormal[n][i] = ((IFace)object).getVertex(i).normal().get();
            }
        }
        this.edgePts = new IVec[this.mesh.edgeNum()][];
        for (n = 0; n < this.mesh.edgeNum(); ++n) {
            object = this.mesh.edge(n);
            this.edgePts[n] = new IVec[2];
            this.edgePts[n][0] = ((IEdge)object).getVertex(0).get();
            this.edgePts[n][1] = ((IEdge)object).getVertex(1).get();
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    public void draw(IGraphics iGraphics) {
        GL gL;
        if (this.mesh == null) {
            this.initMesh();
        }
        if ((gL = iGraphics.getGL()) != null) {
            float[] fArray;
            gL.glLineWidth(weight);
            float f = ISurfaceGraphicGL.defaultColorRed;
            float f2 = ISurfaceGraphicGL.defaultColorGreen;
            float f3 = ISurfaceGraphicGL.defaultColorBlue;
            float f4 = ISurfaceGraphicGL.defaultColorAlpha;
            if (this.color != null) {
                f = (float)this.color.getRed() / 255.0f;
                f2 = (float)this.color.getGreen() / 255.0f;
                f3 = (float)this.color.getBlue() / 255.0f;
                f4 = (float)this.color.getAlpha() / 255.0f;
            }
            if (iGraphics.view().mode().isTransparent()) {
                f4 = (float)transparentModeAlpha;
            }
            if (iGraphics.view().mode().isLight()) {
                fArray = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, fArray, 0);
                gL.glMaterialfv(1032, 4609, fArray, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (iGraphics.view().mode().isFill()) {
                int n = 0;
                for (int i = 0; i < this.facePts.length; ++i) {
                    if (this.facePts[i].length != n) {
                        if (i > 0) {
                            gL.glEnd();
                        }
                        if (this.facePts[i].length == 3) {
                            gL.glBegin(4);
                        } else if (this.facePts[i].length == 4) {
                            gL.glBegin(7);
                        } else {
                            gL.glBegin(9);
                        }
                        n = this.facePts[i].length;
                    }
                    for (int j = 0; j < this.facePts[i].length; ++j) {
                        gL.glNormal3d(this.faceNormal[i][j].x, this.faceNormal[i][j].y, this.faceNormal[i][j].z);
                        gL.glVertex3d(this.facePts[i][j].x, this.facePts[i][j].y, this.facePts[i][j].z);
                    }
                }
                if (this.facePts.length > 0) {
                    gL.glEnd();
                }
            }
            f4 = iGraphics.view().mode().isTransparent() && iGraphics.view().mode().isTransparentWireframe() ? (float)transparentModeAlpha : (this.color != null ? (float)this.color.getAlpha() / 255.0f : ISurfaceGraphicGL.defaultColorAlpha);
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                fArray = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, fArray, 0);
                gL.glMaterialfv(1032, 4609, fArray, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glDisable(2896);
            }
            gL.glColor4f(f, f2, f3, f4);
            if (iGraphics.view().mode().isWireframe()) {
                gL.glBegin(1);
                for (int i = 0; i < this.edgePts.length; ++i) {
                    gL.glVertex3f((float)this.edgePts[i][0].x, (float)this.edgePts[i][0].y, (float)this.edgePts[i][0].z);
                    gL.glVertex3f((float)this.edgePts[i][1].x, (float)this.edgePts[i][1].y, (float)this.edgePts[i][1].z);
                }
                gL.glEnd();
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glEnable(2896);
            }
        }
    }
}

