/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleOnCurve;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITensionOnCurve
extends IDynamicsBase {
    public static double defaultTension = 1.0;
    public IParticleOnCurve pt1;
    public IParticleOnCurve pt2;
    public double tension = defaultTension;
    public boolean isCurveClosed;

    public ITensionOnCurve(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2, double d, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleOnCurve;
        this.pt2 = iParticleOnCurve2;
        this.tension = d;
        this.isCurveClosed = this.pt1.curve.isClosed();
    }

    public ITensionOnCurve(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleOnCurve;
        this.pt2 = iParticleOnCurve2;
        this.isCurveClosed = this.pt1.curve.isClosed();
    }

    public ITensionOnCurve(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2, double d) {
        this.pt1 = iParticleOnCurve;
        this.pt2 = iParticleOnCurve2;
        this.tension = d;
        this.isCurveClosed = this.pt1.curve.isClosed();
    }

    public ITensionOnCurve(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2) {
        this.pt1 = iParticleOnCurve;
        this.pt2 = iParticleOnCurve2;
        this.isCurveClosed = this.pt1.curve.isClosed();
    }

    public double tension() {
        return this.tension;
    }

    public ITensionOnCurve tension(double d) {
        this.tension = d;
        return this;
    }

    @Override
    public ITensionOnCurve parent(IObject iObject) {
        super.parent(iObject);
        return this;
    }

    @Override
    public ITensionOnCurve target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public ITensionOnCurve removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public ITensionOnCurve removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        double d = this.pt2.upos - this.pt1.upos;
        if (this.isCurveClosed) {
            if (d > 0.5) {
                d -= 1.0;
            } else if (d < -0.5) {
                d += 1.0;
            }
        }
        this.pt1.addUForce(d *= this.tension);
        this.pt2.addUForce(-d);
    }

    @Override
    public synchronized void update() {
    }
}

