/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IConfig;
import igeo.geo.ISurfaceI;
import igeo.geo.ITrimCurveI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.gui.IPolyline;
import igeo.gui.IPolyline2D;
import java.util.ArrayList;

public class ITrimCurveGraphic {
    public ITrimCurveI curve;
    public ISurfaceI surface;
    public IPolyline2D polyline2 = null;
    public IPolyline polyline = null;

    public ITrimCurveGraphic(ITrimCurveI iTrimCurveI) {
        this.curve = iTrimCurveI;
        this.surface = this.curve.surface();
    }

    public ITrimCurveGraphic(ISurfaceI iSurfaceI, IPolyline2D iPolyline2D) {
        this.curve = null;
        this.surface = iSurfaceI;
        this.polyline2 = iPolyline2D;
    }

    public IPolyline2D getPolyline2D() {
        return this.polyline2;
    }

    public IPolyline getPolyline(int n) {
        if (this.polyline == null) {
            this.setup3D(n);
        }
        return this.polyline;
    }

    public void setup2D(int n) {
        if (this.curve.deg() == 1) {
            int n2 = this.curve.cpNum();
            this.polyline2 = new IPolyline2D(n2);
            for (int i = 0; i < n2; ++i) {
                IVec iVec = this.curve.cp(i).get();
                this.polyline2.set(i, new IVec2(iVec.x, iVec.y));
            }
        } else {
            int n3 = this.curve.epNum();
            this.polyline2 = new IPolyline2D((n3 - 1) * n + 1);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n && i < n3 - 1 || j == 0; ++j) {
                    IVec2 iVec2 = this.curve.pt2d(this.curve.u(i, (double)j / (double)n)).get();
                    if (iVec2.x < 0.0) {
                        iVec2.x = 0.0;
                    } else if (iVec2.x > 1.0) {
                        iVec2.x = 1.0;
                    }
                    if (iVec2.y < 0.0) {
                        iVec2.y = 0.0;
                    } else if (iVec2.y > 1.0) {
                        iVec2.y = 1.0;
                    }
                    this.polyline2.set(i * n + j, iVec2);
                }
            }
        }
    }

    public void setup3D(int n) {
        if (this.polyline2 == null) {
            this.setup2D(n);
        }
        if (this.surface.udeg() == 1 && this.surface.vdeg() == 1 && this.surface.ucpNum() == 2 && this.surface.vcpNum() == 2 && this.surface.isFlat()) {
            this.polyline = new IPolyline(this.polyline2.num());
            for (int i = 0; i < this.polyline2.num(); ++i) {
                this.polyline.set(i, this.surface.pt(this.polyline2.get(i)));
            }
        } else {
            int n2;
            ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
            for (n2 = 0; n2 < this.polyline2.num() - 1; ++n2) {
                arrayList.add(this.polyline2.get(n2));
                IVec2[] iVec2Array = ITrimCurveGraphic.fillPointsBetween(this.surface, this.polyline2.get(n2), this.polyline2.get(n2 + 1));
                for (int i = 0; iVec2Array != null && i < iVec2Array.length; ++i) {
                    arrayList.add(iVec2Array[i]);
                }
                if (n2 != this.polyline2.num() - 2) continue;
                arrayList.add(this.polyline2.get(n2 + 1));
            }
            this.polyline2 = new IPolyline2D(arrayList.toArray(new IVec2[arrayList.size()]));
            this.polyline = new IPolyline(arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.polyline.set(n2, this.surface.pt((IVec2I)arrayList.get(n2)));
            }
        }
    }

    public static IVec2[] fillPointsBetween(ISurfaceI iSurfaceI, IVec2 iVec2, IVec2 iVec22) {
        if (Math.abs(iVec2.y - iVec22.y) < IConfig.tolerance) {
            return ITrimCurveGraphic.fillUBetween(iSurfaceI, iVec2, iVec22);
        }
        if (Math.abs(iVec2.x - iVec22.x) < IConfig.tolerance) {
            return ITrimCurveGraphic.fillVBetween(iSurfaceI, iVec2, iVec22);
        }
        IVec2[] iVec2Array = ITrimCurveGraphic.fillUBetween(iSurfaceI, iVec2, iVec22);
        IVec2[] iVec2Array2 = ITrimCurveGraphic.fillVBetween(iSurfaceI, iVec2, iVec22);
        if (iVec2Array == null && iVec2Array2 == null) {
            return null;
        }
        if (iVec2Array != null && iVec2Array2 == null) {
            return iVec2Array;
        }
        if (iVec2Array == null && iVec2Array2 != null) {
            return iVec2Array2;
        }
        if (iVec2Array.length >= iVec2Array2.length) {
            return iVec2Array;
        }
        return iVec2Array2;
    }

    public static IVec2[] fillUBetween(ISurfaceI iSurfaceI, IVec2 iVec2, IVec2 iVec22) {
        int n;
        Object[] objectArray;
        double[] dArray = ITrimCurveGraphic.fillUBetween(iSurfaceI, iVec2.x, iVec22.x);
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        if (iVec2.x > iVec22.x) {
            objectArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = dArray[n2 - 1 - n];
            }
            dArray = objectArray;
        }
        objectArray = new IVec2[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = (double)iVec2.sum(iVec22, (dArray[n] - iVec2.x) / (iVec22.x - iVec2.x));
        }
        return objectArray;
    }

    public static double[] fillUBetween(ISurfaceI iSurfaceI, double d, double d2) {
        int n;
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        for (n = 0; n < iSurfaceI.uepNum() && iSurfaceI.u(n, 0.0) < d3; ++n) {
        }
        if (--n < 0) {
            n = 0;
        }
        if (n >= iSurfaceI.uepNum() - 1) {
            return null;
        }
        if (!(iSurfaceI.u(n, 0.0) <= d3) || !(iSurfaceI.u(n + 1, 0.0) >= d3)) {
            return null;
        }
        int n2 = IConfig.surfaceIsoparmResolution * IConfig.surfaceWireframeResolution;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (n < iSurfaceI.uepNum() && iSurfaceI.u(n, 0.0) < d4) {
            for (int i = 0; iSurfaceI.u(n, (double)i / (double)n2) < d4 && (iSurfaceI.udeg() == 1 && i == 0 || iSurfaceI.udeg() > 1 && i < n2); ++i) {
                double d5 = iSurfaceI.u(n, (double)i / (double)n2);
                if (!(d5 > d3) || !(d5 < d4)) continue;
                arrayList.add(d5);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public static IVec2[] fillVBetween(ISurfaceI iSurfaceI, IVec2 iVec2, IVec2 iVec22) {
        int n;
        Object[] objectArray;
        double[] dArray = ITrimCurveGraphic.fillVBetween(iSurfaceI, iVec2.y, iVec22.y);
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        if (iVec2.y > iVec22.y) {
            objectArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = dArray[n2 - 1 - n];
            }
            dArray = objectArray;
        }
        objectArray = new IVec2[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = (double)iVec2.sum(iVec22, (dArray[n] - iVec2.y) / (iVec22.y - iVec2.y));
        }
        return objectArray;
    }

    public static double[] fillVBetween(ISurfaceI iSurfaceI, double d, double d2) {
        int n;
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        for (n = 0; n < iSurfaceI.vepNum() && iSurfaceI.v(n, 0.0) < d3; ++n) {
        }
        if (--n < 0) {
            n = 0;
        }
        if (n >= iSurfaceI.vepNum() - 1) {
            return null;
        }
        if (!(iSurfaceI.v(n, 0.0) <= d3) || !(iSurfaceI.v(n + 1, 0.0) >= d3)) {
            return null;
        }
        int n2 = IConfig.surfaceIsoparmResolution * IConfig.surfaceWireframeResolution;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (n < iSurfaceI.vepNum() && iSurfaceI.v(n, 0.0) < d4) {
            for (int i = 0; iSurfaceI.v(n, (double)i / (double)n2) < d4 && (iSurfaceI.vdeg() == 1 && i == 0 || iSurfaceI.vdeg() > 1 && i < n2); ++i) {
                double d5 = iSurfaceI.v(n, (double)i / (double)n2);
                if (!(d5 > d3) || !(d5 < d4)) continue;
                arrayList.add(d5);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }
}

