/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IG;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.geo.IBoundingBox;
import igeo.gui.IComponent;
import igeo.gui.IFileFilter;
import igeo.gui.IGraphics;
import igeo.gui.IPane;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class IPanel
extends IComponent
implements IServerI,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener,
ComponentListener {
    public ArrayList<IPane> panes = new ArrayList();
    public IG ig;
    public IPane currentMousePane = null;
    public IBoundingBox boundingBox;
    public int serverStateCount = -1;
    public boolean firstDraw = true;

    public IPanel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void setIG(IG iG) {
        this.ig = iG;
    }

    public IServer server() {
        return this.ig.server();
    }

    public void addPane(IPane iPane) {
        this.panes.add(iPane);
        iPane.setParent(this);
    }

    public IPane getPane(int n) {
        return this.panes.get(n);
    }

    public int paneNum() {
        return this.panes.size();
    }

    public void removePane(int n) {
        this.panes.remove(n);
    }

    public void clearPane() {
        this.panes.clear();
    }

    public void show() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).show();
        }
    }

    public void hide() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).hide();
        }
    }

    public void focus() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).focus();
        }
    }

    public void setSize(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < this.panes.size(); ++i) {
            int n5 = this.panes.get(i).getX() * n / n3;
            int n6 = this.panes.get(i).getY() * n2 / n4;
            int n7 = this.panes.get(i).getWidth() * n / n3;
            int n8 = this.panes.get(i).getHeight() * n2 / n4;
            this.panes.get(i).setBounds(n5, n6, n7, n8);
        }
        this.width = n;
        this.height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(IGraphics iGraphics) {
        if (this.firstDraw && this.ig != null && this.ig.dynamicServer() != null && (this.ig.dynamicServer().num() > 0 || this.ig.dynamicServer().addingNum() > 0)) {
            this.ig.dynamicServer().start();
            this.firstDraw = false;
        }
        for (int i = 0; i < this.panes.size(); ++i) {
            Object object = IG.lock;
            synchronized (object) {
                if (this.panes.get(i).isVisible()) {
                    this.panes.get(i).draw(iGraphics);
                }
                continue;
            }
        }
    }

    public IPane getPaneAt(MouseEvent mouseEvent) {
        return this.getPaneAt(mouseEvent.getX(), mouseEvent.getY());
    }

    public IPane getPaneAt(int n, int n2) {
        for (int i = this.panes.size() - 1; i >= 0; --i) {
            if (!this.panes.get(i).isVisible() || !this.panes.get(i).contains(n, n2)) continue;
            return this.panes.get(i);
        }
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            this.currentMousePane = iPane;
            iPane.mousePressed(mouseEvent);
        } else {
            IOut.err("no pane");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        IPane iPane = null;
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseReleased(mouseEvent);
        } else {
            iPane = this.getPaneAt(mouseEvent);
            if (iPane != null) {
                iPane.mouseReleased(mouseEvent);
                this.currentMousePane = iPane;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseClicked(mouseEvent);
        }
        this.currentMousePane = iPane;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseMoved(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        IPane iPane = null;
        iPane = this.currentMousePane != null ? this.currentMousePane : this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseDragged(mouseEvent);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseWheelMoved(mouseWheelEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        if (n == 70 && !bl2) {
            this.currentMousePane.focus();
        } else if (n == 83 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, false);
        } else if (n == 83 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, false);
        } else if (n == 87 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, false, false);
        } else if (n == 84 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, true);
        } else if (n == 84 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, true);
        } else if ((n == 87 || n == 81) && bl2 && !bl) {
            System.exit(0);
        } else if (n == 83 && bl2 && !bl) {
            File file;
            if (this.ig.basePath != null && !(file = new File(this.ig.basePath)).isDirectory()) {
                IOut.debug(20, "creating directory" + file.toString());
                if (!file.mkdir()) {
                    IOut.err("failed to create directory: " + file.toString());
                }
            }
            if ((file = this.chooseFile(new String[][]{{"3dm", "3DM"}, {"obj", "Obj", "OBJ"}}, new String[]{"Rhinoceros 3D file v4 (.3dm)", "Wavefront OBJ file (.obj)"}, "Save", true, this.ig.basePath, null)) != null) {
                this.ig.saveFile(file.getAbsolutePath());
            }
        }
        if (this.currentMousePane != null) {
            this.currentMousePane.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyReleased(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyTyped(keyEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = componentEvent.getComponent().getBounds().width;
        int n2 = componentEvent.getComponent().getBounds().height;
        this.setSize(n, n2);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public IBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new IBoundingBox();
        }
        if (this.ig.server().stateCount() != this.serverStateCount) {
            this.boundingBox.setObjects(this.ig.server());
            this.serverStateCount = this.ig.server().stateCount();
        }
    }

    public File chooseFile(String string, String string2, String string3, boolean bl, String string4, File file) {
        return this.chooseFile(IFileFilter.createCaseVariation(string), string2, string3, bl, string4, file);
    }

    public File chooseFile(String[] stringArray, String string, String string2, boolean bl, String string3, File file) {
        String[][] stringArray2 = new String[][]{stringArray};
        String[] stringArray3 = new String[]{string};
        return this.chooseFile(stringArray2, stringArray3, string2, bl, string3, file);
    }

    public File chooseFile(String[][] stringArray, String[] stringArray2, String string, boolean bl, String string2, File file) {
        File file2 = null;
        boolean bl2 = false;
        if (string2 == null) {
            string2 = ".";
        }
        file2 = file;
        IFileFilter[] iFileFilterArray = new IFileFilter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (stringArray[i][j].startsWith(".")) continue;
                stringArray[i][j] = "." + stringArray[i][j];
            }
            String string3 = "";
            if (stringArray2 != null && stringArray2.length > i && stringArray2[i] != null) {
                string3 = stringArray2[i];
            }
            iFileFilterArray[i] = new IFileFilter(stringArray[i], string3);
        }
        do {
            int n;
            bl2 = false;
            JFileChooser jFileChooser = new JFileChooser(string2);
            for (n = iFileFilterArray.length - 1; n >= 0; --n) {
                jFileChooser.addChoosableFileFilter(iFileFilterArray[n]);
            }
            if (file2 != null) {
                jFileChooser.setCurrentDirectory(new File(file2.getParent()));
                jFileChooser.setSelectedFile(file2);
            }
            if ((n = jFileChooser.showDialog(null, string)) == 0) {
                int n2;
                file2 = jFileChooser.getSelectedFile();
                String string4 = file2.toString();
                boolean bl3 = false;
                FileFilter fileFilter = jFileChooser.getFileFilter();
                int n3 = -1;
                for (n2 = 0; n2 < iFileFilterArray.length && n3 < 0; ++n2) {
                    if (fileFilter != iFileFilterArray[n2]) continue;
                    n3 = n2;
                }
                for (n2 = 0; n3 >= 0 && n2 < stringArray[n3].length && !bl3; ++n2) {
                    if (!string4.endsWith(stringArray[n3][n2])) continue;
                    bl3 = true;
                }
                if (n3 >= 0 && !bl3) {
                    string4 = string4.concat(stringArray[n3][0]);
                    file2 = new File(string4);
                }
                if (bl) {
                    String string5;
                    int n4;
                    if (!file2.exists() || (n4 = JOptionPane.showConfirmDialog(null, string5 = "file is existing\ndo you want to overwrite it?")) == 0) continue;
                    if (n4 == 1) {
                        return null;
                    }
                    if (n4 == 2) {
                        bl2 = true;
                        continue;
                    }
                    return null;
                }
                if (file2.exists()) continue;
                IOut.err("file doesn't exist " + file2.toString());
                String string6 = "file doesn't exist: " + file2.toString();
                JOptionPane.showMessageDialog(null, string6);
                bl2 = true;
                continue;
            }
            file2 = null;
        } while (bl2);
        return file2;
    }

    public File[] chooseFiles(String string, String string2, String string3, String string4) {
        return this.chooseFiles(IFileFilter.createCaseVariation(string), string2, string3, string4);
    }

    public File[] chooseFiles(String[] stringArray, String string, String string2, String string3) {
        File[] fileArray = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith(".")) continue;
            stringArray[i] = "." + stringArray[i];
        }
        if (string3 == null) {
            string3 = ".";
        }
        bl = false;
        JFileChooser jFileChooser = new JFileChooser(string3);
        jFileChooser.addChoosableFileFilter(new IFileFilter(stringArray, string));
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showDialog(null, string2);
        fileArray = n == 0 ? jFileChooser.getSelectedFiles() : null;
        return fileArray;
    }
}

