/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicServer;
import igeo.core.IG;
import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.geo.ICurveI;
import igeo.geo.IParticleAgent;
import igeo.geo.IParticleI;
import igeo.geo.IParticleOnCurve;
import igeo.geo.ITensionLine;
import igeo.geo.ITensionOnCurve;
import igeo.geo.IVec;
import igeo.geo.IVecI;
import igeo.util.IComparator;
import igeo.util.ISort;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITensileNet {
    public static double friction = 0.0;
    public static double tension = 1.0;
    public static double curveTension = 1.0;
    public ArrayList<ITensionLine> links;
    public ArrayList<IParticleAgent> nodes;

    ITensileNet() {
    }

    ITensileNet(ArrayList<ITensionLine> arrayList, ArrayList<IParticleAgent> arrayList2) {
        this.links = arrayList;
        this.nodes = arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray, boolean bl, boolean bl2, double d) {
        int n;
        IVec[] iVecArray;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray2 = new IVec[iCurveIArray.length][2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iVecArray2[i][0] = iCurveIArray[i].start().get();
            iVecArray2[i][1] = iCurveIArray[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray.length];
        IServer iServer = null;
        if (bl2) {
            for (n3 = 0; n3 < iCurveIArray.length; ++n3) {
                if (!(iCurveIArray[n3] instanceof IObject)) continue;
                colorArray[n3] = ((IObject)((Object)iCurveIArray[n3])).clr();
                ((IObject)((Object)iCurveIArray[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray[n3])).server();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray2.length; ++n3) {
            IVec[] iVecArray3 = iVecArray2[n3];
            if (iVecArray3[1].eq(iVecArray3[0], d)) {
                iVecArray3[1] = iVecArray3[0];
            }
            for (n2 = n3 + 1; n2 < iVecArray2.length; ++n2) {
                iVecArray = iVecArray2[n2];
                for (n = 0; n < 2; ++n) {
                    if (iVecArray[n].eq(iVecArray3[0], d)) {
                        iVecArray[n] = iVecArray3[0];
                        continue;
                    }
                    if (!iVecArray[n].eq(iVecArray3[1], d)) continue;
                    iVecArray[n] = iVecArray3[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (n2 = 0; n2 < 2; ++n2) {
                iVecArray = iVecArray2[i][n2];
                if (arrayList.contains(iVecArray)) continue;
                arrayList.add(iVecArray);
            }
        }
        if (bl) {
            ArrayList arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray2.length; ++n) {
                    if (iVecArray2[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray2[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
            if (iVecIArray != null) {
                for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                    arrayList2.add(iVecIArray[n2]);
                }
            }
            iVecIArray = arrayList2.toArray(new IVecI[arrayList2.size()]);
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            ArrayList<IParticleAgent> arrayList3 = new ArrayList<IParticleAgent>();
            for (n = 0; n < arrayList.size(); ++n) {
                IParticleAgent iParticleAgent = new IParticleAgent((IVec)arrayList.get(n));
                iParticleAgent.fric(friction);
                arrayList3.add(iParticleAgent);
            }
            if (iVecIArray != null) {
                for (n = 0; n < iVecIArray.length; ++n) {
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        if (!iVecIArray[n].eq(arrayList3.get(i), d)) continue;
                        arrayList3.get(i).fix();
                    }
                }
            }
            ArrayList<ITensionLine> arrayList4 = new ArrayList<ITensionLine>();
            for (int i = 0; i < iVecArray2.length; ++i) {
                IVec[] iVecArray4 = iVecArray2[i];
                int n5 = arrayList.indexOf(iVecArray4[0]);
                int n6 = arrayList.indexOf(iVecArray4[1]);
                if (n5 >= 0 && n6 >= 0) {
                    IParticleI iParticleI = arrayList3.get(n5);
                    IParticleI iParticleI2 = arrayList3.get(n6);
                    ITensionLine iTensionLine = new ITensionLine(iParticleI, iParticleI2, tension);
                    iTensionLine.tension(tension);
                    arrayList4.add(iTensionLine);
                    continue;
                }
                IOut.err("end point is not found");
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray, boolean bl, boolean bl2) {
        return ITensileNet.create(iCurveIArray, iVecIArray, bl, bl2, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray, boolean bl) {
        return ITensileNet.create(iCurveIArray, iVecIArray, bl, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, boolean bl) {
        return ITensileNet.create(iCurveIArray, null, bl, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray) {
        return ITensileNet.create(iCurveIArray, iVecIArray, false, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray) {
        return ITensileNet.create(iCurveIArray, null, true, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, null, true, false, true, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iVecIArray, true, false, true, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iVecIArray, true, bl, bl2, bl3, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3, double d) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iVecIArray, true, bl, bl2, bl3, d);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iVecIArray, bl, bl2, bl3, bl4, IConfig.tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d) {
        int n;
        IVec[] iVecArray;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no section curve input found");
            return null;
        }
        if (iCurveIArray2 == null || iCurveIArray2.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray2 = new IVec[iCurveIArray2.length][2];
        for (int i = 0; i < iCurveIArray2.length; ++i) {
            iVecArray2[i][0] = iCurveIArray2[i].start().get();
            iVecArray2[i][1] = iCurveIArray2[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray2.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray2.length];
        IServer iServer = null;
        if (bl4) {
            for (n3 = 0; n3 < iCurveIArray2.length; ++n3) {
                if (!(iCurveIArray2[n3] instanceof IObject)) continue;
                colorArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).clr();
                iLayerArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).layer();
                ((IObject)((Object)iCurveIArray2[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray2[n3])).server();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray2.length; ++n3) {
            IVec[] iVecArray3 = iVecArray2[n3];
            if (iVecArray3[1].eq(iVecArray3[0], d)) {
                iVecArray3[1] = iVecArray3[0];
            }
            for (n2 = n3 + 1; n2 < iVecArray2.length; ++n2) {
                iVecArray = iVecArray2[n2];
                for (n = 0; n < 2; ++n) {
                    if (iVecArray[n].eq(iVecArray3[0], d)) {
                        iVecArray[n] = iVecArray3[0];
                        continue;
                    }
                    if (!iVecArray[n].eq(iVecArray3[1], d)) continue;
                    iVecArray[n] = iVecArray3[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (n2 = 0; n2 < 2; ++n2) {
                iVecArray = iVecArray2[i][n2];
                if (arrayList.contains(iVecArray)) continue;
                arrayList.add(iVecArray);
            }
        }
        if (bl2) {
            ArrayList arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray2.length; ++n) {
                    if (iVecArray2[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray2[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
            if (iVecIArray != null) {
                for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                    arrayList2.add(iVecIArray[n2]);
                }
            }
            iVecIArray = arrayList2.toArray(new IVecI[arrayList2.size()]);
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            blArray[n2] = false;
            if (iVecIArray == null) continue;
            for (int i = 0; i < iVecIArray.length && !blArray[n2]; ++i) {
                if (!iVecIArray[i].eq((IVecI)arrayList.get(n2), d)) continue;
                blArray[n2] = true;
            }
        }
        ArrayList[] arrayListArray = null;
        if (bl) {
            ArrayList[] arrayListArray2;
            arrayListArray = arrayListArray2 = new ArrayList[iCurveIArray.length];
            for (n = 0; n < arrayListArray.length; ++n) {
                arrayListArray[n] = new ArrayList();
            }
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            int n5;
            int n6;
            int n7;
            Object object;
            ArrayList<IParticleAgent> arrayList3 = new ArrayList<IParticleAgent>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.size() > 100 && i % 100 == 0) {
                    IOut.debug(0, "finding curve for point to be on (" + i + "/" + arrayList.size() + ")");
                }
                IParticleOnCurve iParticleOnCurve = ITensileNet.createParticleOnClosestCurve(iCurveIArray, (IVec)arrayList.get(i), d, 0.001);
                object = null;
                if (iParticleOnCurve != null) {
                    object = new IParticleAgent(iParticleOnCurve);
                } else {
                    object = new IParticleAgent((IVec)arrayList.get(i));
                    ((IParticleAgent)object).fix();
                    ((IParticleAgent)object).clr(1.0, 1.0, 0.0);
                }
                ((IParticleAgent)object).fric(friction);
                arrayList3.add((IParticleAgent)object);
                if (blArray[i]) {
                    ((IParticleAgent)object).fix();
                    ((IParticleAgent)object).clr(1.0, 1.0, 0.0);
                }
                if (iParticleOnCurve == null || !bl) continue;
                n7 = -1;
                for (n6 = 0; n6 < iCurveIArray.length && n7 < 0; ++n6) {
                    if (iCurveIArray[n6] != iParticleOnCurve.curve()) continue;
                    n7 = n6;
                }
                if (n7 >= 0) {
                    arrayListArray[n7].add(iParticleOnCurve);
                }
                if (!bl3 || !(iParticleOnCurve.upos() < IConfig.parameterTolerance) && !(iParticleOnCurve.upos() > 1.0 - IConfig.parameterTolerance)) continue;
                iParticleOnCurve.fix();
                if (object == null) continue;
                ((IParticleAgent)object).clr(1.0, 1.0, 0.0);
            }
            ArrayList<ITensionLine> arrayList4 = new ArrayList<ITensionLine>();
            for (n5 = 0; n5 < iVecArray2.length; ++n5) {
                object = iVecArray2[n5];
                n7 = arrayList.indexOf(object[0]);
                n6 = arrayList.indexOf(object[1]);
                if (n7 >= 0 && n6 >= 0) {
                    IParticleI iParticleI = arrayList3.get(n7);
                    IParticleI iParticleI2 = arrayList3.get(n6);
                    ITensionLine iTensionLine = new ITensionLine(iParticleI, iParticleI2, tension);
                    if (colorArray[n5] != null) {
                        iTensionLine.clr(colorArray[n5]);
                    }
                    if (iLayerArray[n5] != null) {
                        iTensionLine.layer(iLayerArray[n5]);
                    }
                    iTensionLine.tension(tension);
                    arrayList4.add(iTensionLine);
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (bl) {
                for (n5 = 0; n5 < iCurveIArray.length; ++n5) {
                    if (arrayListArray[n5].size() <= 1) continue;
                    ISort.sort(arrayListArray[n5], new IParticleOnCurveComparator());
                    for (int i = 0; i < arrayListArray[n5].size() - 1; ++i) {
                        new ITensionOnCurve((IParticleOnCurve)arrayListArray[n5].get(i), (IParticleOnCurve)arrayListArray[n5].get(i + 1), curveTension);
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iCurveIArray3, iVecIArray, true, false, true, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iCurveIArray3, iVecIArray, bl, bl2, bl3, true, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return ITensileNet.create(iCurveIArray, iCurveIArray2, iCurveIArray3, iVecIArray, bl, bl2, bl3, bl4, IConfig.tolerance);
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d) {
        int n;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (n = 0; n < iCurveIArray3.length; ++n) {
            int n2;
            IVec iVec;
            IVec iVec2 = iCurveIArray3[n].start().get();
            if (iVec2.eq(iVec = iCurveIArray3[n].end().get(), d)) {
                iVec = null;
            }
            for (n2 = 0; n2 < arrayList.size() && iVec2 != null; ++n2) {
                if (!iVec2.eq((IVecI)arrayList.get(n2), d)) continue;
                iVec2 = null;
            }
            if (iVec2 != null) {
                arrayList.add(iVec2);
            }
            for (n2 = 0; n2 < arrayList.size() && iVec != null; ++n2) {
                if (!iVec.eq((IVecI)arrayList.get(n2), d)) continue;
                iVec = null;
            }
            if (iVec == null) continue;
            arrayList.add(iVec);
        }
        for (n = 0; iVecIArray != null && n < iVecIArray.length; ++n) {
            arrayList.add(iVecIArray[n]);
        }
        return ITensileNet.create(iCurveIArray, iCurveIArray2, arrayList.toArray(new IVecI[arrayList.size()]), bl, bl2, bl3, bl4, d);
    }

    public static ICurveI findClosestCurve(ICurveI[] iCurveIArray, IVec iVec, int n) {
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j <= n; ++j) {
                double d2 = iCurveIArray[i].pt((double)j / (double)n).dist(iVec);
                if (n2 >= 0 && !(d2 < d)) continue;
                n2 = i;
                d = d2;
            }
        }
        if (n2 < 0) {
            return null;
        }
        return iCurveIArray[n2];
    }

    public static IParticleOnCurve createParticleOnClosestCurve(ICurveI[] iCurveIArray, IVec iVec, double d, double d2) {
        IParticleOnCurve iParticleOnCurve = null;
        do {
            ICurveI iCurveI = null;
            iCurveI = iCurveIArray.length == 1 ? iCurveIArray[0] : ITensileNet.findClosestCurve(iCurveIArray, iVec, 20);
            iParticleOnCurve = ITensileNet.createParticleOnCurve(iCurveI, iVec, d, d2);
            if (iParticleOnCurve != null) continue;
            if (iCurveIArray.length > 1) {
                ICurveI[] iCurveIArray2 = new ICurveI[iCurveIArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n < iCurveIArray.length) {
                    if (iCurveIArray[n] != iCurveI) {
                        iCurveIArray2[n2] = iCurveIArray[n];
                    } else {
                        --n2;
                    }
                    ++n;
                    ++n2;
                }
                iCurveIArray = iCurveIArray2;
                continue;
            }
            return null;
        } while (iParticleOnCurve == null && iCurveIArray.length > 1);
        return iParticleOnCurve;
    }

    public static IParticleOnCurve createParticleOnCurve(ICurveI iCurveI, IVec iVec, double d, double d2) {
        int n = 0;
        if (iCurveI == null) {
            return null;
        }
        n = d2 == 0.0 ? 10000 : (int)(1.0 / d2 + 0.5);
        double d3 = -1.0;
        double d4 = -1.0;
        for (int i = 0; i <= n; ++i) {
            double d5 = (double)i / (double)n;
            double d6 = iCurveI.pt(d5).dist(iVec);
            if (!(d4 < 0.0) && !(d6 < d3)) continue;
            d3 = d6;
            d4 = d5;
        }
        if (d4 >= 0.0) {
            IVec iVec2 = iCurveI.pt(d4).get();
            IVec iVec3 = iCurveI.tan(d4).get();
            double d7 = iVec3.len2();
            double d8 = iVec.diff(iVec2).dot(iVec3) / d7;
            if ((d4 += d8) < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d3 = iCurveI.pt(d4).dist(iVec);
        }
        if (d >= 0.0 && d3 > d) {
            return null;
        }
        return new IParticleOnCurve(iCurveI, d4, iVec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IParticleOnCurveComparator
    implements IComparator<IParticleOnCurve> {
        @Override
        public int compare(IParticleOnCurve iParticleOnCurve, IParticleOnCurve iParticleOnCurve2) {
            if (iParticleOnCurve.upos() < iParticleOnCurve2.upos()) {
                return -1;
            }
            if (iParticleOnCurve.upos() > iParticleOnCurve2.upos()) {
                return 1;
            }
            return 0;
        }
    }
}

