/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IObject;
import igeo.geo.IBool;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IDynamics;
import igeo.geo.IDynamicsBase;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.IParticleI;
import igeo.geo.IPoint;
import igeo.geo.IPointR;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec4;
import igeo.geo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticle
extends IDynamicsBase
implements IParticleI,
IVecI {
    static double defaultFriction = 0.0;
    public double mass = 1.0;
    public IVec pos;
    public IVec vel;
    public IVec frc;
    boolean fixed = false;
    public double friction = defaultFriction;

    public IParticle(IVec iVec) {
        this.pos = iVec;
        this.initParticle();
    }

    public IParticle(IVec iVec, IObject iObject) {
        super(iObject);
        this.pos = iVec;
        this.initParticle();
    }

    public IParticle(IVecI iVecI) {
        this.pos = iVecI.get();
        this.initParticle();
    }

    public IParticle(IVecI iVecI, IObject iObject) {
        super(iObject);
        this.pos = iVecI.get();
        this.initParticle();
    }

    public IParticle(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.initParticle();
    }

    public IParticle(double d, double d2, double d3, IObject iObject) {
        super(iObject);
        this.pos = new IVec(d, d2, d3);
        this.initParticle();
    }

    public IParticle(IPoint iPoint) {
        super(iPoint);
        this.pos = iPoint.pos;
        this.initParticle();
    }

    public IParticle(IPointR iPointR) {
        super(iPointR);
        this.pos = iPointR.pos.get();
        this.initParticle();
    }

    public IParticle(IParticle iParticle) {
        super(iParticle.parent);
        this.pos = iParticle.pos.dup();
        this.initParticle();
    }

    public IParticle(IParticle iParticle, IObject iObject) {
        super(iObject);
        this.pos = iParticle.pos.dup();
        this.initParticle();
    }

    public synchronized void initParticle() {
        this.vel = new IVec();
        this.frc = new IVec();
    }

    @Override
    public IParticle dup() {
        return new IParticle(this);
    }

    public synchronized IParticle fix() {
        this.fixed = true;
        return this;
    }

    public synchronized IParticle unfix() {
        this.fixed = false;
        return this;
    }

    @Override
    public synchronized double mass() {
        return this.mass;
    }

    public synchronized IParticle mass(double d) {
        this.mass = d;
        return this;
    }

    @Override
    public synchronized IVec position() {
        return this.pos();
    }

    public synchronized IParticle position(IVec iVec) {
        this.pos(iVec);
        return this;
    }

    @Override
    public synchronized IVec pos() {
        return this.pos;
    }

    public synchronized IParticle pos(IVec iVec) {
        this.pos.set(iVec);
        return this;
    }

    @Override
    public synchronized IVec velocity() {
        return this.vel();
    }

    public synchronized IParticle velocity(IVec iVec) {
        this.vel(iVec);
        return this;
    }

    @Override
    public synchronized IVec vel() {
        return this.vel;
    }

    public synchronized IParticle vel(IVec iVec) {
        this.vel.set(iVec);
        return this;
    }

    public synchronized IVec force() {
        return this.frc();
    }

    public synchronized IParticle force(IVec iVec) {
        this.frc(iVec);
        return this;
    }

    public synchronized IVec frc() {
        return this.frc;
    }

    public synchronized IParticle frc(IVec iVec) {
        this.frc.set(iVec);
        return this;
    }

    public synchronized double friction() {
        return this.fric();
    }

    public synchronized IParticle friction(double d) {
        this.fric(d);
        return this;
    }

    public synchronized double fric() {
        return this.friction;
    }

    public synchronized IParticle fric(double d) {
        this.friction = d;
        return this;
    }

    @Override
    public synchronized IParticle addForce(IVec iVec) {
        this.frc.add(iVec);
        return this;
    }

    @Override
    public synchronized IParticle resetForce() {
        this.frc.set(0.0, 0.0, 0.0);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public synchronized void update() {
        if (this.fixed) {
            return;
        }
        this.vel.add(this.frc.mul(IConfig.updateRate / this.mass)).mul(1.0 - this.friction);
        this.pos.add(this.vel.dup().mul(IConfig.updateRate));
        this.frc.set(0.0, 0.0, 0.0);
        this.updateTarget();
    }

    @Override
    public double x() {
        return this.pos.x();
    }

    @Override
    public double y() {
        return this.pos.y();
    }

    @Override
    public double z() {
        return this.pos.z();
    }

    @Override
    public IVec get() {
        return this.pos.get();
    }

    @Override
    public IVec2 to2d() {
        return this.pos.to2d();
    }

    @Override
    public IVec4 to4d() {
        return this.pos.to4d();
    }

    @Override
    public IVec4 to4d(double d) {
        return this.pos.to4d(d);
    }

    @Override
    public IVec4 to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    @Override
    public IDouble getX() {
        return this.pos.getX();
    }

    @Override
    public IDouble getY() {
        return this.pos.getY();
    }

    @Override
    public IDouble getZ() {
        return this.pos.getZ();
    }

    @Override
    public IParticle set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IParticle set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IParticle set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IParticle add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IParticle sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IParticle sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IParticle mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IParticle mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IParticle div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IParticle div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IParticle neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IParticle rev() {
        return this.neg();
    }

    @Override
    public IParticle flip() {
        return this.neg();
    }

    @Override
    public IParticle add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IParticle add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    @Override
    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    @Override
    public IVec cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    @Override
    public double len() {
        return this.pos.len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    @Override
    public IDouble len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    @Override
    public double len2() {
        return this.pos.len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    @Override
    public IDouble len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    @Override
    public IParticle len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IParticle len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IParticle unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    @Override
    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    @Override
    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    @Override
    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    @Override
    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    @Override
    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    @Override
    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    @Override
    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    @Override
    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    @Override
    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    @Override
    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    @Override
    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    @Override
    public IParticle rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticle scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IParticle scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IParticle scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticle ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticle ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticle mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticle shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticle shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IParticle shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IParticle shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IParticle shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IParticle translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IParticle transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IParticle transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IParticle transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticle transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IParticle mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IParticle mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticle mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IParticle cp() {
        return this.dup();
    }

    @Override
    public IParticle cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IParticle cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticle cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec diff(IVecI iVecI) {
        return this.pos.diff(iVecI);
    }

    @Override
    public IVec mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    @Override
    public IVec sum(IVecI iVecI) {
        return this.pos.sum(iVecI);
    }

    @Override
    public IVec sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    @Override
    public IVec bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    @Override
    public IVec sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    @Override
    public IVec sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    @Override
    public IVec sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI, iDoubleI, iDoubleI2);
    }

    @Override
    public IVec sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI, iDoubleI);
    }

    @Override
    public IVec nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    @Override
    public IVec nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    @Override
    public boolean isValid() {
        return this.pos.isValid();
    }

    public String toString() {
        return this.pos.toString();
    }
}

