/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IObject;
import igeo.geo.ICurve;
import igeo.geo.IParticle;
import igeo.geo.IParticleI;
import igeo.geo.ITension;
import igeo.geo.IVec;
import igeo.geo.IVecI;

public class ITensionLine
extends ICurve {
    public ITension tensionDynamics;

    public ITensionLine(IParticleI iParticleI, IParticleI iParticleI2) {
        super(iParticleI.pos(), iParticleI2.pos());
        this.initTensionLine(iParticleI, iParticleI2);
    }

    public ITensionLine(IParticleI iParticleI, IParticleI iParticleI2, double d) {
        super(iParticleI.pos(), iParticleI2.pos());
        this.initTensionLine(iParticleI, iParticleI2);
        this.tension(d);
    }

    public ITensionLine(IParticle iParticle, IParticle iParticle2) {
        super(iParticle.pos(), iParticle2.pos());
        this.initTensionLine(iParticle, iParticle2);
    }

    public ITensionLine(IParticle iParticle, IParticle iParticle2, double d) {
        super(iParticle.pos(), iParticle2.pos());
        this.initTensionLine(iParticle, iParticle2);
        this.tension(d);
    }

    public ITensionLine(IVec iVec, IVec iVec2) {
        super(iVec, iVec2);
        this.initTensionLine(new IParticle(iVec), new IParticle(iVec2));
    }

    public ITensionLine(IVec iVec, IVec iVec2, double d) {
        super(iVec, iVec2);
        this.initTensionLine(new IParticle(iVec), new IParticle(iVec2));
        this.tension(d);
    }

    public ITensionLine(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
        this.initTensionLine(new IParticle(iVecI.get()), new IParticle(iVecI2.get()));
    }

    public ITensionLine(IVecI iVecI, IVecI iVecI2, double d) {
        super(iVecI, iVecI2);
        this.initTensionLine(new IParticle(iVecI.get()), new IParticle(iVecI2.get()));
        this.tension(d);
    }

    public void initTensionLine(IParticleI iParticleI, IParticleI iParticleI2) {
        this.tensionDynamics = new ITension(iParticleI, iParticleI2, (IObject)this);
        this.addDynamics(this.tensionDynamics);
    }

    public double tension() {
        return this.tensionDynamics.tension();
    }

    public ITensionLine tension(double d) {
        this.tensionDynamics.tension(d);
        return this;
    }
}

