/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicObjectBase;
import igeo.core.IObject;
import igeo.geo.IParticle;
import igeo.geo.IVec;
import igeo.geo.IVecI;

public class IParticleDistanceLink
extends IDynamicObjectBase {
    public IParticle particle;
    public IVecI center;
    public double distance;

    public IParticleDistanceLink(IParticle iParticle, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particle = iParticle;
        this.center = iVecI;
        this.distance = this.center.dist(this.particle);
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticle iParticle, IVecI iVecI) {
        this.particle = iParticle;
        this.center = iVecI;
        this.distance = this.center.dist(this.particle);
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticle iParticle, IVecI iVecI, double d, IObject iObject) {
        super(iObject);
        this.particle = iParticle;
        this.center = iVecI;
        this.distance = d;
        iParticle.pos.set(iParticle.pos.diff(this.center).len(this.distance).add(this.center));
        if (this.distance < 0.0) {
            this.distance = -this.distance;
        }
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticle iParticle, double d, IVecI iVecI) {
        this.particle = iParticle;
        this.center = iVecI;
        this.distance = d;
        iParticle.pos.set(iParticle.pos.diff(this.center).len(this.distance).add(this.center));
        if (this.distance < 0.0) {
            this.distance = -this.distance;
        }
        this.initParticleDistanceLink();
    }

    public void initParticleDistanceLink() {
        this.particle.fix();
    }

    public synchronized void update() {
        IVec iVec = this.particle.pos.diff(this.center);
        this.particle.frc.set(this.particle.frc.perpendicularVectorToVector(iVec));
        this.particle.frc.mul(IConfig.dynamicsSpeed / this.particle.mass);
        this.particle.vel.add(this.particle.frc).mul(1.0 - this.particle.friction);
        this.particle.vel.set(this.particle.vel.perpendicularVectorToVector(iVec));
        this.particle.pos.add(this.particle.vel.dup().mul(IConfig.dynamicsSpeed));
        iVec = this.particle.pos.diff(this.center);
        iVec.len(this.distance).add(this.center);
        this.particle.pos.set(iVec);
        this.particle.updateTarget();
        this.updateTarget();
    }
}

