/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicObjectBase;
import igeo.core.IObject;
import igeo.geo.IParticle;
import igeo.geo.IVec;
import igeo.geo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticleDirectionLink
extends IDynamicObjectBase {
    public ArrayList<IParticle> particles;
    public IVecI center;
    public IVec vel;

    public IParticleDirectionLink(ArrayList<IParticle> arrayList, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = arrayList;
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IParticle[] iParticleArray, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = new ArrayList();
        for (int i = 0; i < iParticleArray.length; ++i) {
            this.particles.add(iParticleArray[i]);
        }
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particles = new ArrayList();
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(ArrayList<IParticle> arrayList, IVecI iVecI) {
        this.particles = arrayList;
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IParticle[] iParticleArray, IVecI iVecI) {
        this.particles = new ArrayList();
        for (int i = 0; i < iParticleArray.length; ++i) {
            this.particles.add(iParticleArray[i]);
        }
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public IParticleDirectionLink(IVecI iVecI) {
        this.particles = new ArrayList();
        this.center = iVecI;
        this.initParticleDirectionLink();
    }

    public void initParticleDirectionLink() {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.particles.get(i).fix();
        }
    }

    public void add(IParticle iParticle) {
        iParticle.fix();
        this.particles.add(iParticle);
    }

    @Override
    public synchronized void update() {
        IParticle iParticle;
        int n;
        IVec iVec = new IVec();
        double d = 0.0;
        double[] dArray = new double[this.particles.size()];
        IVec[] iVecArray = new IVec[this.particles.size()];
        IVec iVec2 = new IVec();
        for (int i = 0; i < this.particles.size(); ++i) {
            IParticle iParticle2 = this.particles.get(i);
            iVecArray[i] = iParticle2.pos.diff(this.center);
            iVec.add(iVecArray[i].cross(iParticle2.frc));
            dArray[i] = iVecArray[i].len2();
            d += iParticle2.mass * dArray[i];
            if (!(dArray[i] > IConfig.lengthResolution)) continue;
            iVec2.add(iVecArray[i].cross(iParticle2.vel).div(dArray[i]));
        }
        iVec2.div(this.particles.size());
        iVec2.add(iVec.mul(IConfig.dynamicsSpeed / d));
        IVec iVec3 = new IVec();
        for (n = 0; n < this.particles.size(); ++n) {
            iParticle = this.particles.get(n);
            iParticle.frc.projectToVec(iVecArray[n]);
            iParticle.frc.mul(IConfig.dynamicsSpeed / iParticle.mass);
            iParticle.vel.projectToVec(iVecArray[n]);
            iParticle.vel.add(iParticle.frc);
            iParticle.vel.add(iVec2.cross(iVecArray[n]));
            iParticle.vel.mul(1.0 - iParticle.friction);
            iParticle.pos.add(iParticle.vel.dup().mul(IConfig.dynamicsSpeed));
            iVecArray[n] = iParticle.pos.diff(this.center);
            if (iVec3.len() < IConfig.lengthResolution) {
                if (!(iVecArray[n].len() > IConfig.lengthResolution)) continue;
                iVec3.add(iVecArray[n]);
                continue;
            }
            if (iVec3.dot(iVecArray[n]) < 0.0) {
                iVec3.add(iVecArray[n], -1.0);
                continue;
            }
            iVec3.add(iVecArray[n]);
        }
        if (iVec3.len() < IConfig.lengthResolution) {
            iVec3.set(0.0, 0.0, 1.0);
        }
        for (n = 0; n < this.particles.size(); ++n) {
            iParticle = this.particles.get(n);
            iParticle.pos.set(iParticle.pos.projectToLine(this.center, iVec3));
            iParticle.updateTarget();
            iParticle.frc.set(0.0, 0.0, 0.0);
        }
        this.updateTarget();
    }
}

