/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IGraphicI;
import igeo.core.IGraphicObject;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanel;
import igeo.gui.IView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGraphicServer {
    public ArrayList<IGraphicI> graphicsGL;
    public HashMap<IView, ArrayList<IGraphicI>> graphicsJava;
    public ArrayList<IView> views;
    public IServer server;
    public IPanel panel;
    public IGraphicMode[] modes = null;
    public boolean useGL;

    public IGraphicServer(IServer iServer, IPanel iPanel) {
        this.server = iServer;
        this.panel = iPanel;
        this.views = new ArrayList();
        for (int i = 0; i < this.panel.paneNum(); ++i) {
            this.views.add(this.panel.getPane(i).getView());
        }
    }

    public void addView(IView iView) {
        this.views.add(iView);
    }

    public IView view(int n) {
        return this.views.get(n);
    }

    public int viewNum() {
        return this.views.size();
    }

    public void setMode(IGraphicMode iGraphicMode) {
        if (this.views != null) {
            for (IView iView : this.views) {
                iView.setMode(new IGraphicMode(iGraphicMode));
            }
        }
    }

    public void enableGL() {
        this.useGL = true;
    }

    public void disableGL() {
        this.useGL = false;
    }

    public boolean isGL() {
        return this.useGL;
    }

    public void bg(Color color, Color color2, Color color3, Color color4) {
        if (this.views != null) {
            for (IView iView : this.views) {
                iView.setBGColor(color, color2, color3, color4);
            }
        }
    }

    public void background(Color color, Color color2, Color color3, Color color4) {
        this.bg(color, color2, color3, color4);
    }

    public void add(IObject iObject) {
        boolean bl = false;
        for (IView iView : this.views) {
            if (!iView.mode().isGL()) continue;
            bl = true;
        }
        if (bl) {
            IGraphicObject iGraphicObject = iObject.getGraphic(this.views.get(0).mode());
            if (iGraphicObject != null) {
                this.add(iGraphicObject, this.views.get(0));
            } else {
                IOut.err("graphic of the object is null : " + iObject);
            }
        } else {
            for (IView iView : this.views) {
                IGraphicObject iGraphicObject = iObject.getGraphic(iView.mode());
                if (iGraphicObject != null) {
                    this.add(iGraphicObject, iView);
                    continue;
                }
                IOut.err("graphic of the object is null : " + iObject);
            }
        }
    }

    public void add(IGraphicI iGraphicI, IView iView) {
        if (iView.mode().isGL()) {
            if (this.graphicsGL == null) {
                this.graphicsGL = new ArrayList();
            }
            this.graphicsGL.add(iGraphicI);
        } else if (iView.mode().isJava()) {
            ArrayList<IGraphicI> arrayList;
            if (this.graphicsJava == null) {
                this.graphicsJava = new HashMap();
            }
            if ((arrayList = this.graphicsJava.get(iView)) == null) {
                arrayList = new ArrayList();
                this.graphicsJava.put(iView, arrayList);
            }
            arrayList.add(iGraphicI);
        }
    }

    public ArrayList<IGraphicI> getObjects(IView iView) {
        if (iView.mode().isGL()) {
            return this.graphicsGL;
        }
        if (iView.mode().isJava()) {
            return this.graphicsJava.get(iView);
        }
        return null;
    }

    public void remove(IGraphicI iGraphicI) {
        if (this.modes == null) {
            this.modes = IGraphicMode.getAllModes();
        }
        for (IGraphicMode iGraphicMode : this.modes) {
            if (!iGraphicI.isDrawable(iGraphicMode)) continue;
            if (iGraphicMode.isGL()) {
                this.graphicsGL.remove(iGraphicI);
                continue;
            }
            if (!iGraphicMode.isJava()) continue;
            for (IView iView : this.views) {
                if (this.graphicsJava.get(iView) == null) continue;
                this.graphicsJava.get(iView).remove(iGraphicI);
            }
        }
    }

    public void clearObjects() {
        if (this.graphicsGL != null) {
            this.graphicsGL.clear();
            this.graphicsGL = null;
        }
        if (this.graphicsJava != null) {
            for (IView iView : this.views) {
                if (this.graphicsJava.get(iView) == null) continue;
                this.graphicsJava.get(iView).clear();
            }
            this.graphicsJava.clear();
            this.graphicsJava = null;
        }
    }

    public void clearViews() {
        this.views.clear();
    }
}

