/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IDynamicObject;
import igeo.core.IG;
import igeo.core.IObject;
import igeo.core.IServerI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDynamicObjectBase
implements IDynamicObject {
    public IObject parent = null;
    public ArrayList<IObject> targets;

    public IDynamicObjectBase() {
        this.initDynamicObjectBase();
    }

    public IDynamicObjectBase(IServerI iServerI) {
        this.initDynamicObjectBase(iServerI);
    }

    public IDynamicObjectBase(IObject iObject) {
        this.parent(iObject);
    }

    public void initDynamicObjectBase() {
        this.initDynamicObjectBase(IG.cur());
    }

    public void initDynamicObjectBase(IServerI iServerI) {
        if (iServerI != null) {
            iServerI.server().dynamicServer().add(this);
        }
    }

    @Override
    public IObject parent() {
        return this.parent;
    }

    @Override
    public IDynamicObjectBase parent(IObject iObject) {
        if (this.parent != null) {
            this.parent.deleteDynamics(this);
            this.removeTarget(this.parent);
        }
        this.parent = iObject;
        if (this.parent != null) {
            this.parent.addDynamics(this);
            this.target(this.parent);
        }
        return this;
    }

    @Override
    public IDynamicObjectBase target(IObject iObject) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        this.targets.add(iObject);
        return this;
    }

    @Override
    public int targetNum() {
        return this.targets == null ? 0 : this.targets.size();
    }

    @Override
    public IObject target(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        return this.targets.get(n);
    }

    @Override
    public ArrayList<IObject> targets() {
        return this.targets;
    }

    @Override
    public IDynamicObjectBase removeTarget(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        this.targets.remove(n);
        return this;
    }

    @Override
    public IDynamicObjectBase removeTarget(IObject iObject) {
        this.targets.remove(iObject);
        return this;
    }

    @Override
    public void updateTarget() {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                if (this.targets.get(i).server() == null) continue;
                this.targets.get(i).updateGraphic();
            }
        }
    }

    @Override
    public void interact(ArrayList<IDynamicObject> arrayList) {
    }

    @Override
    public void update() {
    }
}

