/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicObject;
import igeo.core.IObject;
import igeo.geo.ICurve;
import igeo.geo.ICurveI;
import igeo.geo.IParticle;
import igeo.geo.IPoint;
import igeo.geo.IVec;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticleOnCurve
extends IParticle {
    public ICurveI curve;
    public double upos;
    public double uvel;
    public double uacc;
    public double ufrc;
    public IVec utan;

    public IParticleOnCurve(ICurveI iCurveI) {
        this(iCurveI, 0.0);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d) {
        super(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, IVec iVec) {
        this(iCurveI, 0.0, iVec);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IVec iVec) {
        super(iVec);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, IObject iObject) {
        this(iCurveI, 0.0, iObject);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IObject iObject) {
        super(iCurveI.pt(d).get(), iObject);
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, IVec iVec, IObject iObject) {
        this(iCurveI, 0.0, iVec, iObject);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IVec iVec, IObject iObject) {
        super(iVec, iObject);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IPoint iPoint) {
        this(iCurveI, d, iPoint.pos, iPoint);
    }

    public IParticleOnCurve(ICurveI iCurveI, IPoint iPoint) {
        this(iCurveI, 0.0, iPoint);
    }

    public IParticleOnCurve(ICurve iCurve) {
        this((ICurveI)iCurve, 0.0, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d) {
        this((ICurveI)iCurve, d, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, IVec iVec) {
        this(iCurve, 0.0, iVec, iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d, IVec iVec) {
        this(iCurve, d, iVec, iCurve);
    }

    @Override
    public synchronized void interact(ArrayList<IDynamicObject> arrayList) {
    }

    @Override
    public synchronized void update() {
        if (this.fixed || this.curve == null) {
            return;
        }
        this.utan = this.curve.tan(this.upos).get();
        this.ufrc = this.frc.projectToVec(this.utan) > 0.0 ? this.frc.len() / this.utan.len() : -this.frc.len() / this.utan.len();
        this.uvel += this.ufrc / this.mass * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
        this.uvel *= 1.0 - this.friction;
        if (this.upos + this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0 < 0.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 0.0;
                this.uvel = 0.0;
            }
        } else if (this.upos + this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0 > 1.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 1.0;
                this.uvel = 0.0;
            }
        } else {
            this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
        }
        this.pos.set(this.curve.pt(this.upos));
        this.frc.set(0.0, 0.0, 0.0);
    }
}

