/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicObject;
import igeo.core.IDynamicObjectBase;
import igeo.geo.IVec;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticle
extends IDynamicObjectBase {
    static double defaultFriction = 0.0;
    public double mass = 1.0;
    public IVec pos;
    public IVec vel;
    public IVec acc;
    public IVec frc;
    boolean fixed = false;
    public double friction = defaultFriction;

    public IParticle(IVec iVec) {
        this.pos = iVec;
        this.initParticle();
    }

    public synchronized void initParticle() {
        this.vel = new IVec();
        this.acc = new IVec();
        this.frc = new IVec();
    }

    public synchronized IParticle fix() {
        this.fixed = true;
        return this;
    }

    public synchronized IParticle unfix() {
        this.fixed = false;
        return this;
    }

    public synchronized double mass() {
        return this.mass;
    }

    public synchronized IParticle mass(double d) {
        this.mass = d;
        return this;
    }

    public synchronized IVec position() {
        return this.pos();
    }

    public synchronized IParticle position(IVec iVec) {
        this.pos(iVec);
        return this;
    }

    public synchronized IVec pos() {
        return this.pos;
    }

    public synchronized IParticle pos(IVec iVec) {
        this.pos.set(iVec);
        return this;
    }

    public synchronized IVec velocity() {
        return this.vel();
    }

    public synchronized IParticle velocity(IVec iVec) {
        this.vel(iVec);
        return this;
    }

    public synchronized IVec vel() {
        return this.vel;
    }

    public synchronized IParticle vel(IVec iVec) {
        this.vel.set(iVec);
        return this;
    }

    public synchronized IVec acceleration() {
        return this.acc();
    }

    public synchronized IParticle acceleration(IVec iVec) {
        this.acc(iVec);
        return this;
    }

    public synchronized IVec acc() {
        return this.acc;
    }

    public synchronized IParticle acc(IVec iVec) {
        this.acc.set(iVec);
        return this;
    }

    public synchronized IVec force() {
        return this.frc();
    }

    public synchronized IParticle force(IVec iVec) {
        this.frc(iVec);
        return this;
    }

    public synchronized IVec frc() {
        return this.frc;
    }

    public synchronized IParticle frc(IVec iVec) {
        this.frc.set(iVec);
        return this;
    }

    public synchronized double friction() {
        return this.fric();
    }

    public synchronized IParticle friction(double d) {
        this.fric(d);
        return this;
    }

    public synchronized double fric() {
        return this.friction;
    }

    public synchronized IParticle fric(double d) {
        this.friction = d;
        return this;
    }

    public synchronized IParticle addForce(IVec iVec) {
        this.frc.add(iVec);
        return this;
    }

    public synchronized IParticle resetForce() {
        this.frc.set(0.0, 0.0, 0.0);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamicObject> arrayList) {
    }

    @Override
    public synchronized void update() {
        if (this.fixed) {
            return;
        }
        this.pos.add(this.vel.add(this.frc.mul(this.mass * (double)IConfig.dynamicsUpdateSpeed / 1000.0)).mul(1.0 - this.friction));
        this.frc.set(0.0, 0.0, 0.0);
    }
}

