/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IDynamicObject;
import igeo.core.ILayer;
import igeo.geo.IDoubleI;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.IParticleAgent;
import igeo.geo.IVec;
import igeo.geo.IVecI;
import igeo.util.IRandom;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBoid
extends IParticleAgent {
    public double neighborDist = 300.0;
    public double separationDist = 10.0;
    public double separationRatio = 0.3;
    public double alignmentDist = 20.0;
    public double alignmentRatio = 0.03;
    public double alignmentMaxVelocity = 2.0;
    public double coherenceRatio = 0.02;
    public double randomVelocityPercent = 0.01;
    public double randomVelocityRange = 20.0;
    public ArrayList<IBoid> neighbors;

    public IBoid() {
    }

    public IBoid(IVecI iVecI) {
        super(iVecI);
    }

    public IBoid(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public IBoid(IBoid iBoid) {
        super(iBoid);
        this.neighborDist = iBoid.neighborDist;
        this.separationDist = iBoid.separationDist;
        this.separationRatio = iBoid.separationRatio;
        this.alignmentDist = iBoid.alignmentDist;
        this.alignmentRatio = iBoid.alignmentRatio;
        this.alignmentMaxVelocity = iBoid.alignmentMaxVelocity;
        this.coherenceRatio = iBoid.coherenceRatio;
        this.randomVelocityPercent = iBoid.randomVelocityPercent;
        this.randomVelocityRange = iBoid.randomVelocityRange;
    }

    public synchronized void flock() {
        this.separate();
        this.align();
        this.cohere();
    }

    public synchronized void separate() {
        for (IBoid iBoid : this.neighbors) {
            double d = this.dist(iBoid);
            if (!(d < this.separationDist) || !(d > 0.0)) continue;
            double d2 = (this.separationDist - d) / this.separationDist;
            IVec iVec = this.diff(iBoid);
            iVec.len(this.separationRatio * d2);
            this.addForce(iVec);
        }
    }

    public synchronized void align() {
        if (this.neighbors.size() == 0) {
            return;
        }
        IVec iVec = new IVec();
        for (IBoid iBoid : this.neighbors) {
            double d = this.dist(iBoid);
            if (!(d < this.alignmentDist)) continue;
            iVec.add(iBoid.velocity());
        }
        iVec.div(this.neighbors.size());
        if (iVec.len() > this.alignmentMaxVelocity) {
            iVec.len(this.alignmentMaxVelocity);
        }
        iVec.mul(this.alignmentRatio);
        this.addForce(iVec);
    }

    public synchronized void cohere() {
        if (this.neighbors.size() == 0) {
            return;
        }
        IVec iVec = new IVec();
        for (IBoid iBoid : this.neighbors) {
            iVec.add(iBoid);
        }
        iVec.div(this.neighbors.size());
        IVec iVec2 = iVec.diff(this);
        double d = iVec2.len();
        if (d > 0.0) {
            double d2 = d / this.neighborDist;
            iVec2.len(this.coherenceRatio * d2);
            this.addForce(iVec2);
        }
    }

    @Override
    public synchronized void interact(ArrayList<IDynamicObject> arrayList) {
        super.interact(arrayList);
        for (IDynamicObject iDynamicObject : arrayList) {
            IBoid iBoid;
            double d;
            if (this.neighbors == null) {
                this.neighbors = new ArrayList();
            }
            this.neighbors.clear();
            if (iDynamicObject != this && iDynamicObject instanceof IBoid && (d = (iBoid = (IBoid)iDynamicObject).dist(this)) < this.neighborDist) {
                this.neighbors.add(iBoid);
            }
            this.flock();
            if (!(this.randomVelocityPercent > 0.0) || !IRandom.percent(this.randomVelocityPercent)) continue;
            this.addForce(IRandom.pt(-this.randomVelocityRange, this.randomVelocityRange));
        }
    }

    @Override
    public synchronized void update() {
        super.update();
    }

    @Override
    public IBoid dup() {
        return new IBoid(this);
    }

    @Override
    public IBoid set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IBoid set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IBoid set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IBoid add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IBoid sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IBoid sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IBoid mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IBoid mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IBoid div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IBoid div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IBoid neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IBoid rev() {
        return this.neg();
    }

    @Override
    public IBoid flip() {
        return this.neg();
    }

    @Override
    public IBoid add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IBoid add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IBoid len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IBoid unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoid scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IBoid scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IBoid scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoid scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoid ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoid ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoid mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoid shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoid shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoid shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoid shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IBoid shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IBoid shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IBoid shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoid shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoid translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IBoid translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoid translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IBoid transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IBoid transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IBoid transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoid transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IBoid mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IBoid mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoid mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IBoid cp() {
        return this.dup();
    }

    @Override
    public IBoid cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IBoid cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoid cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IBoid setSize(double d) {
        return this.size(d);
    }

    @Override
    public IBoid size(double d) {
        this.point.size(d);
        return this;
    }

    @Override
    public IBoid name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IBoid layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IBoid show() {
        super.show();
        return this;
    }

    @Override
    public IBoid hide() {
        super.hide();
        return this;
    }

    @Override
    public IBoid clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public IBoid clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IBoid clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IBoid clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IBoid clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBoid clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IBoid hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IBoid setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public IBoid setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IBoid setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IBoid setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IBoid setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBoid setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBoid setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoid setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IBoid setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

