/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IDynamicObject;
import igeo.core.IDynamicServer;
import igeo.core.IG;
import igeo.core.IGraphicServer;
import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.geo.ICurve;
import igeo.geo.IMesh;
import igeo.geo.IPoint;
import igeo.geo.ISurface;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IServer
implements IServerI {
    public ArrayList<IObject> objects;
    public ArrayList<ILayer> layers;
    public IGraphicServer graphicServer;
    public IDynamicServer dynamicServer;
    public IG ig;
    public int statusCount = 0;

    public IServer(IG iG) {
        this.ig = iG;
        this.objects = new ArrayList();
        this.dynamicServer = new IDynamicServer(this);
        this.layers = new ArrayList();
    }

    public IServer(IG iG, IPanel iPanel) {
        this.ig = iG;
        this.objects = new ArrayList();
        this.graphicServer = new IGraphicServer(this, iPanel);
        this.dynamicServer = new IDynamicServer(this);
        this.layers = new ArrayList();
    }

    @Override
    public IServer server() {
        return this;
    }

    public IDynamicServer dynamicServer() {
        return this.dynamicServer;
    }

    public IGraphicServer graphicServer() {
        return this.graphicServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IObject iObject) {
        IG iG = this.ig;
        synchronized (iG) {
            if (!this.objects.contains(iObject)) {
                this.objects.add(iObject);
            }
            iObject.server = this;
            if (iObject instanceof ILayer) {
                this.layers.add((ILayer)iObject);
            }
            if (iObject.dynamicsNum() > 0) {
                this.dynamicServer.add(iObject);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IDynamicObject iDynamicObject) {
        Object object = IG.lock;
        synchronized (object) {
            this.dynamicServer.add(iDynamicObject);
            this.update();
        }
    }

    public boolean isGraphicMode() {
        return this.graphicServer != null;
    }

    public void setGraphicMode(IGraphicMode iGraphicMode) {
        if (this.graphicServer != null) {
            this.graphicServer.setMode(iGraphicMode);
        } else {
            IOut.err("graphicServer is null");
        }
    }

    public ArrayList<IObject> getObjects() {
        return this.objects();
    }

    public ArrayList<IObject> objects() {
        return this.objects;
    }

    public IObject getObject(int n) {
        return this.object(n);
    }

    public IObject object(int n) {
        if (n < 0 || n >= this.objects.size()) {
            return null;
        }
        return this.objects.get(n);
    }

    public int objectNum() {
        return this.objects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        if (n < 0 || n >= this.objects.size()) {
            return;
        }
        IG iG = this.ig;
        synchronized (iG) {
            int n2;
            IObject iObject;
            if (this.graphicServer != null && this.objects.get((int)n).graphics != null) {
                iObject = this.objects.get(n);
                for (n2 = 0; n2 < iObject.graphics.size(); ++n2) {
                    this.graphicServer.remove(iObject.graphics.get(n2));
                }
            }
            if (this.objects.get((int)n).dynamics != null) {
                iObject = this.objects.get(n);
                for (n2 = 0; n2 < iObject.dynamics.size(); ++n2) {
                    this.dynamicServer.remove(iObject.dynamics.get(n2));
                }
            }
            this.objects.remove(n);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IObject iObject) {
        IG iG = this.ig;
        synchronized (iG) {
            int n;
            if (this.graphicServer != null && iObject.graphics != null) {
                for (n = 0; n < iObject.graphics.size(); ++n) {
                    this.graphicServer.remove(iObject.graphics.get(n));
                }
            }
            if (iObject.dynamics != null) {
                for (n = 0; n < iObject.dynamics.size(); ++n) {
                    this.dynamicServer.remove(iObject.dynamics.get(n));
                }
            }
            this.objects.remove(iObject);
            if (iObject instanceof ILayer) {
                this.layers.remove(iObject);
            }
            this.update();
        }
    }

    public void clear() {
        this.objects.clear();
        if (this.graphicServer != null) {
            this.graphicServer.clearObjects();
        }
        if (this.dynamicServer != null) {
            this.dynamicServer.clear();
        }
        this.layers.clear();
        this.update();
    }

    public int statusCount() {
        return this.statusCount;
    }

    public void update() {
        ++this.statusCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoint[] getPoints() {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint)) continue;
                arrayList.add((IPoint)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IPoint[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurve[] getCurves() {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve)) continue;
                arrayList.add((ICurve)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ICurve[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurface[] getSurfaces() {
        ArrayList<ISurface> arrayList = new ArrayList<ISurface>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface)) continue;
                arrayList.add((ISurface)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ISurface[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMesh[] getMeshes() {
        ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh)) continue;
                arrayList.add((IMesh)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IMesh[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject[] getObjects(Class clazz) {
        ArrayList arrayList = new ArrayList();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!clazz.isInstance(arrayList.get(i))) continue;
                arrayList.add(arrayList.get(i));
            }
        }
        return arrayList.toArray(new IObject[arrayList.size()]);
    }

    public int layerNum() {
        return this.layers.size();
    }

    public ILayer layer(int n) {
        return this.layers.get(n);
    }

    public ILayer getLayer(int n) {
        return this.layer(n);
    }

    public ILayer[] layers() {
        return this.layers.toArray(new ILayer[this.layers.size()]);
    }

    public ILayer[] getAllLayers() {
        return this.layers();
    }

    public ILayer getLayer(String string) {
        return this.layer(string);
    }

    public ILayer layer(String string) {
        for (ILayer iLayer : this.layers) {
            if (!iLayer.name().equals(string)) continue;
            return iLayer;
        }
        return new ILayer((IServerI)this, string);
    }

    public void removeLayer(String string) {
        for (ILayer iLayer : this.layers) {
            if (!iLayer.name().equals(string)) continue;
            this.remove(iLayer);
        }
    }
}

