/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IDynamicObject;
import igeo.geo.ICurveI;
import igeo.geo.IParticle;
import igeo.geo.IVec;

public class IParticleOnCurve
extends IParticle {
    ICurveI curve;
    double upos;
    double uvel;
    double uacc;
    double ufrc;
    IVec utan;

    public IParticleOnCurve(ICurveI iCurveI) {
        this(iCurveI, 0.0);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d) {
        super(iCurveI.pt(d).get());
        this.upos = d;
        this.curve = iCurveI;
    }

    public synchronized void interact(IDynamicObject iDynamicObject) {
    }

    public synchronized void update() {
        if (this.fixed || this.curve == null) {
            return;
        }
        this.utan = this.curve.tan(this.upos).get();
        this.ufrc = this.frc.projectToVec(this.utan) > 0.0 ? this.frc.len() / this.utan.len() : -this.frc.len() / this.utan.len();
        this.uvel += this.ufrc / this.mass * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
        this.uvel *= this.friction;
        if (this.upos + this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0 < 0.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 0.0;
                this.uvel = 0.0;
            }
        } else if (this.upos + this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0 > 1.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 1.0;
                this.uvel = 0.0;
            }
        } else {
            this.upos += this.uvel * (double)IConfig.dynamicsUpdateSpeed / 1000.0;
        }
        this.pos.set(this.curve.pt(this.upos));
        this.frc.set(0.0, 0.0, 0.0);
    }
}

