/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IAttribute;
import igeo.core.IDynamicObjectI;
import igeo.core.IG;
import igeo.core.IGraphicObject;
import igeo.core.ILayer;
import igeo.core.IOut;
import igeo.core.IParameterObject;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.gui.IGraphicMode;
import java.awt.Color;
import java.util.ArrayList;

public class IObject {
    public IServer server;
    public IParameterObject parameter;
    public ArrayList<IGraphicObject> graphics;
    public ArrayList<IDynamicObjectI> dynamics;
    public IAttribute attribute;

    public IObject() {
        this.initObject(null);
    }

    public IObject(IServerI iServerI) {
        this.initObject(iServerI);
    }

    public IObject(IObject iObject) {
        this.initObject(iObject.server);
    }

    public IObject(IServerI iServerI, IObject iObject) {
        this.initObject(iServerI);
    }

    public IObject dup() {
        return new IObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initObject(IServerI iServerI) {
        Object object;
        this.server = null;
        if (iServerI == null) {
            object = IG.current();
            if (object == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = ((IG)object).server();
        } else {
            this.server = iServerI.server();
        }
        object = IG.lock;
        synchronized (object) {
            this.server.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initGraphic(IServerI iServerI) {
        Object object;
        this.server = null;
        if (iServerI == null) {
            object = IG.current();
            if (object == null) {
                IOut.err("no IG is found. IObject is not stored in a server.");
                return;
            }
            this.server = ((IG)object).server();
        } else {
            this.server = iServerI.server();
        }
        if (this.server.isGraphicMode()) {
            object = IG.lock;
            synchronized (object) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public void del() {
        if (this.server != null) {
            this.server.remove(this);
        } else if (IG.current() != null) {
            IG.current().server().remove(this);
        }
    }

    public boolean isValid() {
        return true;
    }

    public void setParameter(IParameterObject iParameterObject) {
        if (this.parameter != null) {
            IOut.err("parameter is already set. overwrote.");
        }
        this.parameter = iParameterObject;
    }

    public void addDynamics(IDynamicObjectI iDynamicObjectI) {
        if (this.dynamics == null) {
            this.dynamics = new ArrayList();
        }
        if (!this.dynamics.contains(iDynamicObjectI)) {
            this.dynamics.add(iDynamicObjectI);
        }
        if (this.server != null) {
            this.server.add(iDynamicObjectI);
        }
    }

    public IParameterObject getParameter() {
        return this.parameter;
    }

    public IGraphicObject getGraphic(int n) {
        if (this.graphics == null) {
            return null;
        }
        return this.graphics.get(n);
    }

    public IDynamicObjectI getDynamics(int n) {
        if (this.dynamics == null) {
            return null;
        }
        return this.dynamics.get(n);
    }

    public int graphicsNum() {
        if (this.graphics == null) {
            return 0;
        }
        return this.graphics.size();
    }

    public int dynamicsNum() {
        if (this.dynamics == null) {
            return 0;
        }
        return this.dynamics.size();
    }

    public void clearGraphics() {
        if (this.graphics != null) {
            this.graphics.clear();
        }
    }

    public void clearDynamics() {
        if (this.dynamics != null) {
            this.dynamics.clear();
        }
    }

    public IGraphicObject getGraphic(IGraphicMode iGraphicMode) {
        if (this.graphics == null) {
            this.graphics = new ArrayList();
        } else {
            for (IGraphicObject iGraphicObject : this.graphics) {
                if (!iGraphicObject.isDrawable(iGraphicMode)) continue;
                return iGraphicObject;
            }
        }
        IGraphicObject iGraphicObject = this.createGraphic(iGraphicMode);
        if (iGraphicObject != null) {
            this.graphics.add(iGraphicObject);
        }
        return iGraphicObject;
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return null;
    }

    public void deleteGraphic() {
        if (this.server != null && this.server.graphicServer != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                this.server.graphicServer.remove(iGraphicObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphic() {
        this.deleteGraphic();
        if (this.server != null && this.server.graphicServer != null) {
            Object object = IG.lock;
            synchronized (object) {
                this.server.graphicServer().add(this);
            }
        }
    }

    public String name() {
        if (this.attribute != null) {
            return this.attribute.name;
        }
        return null;
    }

    public IObject name(String string) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.name = string;
        return this;
    }

    public ILayer layer() {
        if (this.attribute != null) {
            return this.attribute.layer;
        }
        return null;
    }

    public IObject layer(ILayer iLayer) {
        if (iLayer == null) {
            if (this.attribute != null) {
                this.attribute.layer = null;
            }
        } else if (this.attribute == null) {
            this.attribute = new IAttribute();
            if (!iLayer.contains(this)) {
                iLayer.add(this);
            }
            this.attribute.layer = iLayer;
        } else if (this.attribute.layer != iLayer) {
            if (!iLayer.contains(this)) {
                iLayer.add(this);
            }
            this.attribute.layer = iLayer;
        }
        return this;
    }

    public IAttribute attr() {
        return this.attribute;
    }

    public IObject attr(IAttribute iAttribute) {
        this.attribute = iAttribute;
        return this;
    }

    public boolean visible() {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        return this.attribute.visible;
    }

    public boolean isVisible() {
        return this.visible();
    }

    public IObject hide() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.hide();
            }
        }
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.visible = false;
        return this;
    }

    public IObject show() {
        if (this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.show();
            }
        }
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.visible = true;
        return this;
    }

    public void syncColor() {
        if (this.attribute != null && this.graphics != null) {
            for (IGraphicObject iGraphicObject : this.graphics) {
                iGraphicObject.setColor(this.attribute.color);
            }
        }
    }

    public Color clr() {
        if (this.graphics == null && this.attribute == null) {
            return null;
        }
        if (this.attribute != null) {
            return this.attribute.color;
        }
        for (IGraphicObject iGraphicObject : this.graphics) {
            if (iGraphicObject.getColor() == null) continue;
            return iGraphicObject.getColor();
        }
        return null;
    }

    public IObject clr(Color color) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(color);
        this.syncColor();
        return this;
    }

    public IObject clr(int n) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(n);
        this.syncColor();
        return this;
    }

    public IObject clr(double d) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(d);
        this.syncColor();
        return this;
    }

    public IObject clr(float f) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(f);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(n, n2);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(d, d2);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(f, f2);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2, int n3) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(n, n2, n3);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2, double d3) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(d, d2, d3);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2, float f3) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(f, f2, f3);
        this.syncColor();
        return this;
    }

    public IObject clr(int n, int n2, int n3, int n4) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(n, n2, n3, n4);
        this.syncColor();
        return this;
    }

    public IObject clr(double d, double d2, double d3, double d4) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(d, d2, d3, d4);
        this.syncColor();
        return this;
    }

    public IObject clr(float f, float f2, float f3, float f4) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.clr(f, f2, f3, f4);
        this.syncColor();
        return this;
    }

    public IObject hsb(double d, double d2, double d3, double d4) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.hsb(d, d2, d3, d4);
        this.syncColor();
        return this;
    }

    public IObject hsb(float f, float f2, float f3, float f4) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.hsb(f, f2, f3, f4);
        this.syncColor();
        return this;
    }

    public IObject hsb(double d, double d2, double d3) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.hsb(d, d2, d3);
        this.syncColor();
        return this;
    }

    public IObject hsb(float f, float f2, float f3) {
        if (this.attribute == null) {
            this.attribute = new IAttribute();
        }
        this.attribute.hsb(f, f2, f3);
        this.syncColor();
        return this;
    }

    public Color getColor() {
        return this.clr();
    }

    public IObject setColor(Color color) {
        return this.clr(color);
    }

    public IObject setColor(int n) {
        return this.clr(n);
    }

    public IObject setColor(float f) {
        return this.clr(f);
    }

    public IObject setColor(double d) {
        return this.clr(d);
    }

    public IObject setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    public IObject setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    public IObject setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public IObject setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    public IObject setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    public IObject setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    public IObject setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    public IObject setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    public IObject setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    public IObject setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    public IObject setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    public IObject setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }
}

