/*
 * Decompiled with CFR 0.152.
 */
package igeo.util;

import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.util.IDoubleMap;
import java.awt.image.BufferedImage;

public class IMap {
    public static final int defaultDensityWidth = 100;
    public static final int defaultDensityHeight = 100;
    public static final double densityMinDelta = 1.0E-4;
    public IDoubleMap uIntegration = null;
    public IDoubleMap vIntegration = null;

    public double get(double d, double d2) {
        return 0.0;
    }

    public double get(IVec2I iVec2I) {
        return this.get(iVec2I.x(), iVec2I.y());
    }

    public void initDensityMapU() {
        this.initDensityMapU(100, 100);
    }

    public void initDensityMapV() {
        this.initDensityMapV(100, 100);
    }

    public void initDensityMapU(int n, int n2) {
        int n3;
        double d;
        int n4;
        this.uIntegration = new IDoubleMap(n + 1, n2);
        for (n4 = 0; n4 < n2; ++n4) {
            d = 0.0;
            this.uIntegration.set(0, n4, d);
            for (n3 = 0; n3 < n; ++n3) {
                this.uIntegration.set(n3 + 1, n4, d += this.get((double)n3 / (double)(n - 1), (double)n4 / (double)(n2 - 1)));
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            d = this.uIntegration.map[n][n4];
            for (n3 = 1; n3 <= n; ++n3) {
                if (d > 0.0) {
                    double[] dArray = this.uIntegration.map[n3];
                    int n5 = n4;
                    dArray[n5] = dArray[n5] / d;
                    continue;
                }
                double[] dArray = this.uIntegration.map[n3];
                int n6 = n4;
                dArray[n6] = dArray[n6] / ((double)n3 / (double)n);
            }
        }
    }

    public void initDensityMapV(int n, int n2) {
        int n3;
        double d;
        int n4;
        this.vIntegration = new IDoubleMap(n, n2 + 1);
        for (n4 = 0; n4 < n; ++n4) {
            d = 0.0;
            this.vIntegration.set(n4, 0, d);
            for (n3 = 0; n3 < n2; ++n3) {
                this.vIntegration.set(n4, n3 + 1, d += this.get((double)n4 / (double)(n - 1), (double)n3 / (double)(n2 - 1)));
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            d = this.vIntegration.map[n4][n2];
            for (n3 = 1; n3 <= n2; ++n3) {
                if (d > 0.0) {
                    double[] dArray = this.vIntegration.map[n4];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] / d;
                    continue;
                }
                double[] dArray = this.vIntegration.map[n4];
                int n6 = n3;
                dArray[n6] = dArray[n6] / ((double)n3 / (double)n2);
            }
        }
    }

    public void scaleDensityMapU(double d) {
        this.uIntegration.scale(d);
    }

    public void scaleDensityMapV(double d) {
        this.vIntegration.scale(d);
    }

    public void matchUDensityWithMap(IMap iMap, double d, double d2) {
        this.matchUDensityWithMap(iMap, d, d + 1.0E-4, d2);
    }

    public void matchUDensityWithMap(IMap iMap, double d, double d2, double d3) {
        double d4 = this.projectU(d, d3);
        double d5 = this.projectU(d2, d3);
        double d6 = iMap.projectU(d, d3);
        double d7 = iMap.projectU(d2, d3);
        this.scaleDensityMapU((d7 - d6) / (d5 - d4));
    }

    public void matchVDensityWithMap(IMap iMap, double d, double d2) {
        this.matchVDensityWithMap(iMap, d, d2, d2 + 1.0E-4);
    }

    public void matchVDensityWithMap(IMap iMap, double d, double d2, double d3) {
        double d4 = this.projectU(d, d2);
        double d5 = this.projectU(d, d3);
        double d6 = iMap.projectU(d, d2);
        double d7 = iMap.projectU(d, d3);
        this.scaleDensityMapV((d7 - d6) / (d5 - d4));
    }

    public BufferedImage createImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = this.get((double)i / (double)(n - 1), (double)j / (double)(n2 - 1));
                int n3 = (int)(d * 255.0);
                int n4 = n3 * 256 * 256 + n3 * 256 + n3;
                bufferedImage.setRGB(i, j, n4);
            }
        }
        return bufferedImage;
    }

    public double projectU(double d, double d2) {
        if (this.uIntegration == null) {
            this.initDensityMapU();
        }
        return this.uIntegration.get(d, d2);
    }

    public double projectV(double d, double d2) {
        if (this.vIntegration == null) {
            this.initDensityMapV();
        }
        return this.vIntegration.get(d, d2);
    }

    public IVec2 project(double d, double d2) {
        if (this.uIntegration == null) {
            this.initDensityMapU();
        }
        if (this.vIntegration == null) {
            this.initDensityMapV();
        }
        return new IVec2(this.uIntegration.get(d, d2), this.vIntegration.get(d, d2));
    }

    public void flipU() {
    }

    public void flipV() {
    }
}

