/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IGraphicObject;
import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.geo.IBoolI;
import igeo.geo.IDoubleI;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVec4R;
import igeo.geo.IVecI;
import igeo.geo.IVecR;
import igeo.gui.IGraphicMode;
import igeo.gui.IPointGraphic;
import java.awt.Color;

public class IPointR
extends IObject
implements IVecI {
    public IVecI pos;

    public IPointR() {
        this.pos = new IVec();
        this.initPoint(null);
    }

    public IPointR(IVecI iVecI) {
        this.pos = iVecI;
        this.initPoint(null);
    }

    public IPointR(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.initPoint(null);
    }

    public IPointR(IServerI iServerI) {
        super(iServerI);
        this.pos = new IVec(0.0, 0.0, 0.0);
        this.initPoint(iServerI);
    }

    public IPointR(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.pos = iVecI;
        this.initPoint(iServerI);
    }

    public IPointR(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.pos = new IVec(d, d2, d3);
        this.initPoint(iServerI);
    }

    public IPointR(IPointR iPointR) {
        super(iPointR);
        this.pos = iPointR.pos.dup();
        this.initPoint(iPointR.server);
        this.setColor(iPointR.getColor());
    }

    public IPointR(IServerI iServerI, IPointR iPointR) {
        super(iServerI, iPointR);
        this.pos = iPointR.pos.dup();
        this.initPoint(iServerI);
        this.setColor(iPointR.getColor());
    }

    protected void initPoint(IServerI iServerI) {
        if (this.pos instanceof IVec) {
            this.parameter = (IVec)this.pos;
        } else if (this.pos instanceof IVecR) {
            this.parameter = (IVecR)this.pos;
        } else if (this.pos instanceof IVec4) {
            this.parameter = (IVec4)this.pos;
        } else if (this.pos instanceof IVec4R) {
            this.parameter = (IVec4R)this.pos;
        }
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return new IPointGraphic(this);
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public IVec get() {
        return this.pos.get();
    }

    public IPointR dup() {
        return new IPointR(this);
    }

    public IVec2I to2d() {
        return this.pos.to2d();
    }

    public IVec4I to4d() {
        return this.pos.to4d();
    }

    public IVec4I to4d(double d) {
        return this.pos.to4d(d);
    }

    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    public IDoubleI getX() {
        return this.pos.getX();
    }

    public IDoubleI getY() {
        return this.pos.getY();
    }

    public IDoubleI getZ() {
        return this.pos.getZ();
    }

    public IPointR set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IPointR set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    public IPointR set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPointR add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    public IPointR add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPointR add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    public IPointR sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    public IPointR sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPointR sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    public IPointR mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    public IPointR mul(double d) {
        this.pos.mul(d);
        return this;
    }

    public IPointR div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    public IPointR div(double d) {
        this.pos.div(d);
        return this;
    }

    public IPointR neg() {
        this.pos.neg();
        return this;
    }

    public IPointR rev() {
        return this.neg();
    }

    public IPointR flip() {
        return this.neg();
    }

    public IPointR add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    public IPointR add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    public IVecI cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    public double len() {
        return this.pos.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    public IDoubleI len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    public double len2() {
        return this.pos.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    public IPointR len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    public IPointR len(double d) {
        this.pos.len(d);
        return this;
    }

    public IPointR unit() {
        this.pos.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    public IPointR rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    public IPointR rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    public IPointR rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    public IPointR rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IPointR rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    public IPointR rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IPointR scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    public IPointR scale(double d) {
        this.pos.scale(d);
        return this;
    }

    public IPointR scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    public IPointR scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    public IPointR scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    public IPointR scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    public IPointR scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    public IPointR scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IPointR ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IPointR ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IPointR mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IPointR mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IPointR shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IPointR shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IPointR shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    public IPointR shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IPointR shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    public IPointR shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    public IPointR shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    public IPointR shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    public IPointR shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    public IPointR shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    public IPointR shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IPointR translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    public IPointR translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IPointR translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    public IPointR transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    public IPointR transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    public IPointR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IPointR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IPointR mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IPointR mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IPointR mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IPointR cp() {
        return this.dup();
    }

    public IPointR cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IPointR cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IPointR cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVecI diff(IVecI iVecI) {
        return this.pos.diff(iVecI);
    }

    public IVecI mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    public IVecI sum(IVecI iVecI) {
        return this.pos.sum(iVecI);
    }

    public IVecI sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    public IVecI bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    public IVecI sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    public IVecI sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.pos.sum(iVecI, iDoubleI, iDoubleI2);
    }

    public IVecI sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.sum(iVecI, iDoubleI);
    }

    public IVecI nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    public IVecI nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    public IPointR setSize(double d) {
        return this.size(d);
    }

    public IPointR size(double d) {
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IPointGraphic)) continue;
            ((IPointGraphic)this.graphics.get(i)).size(d);
        }
        return this;
    }

    public double getSize() {
        return this.size();
    }

    public double size() {
        if (this.graphics == null) {
            IOut.err("no graphics is set");
            return -1.0;
        }
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IPointGraphic)) continue;
            return ((IPointGraphic)this.graphics.get(i)).size();
        }
        return -1.0;
    }

    public IPointR name(String string) {
        super.name(string);
        return this;
    }

    public IPointR layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    public IPointR hide() {
        super.hide();
        return this;
    }

    public IPointR show() {
        super.show();
        return this;
    }

    public IPointR clr(Color color) {
        super.clr(color);
        return this;
    }

    public IPointR clr(int n) {
        super.clr(n);
        return this;
    }

    public IPointR clr(float f) {
        super.clr(f);
        return this;
    }

    public IPointR clr(double d) {
        super.clr(d);
        return this;
    }

    public IPointR clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    public IPointR clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    public IPointR clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    public IPointR clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    public IPointR clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    public IPointR clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    public IPointR clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    public IPointR clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    public IPointR clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    public IPointR hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    public IPointR hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    public IPointR hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    public IPointR hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    public IPointR setColor(Color color) {
        super.setColor(color);
        return this;
    }

    public IPointR setColor(int n) {
        super.setColor(n);
        return this;
    }

    public IPointR setColor(float f) {
        super.setColor(f);
        return this;
    }

    public IPointR setColor(double d) {
        super.setColor(d);
        return this;
    }

    public IPointR setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    public IPointR setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    public IPointR setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    public IPointR setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    public IPointR setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    public IPointR setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    public IPointR setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    public IPointR setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    public IPointR setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    public IPointR setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    public IPointR setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    public IPointR setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    public IPointR setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

