/*
 * Decompiled with CFR 0.152.
 */
package igeo.util;

import igeo.gui.IImageLoader;
import igeo.util.IDoubleMap;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class IImageMap
extends IDoubleMap {
    public Image image;

    public IImageMap(String string) {
        this.initMap(string);
    }

    public IImageMap(Image image) {
        this.initMap(image);
    }

    public IImageMap(String string, Component component) {
        this.initMap(string, component);
    }

    public void initMap(String string) {
        this.initMap(IImageLoader.getImage(string));
    }

    public void initMap(String string, Component component) {
        this.initMap(IImageLoader.getImage(string, component));
    }

    public void initMap(Image image) {
        this.image = image;
        this.width = image.getWidth(IImageLoader.observer);
        this.height = image.getHeight(IImageLoader.observer);
        int[] nArray = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, nArray, 0, this.width);
        if (pixelGrabber != null) {
            try {
                pixelGrabber.grabPixels();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.initMap(this.width, this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                super.set(j, i, IImageMap.getColorValue(nArray, j, i, this.width));
            }
        }
    }

    public static double getColorValue(int[] nArray, int n, int n2, int n3) {
        int[] nArray2 = new int[4];
        int n4 = nArray[n3 * n2 + n];
        nArray2[0] = n4 >> 24 & 0xFF;
        nArray2[1] = n4 >> 16 & 0xFF;
        nArray2[2] = n4 >> 8 & 0xFF;
        nArray2[3] = n4 & 0xFF;
        return (double)(nArray2[1] + nArray2[2] + nArray2[3]) / 765.0 * ((double)nArray2[0] / 255.0);
    }

    public void initDensityMapU() {
        this.initDensityMapU(this.width, this.height);
    }

    public void initDensityMapV() {
        this.initDensityMapV(this.width, this.height);
    }
}

