/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IG;
import igeo.core.IOut;
import igeo.core.IParameterObject;
import igeo.geo.ICurveI;
import igeo.geo.IEdge;
import igeo.geo.IFace;
import igeo.geo.IInteger;
import igeo.geo.IIntegerI;
import igeo.geo.IMeshCreator;
import igeo.geo.IMeshI;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVecI;
import igeo.geo.IVertex;
import igeo.util.ISort;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMeshGeo
extends IParameterObject
implements IMeshI {
    public ArrayList<IVertex> vertices;
    public ArrayList<IEdge> edges;
    public ArrayList<IFace> faces;

    public IMeshGeo(ArrayList<ICurveI> arrayList) {
        this.init(arrayList, new IMeshCreator());
    }

    public IMeshGeo(ArrayList<ICurveI> arrayList, IMeshCreator iMeshCreator) {
        this.init(arrayList, iMeshCreator);
    }

    public IMeshGeo(IVec[][] iVecArray) {
        this(iVecArray, true, new IMeshCreator());
    }

    public IMeshGeo(IVec[][] iVecArray, boolean bl) {
        this(iVecArray, bl, new IMeshCreator());
    }

    public IMeshGeo(IVec[][] iVecArray, boolean bl, IMeshCreator iMeshCreator) {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
        this.initWithPointMatrix(iVecArray, iVecArray.length, iVecArray[0].length, bl, iMeshCreator);
    }

    public IMeshGeo(IVec[][] iVecArray, int n, int n2, boolean bl) {
        this(iVecArray, n, n2, bl, new IMeshCreator());
    }

    public IMeshGeo(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshCreator iMeshCreator) {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
        this.initWithPointMatrix(iVecArray, n, n2, bl, iMeshCreator);
    }

    public IMeshGeo() {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
    }

    public IMeshGeo(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        this.vertices = arrayList;
        this.edges = arrayList2;
        this.faces = arrayList3;
    }

    public IMeshGeo(IVec[] iVecArray) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iVecArray.length; ++n) {
            this.vertices.add(new IVertex(iVecArray[n]));
        }
        for (n = 0; n < iVecArray.length; ++n) {
            this.edges.add(new IEdge(this.vertices.get(n), this.vertices.get((n + 1) % this.vertices.size())));
        }
        IEdge[] iEdgeArray = new IEdge[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            iEdgeArray[i] = this.edges.get(i);
        }
        this.faces.add(new IFace(iEdgeArray));
    }

    public IMeshGeo(IVertex[] iVertexArray) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iVertexArray.length; ++n) {
            this.vertices.add(iVertexArray[n]);
        }
        for (n = 0; n < iVertexArray.length; ++n) {
            this.edges.add(new IEdge(this.vertices.get(n), this.vertices.get((n + 1) % this.vertices.size())));
        }
        IEdge[] iEdgeArray = new IEdge[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            iEdgeArray[i] = this.edges.get(i);
        }
        this.faces.add(new IFace(iEdgeArray));
    }

    public IMeshGeo(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3});
    }

    public IMeshGeo(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3, iVertex4});
    }

    public IMeshGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this(new IVertex[]{new IVertex(iVecI), new IVertex(iVecI2), new IVertex(iVecI3)});
    }

    public IMeshGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this(new IVertex[]{new IVertex(iVecI), new IVertex(iVecI2), new IVertex(iVecI3), new IVertex(iVecI4)});
    }

    public IMeshGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(new IVertex[]{new IVertex(d, d2, d3), new IVertex(d4, d5, d6), new IVertex(d7, d8, d9)});
    }

    public IMeshGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this(new IVertex[]{new IVertex(d, d2, d3), new IVertex(d4, d5, d6), new IVertex(d7, d8, d9), new IVertex(d10, d11, d12)});
    }

    public IMeshGeo(IFace[] iFaceArray) {
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (IFace iFace : iFaceArray) {
            this.faces.add(iFace);
            for (IVertex iVertex : iFace.vertices) {
                if (this.vertices.contains(iVertex)) continue;
                this.vertices.add(iVertex);
            }
            for (IEdge iEdge : iFace.edges) {
                if (this.edges.contains(iEdge)) continue;
                this.edges.add(iEdge);
            }
        }
    }

    public IMeshGeo(IMeshGeo iMeshGeo) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iMeshGeo.vertices.size(); ++n) {
            this.vertices.add(iMeshGeo.vertices.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.edges.size(); ++n) {
            this.edges.add(iMeshGeo.edges.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.faces.size(); ++n) {
            this.faces.add(iMeshGeo.faces.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.faces.size(); ++n) {
            this.replaceFace(iMeshGeo.faces.get(n), this.faces.get(n));
        }
        for (n = 0; n < iMeshGeo.edges.size(); ++n) {
            this.replaceEdge(iMeshGeo.edges.get(n), this.edges.get(n));
        }
        for (n = 0; n < iMeshGeo.vertices.size(); ++n) {
            this.replaceVertex(iMeshGeo.vertices.get(n), this.vertices.get(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ArrayList<ICurveI> arrayList, IMeshCreator iMeshCreator) {
        Object object;
        Object object2;
        Object object3;
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            object3 = IG.lock;
            synchronized (object3) {
                ICurveI iCurveI = arrayList.get(n);
                IVertex iVertex = iMeshCreator.createVertex(iCurveI.start().get());
                object2 = iMeshCreator.createVertex(iCurveI.end().get());
                object = iMeshCreator.createEdge(iVertex, (IVertex)object2);
                this.edges.add((IEdge)object);
                this.vertices.add(iVertex);
                this.vertices.add((IVertex)object2);
                continue;
            }
        }
        ISort.sort(this.vertices, new IVertex.ZYXComparator());
        for (n = 0; n < this.vertices.size(); ++n) {
            object3 = this.vertices.get(n);
            boolean bl = true;
            for (int i = n + 1; i < this.vertices.size() && bl; ++i) {
                object2 = this.vertices.get(i);
                if (((IVertex)object3).eq((IVecI)object2)) {
                    object = IG.lock;
                    synchronized (object) {
                        ((IVertex)object2).replaceVertex((IVertex)object3);
                        this.vertices.remove(i);
                        --i;
                        continue;
                    }
                }
                bl = false;
            }
        }
        for (n = this.vertices.size() - 1; n >= 0; --n) {
            if (this.vertices.get((int)n).edges.size() != 0) continue;
            this.vertices.remove(n);
        }
        this.faces = new ArrayList();
        for (n = 0; n < this.edges.size(); ++n) {
            object3 = this.edges.get(n);
            IFace[] iFaceArray = ((IEdge)object3).createFace(iMeshCreator);
            if (iFaceArray == null) continue;
            for (int i = 0; i < iFaceArray.length; ++i) {
                object2 = IG.lock;
                synchronized (object2) {
                    boolean bl = true;
                    for (int j = 0; j < this.faces.size() && bl; ++j) {
                        IFace iFace = this.faces.get(j);
                        if (iFace != iFaceArray[i]) continue;
                        bl = false;
                    }
                    if (bl) {
                        this.faces.add(iFaceArray[i]);
                    } else {
                        iFaceArray[i].del();
                    }
                    continue;
                }
            }
        }
    }

    @Override
    public IMeshGeo get() {
        return this;
    }

    @Override
    public IMeshGeo dup() {
        return new IMeshGeo(this);
    }

    protected void replaceVertex(IVertex iVertex, IVertex iVertex2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.linkedVertices.size(); ++n) {
                if (object.linkedVertices.get(n) != iVertex) continue;
                object.linkedVertices.set(n, iVertex2);
            }
        }
        for (IEdge iEdge : this.edges) {
            for (n = 0; n < iEdge.vertices.length; ++n) {
                if (iEdge.vertices[n] != iVertex) continue;
                iEdge.vertices[n] = iVertex2;
            }
        }
        for (IFace iFace : this.faces) {
            for (n = 0; n < iFace.vertices.length; ++n) {
                if (iFace.vertices[n] != iVertex) continue;
                iFace.vertices[n] = iVertex2;
            }
        }
    }

    protected void replaceEdge(IEdge iEdge, IEdge iEdge2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.edges.size(); ++n) {
                if (object.edges.get(n) != iEdge) continue;
                object.edges.set(n, iEdge2);
            }
        }
        for (IFace iFace : this.faces) {
            for (n = 0; n < iFace.edges.length; ++n) {
                if (iFace.edges[n] != iEdge) continue;
                iFace.edges[n] = iEdge2;
            }
        }
    }

    protected void replaceFace(IFace iFace, IFace iFace2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.faces.size(); ++n) {
                if (object.faces.get(n) != iFace) continue;
                object.faces.set(n, iFace2);
            }
        }
        for (IEdge iEdge : this.edges) {
            for (n = 0; n < iEdge.faces.size(); ++n) {
                if (iEdge.faces.get(n) != iFace) continue;
                iEdge.faces.set(n, iFace2);
            }
        }
    }

    static IMeshGeo createMeshWithEdges(ArrayList<IEdge> arrayList, IMeshCreator iMeshCreator) {
        IMeshGeo iMeshGeo = new IMeshGeo();
        iMeshGeo.initWithEdges(arrayList, iMeshCreator);
        return iMeshGeo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWithEdges(ArrayList<IEdge> arrayList, IMeshCreator iMeshCreator) {
        int n;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.vertices.contains(arrayList.get((int)i).vertices[0])) {
                this.vertices.add(arrayList.get((int)i).vertices[0]);
            }
            if (this.vertices.contains(arrayList.get((int)i).vertices[1])) continue;
            this.vertices.add(arrayList.get((int)i).vertices[1]);
        }
        ArrayList<IVertex> arrayList2 = new ArrayList<IVertex>();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList2.contains(arrayList.get((int)n).vertices[0])) {
                arrayList2.add(arrayList.get((int)n).vertices[0]);
            }
            if (arrayList2.contains(arrayList.get((int)n).vertices[1])) continue;
            arrayList2.add(arrayList.get((int)n).vertices[1]);
        }
        this.faces = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            IEdge iEdge = arrayList.get(n);
            IFace[] iFaceArray = iEdge.createFace(iMeshCreator);
            if (iFaceArray == null) continue;
            for (int i = 0; i < iFaceArray.length; ++i) {
                Object object = IG.lock;
                synchronized (object) {
                    boolean bl = true;
                    for (int j = 0; j < this.faces.size() && bl; ++j) {
                        IFace iFace = this.faces.get(j);
                        if (iFace != iFaceArray[i]) continue;
                        bl = false;
                    }
                    if (bl) {
                        this.faces.add(iFaceArray[i]);
                    } else {
                        iFaceArray[i].del();
                    }
                    continue;
                }
            }
        }
    }

    public void initWithPointMatrix(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshCreator iMeshCreator) {
        int n3;
        int n4;
        IVertex[][] iVertexArray = new IVertex[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                iVertexArray[i][j] = iMeshCreator.createVertex(iVecArray[i][j]);
                this.vertices.add(iVertexArray[i][j]);
            }
        }
        IEdge[][] iEdgeArray = new IEdge[n - 1][n2];
        IEdge[][] iEdgeArray2 = new IEdge[n][n2 - 1];
        for (n4 = 0; n4 < n - 1; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                iEdgeArray[n4][n3] = iMeshCreator.createEdge(iVertexArray[n4][n3], iVertexArray[n4 + 1][n3]);
                this.edges.add(iEdgeArray[n4][n3]);
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                iEdgeArray2[n4][n3] = iMeshCreator.createEdge(iVertexArray[n4][n3], iVertexArray[n4][n3 + 1]);
                this.edges.add(iEdgeArray2[n4][n3]);
            }
        }
        IEdge[] iEdgeArray3 = new IEdge[3];
        for (n3 = 0; n3 < n - 1; ++n3) {
            for (int i = 0; i < n2 - 1; ++i) {
                IEdge iEdge;
                if (bl) {
                    iEdge = iMeshCreator.createEdge(iVertexArray[n3][i], iVertexArray[n3 + 1][i + 1]);
                    this.edges.add(iEdge);
                    iEdgeArray3[0] = iEdgeArray[n3][i];
                    iEdgeArray3[1] = iEdge;
                    iEdgeArray3[2] = iEdgeArray2[n3 + 1][i];
                    this.faces.add(iMeshCreator.createFace(iEdgeArray3));
                    iEdgeArray3[0] = iEdgeArray2[n3][i];
                    iEdgeArray3[1] = iEdgeArray[n3][i + 1];
                    iEdgeArray3[2] = iEdge;
                    this.faces.add(iMeshCreator.createFace(iEdgeArray3));
                    continue;
                }
                iEdge = iMeshCreator.createEdge(iVertexArray[n3 + 1][i], iVertexArray[n3][i + 1]);
                this.edges.add(iEdge);
                iEdgeArray3[0] = iEdgeArray[n3][i];
                iEdgeArray3[1] = iEdgeArray2[n3][i];
                iEdgeArray3[2] = iEdge;
                this.faces.add(iMeshCreator.createFace(iEdgeArray3));
                iEdgeArray3[0] = iEdgeArray[n3][i + 1];
                iEdgeArray3[1] = iEdgeArray2[n3 + 1][i];
                iEdgeArray3[2] = iEdge;
                this.faces.add(iMeshCreator.createFace(iEdgeArray3));
            }
        }
    }

    @Override
    public int vertexNum() {
        return this.vertices.size();
    }

    @Override
    public int edgeNum() {
        return this.edges.size();
    }

    @Override
    public int faceNum() {
        return this.faces.size();
    }

    @Override
    public int vertexNum(ISwitchE iSwitchE) {
        return this.vertexNum();
    }

    @Override
    public int edgeNum(ISwitchE iSwitchE) {
        return this.edgeNum();
    }

    @Override
    public int faceNum(ISwitchE iSwitchE) {
        return this.faceNum();
    }

    @Override
    public IInteger vertexNum(ISwitchR iSwitchR) {
        return new IInteger(this.vertexNum());
    }

    @Override
    public IInteger edgeNum(ISwitchR iSwitchR) {
        return new IInteger(this.edgeNum());
    }

    @Override
    public IInteger faceNum(ISwitchR iSwitchR) {
        return new IInteger(this.faceNum());
    }

    @Override
    public IVertex vertex(int n) {
        return this.vertices.get(n);
    }

    @Override
    public IEdge edge(int n) {
        return this.edges.get(n);
    }

    @Override
    public IFace face(int n) {
        return this.faces.get(n);
    }

    @Override
    public IVertex vertex(IIntegerI iIntegerI) {
        return this.vertices.get(iIntegerI.x());
    }

    @Override
    public IEdge edge(IIntegerI iIntegerI) {
        return this.edges.get(iIntegerI.x());
    }

    @Override
    public IFace face(IIntegerI iIntegerI) {
        return this.faces.get(iIntegerI.x());
    }

    public void deleteVertex(int n) {
        this.vertices.get(n).del();
        this.vertices.remove(n);
    }

    public void deleteEdge(int n) {
        this.edges.get(n).del();
        this.edges.remove(n);
    }

    public void deleteFace(int n) {
        this.faces.get(n).del();
        this.faces.remove(n);
    }

    public int getIndex(IVertex iVertex) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i) != iVertex) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(IEdge iEdge) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i) != iEdge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(IFace iFace) {
        for (int i = 0; i < this.faces.size(); ++i) {
            if (this.faces.get(i) != iFace) continue;
            return i;
        }
        return -1;
    }

    public void addFace(IFace iFace) {
        int n;
        if (!this.faces.contains(iFace)) {
            this.faces.add(iFace);
        }
        for (n = 0; n < iFace.edges.length; ++n) {
            if (this.edges.contains(iFace.edges[n])) continue;
            this.edges.add(iFace.edges[n]);
        }
        for (n = 0; n < iFace.vertices.length; ++n) {
            if (this.vertices.contains(iFace.vertices[n])) continue;
            this.vertices.add(iFace.vertices[n]);
        }
    }

    public IVertex insertVertex(IFace iFace, IVertex iVertex, IMeshCreator iMeshCreator) {
        int n;
        for (int i = 0; i < iFace.vertices.length; ++i) {
            if (!iFace.vertices[i].pos.eq(iVertex.pos)) continue;
            return iFace.vertices[i];
        }
        IEdge iEdge = null;
        int n2 = -1;
        for (int i = 0; i < iFace.edges.length && iEdge == null; ++i) {
            if (!iFace.edges[i].isOnEdge(iVertex)) continue;
            iEdge = iFace.edges[i];
            n2 = i;
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        int n3 = iFace.edges.length;
        IEdge[] iEdgeArray = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            IVertex iVertex2 = iFace.edges[i].getSharingVertex(iFace.edges[(i + 1) % n3]);
            iEdgeArray[i] = iMeshCreator.createEdge(iVertex2, iVertex);
            if (n2 < 0 || i != n2 && i + 1 != n2) continue;
            arrayList.add(iEdgeArray[i]);
        }
        IFace[] iFaceArray = new IFace[n3];
        for (n = 0; n < n3; ++n) {
            if (n == n2) continue;
            IEdge[] iEdgeArray2 = new IEdge[]{iFace.edges[n], iEdgeArray[n], iEdgeArray[(n - 1 + n3) % n3]};
            iFaceArray[n] = iMeshCreator.createFace(iEdgeArray2);
        }
        if (!this.vertices.contains(iVertex)) {
            this.vertices.add(iVertex);
        }
        for (n = 0; n < n3; ++n) {
            this.edges.add(iEdgeArray[n]);
            if (iFaceArray[n] == null) continue;
            this.faces.add(iFaceArray[n]);
        }
        iFace.del();
        this.faces.remove(iFace);
        if (iEdge != null) {
            if (arrayList.size() != 2) {
                IOut.err("new edges for on-edge insertion point cannot be found");
            }
            for (n = 0; n < iEdge.faces.size(); ++n) {
                this.replaceEdge(iEdge.faces.get(n), iEdge, (IEdge)arrayList.get(0), (IEdge)arrayList.get(1), iVertex, iMeshCreator);
            }
            iEdge.del();
            this.edges.remove(iEdge);
        }
        return iVertex;
    }

    public void replaceEdge(IFace iFace, IEdge iEdge, IEdge iEdge2, IEdge iEdge3, IVertex iVertex, IMeshCreator iMeshCreator) {
        int n;
        int n2 = iFace.indexOf(iEdge);
        if (n2 < 0) {
            IOut.err("specified edge is not included in the face");
            return;
        }
        IVertex iVertex2 = iEdge2.getOtherVertex(iVertex);
        IVertex iVertex3 = iEdge3.getOtherVertex(iVertex);
        int n3 = iFace.edges.length;
        IEdge[] iEdgeArray = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            IVertex iVertex4 = iFace.edges[i].getSharingVertex(iFace.edges[(i + 1) % n3]);
            iEdgeArray[i] = iVertex4 == iVertex2 ? iEdge2 : (iVertex4 == iVertex3 ? iEdge3 : iMeshCreator.createEdge(iVertex4, iVertex));
        }
        IFace[] iFaceArray = new IFace[n3];
        for (n = 0; n < n3; ++n) {
            if (n == n2) continue;
            IEdge[] iEdgeArray2 = new IEdge[]{iFace.edges[n], iEdgeArray[n], iEdgeArray[(n - 1 + n3) % n3]};
            iFaceArray[n] = iMeshCreator.createFace(iEdgeArray2);
        }
        if (!this.vertices.contains(iVertex)) {
            this.vertices.add(iVertex);
        }
        for (n = 0; n < n3; ++n) {
            if (iEdgeArray[n] != iEdge2 && iEdgeArray[n] != iEdge3) {
                this.edges.add(iEdgeArray[n]);
            }
            if (iFaceArray[n] == null) continue;
            this.faces.add(iFaceArray[n]);
        }
        iFace.del();
        this.faces.remove(iFace);
    }

    public void divideEdge(IEdge iEdge, double d, IMeshCreator iMeshCreator) {
        int n;
        IVertex iVertex = iEdge.vertices[0];
        IVertex iVertex2 = iEdge.vertices[1];
        IVertex iVertex3 = iMeshCreator.createVertex(iVertex2.pos.dup().get().sum(iVertex.pos, 1.0 - d));
        IEdge iEdge2 = iMeshCreator.createEdge(iVertex, iVertex3);
        IEdge iEdge3 = iMeshCreator.createEdge(iVertex3, iVertex2);
        this.vertices.add(iVertex3);
        this.edges.add(iEdge2);
        this.edges.add(iEdge3);
        for (n = 0; n < iEdge.faces.size(); ++n) {
            IVertex iVertex4 = iEdge.faces.get(n).getOtherVertex(iVertex, iVertex2);
            if (iVertex4 != null) {
                IEdge iEdge4 = iMeshCreator.createEdge(iVertex4, iVertex3);
                this.edges.add(iEdge4);
                IEdge iEdge5 = iEdge.faces.get(n).getEdge(iVertex4, iVertex);
                IEdge iEdge6 = iEdge.faces.get(n).getEdge(iVertex4, iVertex2);
                IEdge[] iEdgeArray = new IEdge[]{iEdge5, iEdge2, iEdge4};
                IFace iFace = iMeshCreator.createFace(iEdgeArray);
                iEdgeArray[0] = iEdge6;
                iEdgeArray[1] = iEdge3;
                iEdgeArray[2] = iEdge4;
                IFace iFace2 = iMeshCreator.createFace(iEdgeArray);
                this.faces.add(iFace);
                this.faces.add(iFace2);
                continue;
            }
            IOut.err("no opposite vertex!");
        }
        for (n = 0; n < iEdge.faces.size(); ++n) {
            this.faces.remove(iEdge.faces.get(n));
            iEdge.faces.get(n).del();
        }
        this.edges.remove(iEdge);
        iEdge.del();
    }

    public void divideFace(IFace iFace, IEdge iEdge, IVertex iVertex, IEdge iEdge2, IVertex iVertex2, IMeshCreator iMeshCreator) {
        if (!iFace.contains(iEdge) || !iFace.contains(iEdge2)) {
            IOut.err("edges are not included in the face");
            return;
        }
        IEdge iEdge3 = iMeshCreator.createEdge(iVertex, iVertex2);
        IEdge iEdge4 = iMeshCreator.createEdge(iEdge.vertices[0], iVertex);
        IEdge iEdge5 = iMeshCreator.createEdge(iVertex, iEdge.vertices[1]);
        IEdge iEdge6 = iMeshCreator.createEdge(iEdge2.vertices[0], iVertex2);
        IEdge iEdge7 = iMeshCreator.createEdge(iVertex2, iEdge2.vertices[1]);
        int n = iFace.indexOf(iEdge);
        int n2 = iFace.indexOf(iEdge2);
        if (n < 0 || n2 < 0) {
            IOut.err("edges are not included in the face");
            return;
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        int n3 = iFace.edges.length;
        arrayList.add(iEdge3);
        if (iFace.edges[(n + 1) % n3].isSharingVertex(iEdge4)) {
            arrayList.add(iEdge4);
        } else if (iFace.edges[(n + 1) % n3].isSharingVertex(iEdge5)) {
            arrayList.add(iEdge5);
        }
        int n4 = n + 1;
        while (n4 % n3 != n2) {
            arrayList.add(iFace.edges[n4 % n3]);
            ++n4;
        }
        if (iFace.edges[(n2 - 1 + n3) % n3].isSharingVertex(iEdge4)) {
            arrayList.add(iEdge4);
        } else if (iFace.edges[(n2 - 1 + n3) % n3].isSharingVertex(iEdge5)) {
            arrayList.add(iEdge5);
        }
        arrayList2.add(iEdge3);
        if (iFace.edges[(n2 + 1) % n3].isSharingVertex(iEdge6)) {
            arrayList2.add(iEdge6);
        } else if (iFace.edges[(n2 + 1) % n3].isSharingVertex(iEdge7)) {
            arrayList2.add(iEdge7);
        }
        n4 = n2 + 1;
        while (n4 % n3 != n) {
            arrayList2.add(iFace.edges[n4 % n3]);
            ++n4;
        }
        if (iFace.edges[(n - 1 + n3) % n3].isSharingVertex(iEdge6)) {
            arrayList2.add(iEdge6);
        } else if (iFace.edges[(n - 1 + n3) % n3].isSharingVertex(iEdge7)) {
            arrayList2.add(iEdge7);
        }
        IEdge[] iEdgeArray = new IEdge[arrayList.size()];
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            iEdgeArray[n4] = (IEdge)arrayList.get(n4);
        }
        IEdge[] iEdgeArray2 = new IEdge[arrayList2.size()];
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            iEdgeArray2[n4] = (IEdge)arrayList2.get(n4);
        }
        IFace iFace2 = iMeshCreator.createFace(iEdgeArray);
        IFace iFace3 = iMeshCreator.createFace(iEdgeArray2);
        this.faces.add(iFace2);
        this.faces.add(iFace3);
        this.faces.remove(iFace);
        iFace.del();
        if (iEdge.faces.size() == 0) {
            this.edges.remove(iEdge);
            iEdge.del();
        }
        if (iEdge2.faces.size() == 0) {
            this.edges.remove(iEdge2);
            iEdge2.del();
        }
    }

    public void triangulate(IFace iFace, boolean bl, IMeshCreator iMeshCreator) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<Object> arrayList3 = iFace.triangulate(bl, iMeshCreator);
        for (n = 0; n < arrayList3.size(); ++n) {
            if (arrayList3.get(n) instanceof IEdge) {
                arrayList2.add((IEdge)arrayList3.get(n));
                continue;
            }
            if (!(arrayList3.get(n) instanceof IFace)) continue;
            arrayList.add((IFace)arrayList3.get(n));
        }
        iFace.del();
        this.faces.remove(iFace);
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
    }

    public void triangulateAll(boolean bl, IMeshCreator iMeshCreator) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (n = 0; n < this.faces.size(); ++n) {
            ArrayList<Object> arrayList3 = this.faces.get(n).triangulate(bl, iMeshCreator);
            for (int i = 0; arrayList3 != null && i < arrayList3.size(); ++i) {
                if (arrayList3.get(i) instanceof IEdge) {
                    arrayList2.add((IEdge)arrayList3.get(i));
                    continue;
                }
                if (!(arrayList3.get(i) instanceof IFace)) continue;
                arrayList.add((IFace)arrayList3.get(i));
            }
            if (arrayList3 == null) continue;
            this.faces.get(n).del();
            this.faces.remove(n);
            --n;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
    }

    public void triangulateAtCenter(IMeshCreator iMeshCreator) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IVertex> arrayList3 = new ArrayList<IVertex>();
        for (n = 0; n < this.faces.size(); ++n) {
            ArrayList<Object> arrayList4 = this.faces.get(n).triangulateAtCenter(iMeshCreator);
            for (int i = 0; arrayList4 != null && i < arrayList4.size(); ++i) {
                if (arrayList4.get(i) instanceof IVertex) {
                    arrayList3.add((IVertex)arrayList4.get(i));
                }
                if (arrayList4.get(i) instanceof IEdge) {
                    arrayList2.add((IEdge)arrayList4.get(i));
                    continue;
                }
                if (!(arrayList4.get(i) instanceof IFace)) continue;
                arrayList.add((IFace)arrayList4.get(i));
            }
            if (arrayList4 == null) continue;
            this.faces.get(n).del();
            this.faces.remove(n);
            --n;
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.vertices.add((IVertex)arrayList3.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
    }

    public IVec[] getBoundingBox() {
        IVec iVec = new IVec(this.vertices.get(0));
        IVec iVec2 = new IVec(this.vertices.get(0));
        for (int i = 1; i < this.vertices.size(); ++i) {
            IVec iVec3 = this.vertices.get((int)i).pos.get();
            if (iVec3.x < iVec.x) {
                iVec.x = iVec3.x;
            }
            if (iVec3.x > iVec2.x) {
                iVec2.x = iVec3.x;
            }
            if (iVec3.y < iVec.y) {
                iVec.y = iVec3.y;
            }
            if (iVec3.y > iVec2.y) {
                iVec2.y = iVec3.y;
            }
            if (iVec3.z < iVec.z) {
                iVec.z = iVec3.z;
            }
            if (!(iVec3.z > iVec2.z)) continue;
            iVec2.z = iVec3.z;
        }
        IVec[] iVecArray = new IVec[]{iVec, iVec2};
        return iVecArray;
    }

    public static IMeshGeo joinMesh(IMeshGeo[] iMeshGeoArray) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < iMeshGeoArray.length; ++i) {
            for (n = 0; n < iMeshGeoArray[i].faceNum(); ++n) {
                arrayList.add(iMeshGeoArray[i].face(n));
            }
        }
        IFace[] iFaceArray = new IFace[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            iFaceArray[n] = (IFace)arrayList.get(n);
        }
        return new IMeshGeo(iFaceArray);
    }
}

