/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IConfig;
import igeo.core.IDynamicObject;
import igeo.core.IObject;
import igeo.core.IServer;
import igeo.core.IServerI;
import java.util.ArrayList;

public class IDynamicServer
implements Runnable {
    public Thread thread;
    public int speed = IConfig.dynamicsUpdateSpeed;
    public IServer server;
    public boolean runningDynamics = false;
    public ArrayList<IDynamicObject> dynamics;

    public IDynamicServer(IServerI iServerI) {
        this.server = iServerI.server();
        this.dynamics = new ArrayList();
    }

    public synchronized void add(IObject iObject) {
        for (IDynamicObject iDynamicObject : iObject.dynamics) {
            this.add(iDynamicObject);
        }
    }

    public synchronized void add(IDynamicObject iDynamicObject) {
        if (!this.dynamics.contains(iDynamicObject)) {
            this.dynamics.add(iDynamicObject);
        }
    }

    public int num() {
        return this.dynamics.size();
    }

    public IDynamicObject get(int n) {
        return this.dynamics.get(n);
    }

    public synchronized void remove(int n) {
        this.dynamics.remove(n);
    }

    public synchronized void remove(IDynamicObject iDynamicObject) {
        this.dynamics.remove(iDynamicObject);
    }

    public synchronized void clear() {
        this.dynamics.clear();
    }

    public void pause() {
        this.runningDynamics = false;
    }

    public void resume() {
        this.runningDynamics = true;
    }

    public void start() {
        this.thread = new Thread(this);
        this.runningDynamics = true;
        this.thread.start();
    }

    public void stop() {
        this.runningDynamics = false;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            if (this.runningDynamics) {
                IDynamicServer iDynamicServer = this;
                synchronized (iDynamicServer) {
                    for (int i = 0; i < this.dynamics.size(); ++i) {
                        for (int j = i + 1; j < this.dynamics.size(); ++j) {
                            this.dynamics.get(i).interact(this.dynamics.get(j));
                        }
                    }
                    for (IDynamicObject iDynamicObject : this.dynamics) {
                        iDynamicObject.update();
                    }
                }
            }
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

