/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IServerI;
import igeo.geo.ICircleGeo;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceGeo;
import igeo.geo.IVec;
import igeo.geo.IVec4;
import igeo.geo.IVecI;

public class ISphere
extends ISurface {
    public IVec center;
    public double radius;

    public static double[] sphereKnots() {
        return new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 1.0, 1.0, 1.0};
    }

    public ISphere(double d, double d2, double d3, double d4) {
        this(null, new IVec(d, d2, d3), d4);
    }

    public ISphere(IServerI iServerI, double d, double d2, double d3, double d4) {
        this(iServerI, new IVec(d, d2, d3), d4);
    }

    public ISphere(IVec iVec, double d) {
        this(null, iVec, d);
    }

    public ISphere(IServerI iServerI, IVec iVec, double d) {
        super(iServerI);
        this.center = iVec;
        this.radius = d;
        this.initSphere(iServerI);
    }

    public void initSphere(IServerI iServerI) {
        IVecI[][] iVecIArray = new IVec4[9][5];
        double d = Math.sqrt(2.0) / 2.0;
        IVec4 iVec4 = this.center.to4d().add(0.0, 0.0, this.radius);
        IVec4 iVec42 = iVec4.dup();
        iVec42.w = d;
        IVec4 iVec43 = this.center.to4d().add(0.0, 0.0, -this.radius);
        IVec4 iVec44 = iVec43.dup();
        iVec44.w = d;
        IVec4[] iVec4Array = ICircleGeo.circleCP(this.center, new IVec(0.0, 0.0, 1.0), this.radius);
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray[i][0] = i % 2 == 0 ? iVec43 : iVec44;
            iVecIArray[i][1] = iVec4Array[i].dup().add(0.0, 0.0, -this.radius);
            ((IVec4)iVecIArray[i][1]).w *= d;
            iVecIArray[i][2] = iVec4Array[i];
            iVecIArray[i][3] = iVec4Array[i].dup().add(0.0, 0.0, this.radius);
            ((IVec4)iVecIArray[i][3]).w *= d;
            iVecIArray[i][4] = i % 2 == 0 ? iVec4 : iVec42;
        }
        this.surface = new ISurfaceGeo(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleDeg(), ICircleGeo.circleKnots(), ISphere.sphereKnots());
        super.initSurface(iServerI);
    }
}

